/* CMSynergyVer %full_filespec: mib_id.h;3.9.2.1.1:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      Managed Object Definitions
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/mib_id.h $
 **
 ** VERSION:        $Revision: #8 $
 **
 ** DATED:          $Date: 2004/02/20 $
 **
 ** AUTHOR:         S Sondergaard
 **
 ** DESCRIPTION:    External interface for managed objects
 **
 ****************************************************************************
 *
 *  (c) Copyright 2003, TTPCom Limited.
 *
 ****************************************************************************/

#ifndef  MIB_ID_INCLUDED
#define  MIB_ID_INCLUDED

/***************************************************************************/
/***                   Include File Dependencies                         ***/
/***************************************************************************/

#include "mhi_mib_id.h"

/***************************************************************************/
/***                  Global data                                        ***/
/***************************************************************************/

/* Accessibility of managed object - refer to hi_motab.h for use */

#define MIB_ACC_R             0  /* Read-only                           */
#define MIB_ACC_RW_ADOPT      1  /* Read-write prior to enabling the mac*/
                                     /* i.e. adopting a configuration       */
#define MIB_ACC_RW            2  /* Read-write at any time              */
#define MIB_ACC_W             3  /* Write-only at any time              */


/* Setup requirement for a manged object */
#define MIB_REQ_OPTIONAL      0  /* Value need not be specified         */
#define MIB_REQ_MANDATORY     1  /* Value must be give prior to adopt   */
#define MIB_REQ_NOTUSED       2  /* Value is not used by MAC s/w */

/* Conversion of Kus to us and vice versa - 2^10 us in 1 Kus */
#define MO_KUS_TO_US(kus_value) (((uint32)(kus_value)) << 10)
#define MO_US_TO_KUS(us_value)  ((us_value) >> 10)

#define MO_KUS_TO_MS(kus_value) ((((uint32)(kus_value)) << 10) / 1000UL)
#define MO_MS_TO_KUS(s_value)   ((((uint32)(s_value)) * 1000UL) >> 10)

#define MO_KUS_TO_S(kus_value)  ((((uint32)(kus_value)) << 10) / 1000000UL)
#define MO_S_TO_KUS(s_value)    ((((uint32)(s_value)) * 1000000UL) >> 10)

/* TPC Algorithm defines    */
/* ************************ */
#define MIB_TPC_FREQ_DEFAULT    {{  0 MIB_COMMA    /* chID     */ \
                                    0 MIB_COMMA    /* BackoffMultiplier */ \
                                    0 MIB_COMMA    /* MaxTxPowerIndex */ \
                                    0 MIB_COMMA    /* Backoff */ \
                                  { 0 MIB_COMMA 0 MIB_COMMA 0 MIB_COMMA 0 MIB_COMMA  0 } MIB_COMMA /* x[0..5] */ \
                                  { 0 MIB_COMMA 0 MIB_COMMA 0 MIB_COMMA 0 MIB_COMMA  0 } MIB_COMMA/* y[0..5] */  \
                                }}
           


#define MIB_EEPROM_VERSION_DEFAULT {100 MIB_COMMA 0 MIB_COMMA 0}        

#define MIB_WME_OUI_AND_VERSION_DEFAULT { { 0 MIB_COMMA 0x50 MIB_COMMA 0xF2} /* OUI */ \
                                             MIB_COMMA 2 MIB_COMMA 1 MIB_COMMA 1  /* Sub/type Version */ \
                                             MIB_COMMA 0 MIB_COMMA 0}


/* WME Control */
#define MIB_WME_TXOP_BUDGET_DEFAULT    {0x7fff MIB_COMMA 0x7fff MIB_COMMA 0x7fff}
#define MIB_WME_LOAD_DEFAULT           {0 MIB_COMMA 0 MIB_COMMA 0}
#define MIB_WME_DAMPING_DEFAULT        {230 MIB_COMMA 230 MIB_COMMA 230} /* 0.9 in 256ths */

typedef struct _WME_3WORD_ARRAY
{
    uint16 au16Wme3Word[3];
} WME_3WORD_ARRAY;

/*--------------------------------------------------------------------------
 * Managed Object Type Definitions
 *
 * Description:     QAP EDCF Config Table
 *                  <DS> - WME paramters that the AP send in Beacon and Prode 
 *
 * Representation:  MIB_MANUFACTURER_ID
 *
 *--------------------------------------------------------------------------*/
/* <DS> - WME EDCF permters corresponds to 802.11e MIBs */

#define MIB_WME_CWMIN_DEFAULT_A_G      {CW_MIN_BE_11A   MIB_COMMA \
                                        CW_MIN_BK_11A   MIB_COMMA \
                                        CW_MIN_VI_11A   MIB_COMMA \
                                        CW_MIN_VO_11A}          

#define MIB_WME_CWMAX_DEFAULT_A_G      {CW_MAX_BE_11A   MIB_COMMA \
                                        CW_MAX_BK_11A   MIB_COMMA \
                                        CW_MAX_VI_11A   MIB_COMMA \
                                        CW_MAX_VO_11A}

#define MIB_WME_CWMIN_DEFAULT_B        {CW_MIN_BE_11B   MIB_COMMA \
                                        CW_MIN_BK_11B   MIB_COMMA \
                                        CW_MIN_VI_11B   MIB_COMMA \
                                        CW_MIN_VO_11B}

#define MIB_WME_CWMAX_DEFAULT_B        {CW_MAX_BE_11B   MIB_COMMA \
                                        CW_MAX_BK_11B   MIB_COMMA \
                                        CW_MAX_VI_11B   MIB_COMMA \
                                        CW_MAX_VO_11B}

#define MIB_WME_AIFS_DEFAULT           {3 MIB_COMMA 7 MIB_COMMA 2 MIB_COMMA 2}
#define MIB_WME_TXOP_LIMIT_DEFAULT_A_G {0 MIB_COMMA 0 MIB_COMMA 3008/32 MIB_COMMA 1504/32}
#define MIB_WME_TXOP_LIMIT_DEFAULT_B   {0 MIB_COMMA 0 MIB_COMMA 6016/32 MIB_COMMA 3264/32}

 /* <DS> - Msdu LifeTime */
#define MIB_WME_MSDU_LIFETIME_DEFAULT  {500 MIB_COMMA 500 MIB_COMMA 500 MIB_COMMA 500}

 /* <DS> - Admission Control */
#define MIB_WME_ADC_DEFAULT            {0 MIB_COMMA 0 MIB_COMMA 0 MIB_COMMA 0}

#define MIB_WME_PARAMETERS_A_G         { MIB_WME_CWMIN_DEFAULT_A_G      MIB_COMMA \
                                         MIB_WME_CWMAX_DEFAULT_A_G      MIB_COMMA \
                                         MIB_WME_AIFS_DEFAULT           MIB_COMMA \
                                         MIB_WME_TXOP_LIMIT_DEFAULT_A_G MIB_COMMA \
                                         MIB_WME_MSDU_LIFETIME_DEFAULT  MIB_COMMA \
                                         MIB_WME_ADC_DEFAULT }

#define MIB_WME_PARAMETERS_B           { MIB_WME_CWMIN_DEFAULT_B        MIB_COMMA \
                                         MIB_WME_CWMAX_DEFAULT_B        MIB_COMMA \
                                         MIB_WME_AIFS_DEFAULT           MIB_COMMA \
                                         MIB_WME_TXOP_LIMIT_DEFAULT_B   MIB_COMMA \
                                         MIB_WME_MSDU_LIFETIME_DEFAULT  MIB_COMMA \
                                         MIB_WME_ADC_DEFAULT }
 
/*--------------------------------------------------------------------------
 * Managed Object Type Definitions
 *
 * Description:     EDCF Config Table
 *                  <DS> - WME paramters for QAP (AP uses those valuse to transmit) 
 *
 * Representation:  MIB_MANUFACTURER_ID
 *
 *--------------------------------------------------------------------------*/

#define MIB_WME_AP_CWMIN_DEFAULT_A_G   {CW_MIN_BE_11A       MIB_COMMA \
                                        CW_MIN_BK_11A       MIB_COMMA \
                                        CW_MIN_VI_11A       MIB_COMMA \
                                        CW_MIN_VO_11A}

#define MIB_WME_AP_CWMAX_DEFAULT_A_G  {CW_MAX_BE_AP_11A     MIB_COMMA \
                                       CW_MAX_BK_11A        MIB_COMMA \
                                       CW_MAX_VI_11A        MIB_COMMA \
                                       CW_MAX_VO_11A}

#define MIB_WME_AP_CWMIN_DEFAULT_B    {CW_MIN_BE_11B        MIB_COMMA \
                                       CW_MIN_BK_11B        MIB_COMMA \
                                       CW_MIN_VI_11B        MIB_COMMA \
                                       CW_MIN_VO_11B}

#define MIB_WME_AP_CWMAX_DEFAULT_B    {CW_MAX_BE_AP_11B     MIB_COMMA \
                                       CW_MAX_BK_11B        MIB_COMMA \
                                       CW_MAX_VI_11B        MIB_COMMA \
                                       CW_MAX_VO_11B}

#define MIB_WME_AP_AIFS_DEFAULT           {3 MIB_COMMA 7 MIB_COMMA 1 MIB_COMMA 1}
#define MIB_WME_AP_TXOP_LIMIT_DEFAULT_A_G {0 MIB_COMMA 0 MIB_COMMA 3008/32 MIB_COMMA 1504/32}
#define MIB_WME_AP_TXOP_LIMIT_DEFAULT_B   {0 MIB_COMMA 0 MIB_COMMA 6016/32 MIB_COMMA 3264/32}
#define MIB_WME_AP_MSDU_LIFETIME_DEFAULT  {500 MIB_COMMA 500 MIB_COMMA 500 MIB_COMMA 500}
#define MIB_WME_AP_ADC_DEFAULT             {0 MIB_COMMA 0 MIB_COMMA 0 MIB_COMMA 0}

#define MIB_WME_AP_PARAMETERS_A_G     { MIB_WME_AP_CWMIN_DEFAULT_A_G      MIB_COMMA \
                                         MIB_WME_AP_CWMAX_DEFAULT_A_G      MIB_COMMA \
                                         MIB_WME_AP_AIFS_DEFAULT           MIB_COMMA \
                                         MIB_WME_AP_TXOP_LIMIT_DEFAULT_A_G MIB_COMMA \
                                         MIB_WME_AP_MSDU_LIFETIME_DEFAULT  MIB_COMMA \
                                         MIB_WME_AP_ADC_DEFAULT }

#define MIB_WME_AP_PARAMETERS_B        { MIB_WME_AP_CWMIN_DEFAULT_B        MIB_COMMA \
                                          MIB_WME_AP_CWMAX_DEFAULT_B        MIB_COMMA \
                                          MIB_WME_AP_AIFS_DEFAULT           MIB_COMMA \
                                          MIB_WME_AP_TXOP_LIMIT_DEFAULT_B   MIB_COMMA \
                                          MIB_WME_AP_MSDU_LIFETIME_DEFAULT  MIB_COMMA \
                                          MIB_WME_AP_ADC_DEFAULT }


typedef struct _PROTECTION_METHOD
{
	uint8	ProtectionMethod	:2; // 0=None 1=Rts/Cts 2=Cts/Self
	uint8	ProtectionForce 	:1; // When to protect? 0=Auto 1=Force
	uint8	ProtectionForceRate :1; // How to select Rts/Cts rate? 0=Auto (lowest basic rate) 1=Force
	uint8	ProtectionRate  	:4; // Legacy rate index to use if ProtectionForceRate=1 (0:14)
} PROTECTION_METHOD;

#endif     /* MODULE_INCLUDED */
/* End of Module */

