/* CMSynergyVer %full_filespec: mib_ms.h;3.3.1.3.1.3.1.2.1.1:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      Managed Objects
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/mib_ms.h $
 **
 ** VERSION:        $Revision: #1 $
 **
 ** DATED:          $Date: 2003/10/27 $
 **
 ** AUTHOR:         S Sondergaard
 **
 ** DESCRIPTION:    Internal structure definitions
 **
 ** LAST MODIFIED BY:   $Author: njk $
 **
 ** $Log: mib_ms.h $
 ** Revision 1.24  2002/11/25 16:48:40Z  prh
 ** Modifications for RTS rate selection.
 ** Revision 1.23  2002/11/18 11:21:36Z  prh
 ** Make sure any basic rate we do not support flags failure.
 ** Revision 1.22  2002/11/13 12:29:27Z  prh
 ** Short slot support for 'g'.
 ** Modify capability determination.
 ** Partial nonERP support.
 ** Revision 1.21  2002/11/11 11:29:30Z  prh
 ** Implement common capability set up function.
 ** Revision 1.20  2002/11/06 11:26:56Z  jcm
 ** Implement Short preamble
 ** Revision 1.19  2002/11/06 10:40:41Z  jcm
 ** Add support for Short and Long preamble
 ** Revision 1.18  2002/11/04 13:50:37Z  prh
 ** Correct operation of rate fallback.
 ** Revision 1.17  2002/11/04 11:39:54Z  prh
 ** Re-design rate set selection, and usage.
 ** Revision 1.16  2002/07/31 15:39:20Z  lde
 ** Changes for 802.11b and g. Excludes phy mode selection and rate fallback.
 ** Revision 1.15  2002/05/09 14:32:18Z  djh
 ** Tidied up formatting and removed a few typos from comments
 **
 ****************************************************************************
 *
 *  (c) Copyright 2000, TTPCom Limited.
 *
 ****************************************************************************/

#ifndef  MIB_MS_INCLUDED
#define  MIB_MS_INCLUDED

#include "mib_id.h"
#include "mhi_ieee_address.h"


/***************************************************************************/
/***                  Type definitions                                   ***/
/***************************************************************************/

/* Define a struct to hold the current value of all managed objects */
typedef struct MIB_OBJECTS
{
#define MO_V(id,field,type,units,default,access,required)  type field;
#include "mib_table.h"
#undef  MO_V
} MIB_OBJECTS;

/*
                    Values for u8NetworkMask
[ RESERVED ][ Is 5G Band ][   Is HT    ][   Is G rates   ][  Is B rates   ]
  bits 4-7       bit 3        bit 2          bit 1             bit 0
*/

#define MIB_PROTOCOL_MASK_B_RATES       0x01
#define MIB_PROTOCOL_MASK_G_RATES       0x02
#define MIB_PROTOCOL_MASK_HT_RATES      0x04
#define MIB_PROTOCOL_MASK_5_GHZ         0x08

/*These masks will be used to define the following values:*/
#define MIB_PROTOCOL_802_11B_ONLY       (MIB_PROTOCOL_MASK_B_RATES)                                                        // 0x01
#define MIB_PROTOCOL_802_11G_ONLY       (MIB_PROTOCOL_MASK_G_RATES)                                                        // 0x02
#define MIB_PROTOCOL_802_11BG_MIXED     (MIB_PROTOCOL_MASK_B_RATES | MIB_PROTOCOL_MASK_G_RATES)                            // 0x03
#define MIB_PROTOCOL_802_11N_2_4G_ONLY  (MIB_PROTOCOL_MASK_HT_RATES)                                                       // 0x04
#define MIB_PROTOCOL_802_11GN_MIXED     (MIB_PROTOCOL_MASK_HT_RATES | MIB_PROTOCOL_MASK_G_RATES)                           // 0x06
#define MIB_PROTOCOL_802_11BGN_MIXED    (MIB_PROTOCOL_MASK_HT_RATES | MIB_PROTOCOL_MASK_G_RATES | MIB_PROTOCOL_MASK_B_RATES) // 0x07

#define MIB_PROTOCOL_802_11A_ONLY       (MIB_PROTOCOL_MASK_5_GHZ | MIB_PROTOCOL_MASK_G_RATES)                              // 0x0A
#define MIB_PROTOCOL_802_11N_5G_ONLY    (MIB_PROTOCOL_MASK_5_GHZ | MIB_PROTOCOL_MASK_HT_RATES)                             // 0x0C
#define MIB_PROTOCOL_802_11AN_MIXED     (MIB_PROTOCOL_MASK_5_GHZ | MIB_PROTOCOL_MASK_HT_RATES | MIB_PROTOCOL_MASK_G_RATES) // 0x0E

#define NETWORK_IS_HT(x)                ((x) & MIB_PROTOCOL_MASK_HT_RATES)
#define NETWORK_IS_5G(x)                ((x) & MIB_PROTOCOL_MASK_5_GHZ)
#define NETWORK_SUPPORTS_B_RATES(x)     ((x) & MIB_PROTOCOL_MASK_B_RATES)
#define NETWORK_SUPPORTS_G_RATES(x)     ((x) & MIB_PROTOCOL_MASK_G_RATES)
#define NETWORK_SUPPORTS_ERP(x)         (!(NETWORK_IS_5G(x)) && NETWORK_SUPPORTS_G_RATES(x)) //ERP is used in 2.4G only

#define NETWORK_IS_A_ONLY(x)            ((x) == MIB_PROTOCOL_802_11A_ONLY)
#define NETWORK_IS_B_ONLY(x)            ((x) == MIB_PROTOCOL_802_11B_ONLY)
#define NETWORK_IS_G_ONLY(x)            ((x) == MIB_PROTOCOL_802_11G_ONLY)
#define NETWORK_IS_BG_MIXED(x)          ((x) == MIB_PROTOCOL_802_11BG_MIXED)
#define NETWORK_IS_GN_MIXED(x)          ((x) == MIB_PROTOCOL_802_11GN_MIXED)
#define NETWORK_IS_BGN_MIXED(x)         ((x) == MIB_PROTOCOL_802_11BGN_MIXED)
#define NETWORK_IS_AN_MIXED(x)          ((x) == MIB_PROTOCOL_802_11AN_MIXED)
#define NETWORK_IS_N_2_4G_ONLY(x)       ((x) == MIB_PROTOCOL_802_11N_2_4G_ONLY)
#define NETWORK_IS_N_5G_ONLY(x)         ((x) == MIB_PROTOCOL_802_11N_5G_ONLY)

#define MIB_INVALID_BASIC_RATE 0x80000000

/***************************************************************************/
/***                  Global data                                        ***/
/***************************************************************************/

/* Globally-accessible table of managed objects */
extern  MIB_OBJECTS sMIB_Objects;

/***************************************************************************/
/***                  Public Routines                                    ***/
/***************************************************************************/

void vMIB_Init( void );
void vMIB_Adopt(bool boAdopt);
#ifdef DEBUG_UM_INTERFACE
uint16 u16MIB_GetValue(MIB_ID u16ID, MIB_VALUE *puValue);
uint16 u16MIB_PutValue(MIB_ID u16ID, MIB_VALUE *puValue);
#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#endif     /* MODULE_INCLUDED */
/* End of Module */


