/* CMSynergyVer %full_filespec: mib_table.h;21.2.1.2.3.1.1.2.8.1.4:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      Managed objects
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/mib_table.h $
 **
 ** VERSION:        $Revision: #8 $
 **
 ** DATED:          $Date: 2004/02/20 $
 **
 ** AUTHOR:         S Sondergaard
 **
 ** DESCRIPTION:    Internal definition for managed objects
 **
 ** LAST MODIFIED BY:   $Author: jh3 $
 **
 ****************************************************************************
 *
 *  (c) Copyright 2003, TTPCom Limited.
 *
 ****************************************************************************/



/***************************************************************************/
/***                  Type definitions                                   ***/
/***************************************************************************/

/***************************************************************************/
/***                  Global data                                        ***/
/***************************************************************************/

/***************************************************************************/
/***                  Public Routines                                    ***/
/***************************************************************************/


/*----Instructions for Use--------------------------------------------------
 *  If you've not come across this technique before,   it can seem a little
 *  odd.
 *  1.  Define a MACROs MO_V and MO_V which takes the parameters described below.
 *  2.  Include this file at the point in the source where it is required.
 *      This will typically be within a struct definition or initialisation.
 *  3.  "undef" the macros.
 *
 *  The MO_V entries below are for parameters which are volatile between
 *  resets of the mac software.   The MO_V parameters retain their value
 *  between resets.   They are separate macros to allow separate structures/tables of
 *  parameters to be built.
 *--------------------------------------------------------------------------*/





/*--- Macro Definitions ----------------------------------------------------*/
/*--------------------------------------------------------------------------
 * Macro:       MO_V        - Volatile managed-object
 * Macro:       MO_V       - Non-volatile managed-object
 *
 * Parameters:
 *              ID name     - name of  #define variable
 *              field name  - name of MANAGED_OBJECT union field name
 *              type        - "C" type of field
 *              units       - text field
 *              default     - default value
 *              accessability - one of the MIB_ACC_* codes (see hi_mo.h)
 *              required    - one of the MIB_REQ_* codes (see hi_mo.h)
 *
 * Description:
 *
 *      This macro should be defined by the includer of this file.  It is
 *      used to build tables of managed objects of varying uses.
 *
 *      Note - not all the parameters defined above need be used.
 *
 *--------------------------------------------------------------------------*/


/*--- Current Status -------------------------------------------------------*/

/* The managed objects listed here are split into these categories :

   1. SMT object attributes
   2. MAC object attributes (including statistics)
   3. PHY object attributes
   4. Layer Management Parameters.
   5. Private objects.


    The first two categories are described fully in IEEE 802.11. The managed
    objects in the last section are described in hi_mo.h in more detail.

    All the mandatory SMT and MAC are present in the MIB,  however
    some of them are not used by the MAC.   These are marked as
    MIB_REQ_NOTUSED below.   These parameters have no effect on
    the operation of the MAC software.

    Most of the PHY objects are not exposed to the host interface.
    Only those which are of genuine interest are implemented.

    The layer management parameters are managed objects which are present
    in the definition of the MAC and PHY management layer service
    primitives.   They are defined there in all but name.


    The private objects are additional managed objects which do not
    appear in IEEE 802.11.   They are used to control aspects of the
    MAC/PHY which are not within the scope of the standard.

*/

#define MIB_NUM_RATES 0
#define MIB_RATES   0





/*----Table Definition------------------------------------------------------*/
/* Keep up to date with hi_mo.h */


/*--------------------------------------------------------------------------*/
/*  SMT Attributes                                                                        */
/*--------------------------------------------------------------------------*/

/* ---------- MAC Attributes */
/*--------------------------------------------------------------------------*/
/* MAC Attributes                                                                         */
/*--------------------------------------------------------------------------*/
MO_V(MIB_IEEE_ADDRESS,             /* ID */          \
      sIEEEaddrMAC,                   /* field */       \
      IEEE_ADDR,                      /* type */        \
      "",                             /* units */       \
      {{0}},                          /* default */     \
      MIB_ACC_RW_ADOPT,             /* access - NOTE: 802.11 specifies read only*/      \
      MIB_REQ_MANDATORY  )

MO_V( MIB_PRE_ACTIVATE,              /* ID */         \
      sPreActivate,                  /* field */      \
      PRE_ACTIVATE_MIB_TYPE,         /* type */       \
      "",                            /* units */      \
      { {0 MIB_COMMA 0 MIB_COMMA 0} MIB_COMMA 0 MIB_COMMA 1 MIB_COMMA 0 MIB_COMMA 0 MIB_COMMA 0 MIB_COMMA LM_PHY_11N_RATE_MSK|LM_PHY_11A_RATE_MSK MIB_COMMA LM_PHY_11A_RATE_MSK }, \
      MIB_ACC_RW,                    /* access */     \
      MIB_REQ_OPTIONAL   )

/* Note D5.3 defines the default fragmentation threshold
 * to be 2346 bytes in the MAC sections.
 */

MO_V( MIB_LONG_RETRY_LIMIT,         /* ID */          \
      u16LongRetryLimit,              /* field */       \
      uint16,                            /* type */        \
      "retries",                      /* units */       \
      15,                              /* default */     \
      MIB_ACC_RW,                   /* access */      \
      MIB_REQ_OPTIONAL   )

/*--------------------------------------------------------------------------*/
/* MT PHY advanced parameters:                                                                                       */
/*--------------------------------------------------------------------------*/
MO_V( MIB_SPECTRUM_MODE,       /* ID */          \
      u8SpectrumMode,              /* field */       \
      uint8,                         /* type */        \
      "20M=0x0,40M=0x1,Half=0x2",		      /* units */       \
      0,			            /* default */     \
      MIB_ACC_RW_ADOPT,              /* access */      \
      MIB_REQ_OPTIONAL  )


/* Not exposed: aSlotTime */
/* Not exposed: aCCATime */
/* Not exposed: aRxTxTurnroundTime */
/* Not exposed: aTxPLCPDelay */
/* Not exposed: aRxTxSwitchTime */
/* Not exposed: aTxRampOnTime */
/* Not exposed: aTxRFDelay */


/* Not exposed: aSIFStime */
/* Not exposed: aRxRFDelay */
/* Not exposed: aRxPLCPDelay */
/* Not exposed: aMACProcessingDelay */
/* Not exposed: aTxRampOffTime */
/* Not exposed: aPreambleLength */
/* Not exposed: aPLCPHeaderLength */
/* Not exposed: aMPDUDurationFactor */
/* Not exposed: aAirPropagationTime */



/* Note,  the 802.11 MIB requires the tx power levels
 * in mW.   The power objects below are specified in
 * terms of arbitrary units,  and should be calibrated
 * during manufacturing to achieve four fixed power
 * settings.   These objects are non-volatile.
 */


/*--------------------------------------------------------------------------*/
/* Layer Management Parameters                                                            */



/*--------------------------------------------------------------------------*/
/* Private Objects                                                                                       */
/*--------------------------------------------------------------------------*/

/* Enables test scripts to determine which conditionally */
/* compiled modules have been included allowing an       */
/* assessment of a test script's suitability             */


MO_V( MIB_MAC_ENABLED,                 /* ID */          \
      boMacEnabled,                      /* field */       \
      uint8,                                /* type */        \
      "",                                /* units */       \
      0,                                 /* default */     \
      MIB_ACC_R,                       /* access */      \
      MIB_REQ_OPTIONAL   )


/* Private PHY objects */

/*--------------------------------------------------------------------------*/
/* WME Objects                                                                                       */
/*--------------------------------------------------------------------------*/

#define MIB_WME_PARAMETERS_ACCESS  MIB_ACC_RW_ADOPT

MO_V( MIB_WME_PARAMETERS,
      sWMEparameters,                   /* field */       \
      MIB_WME_TABLE,	                /* type */        \
      "",                               /* units */       \
	  MIB_WME_PARAMETERS_A_G,        /* default */      \
      MIB_WME_PARAMETERS_ACCESS,        /* access */      \
      MIB_REQ_OPTIONAL   )

MO_V( MIB_WME_QAP_PARAMETERS,
      sWMEQAPparameters,                /* field */       \
      MIB_WME_TABLE,	                /* type */        \
      "",                               /* units */       \
      MIB_WME_AP_PARAMETERS_A_G,        /* default */     \
      MIB_WME_PARAMETERS_ACCESS,        /* access */      \
      MIB_REQ_OPTIONAL   )

MO_V( MIB_WME_OUI_AND_VERSION,
      sWMEOUIandVersion,                /* field */       \
      FM_WME_OUI_AND_VER,               /* type */        \
      "",                               /* units */       \
      MIB_WME_OUI_AND_VERSION_DEFAULT,  /* default */     \
      MIB_ACC_R,                        /* access */      \
      MIB_REQ_OPTIONAL   )


/* End of Table */

/*--------------------------------------------------------------------------*/

/* This macro allows the initialisation parameter to contain
 * a list of initialising values.
 */
#define MIB_COMMA ,

/* End of Module */

