/* CMSynergyVer %full_filespec: mib.c;23.1.3.2.11.3.8.1.5.1.1:csrc:1 % */
/*****************************************************************************
 **
 ** COMPONENT:      Managed objects
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/mib.c $
 **
 ** VERSION:        $Revision: #16 $
 **
 ** DATED:          $Date: 2004/03/15 $
 **
 ** AUTHOR:         S Sondergaard
 **
 ** DESCRIPTION:    Managed objects access routines
 **
 ****************************************************************************
 *
 *  (c) Copyright 2003, TTPCom Limited.
 *
 ****************************************************************************/


/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/

#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "Utils_Api.h"

#include "stringLibApi.h"

#include "ieee80211.h"
#include "frame.h"
#include "lmi.h"
#include "mib_id.h"
#include "mib_ms.h"
#include "database.h"
#include "um_interface.h"
#include "BSSmanager_API.h"
#include "VapDatabase_Api.h"

//#include "um_msgs.h"
#include "ErrorHandler_Api.h"

#include "loggerAPI.h"

#include "bss_manage_task.h"

#define LOG_LOCAL_GID GLOBAL_GID_DATABASE
#define LOG_LOCAL_FID 0

/***************************************************************************/
/***                  Local Constants                                    ***/
/***************************************************************************/

/* Enforce limits */
#define LIMIT_MAX(var, limit) if (var > limit) {var = limit;}
#define LIMIT_MIN(var, limit) if (var < limit) {var = limit;}


/*----Type Definitions------------------------------------------------------*/

/* Managed Object Table control entry */
typedef struct
{
    uint16          id;             /* Managed Object ID */
    uint8           size;           /* Size of object       */
    int             access :4;      /* Accessibility */
    int             required :4;    /* Whether mandatory or optional */
    MIB_VALUE       *puValue;            /* Pointer to value in managed objects */
#if defined(MODULE_TEST)
    char *          pcName;         /* Field name */
    char *          pcUnits;            /* units description */
#endif
}
MIB_CONTROL;




/***************************************************************************/
/*                    External Definitions                               ***/
/***************************************************************************/


/* Globally-accessible table of managed objects with initial values */
MIB_OBJECTS sMIB_Objects;


/***************************************************************************/
/***                  Function prototypes                                ***/
/***************************************************************************/

#ifdef DEBUG_UM_INTERFACE
static const MIB_CONTROL * psMIB_GetObject(uint16 u16ID);
static bool boSpeciallyHandledWriteObject(uint16 u16ID, MIB_VALUE *puValue, const MIB_CONTROL *psManagedObject, uint16 *pStatus);
#endif

/***************************************************************************/
/***                  Static data                                        ***/
/***************************************************************************/
#ifdef DEBUG_UM_INTERFACE
static const MIB_CONTROL asMOControlTable[] =
{
#if defined(MODULE_TEST)
  #define   MO_V(id,field,type,units,default,access,required) \
        {id, sizeof(type), access, required, (void *)&sMIB_Objects.field, #field, units},
#else
  #define   MO_V(id,field,type,units,default,access,required) \
        {id, sizeof(type), access, required, (void *)&sMIB_Objects.field},
#endif
#include "mib_table.h"
#undef  MO_V
};
#endif
/* static MIB_INDIVIDUAL_WEP_KEYS sMIBIndividualWEPKeys; */
const MIB_OBJECTS sMIB_ObjectsDefaults =
{
#define MO_V(id,field,type,units,default,access,required) default,
#include "mib_table.h"
#undef  MO_V
};
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

void vMIB_Init( void )
{
    /* Initlialise table of MIB values with defaults */
    DEBUG_ASSERT( sizeof( sMIB_Objects ) == sizeof( sMIB_ObjectsDefaults )  );
    MEMCPY( &sMIB_Objects, &sMIB_ObjectsDefaults, sizeof( sMIB_Objects ) );



    /* Clear all stats */
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

/****************************************************************************
 **
 ** NAME:           vMIB_Adopt
 **
 ** PARAMETERS:     none.
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    Sets Adopt state to lock changing after activation.
 **
 ****************************************************************************/
void vMIB_Adopt(bool boAdopt)
{
    sMIB_Objects.boMacEnabled = boAdopt;
}

/****************************************************************************
**
** NAME:           vUM_MAN_SET_MIB_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_SET_MIB_REQ message
**
****************************************************************************/
void vUM_MAN_SET_MIB_REQ(K_MSG *psMsg)
{
    /* Set a MIB value */
    UMI_MIB  *psMIB = (UMI_MIB *) pK_MSG_DATA(psMsg);
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_MIB_REQ_CFM); 
#ifdef ENET_INC_ARCH_WAVE600
	SLOG0(0, 0, UMI_MIB, psMIB);
#endif

    if (psMsg->header.vapId < HW_NUM_OF_VAPS)
	{
			psMIB->u16Status = UMI_OK;
	}
	else
	{
		psMIB->u16Status = UMI_BAD_PARAMETER;

		DEBUG_ASSERT(0);
	}

    /* send to MC */
	vUMI_MC_MAN_SET_MIB_CFM(psMsg);
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_MIB_REQ_CFM);
}


/****************************************************************************
**
** NAME:           vvUM_MAN_GET_MIB_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle vUM_MAN_GET_MIB_REQ message
**
****************************************************************************/
void vUM_MAN_GET_MIB_REQ(K_MSG *psMsg)
{
	/* Get a MIB value */
	UMI_MIB     *psMIB = (UMI_MIB *) pK_MSG_DATA(psMsg);
#ifdef DEBUG_UM_INTERFACE
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GET_MIB_REQ_CFM);
	if (psMsg->header.vapId < HW_NUM_OF_VAPS)
	{
		psMIB->u16Status = u16MIB_GetValue(psMIB->u16ObjectID, &psMIB->uValue);
	}
	else //vap ID out of range
	{
		psMIB->u16Status = UMI_BAD_PARAMETER;
	}
    /* send to MC */
	vUMI_MC_MAN_GET_MIB_CFM(psMsg);
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GET_MIB_REQ_CFM);
#else
	psMIB->u16Status = UMI_NOT_SUPPORTED;
	vUMI_MC_MAN_GET_MIB_CFM(psMsg);
#endif
}

#ifdef DEBUG_UM_INTERFACE
/****************************************************************************
 * Routine:     u16MIB_GetValue
 *
 *
 * Parameters: Name           r/w  Usage
 *             id               r   ID of object to return
 *              psManagedObject             *w  Place to put result
 *
 * Returns:    status       UMI_OK,  STS_BAD_PARAM
 *
 * Description:
 *
 *  Get the current value of the specified managed object.
 ****************************************************************************/
uint16 u16MIB_GetValue(MIB_ID u16ID, MIB_VALUE *puValue)
{
    const MIB_CONTROL * psMOcontrol;
    uint16 u16Status = UMI_OK;

    /* Lookup control record for this managed object id */
    psMOcontrol = psMIB_GetObject(u16ID);

    if (psMOcontrol)
    {
        if (psMOcontrol->access == MIB_ACC_W )
        {
            /* Attempted read of write-only object */
            u16Status = UMI_WRITE_ONLY;
            /* Attempted write to read-only object */
        }
        else
        {

            uint16 u16size = psMOcontrol->size;
            uint8 * pu8Data = &psMOcontrol->puValue->u8Uint8;

            /* Copy value specified */
            MEMCPY(puValue, pu8Data, u16size);
            while (u16size)
            {
                u16size--;
                pu8Data++;
            }
        }
    }
    else
    {
        puValue = NULL;
        /* Attempted write to object after its value has been adopted */
        /* Not found */
        u16Status = UMI_UNKNOWN_OBJECT;
    }

    return u16Status;
}

static void vWME_SetWMEBssParams(MIB_WME_TABLE *pValue,const MIB_CONTROL *psManagedObject)
{
	UNUSED_PARAM(psManagedObject);	
	/* Update the value in the MIB */
	MEMCPY(&sMIB_Objects.sWMEparameters, (uint8 *)pValue, sizeof(MIB_WME_TABLE));

	/* Inc the QoS Info filed */
	sMIB_Objects.sWMEOUIandVersion.u8QosInfoField = 
		(sMIB_Objects.sWMEOUIandVersion.u8QosInfoField+1) & WME_QOSINFO_COUNT;
}

static void vWME_SetWMEAPParams(MIB_WME_TABLE *pValue,const MIB_CONTROL *psManagedObject)
{
	UNUSED_PARAM(psManagedObject);		
	/* Update the value in the MIB */
	MEMCPY(&sMIB_Objects.sWMEQAPparameters, (uint8 *)pValue, sizeof(MIB_WME_TABLE));
}

/****************************************************************************
 **
 **  NAME:          boSpeciallyHandledWriteObject
 **
 **  RETURNS:       bool - TRUE is handled differently from other MIB params
 **
 **  DESCRIPTION:   Normal MIB parameters are just a get/put directly to the
 **                 value. However, some parameters require special handling.
 **
 ****************************************************************************/
static bool boSpeciallyHandledWriteObject(uint16 u16ID,
                                          MIB_VALUE *puValue,
                                          const MIB_CONTROL *psManagedObject,
                                          uint16 *pStatus)
{
    bool boIsHandled = TRUE;

/* Some test builds do not require all functions */
    switch (u16ID)
    {
/* Some test builds do not require all functions */
#if defined (ENET_INC_UMAC)
    case MIB_WME_PARAMETERS:
		{
		MIB_WME_TABLE *pValue = (MIB_WME_TABLE *)puValue;
		int iLoop;

		for(iLoop=0 ;iLoop < MAX_USER_PRIORITIES;iLoop++)
		{
			if ((pValue->au8CWmin[iLoop] > 15)
				||(pValue->au16Cwmax[iLoop] > 15)	
				||(pValue->au8AIFS[iLoop] > 15)
				||(pValue->au16TXOPlimit[iLoop] > 256)) /* Max 8192, 256*32*/			
			{
				*pStatus = UMI_BAD_VALUE;
                break;
			}

		}


			/* update WME parameters */
			vWME_SetWMEBssParams(pValue, psManagedObject);
			*pStatus = UMI_OK;
			
			break;
		}

	case MIB_WME_QAP_PARAMETERS:
		{
		MIB_WME_TABLE *pValue = (MIB_WME_TABLE *)puValue;
		int iLoop;

		for(iLoop=0;iLoop < MAX_USER_PRIORITIES;iLoop++)
		{
			if ((pValue->au8CWmin[iLoop] > 15)
				||(pValue->au16Cwmax[iLoop] > 15)	
				||(pValue->au8AIFS[iLoop] > 15)
				||(pValue->au16TXOPlimit[iLoop] > 256)) /* Max 8192, 256*32*/			
			{
				*pStatus = UMI_BAD_VALUE;
                break;
			}

		}

		/* update WME parameters */
		vWME_SetWMEAPParams(pValue, psManagedObject);
		*pStatus = UMI_OK;
		
		break;
		}
#endif
    default:
        boIsHandled = FALSE;
    }
    return boIsHandled;
}


/****************************************************************************
 * Routine:     u16MIB_PutValue
 *
 * Parameters: Name           r/w  Usage
 *             psManagedObject              *r  Pointer to managed object to put.
 *
 * Returns:    status       UMI_OK, stsNowNow, STS_BAD_VALUE
 * STS_BAD_PARAM
 *
 * Description:
 *
 *  Specifies a new value for a managed object.
 ****************************************************************************/
uint16 u16MIB_PutValue(MIB_ID u16ID, MIB_VALUE *puValue)
{
    uint16 status = UMI_OK;

    bool boSpeciallyHandled;
    const MIB_CONTROL * psMOcontrol;

    /* Lookup control record for this managed object id */
    psMOcontrol = psMIB_GetObject(u16ID);
	ILOG2_D("u16MIB_PutValue: u16ID=%d ",u16ID);

	if (!psMOcontrol)
    {
        /* MIB ID Not found */
        status =  UMI_UNKNOWN_OBJECT;
    }

    else if (psMOcontrol->access == MIB_ACC_R )
    {
        /* Attempted write to read-only object */
        status = UMI_READ_ONLY;
    }

    else if ((psMOcontrol->access == MIB_ACC_RW_ADOPT) && sMIB_Objects.boMacEnabled)
    {
        /* Attempted write to object after its value has been adopted */
        status =  UMI_ALREADY_ENABLED;
    }
    else
    {
        boSpeciallyHandled = boSpeciallyHandledWriteObject(u16ID,
                                                           puValue,
                                                           psMOcontrol,
                                                           &status);

        if (!boSpeciallyHandled)
        {
            uint16 u16size = psMOcontrol->size;
            uint8 * pu8Data = &psMOcontrol->puValue->u8Uint8;

            /* Accept value specified - no validity checking */
            MEMCPY(pu8Data, (uint8 *)puValue, u16size);
            
			while (u16size)
            {
                u16size--;
                pu8Data++;
            }

            // activate MIB:
            if ( u16ID == MIB_PRE_ACTIVATE )
            {
                // This assert is done to verify that the driver and the mac are aligned
                DEBUG_ASSERT((sMIB_Objects.sPreActivate.u8Reserved[0]|sMIB_Objects.sPreActivate.u8Reserved[1])==0);
			

                sMIB_Objects.u8SpectrumMode                   = sMIB_Objects.sPreActivate.u8SpectrumMode                  ;
                //sMIB_Objects.u8ShortPreambleOptionImplemented = sMIB_Objects.sPreActivate.u8ShortPreambleOptionImplemented;
                //sMIB_Objects.u8ShortSlotTimeOptionEnabled11g  = sMIB_Objects.sPreActivate.u8ShortSlotTimeOptionEnabled11g ;
								   
            }
        }
    }

	return status;
}
#endif

/*-----Local Routines-------------------------------------------------------*/
#ifdef DEBUG_UM_INTERFACE
/****************************************************************************
 * Routine:     psMIB_GetObject
 *
 * Parameters: Name           r/w  Usage
 *              ID              r   MIB_ID
 * Returns:    pointer to MIB_CONTROL record or NULL.
 *
 ****************************************************************************/
static const MIB_CONTROL * psMIB_GetObject(uint16 id)
{
    register uint32 i;
    register const MIB_CONTROL * p;



	uint32 arraySize;
	
	arraySize = sizeof(asMOControlTable)/sizeof(asMOControlTable[0]);

    /* Lookup managed object id by scanning control table */
    for (i=0, p=asMOControlTable;  i < arraySize; i++, p++)
    {
        if (p->id == id)
        {
            return p;
        }
    }
    return NULL;
}
#endif



/*--------------------------------------------------------------------------*/
/* End of Module */

