/***********************************************************************************
 File:			CpuLoad_Api.h			
 Module:			Debug Enviroment Purpose:			
 Description:		Calcultate the CPU idle time
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Pac_Api.h"
/*---------------------------------------------------------------------------------
/						Defines 					
/----------------------------------------------------------------------------------*/
#if defined(CALCULATE_CPU_IDLE_TIME)
#define CPU_IDLE_TIME_PRINT_EVERY_X_TICKS (100) /* each tick is 10 millisecond hence 100 means send log every 1 second */
#define CPU_IDLE_ARRAY_SIZE (200)
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
/*        calculate CPU idle time variables        */
extern volatile uint32 CalcCPUIdle_isInSleep ;
extern volatile uint32 CalcCPUIdle_enterSleepTime ;
extern volatile uint32 CalcCPUIdle_totalSleepTime ;
extern volatile uint32 CalcCPUIdle_LastPrint;
extern uint16 cpuLoadArrayLm[CPU_IDLE_ARRAY_SIZE];
extern uint16 cpuLoadArrayLmIndex;




#define ACCUMULATE_CPU_IDLE_TIME() do {\
	TX_INTERRUPT_SAVE_AREA;\
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);\
	if (CalcCPUIdle_isInSleep == 1){\
	CalcCPUIdle_isInSleep = 0; \
	CalcCPUIdle_totalSleepTime = CalcCPUIdle_totalSleepTime + GET_TSF_TIMER_LOW() - CalcCPUIdle_enterSleepTime;\
	}\
	OSAL_ENABLE_INTERRUPTS(interrupt_save);\
	} while(0);


#else
#define ACCUMULATE_CPU_IDLE_TIME()
#endif


/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

