/************************************************************************************
*    
*    File:		  Debug_Trace.h
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/

#ifndef  DEBUG_TRACE_H
#define  DEBUG_TRACE_H

#include "System_GlobalDefinitions.h"
#include "enet_pas.h"
#include "Pac_Api.h"


//------------ Debug LMI code ---vvv--------
#undef	AAA_DEBUG_LMI
//#if defined (ENET_INC_UMAC) || defined (ENET_INC_LMAC)
//#define	AAA_DEBUG_LMI
//#endif

typedef enum
{
	AAA_DebugLmi_vPutMsgQ,				//var1: num of messages in queue,	var2: msg type
	AAA_DebugLmi_pvGetMsgQ,				//var1: num of messages in queue,	var2: msg type
	AAA_DebugLmi_vLMI_ISR_M_CFM_IND,	//var1: num of messages in queue,	var2: msg type
	AAA_DebugLmi_vTLM_M_REQ_RES_ISR,	//var1: u32SignalMask,				var2: IGEN_CHECK_MASK(u32SignalMask,IGEN_EVT_M_REQ_RES)
	AAA_DebugLmi_vClearSignalMask,		//var1: u32SignalMask,				var2: u32BitMask
	AAA_DebugLmi_vIndListPut,
	AAA_DebugLmi_ptIndListGet,
} AAA_DebugLmi_enum;

#if defined (AAA_DEBUG_LMI)
typedef struct _AAA_DebugLmi_t 
{
	uint32				time;
	AAA_DebugLmi_enum	func_enum;
	uint32				var1;
	uint32				var2;
} AAA_DebugLmi_t;

#if defined (ENET_INC_UMAC)
#define AAA_DEBUGLMIARRAYSIZE (5)
#elif defined (ENET_INC_LMAC)
#define AAA_DEBUGLMIARRAYSIZE (20)
#endif
extern AAA_DebugLmi_t AAA_DebugLmiArray[AAA_DEBUGLMIARRAYSIZE];
extern uint16 AAA_DebugLmiIdx, AAA_DebugLmiLooper;

#define AAA_DEBUG_LMI_MACRO(x,y,z) \
{\
	TX_INTERRUPT_SAVE_AREA;\
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);\
	AAA_DebugLmiArray[AAA_DebugLmiIdx].time			= GET_TSF_TIMER_LOW();\
	AAA_DebugLmiArray[AAA_DebugLmiIdx].func_enum	= x;\
	AAA_DebugLmiArray[AAA_DebugLmiIdx].var1			= y;\
	AAA_DebugLmiArray[AAA_DebugLmiIdx].var2			= z;\
	AAA_DebugLmiIdx++;\
	\
	if (AAA_DebugLmiIdx == AAA_DEBUGLMIARRAYSIZE)\
	{\
		AAA_DebugLmiIdx = 0;\
		AAA_DebugLmiLooper++;\
	}\
	OSAL_ENABLE_INTERRUPTS(interrupt_save);\
}
#else
#define AAA_DEBUG_LMI_MACRO(x,y,z) {}
#endif
//------------ Debug LMI code ---^^^--------

//------------ Debug KCC MSG code ---vvv--------

//#if defined (ENET_INC_UMAC) || defined (ENET_INC_LMAC)
#define AAA_DISABLE_DEBUG_KCC_MSG
//#endif

#ifndef AAA_DISABLE_DEBUG_KCC_MSG
typedef struct _AAA_DebugKccMsg_t 
{
	uint32				time;
	uint32				p_msg;
	uint8				taskId;
} AAA_DebugKccMsg_t;

#define AAA_DEBUGKCCMSGARRAYSIZE (33) //greater than K_NO_OF_FAST_MSG

extern AAA_DebugKccMsg_t AAA_DebugKccMsgArray[AAA_DEBUGKCCMSGARRAYSIZE];
extern uint16 AAA_DebugKccMsgIdx, AAA_DebugKccMsgLooper;

#define AAA_DEBUG_KCC_MSG_MACRO(x,y) \
{\
	TX_INTERRUPT_SAVE_AREA;\
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);\
	AAA_DebugKccMsgArray[AAA_DebugKccMsgIdx].time	= GET_TSF_TIMER_LOW();\
	AAA_DebugKccMsgArray[AAA_DebugKccMsgIdx].taskId	= x;\
	AAA_DebugKccMsgArray[AAA_DebugKccMsgIdx].p_msg	= y;\
	AAA_DebugKccMsgIdx++;\
	\
	if (AAA_DebugKccMsgIdx == AAA_DEBUGKCCMSGARRAYSIZE)\
	{\
		AAA_DebugKccMsgIdx = 0;\
		AAA_DebugKccMsgLooper++;\
	}\
	OSAL_ENABLE_INTERRUPTS(interrupt_save);\
}
#else
#define AAA_DEBUG_KCC_MSG_MACRO(x,y) {}
#endif
//------------ Debug KCC MSG code ---^^^--------

//------------ Debug kernel scheduler code ---vvv--------
#undef	AAA_DEBUG_KERNEL_SCHEDULER

typedef enum
{
	AAA_DebugKernelSchduler_kernelBefore_scheduledCall,
	AAA_DebugKernelSchduler_kernelAfter_scheduledCall,
	AAA_DebugKernelSchduler_kernelBefore_directCall,
	AAA_DebugKernelSchduler_kernelAfter_directCall,
	AAA_DebugKernelSchduler_vKNLputMessageHigh,
	AAA_DebugKernelSchduler_vKNLputMessageMid,
	AAA_DebugKernelSchduler_vKNLputMessageLow,
	AAA_DebugKernelSchduler_KNL_MIPS_SLEEP,
	AAA_DebugKernelSchduler_MT_vINTTimer1,
	AAA_DebugKernelSchduler_INTTimer0,
	AAA_DebugKernelSchduler_vHIM_HostISR,
	AAA_DebugKernelSchduler_vKNLintrTimer,
	AAA_DebugKernelSchduler_MT_LM_DeliaRecipeTogglingIsr,
	AAA_DebugKernelSchduler_vLM_pac_int,
	AAA_DebugKernelSchduler_vLM_pac_tsf_timer_int,
	AAA_DebugKernelSchduler_vLM_RxFIFOoverflowISR,
	AAA_DebugKernelSchduler_MT_LM_DelLenErrISR,
	AAA_DebugKernelSchduler_MT_LM_EofErrISR,
	AAA_DebugKernelSchduler_MT_LM_RxErrISR,
	AAA_DebugKernelSchduler_MT_LM_TxErrISR,
	AAA_DebugKernelSchduler_LmTpcTimerISR,
	AAA_DebugKernelSchduler_NOT_USED,
	AAA_DebugKernelSchduler_vDMA_ISR,
	AAA_DebugKernelSchduler_vDMA_Abort,
	AAA_DebugKernelSchduler_vINT_OtherCore,
	AAA_DebugKernelSchduler_vINT_AggrTimeout,
	AAA_DebugKernelSchduler_MT_vINT_BAerror,
	AAA_DebugKernelSchduler_vINT_fromUMAC,
	AAA_DebugKernelSchduler_vENC_OnInterrupt,
	AAA_DebugKernelSchduler_MT_vENC_ERR_OnInterrupt,
	AAA_DebugKernelSchduler_MT_vINTTimer1_PromptScheduler,
	SET_KEY_INDEX,
	SET_KEY,
} AAA_DebugKernelScheduler_enum;

#if defined (AAA_DEBUG_KERNEL_SCHEDULER)
typedef struct _AAA_DebugKernelScheduler_t 
{
	uint32							time;
	AAA_DebugKernelScheduler_enum	func_enum;
	uint8							taskId;
	uint16							msgType;
} AAA_DebugKernelScheduler_t;

#if defined (ENET_INC_UMAC)
#define AAA_DEBUGKERNELSCHEDULERARRAYSIZE (50)
#elif defined (ENET_INC_LMAC)
#define AAA_DEBUGKERNELSCHEDULERARRAYSIZE (50)
#endif

extern AAA_DebugKernelScheduler_t AAA_DebugKernelSchedulerArray[AAA_DEBUGKERNELSCHEDULERARRAYSIZE];
extern uint16 AAA_DebugKernelSchedulerIdx, AAA_DebugKernelSchedulerLooper;

#define AAA_DEBUG_KERNEL_SCHEDULER_MACRO(x,y,z) \
{\
	TX_INTERRUPT_SAVE_AREA;\
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);\
	AAA_DebugKernelSchedulerArray[AAA_DebugKernelSchedulerIdx].time			= GET_TSF_TIMER_LOW();\
	AAA_DebugKernelSchedulerArray[AAA_DebugKernelSchedulerIdx].func_enum	= x;\
	AAA_DebugKernelSchedulerArray[AAA_DebugKernelSchedulerIdx].taskId		= y;\
	AAA_DebugKernelSchedulerArray[AAA_DebugKernelSchedulerIdx].msgType		= z;\
	AAA_DebugKernelSchedulerIdx++;\
	\
	if (AAA_DebugKernelSchedulerIdx == AAA_DEBUGKERNELSCHEDULERARRAYSIZE)\
	{\
		AAA_DebugKernelSchedulerIdx = 0;\
		AAA_DebugKernelSchedulerLooper++;\
	}\
	OSAL_ENABLE_INTERRUPTS(interrupt_save);\
}
#else
#define AAA_DEBUG_KERNEL_SCHEDULER_MACRO(x,y,z) {}
#endif
//------------ Debug kernel scheduler code ---^^^--------


#endif //DEBUG_TRACE_H

