/***********************************************************************************
 File:		    Statistics_Api.h			
 Module:	    Debug Environment 
 Purpose: 		To handle all global statistics counters - parallel to the HW 
 				counters in wave500
 Description:   This file is the API of the statistics module which is responsible 
 				of handling the global statistics counters
************************************************************************************/
#ifndef STATISTICS_API_H_
#define STATISTICS_API_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"
#include "RxMpduStructure.h"
#include "HwGlobalDefinitions.h"
#include "mhi_umi.h"
#include "ConfigurationManager_api.h"
#include "Statistics_Descriptors.h"


/*---------------------------------------------------------------------------------
/						Defines 					
/----------------------------------------------------------------------------------*/
#define MAX_AC_PD_COUNTER 				0xFFFF //TBD this define is due to bug in host interface accelerator , when the bug is fixed this define can be removed
#define SIZE_OF_METRICS_FIFO   			16
#define PHY_METRIC_0_AIR_TIME_SHIFT     8 //Place of 11a/n air time packets in Metric 0 offset 8
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/
#define METRICS_INVALID_STATION 0x1ff
#define METRICS_INVALID_VAP 0x1F

typedef struct phyChannelSwitchDone_t_
{
	uint8 	channelSwitchType;
	uint8	channelSwitchBw;
} phyChannelSwitchDone_t;

typedef struct metricFifoEntry
{
	uint32 tsf;
	RX_MPDU_PHY_METRICS rxPhyMetrics;
} metricFifoEntry_t;

/*---------------------------------------------------------------------------------
/						Externals									
/----------------------------------------------------------------------------------*/
#ifdef ENET_INC_ARCH_WAVE600D2
extern HostIfQosCounters_t *pHostIfQosCounters;
extern RxCoordinatorCounters_t *pRxCoorCounters;
#endif
extern HostIfCounters_t *pHostIfCounters;
extern RxCounters_t *pRxCounters;
extern BaaCounters_t *pBaaCounters;



/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/					Public Function Declaration						
/----------------------------------------------------------------------------------*/
#ifndef ENET_INC_ARCH_WAVE600
void StatisticsHandler_RxThUpdateRssi(int8 oldRssi, int8 newRssi, uint8 vapId);
#endif
uint8 StatisticsHandler_returnRssiToDbmVal(void);
uint8 StatisticsHandler_getNoiseOffset(void);
uint8 StatisticsManager_getMainAntIndex(void);
void StatisticsManager_RxThUpdateMainAntIndex(void);
#endif /* HW_STATISTICS_API_H_ */

