#ifndef mt_bcl_task_h_H
#define mt_bcl_task_h_H

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/

#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "Utils_Api.h"

/***************************************************************************/
/***                  Local Constants                                    ***/
/***************************************************************************/


/***************************************************************************/
/*                    External Definitions                               ***/
/***************************************************************************/


/*****BCL On Exeption***********/


typedef struct _LM_BCL_REQUEST
{
    K_MSG*	pBclMsg;
} LM_BCL_REQUEST;



typedef enum
{
    BCL_UNIT_INT_RAM,
    BCL_UNIT_AFE_RAM,
    BCL_UNIT_RFIC_RAM,
	BCL_UNIT_EEPROM
} BCL_UNIT_TYPE;

#define BCL_IDLE  	0
#define BCL_WRITE 	1
#define BCL_READ  	2
#define BCL_LM_BUSY 3



#if defined (ENET_INC_UMAC) || defined (ENET_INC_LMAC)
#define OTHER_CPU_BIT 					(0x00080000) // This bit is turned on in the address when we want UM to access LM memory
#define CLEAR_OTHER_CPU_BIT(addr)		(addr = (addr & ~OTHER_CPU_BIT))
#define SET_OTHER_CPU_BIT(addr)			(addr = (addr | OTHER_CPU_BIT))
#else
#define SET_OTHER_CPU_BIT(addr)			
#endif

/***************************************************************************/
/***                  Function prototypes                                ***/
/***************************************************************************/

/***************************************************************************/
/***                  Static data                                        ***/
/***************************************************************************/




/***************************************************************************/
/***                  Public Routines                                    ***/
/***************************************************************************/

#endif // mt_bcl_task_h_H

