//**********************************************************************
// CMSynergyVer %full_filespec:  mt_phy_statistics.h;1:incl:1 %
// File Name: mt_phy_statistics.h
// Created By renata on Sunday, March 16, 2008 1:00:56 PM
// 
//
// Module:
//
// Purpose: 	A short description of the class purpose.
//
// Description: A detailed description of the class, its attributes and  
//	        whatever information the user & maintainer might find valuable.
// 	             
//
//
//***********************************************************************

#ifndef mt_phy_statistics_h_H
#define mt_phy_statistics_h_H

//#if (ENET_REAL_PHY ==  PHY_REAL_MT_11A_11N)

//#if defined(MT_GLOBAL)
//   #define extern
//   #define I(x) x
//#else
//   #define extern extern
//   #define I(x)
//#endif

//----------------------------------------------------------------------
//                 Include Statements For System Header Files
//----------------------------------------------------------------------




//----------------------------------------------------------------------
//                 Include Statements For Proprietary Header Files
//----------------------------------------------------------------------
typedef struct QBSS_LoadChan_T
{
   uint32 uChLoad;
   uint8  uShapedChLoadPerct;
   uint32 uOwnBssAirTime;
   uint32 uTimeStart;
}QBSS_LoadChan_T;


typedef struct _PHYStat_globalParameters
{
   uint8            uGlobalNoise;
   QBSS_LoadChan_T  sQBSSchannelLoad;
 
}  PHYStat_globalParameters;

typedef struct _PHYStat_testParameters
{
   uint32  uTestEnabled;
   uint32  uChannelLoadValue;
 
} PHYStat_testParameters;

//#ifdef MT_GLOBAL
//= {0,0}
//#endif /* #ifdef MT_GLOBAL */  

//----------------------------------------------------------------------
//                                Extern Statements
//----------------------------------------------------------------------







//#endif //(ENET_REAL_PHY ==  PHY_REAL_MT_11A_11N)

typedef enum PHYMetricIndex
{
	PHY_METRIC_0,
	PHY_METRIC_1,
	PHY_METRIC_2,
	PHY_METRIC_3,
	PHY_METRIC_4,
    PHY_RECEIVE_STATUS
}   PHYMetricIndex_E;

/* PHY metric 2  Noise offset for ANT#0
    4 MSB bits represents integer value of noise
	4 LSB bits represents fraction value of noise*/
#define PHY_METRIC_2_NOISE_ANT_0                    0
#define PHY_METRIC_2_INTEGER_NOISE_ANT_0            4
#define PHY_METRIC_INVERSE_NOISE_VALUE_MASK			0xFFFF
#define PHY_METRIC_8BIT_NOISE_VALUE_MASK	        0xFF
#define PHY_METRIC_4BIT_NOISE_VALUE_MASK	        0xF

// For Gen5 :
#define PHY_METRIC_MCS_OFFSET                    0
#define PHY_METRIC_11B_OFFSET                    5
#define PHY_METRIC_CB_OFFSET                     7

#define PHY_METRIC_MCS_FIRST_4_BITS_MASK         0xF
#define PHY_METRIC_MCS_LAST_BIT_MASK             0x20
#define PHY_METRIC_MCS_LAST_BIT_SHIFT            1
// End of - For Gen5

// For GEN4:

#define PSDU_LEN_MASK			(0x0000FFFF)


#define PHY_METRIC_CBMODE_OFFSET                    30 //CB/nCB specification in PHY metric


/* PHY metrics 0*/
// bit #27 - sCP: For HT frames this bit indicates that the received frame was transmitted
// with short cyclic prefix option.
#define PHY_METRIC_0_SCP_MASK	0x08000000
#define PHY_METRIC_0_SCP_SHIFT	27


/*Phy Metric2*/
/*	The metric bits (marked packet) are :
Phy Metric 2  <31:28> - gen_risc_spare3 (in gen risc) 
Values: 0x00 - No Record
0xFF - Record exists */
#define PHY_METRIC_ANT_SEL_RECORD_MASK		0xF0000000

/*Recieve Status*/
#define PHY_RECEIVE_STATUS_RSSI_ANT_0               0 // ReceiveStatus RSSI offset for ANT#0 [7:0]
#define PHY_RECEIVE_STATUS_RSSIs_MASK               0xFFF00000 //24 bit LSBs stored for RSSI per antenna

#define PHY_HT_MCS_SHIFT							24
#define PHY_HT_MCS_MASK								0x1F
#define PHY_MAX_NOISE_IN_RECEIVE_STATUS             8 // MAX Noise value in receive status that store as a part of receive status in RxMPDU


/*   Rate <2..0>
<3> - 802.11b\802.11a (Single Carrier\Multi Carrier)
<4> - HT rate (802.11n)
<5> - Channel bonding Indication
<6> - Last Packet in aggergate 
<7> - Aggregate Packet Indication
*/
#define PHY_METRIC_LEGACY                           0 //Defines an existing a phy metric in the received packet
#define PHY_METRIC_MIDDLE_FRAME_AGGR			    2
#define PHY_METRIC_LAST_FRAME_AGGR                  3

#define AGGREGATION_STATUS_BITS_SHIFT 	0
#define AGGREGATION_STATUS_BITS_MASK	0x3
#define AGGREGATION_STATUS_INFO(psMPDU) ((psMPDU)->rxMpduInfo_p->sPhyRxInfo.u8HwInfo)
#define AGGREGATION_STATUS_CHECK_FRAME_POS(psMPDU)   ((AGGREGATION_STATUS_INFO(psMPDU) & AGGREGATION_STATUS_BITS_MASK) >> AGGREGATION_STATUS_BITS_SHIFT)

#undef MT_EXTERN
#undef I

#endif // mt_phy_statistics_h_H
