/***********************************************************************************
 File:			StatisticsHandler.h			
 Module:		Debug Enviroment 
 Purpose:			
 Description:	Definition for the Hw Counter Handling
************************************************************************************/
#ifndef HW_STATISTICS_HANDLER_H_
#define HW_STATISTICS_HANDLER_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwCounters.h"

/*---------------------------------------------------------------------------------
/						Defines 					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/					Public Function Declaration						
/----------------------------------------------------------------------------------*/

#ifndef ENET_INC_ARCH_WAVE600
void StatisticsHandler_SetRxThReq(K_MSG *statisticsManagerMsg);
void StatisticsHandler_RxThRemoveSta(StaId staId, uint8 vapId);
void StatisticsHandler_RxThAddSta(K_MSG *statisticsManagerMsg);
void StatisticsManager_InitRxThDB(void);
void StatisticsHandler_UpdateBssLoadIeAdmissionCapacity(uint8 vapIndex, uint16 admissionCapacity);

#endif //ENET_INC_ARCH_WAVE600

void StatisticsCalcLinkAdaptationOffsets(void);
void StatisticsHandler_Init(void);
void StatisticsHandler_UpdateBssLoadIeChannelUtilization(uint8 channelUtilization);

uint16 StatisticsHandler_GetAdmissionCapacity(uint8 vapId);


#endif /* HW_STATISTICS_HANDLER_H_ */
