
/***************************************************************
 File:		StatisticsPhyHandler.h
 Module:	  	StatisticsPhyHandler
 Purpose: 	holds the definions for the Statistics Phy Handler module 
 Description:  This file contains the definions of the Statistics Phy Handlerr module which 
 			is responsible to pass the phy statistic to host
***************************************************************/
#ifndef STATISTIC_PHY_HANDLER_H_
#define STATISTIC_PHY_HANDLER_H_
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"

#include "OSAL_Kmsg.h"

#ifndef ENET_INC_ARCH_WAVE600
// defines
#define CONVERT_PHY_LOG10_TO_LOG2(value) ((value)*3)  // 10log10( x ) = 3log2( x ) 
#define REMOVE_PHY_RESOLUTION(value) ((value) >> 4)  // remove resolution
#endif
void PhyStatistics_MetricsFifoNotEmpty(K_MSG* msg);
void PhyStatistics_GetPhyStatusReq(void);
void PhyStatistics_DmaDone(void);
void PhyStatistics_SetAntennaActiveBitmap(K_MSG* psMsg);

#ifndef ENET_INC_ARCH_WAVE600
int32 PhyStatistics_getTotalRssi(void);
int8 PhyStatistics_getRssi(StaId stationId);
void PhyStatistics_addStaPhyRxStatus(StaId stationId, uint8 maxRssi);
void PhyStatistics_removeStaPhyRxStatus(StaId stationId);
void PhyStatistics_addSta(StaId stationId);
void PhyStatistics_resetStaPhyRxStatus(void);
#else
void PhyStatistics_addSta(StaId stationId,uint8 maxRssi);
void PhyStatistics_ChannelLoadCalculated(K_MSG* msg);
void PhyStatistics_ChannelSwitchNotify(K_MSG* msg);
#endif //ENET_INC_ARCH_WAVE600

void PhyStatistics_HdkStatisticsCfm(K_MSG* msg);
void PhyStatistics_removeSta(StaId stationId);
void PhyStatistics_removeStaPhyRxStatus(StaId stationId);

void PhyStatistics_Init(void);
void PhyStatistics_UpdateHdkAntsInfo(K_MSG* psMsg);
void PhyStatistics_UpdateHdkChannelWidthInfo(K_MSG* psMsg);
void PhyStatistics_GetAntsAndChannelWidth(uint8 * maxAnts,uint8 * antMask, uint8* channelWidth);
void PhyStatistics_UpdateMaxEvm(K_MSG* psMsg);
#endif /*STATISTIC_PHY_HANDLER_H_ */

