/***********************************************************************************
 File:			CpuLoad.c			
 Module:			Debug Enviroment Purpose:			
 Description:		Calcultate the CPU idle time
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "Pac_Api.h"
#include "CpuLoad_Api.h"

#include "loggerAPI.h"


/*---------------------------------------------------------------------------------
/						Defines 					
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_DEBUG_ENVIRONMENT
#define LOG_LOCAL_FID 1

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
#if defined(CALCULATE_CPU_IDLE_TIME)
/*        calculate CPU idle time variables        */
volatile uint32 CalcCPUIdle_isInSleep = 0;
volatile uint32 CalcCPUIdle_enterSleepTime = 0;
volatile uint32 CalcCPUIdle_totalSleepTime = 0;
volatile uint32 CalcCPUIdle_LastPrint = 0;
uint16 cpuLoadArrayLm[CPU_IDLE_ARRAY_SIZE] = {0};
uint16 cpuLoadArrayLmIndex = 0;

/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/




/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
#endif /* defined(CALCULATE_CPU_IDLE_TIME) */






/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

