/* CMSynergyVer %full_filespec: mt_bcl_task.c;5.1.2.1.2.1.2.1.1:csrc:1 % */
/*****************************************************************************
 **
 ** COMPONENT:      Metalink BCL Studio task
 **
 ** MODULE:         $File: /develop/src/mac_upper/mt_bcl_task.c $
 **
 ** VERSION:        $Revision: #16 $
 **
 ** DATED:          $Date: 2005/09/26 $
 **
 ** AUTHOR:         Amit Danenberg
 **
 ** DESCRIPTION:    Task to process BCL requests over PCI
 **
 ****************************************************************************/

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/

#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "OSAL_Kmsg.h"
#ifndef DISABLE_EEPROM_FW_SUPPORT
#include "mt_eeprom.h"
#endif
#include "init_ifmsg.h"
#include "mt_bcl_task.h"
#include "loggerAPI.h"
#include "Utils_Api.h"
#include "um_interface.h"

#define LOG_LOCAL_GID GLOBAL_GID_DEBUG_ENVIRONMENT 
#define LOG_LOCAL_FID 4



/***************************************************************************/
/***                  Local Constants                                    ***/
/***************************************************************************/


/***************************************************************************/
/*                    External Definitions                               ***/
/***************************************************************************/


/*****BCL On Exeption***********/

PRAGMA_START_DATA
MAP_TO_SECTION(bss, ".SHARED_RAM_BCL_ON_EXCEPTION")

volatile uint32 MTG_BCL_request;       // 0 = idle; 1 = write; 2 = read;
UMI_BCL_REQUEST MTG_BCL_data;


MAP_TO_DEFAULT_SECTION(bss)
PRAGMA_END_DATA


/***************************************************************************/
/***                  Function prototypes                                ***/
/***************************************************************************/

/***************************************************************************/
/***                  Static data                                        ***/
/***************************************************************************/


/***************************************************************************/
/***                  Public Routines                                    ***/
/***************************************************************************/


/****************************************************************************
**
** NAME:           MT_vUM_CommonManSetBclValueReq
**
** PARAMETERS:	   psBCL- pointer to UMI_BCL_REQUEST struct	
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Performs the write instruction handling common to both a
**                 UM_MAN_SET_BCL_VALUE_REQ message and a BCL write request
**                 on exception.
**
****************************************************************************/
  void MT_vUM_CommonManSetBclValueReq(UMI_BCL_REQUEST *psbcl)
{
	uint32   *psaddr;
	uint32   i;
	uint32   bytes2Read;

	if (psbcl == NULL)
	{
		return;
	}
	if (psbcl->Address == 0)
	{
		return;
	}
	bytes2Read = (psbcl->Size > MAX_GENERIC_REQ_DATA) ? MAX_GENERIC_REQ_DATA : psbcl->Size;

	switch ( psbcl->Unit )
	{
	   case BCL_UNIT_INT_RAM:
	       psaddr = (uint32 *)(psbcl->Address); 
		   for (i = 0; i < bytes2Read; i++)
		   {
		     *(psaddr+i) = psbcl->Data[i];
		   }
	       break;
	   case BCL_UNIT_AFE_RAM:
	       break;
	   case BCL_UNIT_RFIC_RAM:
	       break;
#ifndef DISABLE_EEPROM_FW_SUPPORT
           case BCL_UNIT_EEPROM:
           for (i = 0; i < bytes2Read; i++)
		   {
		      Eeprom_Write_Byte(psbcl->Address+i,(uint8)(psbcl->Data[i]));
	       }
	       break;
#endif// DISABLE_EEPROM_FW_SUPPORT
	   default:
	       /* Illegal unit number */
	       break;
	}
}
/****************************************************************************
**
** NAME:           MT_vUM_CommonManQueryBclValueReq
**
** PARAMETERS:	   psBCL- pointer to UMI_BCL_REQUEST struct	
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Performs the write instruction handling common to both a
**                 UM_MAN_SET_BCL_VALUE_REQ message and a BCL write request
**                 on exception.
**
****************************************************************************/
  void MT_vUM_CommonManQueryBclValueReq(UMI_BCL_REQUEST *psbcl)
{
	uint32   *psaddr;
	uint32   i;
	uint32   bytes2Read;

#ifndef DISABLE_EEPROM_FW_SUPPORT
  	uint8    eeprom_read_byte;
#endif// DISABLE_EEPROM_FW_SUPPORT

	if (psbcl == NULL)
	{
		return;
	}

	if (psbcl->Address == 0)
	{
		return;
	}
	bytes2Read = (psbcl->Size > MAX_GENERIC_REQ_DATA) ? MAX_GENERIC_REQ_DATA : psbcl->Size;
	switch ( psbcl->Unit )
	{
	   case BCL_UNIT_INT_RAM:
	       psaddr = (uint32 *)(psbcl->Address); 
		   for (i = 0; i < bytes2Read; i++)
		   {
		     psbcl->Data[i] = *(psaddr+i);
		   }
	       break;
	   case BCL_UNIT_AFE_RAM:
	       break;
	   case BCL_UNIT_RFIC_RAM:
	       break;
#ifndef DISABLE_EEPROM_FW_SUPPORT
	   case BCL_UNIT_EEPROM:

	       for (i = 0; i<bytes2Read; i++)
		   {
		       Eeprom_Read_Byte(psbcl->Address+i,&eeprom_read_byte);
			   psbcl->Data[i] =(uint32)(eeprom_read_byte);
		   }
           break; 
#endif// DISABLE_EEPROM_FW_SUPPORT
 	   default:
	       /* Illegal unit number */
	       break;
	}
}

/****************************************************************************
**
** NAME:           MT_CheckBclOnException
**
** PARAMETERS:	   none
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Performs the write instruction handling common to both a
**                 UM_MAN_SET_BCL_VALUE_REQ message and a BCL write request
**                 on exception.
**
****************************************************************************/
void MT_CheckBclOnException()
{
	// WRITE BCL
	if (MTG_BCL_request==BCL_WRITE)
	{
#if defined (ENET_INC_LMAC)
		if (((MTG_BCL_data.Address & OTHER_CPU_BIT) != 0) && (IS_ADDRESS_IN_IRAM(MTG_BCL_data.Address) == TRUE))
		{
			// Address is in LM
			MTG_BCL_request = BCL_LM_BUSY; // change state so that UM will not read the same address after we move the OTHER_CPU_BIT
			CLEAR_OTHER_CPU_BIT(MTG_BCL_data.Address);
			MT_vUM_CommonManSetBclValueReq(&MTG_BCL_data);
			SET_OTHER_CPU_BIT(MTG_BCL_data.Address);
			MTG_BCL_request = BCL_IDLE;					
		}
#else
		if (((MTG_BCL_data.Address & OTHER_CPU_BIT) == 0) || (IS_ADDRESS_IN_IRAM(MTG_BCL_data.Address) == FALSE))
		{
			if (MTG_BCL_request == BCL_WRITE) // Make sure there was no race that LM didn't clear the other cpu bit while UM already checked 
			{		
				// Address is in UM / AR10
				MT_vUM_CommonManSetBclValueReq(&MTG_BCL_data);
				MTG_BCL_request = BCL_IDLE;
			}
		}
#endif		
	}
	// READ BCL
	else if (MTG_BCL_request==BCL_READ)
	{
#if defined (ENET_INC_LMAC)
		if (((MTG_BCL_data.Address & OTHER_CPU_BIT) != 0) && (IS_ADDRESS_IN_IRAM(MTG_BCL_data.Address) == TRUE))
		{
			// Address is in LM
			MTG_BCL_request = BCL_LM_BUSY;
			CLEAR_OTHER_CPU_BIT(MTG_BCL_data.Address);
			MT_vUM_CommonManQueryBclValueReq(&MTG_BCL_data);
			SET_OTHER_CPU_BIT(MTG_BCL_data.Address);
			MTG_BCL_request = BCL_IDLE; 				
		}
#else
		if (((MTG_BCL_data.Address & OTHER_CPU_BIT) == 0) || (IS_ADDRESS_IN_IRAM(MTG_BCL_data.Address) == FALSE))
		{
			if (MTG_BCL_request == BCL_READ) // Make sure there was no race that LM didn't clear the other cpu bit while UM already checked 
			{
				// Address is in UM / AR10
				MT_vUM_CommonManQueryBclValueReq(&MTG_BCL_data);
				MTG_BCL_request = BCL_IDLE;
			}
		}
#endif		
	}
}

#if defined (ENET_INC_UMAC)
void MT_BclOnExceptionInit(void)
{
	MTG_BCL_request = 0;
	memset(&MTG_BCL_data, 0, sizeof(UMI_BCL_REQUEST));
}
#endif	



