/***********************************************************************************
 File:			StatisticsHandler.c			
 Module:			Debug Enviroment 
 Purpose:			
 Description:		
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwCounters.h"
#include "HwMemoryMap.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "loggerAPI.h"
#include "StatisticsHandler.h"
#include "Statistics_Api.h"
#include "shramTxDesc.h"
#include "PhyDriver_API.h"
#include "Utils_Api.h"
#include "BSSmanager_API.h"
#include "StatisticsPhyHandler.h"
#include "PSD.h"
#include "Pac_Api.h"
#include "StatisticsManager_api.h"
#include "ShramStatistics.h"

/*---------------------------------------------------------------------------------
/						Defines 					
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_DEBUG_ENVIRONMENT
#define LOG_LOCAL_FID 8

#define RX_TH_MIN_VALUE		RX_THRESHOLD_DEFAULT_VALUE
#define RX_TH_MAX_VALUE 	127
#define RX_TH_OFFSET_DOWN	2
#define RX_TH_OFFSET_UP		7
#define RX_TH_PHY_REPORT_INIT	(RX_TH_MIN_VALUE)
#define MAX_NUM_OF_ACTIVE_RSSI 	(256)
#define RX_TH_INDEX_MASK		(0x00FF)
#define ACTIVE_RSSI_BITMAP_SIZE 				((MAX_NUM_OF_ACTIVE_RSSI + 7)>>3)
#define ACTIVE_RSSI_BITMAP_SIZE_IN_WORDS 		((ACTIVE_RSSI_BITMAP_SIZE +3)>>2)

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Variables									
/----------------------------------------------------------------------------------*/
HostIfCounters_t *pHostIfCounters;
RxCounters_t *pRxCounters;
BaaCounters_t *pBaaCounters;
UplinkBsrcTidCnt_t *pUpLinkBsrcCounters;
//uint8  statsChannelWidth;

/*---------------------------------------------------------------------------------
/						Debug									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

/**********************************************************************************

StatisticsHandler_returnRssiToDbmVal



Description:
------------
	
	
Input:
-----
	
	
**********************************************************************************/
uint8 StatisticsHandler_returnRssiToDbmVal(void)
{
	return GEN6_PHY_RSSI_TO_DBM; 
}

/**********************************************************************************

StatisticsHandler_getNoiseOffset




Description:
------------
	
	
Input:
-----
	
	
**********************************************************************************/
uint8 StatisticsHandler_getNoiseOffset(void)
{
	return GEN6_NOISE_OFFS;
}


void StatisticsCalcLinkAdaptationOffsets(void)
{
	/*get the address of the VAP Frame error count*/	
	LinkAdaptationVapFrameErrorCountBaseAddress = (uint32)(&(pBaaCounters->txSenderError));

	/*get the address of the WLAN Frame error count*/	
	LinkAdaptationWlanFrameErrorCountBaseAddress =	(uint32)(&(pBaaCounters->txFrameErrorCount));
}


/**********************************************************************************

StatisticsHandler_Init 

Description:
------------
	Set all Hw Counters to 0
		

**********************************************************************************/
void StatisticsHandler_Init(void)
{
	pHostIfCounters =  (HostIfCounters_t*)HOST_IF_COUNTERS_BASE_ADDR;
	pRxCounters =  (RxCounters_t*)RX_PP_COUNTERS_BASE_ADDR;
	pUpLinkBsrcCounters = (UplinkBsrcTidCnt_t*)BSRC_CNT_MEM_BASE_ADDR;
	pBaaCounters = (BaaCounters_t *)BA_ANALYZER_COUNTER_BASE_ADDR;
}


/**********************************************************************************

StatisticsHandler_UpdateBssLoadIeChannelUtilization 

Description:
------------
	updates channel load in bssload ie in shram
	
Input:
-----
	uint8 channelUtilization - current channel load read value

************************************************************************************/
void StatisticsHandler_UpdateBssLoadIeChannelUtilization(uint8 channelUtilization)
{
	uint8 vapId = 0;
	
	// todo: go over all vaps and update only active vaps
#ifndef GEN6_REL3_5_HW_BUG_PATCH
	ASSERT(0); // TBD CDB - This for loop doesn't support CDB. Need to loop over only the VAPs of the relevant band.
#endif

	for (vapId = 0; vapId < HW_NUM_OF_VAPS; vapId++)
	{
		bssLoadIePayload[vapId].bssLoad.channelUtilization = (channelUtilization * MAX_UINT8)/HUNDRED_PERCENT;
	}
}


/**********************************************************************************

statisticsGetHostIfCountersAddress 


Description:
------------

Input: 
-----
		
Output:
-------
	
Returns:
--------
Address in memory of the statistic
	
**********************************************************************************/
uint32* statisticsGetHostIfCountersAddress(void)
{
	return ((uint32*)pHostIfCounters);
}

/**********************************************************************************

statisticsGetRxCountersAddress 


Description:
------------

Input: 
-----
		
Output:
-------
	
Returns:
--------
Address in memory of the statistic
	
**********************************************************************************/
uint32* statisticsGetRxCountersAddress(void)
{
	return ((uint32*)pRxCounters);
}

/**********************************************************************************

statisticsGetUpLinkBsrcCountersAddress 


Description:
------------

Input: 
-----
		
Output:
-------
	
Returns:
--------
Address in memory of the statistic
	
**********************************************************************************/
uint32* statisticsGetUpLinkBsrcCountersAddress(void)
{
	return ((uint32*)pUpLinkBsrcCounters);
}

/**********************************************************************************

statisticsGetBaaxCountersAddress 


Description:
------------

Input: 
-----
		
Output:
-------
	
Returns:
--------
Address in memory of the statistic
	
**********************************************************************************/
uint32* statisticsGetBaaCountersAddress(void)
{
	return ((uint32*)pBaaCounters);
}


