/***************************************************************
 File:		DmaManager_Api.h
 Module:	  	DmaManager  interface
 Purpose: 	interface of the DmaManager
 Description:  	This file is the API to the DmaManager module  
***************************************************************/

#ifndef DMA_MANAGER_API_H_
#define DMA_MANAGER_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "InterruptManager_Api.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define NUM_OF_DMA_CLIENTS_PER_CHANNEL 11
#if defined (ENET_INC_ARCH_WAVE600)
#define DMA_DEBUG 1
#endif
//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



typedef enum {
	DMA_PRIORITY_0 = 0,// Lowest priority
	DMA_PRIORITY_1 = 1,
	DMA_PRIORITY_2 = 2,
	DMA_PRIORITY_3 = 3,
	DMA_PRIORITY_4 = 4,
	DMA_PRIORITY_5 = 5,	// Highest priority
	NUM_OF_DMA_PRIORITIES = 6
}dmaPriority_e; 


typedef struct dmaRegistration
{
	uint8 priority;
	uint8 eventId;
}dmaRegistration_t;


typedef enum {
	DMA_DIRECTION_HOST_TO_SHRAM = 0,
	DMA_DIRECTION_SHRAM_TO_HOST,
	DMA_DIRECTION_SHRAM_TO_SHRAM,
#ifdef ENET_INC_ARCH_WAVE600D2
	DMA_DIRECTION_HOST_IF_QOS_TO_HOST,
#endif
	DMA_DIRECTION_HOST_IF_TO_HOST,
#ifdef ENET_INC_ARCH_WAVE600D2
	DMA_DIRECTION_RX_COORDINATOR_TO_HOST,
#endif
	DMA_DIRECTION_RXCOUNTERS_TO_HOST,
	DMA_DIRECTION_BAACOUNTERS_TO_HOST,
	DMA_DIRECTION_BSRCOUNTERS_TO_HOST,
	DMA_DIRECTION_SKIP,
	DMA_DIRECTION_INVALID,
	NUM_OF_DMA_DIRECTIONS
}dmaDirection_e; 



typedef struct dmaDescTag
{
	uint32 source;
	uint32 destination;
	uint8 direction;
	uint8 clientId;
	uint16 length;
 	struct dmaDescTag* pNexdDmaDesc;
}dmaDesc_t;

typedef struct dmaDescQ
{
	dmaDesc_t* pHead;
	dmaDesc_t* pTail;
}dmaDescQ_t;


typedef struct dmaClientDb
{	
	uint8 priority;
	uint8 eventId;
	uint32 transferCount;
}dmaClientDb_t;

typedef struct dmaChannelDb
{
	dmaClientDb_t dmaClientDB[NUM_OF_DMA_CLIENTS_PER_CHANNEL];
	uint8 nextAvailableClientID;
	dmaDesc_t* activeDmaDesc;
	uint8 dmaBusyFlag;
	dmaDescQ_t dmaPendDescQ[NUM_OF_DMA_PRIORITIES];
}dmaChannelDb_t;


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------

void Dma_HwInit(void);
void DmaManager_Init(void);
uint8 DmaManager_Register(dmaRegistration_t* DMA_register);
dmaDesc_t* DmaManager_AllocateDesc(void);
uint32 DmaManager_GetTransferCount(uint8 clientId);
void dmaManagerAddDescToPendQ(dmaDesc_t* pDmaDesc);
dmaDesc_t* dmaManagerGetPendDesc(void);
void DmaManager_ReleaseDesc(dmaDesc_t* pDmaDesc);
void DmaManager_NewDmaRequest(dmaDesc_t* dmaDesc);
void dmaManagerDmaHwDone(void);

ISR_VOID isr_DmaDone(void);

void DmaDriver_ActivateHW(dmaDesc_t* pDmaDesc);
#if (DMA_DEBUG)
void DmaDriver_UpdateFwDmaStatus(void);
void DmaDriver_ResetFwDmaStatus(void);

#endif


#endif /* DMA_MANAGER_API_H_ */

