/***********************************************************************************
 File:			DmaHandler.h
 Module:			DmaHandler 
 Purpose: 		Driver for DMA controler
 Description:		Driver for DMA controler
 				
************************************************************************************/
#ifndef DMAC_WRAPPER_H_
#define DMAC_WRAPPER_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "ShramDmacWrapper.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

// Move to DMA regs file?
#define DMA_ENABLE_INTERRUPTS_ALL_CHANNELS   (0x0F00)
#ifdef ENET_INC_ARCH_WAVE600
#define DMAC_WRAPPER_CHANNEL_CODING_ALLOCATED_SPACE     				(0x18)  
#define DMAC_WRAPPER_CHANNEL_CONFIG_CYCLIC_BUFF_FLOW_CONTROL_DISABLE   	(0x0)
#define DMAC_WRAPPER_CHANNEL_CONFIG_CYCLIC_BUFF_FLOW_CONTROL_ENABLE    	(0x1)
#define DMAC_WRAPPER_CHANNEL_CONFIG_CACHE_INVALID_ENABLE				(0x1)

#define DMAC_WRAPPER_CHANNEL_CONFIG_BUS_AND_TRANSFER_SIZE_16_BYTES		(0x3) // [1] - ch max transfer: 256 Bytes , [0] - ch dma bus size: 128bit

#define DMAC_WRAPPER_CONFIG_AXI_ADDR_TOGGLE_VAL_FIXED_ZERO 				(0x0)
#define DMAC_WRAPPER_CONFIG_AXI_ADDR_TOGGLE_VAL_FIXED_ONE 				(0x1)
#define DMAC_WRAPPER_CONFIG_AXI_ADDR_TOGGLE_VAL_TOGGLE 					(0x3)

// channel manipulation image start address calculation must not be greater than 16bit (i.e. < 0x10000) (calculation example below is for dma1 ch3):
// Manip_ba_b4_shift = dma1_ch_manip_ba + (8 * 4) + (dma1_ch_code_alloc * 3)  + dma1_ch3_prg_len
// Manip_ba = Manip_ba_b4_shift * 8
#define DMAC_WRAPPER_DMA1_CHANNEL_MANIP_BA_MAX_ADDRESS 					(0x1F8C)

#else
#define DMAC_WRAPPER_CHANNEL_CODING_ALLOCATED_SPACE      (0x20)  // units 64b. 


#endif

#define DMAC_WRAPPER_HEADER_MONITOR_OFFSET               (0x0)
#define DMAC_WRAPPER_HEADER_MONITOR_CHANNEL_0	         (0x0)
#define DMAC_WRAPPER_HEADER_MONITOR_ENABLE		         (0x1)
#define DMAC_WRAPPER_LAST_JOB_ID_INT_CHANNEL_SELECTION_2 (0x2)
#define DMAC_WRAPPER_TX_BUFFER_FULL_MARGIN               (0x80)
#define DMAC_WRAPPER_SENDER_ALIGNER_ENABLE		         (0x1)
#define DMAC_WRAPPER_SENDER_ALIGNER_DISABLE		         (0x0)

#define DMAC_WRAPPER_CHANNEL_0_LAST_JOB_DONE_INT  (0x1)
#define DMAC_WRAPPER_CHANNEL_1_LAST_JOB_DONE_INT  (0x2)
#define DMAC_WRAPPER_CHANNEL_2_LAST_JOB_DONE_INT  (0x4)
#define DMAC_WRAPPER_CHANNEL_3_LAST_JOB_DONE_INT  (0x8)

#define DMAC_WRAPPER_ALL_CHANNELS_LAST_JOB_ID_ENABLE     (0xF)

#define DMAC_WRAPPER_CHANNEL_CONFIG_PRIORITY_0 			 (0x0)
#define DMAC_WRAPPER_CHANNEL_CONFIG_PRIORITY_1 			 (0x1)
#define DMAC_WRAPPER_CHANNEL_CONFIG_PRIORITY_2 			 (0x2)
#define DMAC_WRAPPER_CHANNEL_CONFIG_PRIORITY_3 			 (0x3)

#define DMAC_WRAPPER_CHANNEL_CONFIG_NO_SWAP						(0x0)
#define DMAC_WRAPPER_CHANNEL_CONFIG_SWAP_BYTES_WITHIN_SHORTS	(0x1)
#define DMAC_WRAPPER_CHANNEL_CONFIG_SWAP_BYTES_WITHIN_WORDS		(0x2)
#define DMAC_WRAPPER_CHANNEL_CONFIG_SWAP_BYTES_WITHIN_DWORDS	(0x3)

#define DMAC_WRAPPER_CHANNEL_CONFIG_EXTERNAL_FLOW_CONTROL_INPUT_DISABLE   (0x0)
#define DMAC_WRAPPER_CHANNEL_CONFIG_EXTERNAL_FLOW_CONTROL_INPUT_ENABLE    (0x1)

#define DMAC_WRAPPER_CHANNEL_CONFIG_TX_CYCLIC_BUFF_FLOW_CONTROL_DISABLE   (0x0)
#define DMAC_WRAPPER_CHANNEL_CONFIG_TX_CYCLIC_BUFF_FLOW_CONTROL_ENABLE    (0x1)

#define DMAC_WRAPPER_CHANNEL_CONFIG_WRITE_BARRIER_MODE_DISABLE  		  (0x0)
#define DMAC_WRAPPER_CHANNEL_CONFIG_WRITE_BARRIER_MODE_ENABLE   		  (0x1)

#define DMAC_WRAPPER_CHANNEL_CONFIG_LOAD_OPTIMIZATION_DISABLE  		  	  (0x0)
#define DMAC_WRAPPER_CHANNEL_CONFIG_LOAD_OPTIMIZATION_ENABLE   		      (0x1)

#define DMAC_WRAPPER_CHANNEL_CONFIG_SIZEOF_PROGRAM						  (0xC)
#define DMAC_WRAPPER_CHANNEL_CONFIG_SIZEOF_PROGRAM_ALIGNER_ENABLED		  (0x6)	

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------



#endif /* DMAC_WRAPPER_H_ */

