/***********************************************************************************
 File:		DmaManager.c
 Module:		DmaManager
 Purpose:		
 Description:	FW driver for DmaManager module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "DmaManager_Api.h"
#include "HwQManager_API.h"
#include "RegAccess_Api.h"
#include "OSAL_Api.h"
//#include "DmacWrapperRegs.h"
#include "EventsManager_api.h"
#include "loggerAPI.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_DMA_MANAGER
#define LOG_LOCAL_FID 2

#define NUM_OF_DMA_DESCRIPTORS 100

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/
	

/*---------------------------------------------------------------------------------
/						Static Function Declaration 								
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static variables Declaration									
/----------------------------------------------------------------------------------*/



dmaChannelDb_t dmaDb;
dmaDesc_t dmaDescPool[NUM_OF_DMA_DESCRIPTORS];
dmaDesc_t* pDmaPoolHead;


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/



#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
uint8 DmaManager_Register(dmaRegistration_t* DMA_register)
{
	uint8 clientId = 0;

	clientId = dmaDb.nextAvailableClientID;
	DEBUG_ASSERT(clientId < NUM_OF_DMA_CLIENTS_PER_CHANNEL);
	
	dmaDb.dmaClientDB[clientId].priority = DMA_register->priority;
	dmaDb.dmaClientDB[clientId].eventId = DMA_register->eventId;

	dmaDb.nextAvailableClientID++;

	return clientId;
	
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

dmaDesc_t* DmaManager_AllocateDesc(void)
{
	TX_INTERRUPT_SAVE_AREA;

	dmaDesc_t* pDmaDesc = NULL;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	pDmaDesc = pDmaPoolHead;
	pDmaPoolHead = pDmaDesc->pNexdDmaDesc;
	pDmaDesc->pNexdDmaDesc = NULL;

	OSAL_ENABLE_INTERRUPTS(interrupt_save);	

	return pDmaDesc;
}


void DmaManager_ReleaseDesc(dmaDesc_t* pDmaDesc)
{
	pDmaDesc->pNexdDmaDesc = pDmaPoolHead;
	pDmaPoolHead = pDmaDesc;
}

void DmaManager_NewDmaRequest(dmaDesc_t* pDmaDesc)
{
	TX_INTERRUPT_SAVE_AREA;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	if (!dmaDb.dmaBusyFlag)
	{
		dmaDb.dmaBusyFlag = TRUE;	

		OSAL_ENABLE_INTERRUPTS(interrupt_save);
		dmaDb.activeDmaDesc = pDmaDesc;	
	
		DmaDriver_ActivateHW(pDmaDesc);
	}
	else
	{
#if  DMA_DEBUG
		DmaDriver_UpdateFwDmaStatus();
#endif
		dmaManagerAddDescToPendQ(pDmaDesc);
		OSAL_ENABLE_INTERRUPTS(interrupt_save);

	}
}

uint32 DmaManager_GetTransferCount(uint8 clientId)
{
	return 	dmaDb.dmaClientDB[clientId].transferCount;
}

void dmaManagerAddDescToPendQ(dmaDesc_t* pDmaDesc)
{
	uint8 dmaPriority;
	uint8 clientId =  pDmaDesc->clientId;

	dmaPriority = dmaDb.dmaClientDB[clientId].priority;

	if (dmaDb.dmaPendDescQ[dmaPriority].pHead == NULL)
	{
		dmaDb.dmaPendDescQ[dmaPriority].pHead = pDmaDesc;
	}
	else
	{
		dmaDb.dmaPendDescQ[dmaPriority].pTail->pNexdDmaDesc= pDmaDesc;
	}

	dmaDb.dmaPendDescQ[dmaPriority].pTail = pDmaDesc;

}

void dmaManagerDmaHwDone(void)
{
	uint8 clientId;
	dmaDesc_t* pDmaDesc;
	uint8 eventId;
	pDmaDesc = dmaDb.activeDmaDesc;
	clientId = pDmaDesc->clientId;

	dmaDb.dmaClientDB[clientId].transferCount++;

 	DmaManager_ReleaseDesc(pDmaDesc);

	eventId = dmaDb.dmaClientDB[clientId].eventId;

	EventManager_TriggerSwEvent((eventId_e)eventId);

	pDmaDesc = dmaManagerGetPendDesc();

	if (pDmaDesc)
	{
		dmaDb.activeDmaDesc = pDmaDesc;	
		DmaDriver_ActivateHW(pDmaDesc);
	}
	else
	{
		dmaDb.dmaBusyFlag = FALSE;
#if DMA_DEBUG
		DmaDriver_ResetFwDmaStatus();
#endif
	}
}

dmaDesc_t* dmaManagerGetPendDesc(void)
{
	dmaDesc_t* pDmaDesc = NULL;
	uint8 dmaPriority = NUM_OF_DMA_PRIORITIES;

	while (dmaPriority > 0)
	{
		pDmaDesc = dmaDb.dmaPendDescQ[dmaPriority -1].pHead;
		if (pDmaDesc)
		{
			dmaDb.dmaPendDescQ[dmaPriority -1].pHead = pDmaDesc->pNexdDmaDesc;
			pDmaDesc->pNexdDmaDesc = NULL;
			break; 	
		}
		dmaPriority--;
	}
	return pDmaDesc;
}

#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

void DmaManager_Init(void)
{
	uint8 descIndex;

	/*Clear the whole DMA DB*/
	memset(&dmaDb, 0, sizeof(dmaDb));
	
	for (descIndex = 0 ; descIndex < NUM_OF_DMA_DESCRIPTORS ; descIndex++)
	{
		dmaDescPool[descIndex].pNexdDmaDesc = &dmaDescPool[descIndex + 1];
	}
	dmaDescPool[NUM_OF_DMA_DESCRIPTORS - 1].pNexdDmaDesc = NULL;

	pDmaPoolHead = &dmaDescPool[0];

	Dma_HwInit();	

}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif






