/***********************************************************************************
 File:		DmaDriver.c
 Module:		DmaDriver
 Purpose:		
 Description:	FW driver forDmaDriver module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "DmaManager_Api.h"
#include "HwQManager_API.h"
#include "RegAccess_Api.h"
#include "OSAL_Api.h"
#include "DmacWrapperRegs.h"
#include "DmacWrapper.h"
#include "WlanArmDmaRegs.h"
#include "ShramDmacWrapper.h"
#include "stringLibApi.h"
#include "HwMemoryMap.h"




#include "loggerAPI.h"



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_DMA_MANAGER
#define LOG_LOCAL_FID 0

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/
typedef void (*DmaGeneralFunc)(dmaDesc_t* pDmaDesc);


typedef union
{
	uint32	val;
	struct 
	{
		uint32	interruptEnable:32;                                    /*  */ 
	} bitFields; 
} RegDmaIntEnableReg_u; 



/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

void dmaDriverHostToShramHandler(dmaDesc_t* pDmaDesc);
void dmaDriverShramToHostHandler(dmaDesc_t* pDmaDesc);
void dmaDriverShramToShramHandler(dmaDesc_t* pDmaDesc);
void dmaDriverHostIfToHostHandler(dmaDesc_t* pDmaDesc);
void dmaDriverRxcountersToHostHandler(dmaDesc_t* pDmaDesc);
void dmaDriverBaacountersToHostHandler(dmaDesc_t* pDmaDesc);
void dmaDriverSkipHandler(dmaDesc_t* pDmaDesc);
void dmaDriverInvalidHandler(dmaDesc_t* pDmaDesc);


/*---------------------------------------------------------------------------------
/						Static variables Declaration									
/----------------------------------------------------------------------------------*/

DmaGeneralFunc dmaHwHandler[NUM_OF_DMA_DIRECTIONS] = {
	dmaDriverHostToShramHandler , 
	dmaDriverShramToHostHandler ,
	dmaDriverShramToShramHandler,
	dmaDriverHostIfToHostHandler,
	dmaDriverRxcountersToHostHandler,
	dmaDriverBaacountersToHostHandler,
	dmaDriverSkipHandler,
	dmaDriverInvalidHandler
	};

uint32 DmacWrapperManipulationLists[DMAC_WRAPPER_MANIPULATION_LISTS_DWORD_SIZE] =
{
	// ch0  

	0x0e210820, // SAR@8,DAR@14
	0x26401d80, // AUTO_LD_ST@22,LOOPS@37
	0x2f012c03, // AUTO_LD_ST@46,AUTO_LD_ST@54
	0x00000000, // AUTO_LD_ST@62,DAR_JUNK@70
	0x00000000, // AUTO_STORE_JUNK@78, COND_CLOSE@84
	0x00000000, // COND_END@87
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,


	// ch1
	0x0e210820, // SAR@8,DAR@14
	0x29801640, // AUTO_LD_ST@22,LOOPS@41
	0x3e403240, // AUTO_LD_ST@50,AUTO_LD_ST@62
	0x56014a40,// AUTO_LD_ST@74,COND_END@86
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	// ch2
	0x0e210820, // SAR@8,DAR@14
	0x29801640, // AUTO_LD_ST@22,LOOPS@41
	0x3e403240, // AUTO_LD_ST@50,AUTO_LD_ST@62
	0x56014a40, // AUTO_LD_ST@74,COND_END@86
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,

	// ch3
	0x0e210820, // SAR@8,DAR@14
	0x29801640, // AUTO_LD_ST@22,LOOPS@41
	0x3e403240, // AUTO_LD_ST@50,AUTO_LD_ST@62
	0x56014a40, // AUTO_LD_ST@74,COND_END@86
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};


uint32 DmacWrapperChannelPrograms[DMAC_WRAPPER_CHANNEL_PROGRAMS_DWORD_SIZE] =
{
	//ch#0 code at offset 0x100

	0x00340031, // 0)wfp 0; 2)sev 0
	0x00bc0236, // 4)wfe 0 invalidate cache; 6)movsar
	0x00000000,
	0x000002bc, // 12)movdar
	0x18180000, // 18)nop; 19)nop
	0xc2f701bc, // 20)movccr
	0x181800bd, // 26)nop; 27)nop
	0x18180020, // 28)lp; 30)nop; 31)nop 
	0x04381818, // 32)nop; 33)nop; 34)lpend
	0x000001bc, // 36)movccr
	0x18180000, // 42)nop; 43)nop
	0x18403418, // 44)nop; 45)sev 8; 47)nop
	0x00340031, // start of ch#0 2nd program
	0x00bc0236, 
	0x00000000,
	0x000002bc,
	0x18180000,
	0xc2f701bc, 
	0x181800bd, 
	0x18180020,	
	0x04381818, 
	0x000001bc, 
	0x18180000, 
	0x18403418,
	0x1818602c, 
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 200
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 240
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 256

	// ch#1 code at offset 0x200
    0x08340831,
    0x00bc0a36,
    0x00000000,
    0x000002bc,
    0x18180000,
    0x000001bc,
    0x18180000,
    0x18181813,
    0xc2f701bc,
    0x181800bd,
    0x18180020,
    0x04381813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x18180835,
    0x18181818,
    0x18181818,
    0x08340831,
    0x00bc0a36,
    0x00000000,
    0x000002bc,
    0x18180000,
    0x000001bc,
    0x18180000,
    0x18181813,
    0xc2f701bc,
    0x181800bd,
    0x18180020,
    0x04381813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x18180835,
    0x1818b82c,
    0x00000000,
    0x00000000,
	0x00000000,	// 200
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 240
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 256

	// ch#2 code at offset 0x300
    0x10341031,
    0x00bc1236,
    0x00000000,
    0x000002bc,
    0x18180000,
    0x000001bc,
    0x18180000,
    0x18181813,
    0xc2f701bc,
    0x181800bd,
    0x18180020,
    0x04381813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x18181035,
    0x18181818,
    0x18181818,
    0x10341031,
    0x00bc1236,
    0x00000000,
    0x000002bc,
    0x18180000,
    0x000001bc,
    0x18180000,
    0x18181813,
    0xc2f701bc,
    0x181800bd,
    0x18180020,
    0x04381813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x18181035,
    0x1818b82c,
    0x00000000,
	0x00000000,
	0x00000000, // 200
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 240
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 256
	
	// ch#3 code at offset 0x400
    0x18341831,
    0x00bc1a36,
    0x00000000,
    0x000002bc,
    0x18180000,
    0x000001bc,
    0x18180000,
    0x18181813,
    0xc2f701bc,
    0x181800bd,
    0x18180020,
    0x04381813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x18181835,
    0x18181818,
    0x18181818,
    0x18341831,
    0x00bc1a36,
    0x00000000,
    0x000002bc,
    0x18180000,
    0x000001bc,
    0x18180000,
    0x18181813,
    0xc2f701bc,
    0x181800bd,
    0x18180020,
    0x04381813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x000001bc,
    0x18180000,
    0x18181813,
    0x18181835,
    0x1818b82c,
    0x00000000,
	0x00000000,
	0x00000000, // 200
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 240
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000, // 256

};


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/



void dmaDriverHostToShramHandler(dmaDesc_t* pDmaDesc)
{
	TX_INTERRUPT_SAVE_AREA;
	RegDmacWrapperCh3FifoPushSrcAddr_u sourceAddressRegister;
	RegDmacWrapperCh3FifoPushDestAddr_u destinationAddressRegister; 
	RegDmacWrapperCh3FifoPushCReg_u triggerRegister;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);


 
	sourceAddressRegister.val = 0;
	destinationAddressRegister.val = 0;
    triggerRegister.val = 0;


	pDmaDesc->destination = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR(pDmaDesc->destination);
	pDmaDesc->source = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pDmaDesc->source);

	sourceAddressRegister.bitFields.ch3FifoPushSrcAddr = pDmaDesc->source;
	destinationAddressRegister.bitFields.ch3FifoPushDestAddr = (uint32)pDmaDesc->destination;

   	triggerRegister.bitFields.ch3FifoPushLength = pDmaDesc->length;
	triggerRegister.bitFields.ch3FifoPushLast = TRUE;

	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_SRC_ADDR, sourceAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_DEST_ADDR, destinationAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_C_REG, triggerRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);	


}

void dmaDriverShramToHostHandler(dmaDesc_t* pDmaDesc)
{
	TX_INTERRUPT_SAVE_AREA;

	RegDmacWrapperCh3FifoPushSrcAddr_u sourceAddressRegister;
	RegDmacWrapperCh3FifoPushDestAddr_u destinationAddressRegister; 
	RegDmacWrapperCh3FifoPushCReg_u triggerRegister;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
 
	sourceAddressRegister.val = 0;
	destinationAddressRegister.val = 0;
    triggerRegister.val = 0;

	pDmaDesc->source = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR(pDmaDesc->source);	
	pDmaDesc->destination =CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pDmaDesc->destination);
	sourceAddressRegister.bitFields.ch3FifoPushSrcAddr = (uint32)pDmaDesc->source;
	destinationAddressRegister.bitFields.ch3FifoPushDestAddr = pDmaDesc->destination;

   	triggerRegister.bitFields.ch3FifoPushLength = pDmaDesc->length ;
	triggerRegister.bitFields.ch3FifoPushLast = TRUE;

	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_SRC_ADDR, sourceAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_DEST_ADDR, destinationAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_C_REG, triggerRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);	


}


void dmaDriverShramToShramHandler(dmaDesc_t* pDmaDesc)
{
	TX_INTERRUPT_SAVE_AREA;

	RegDmacWrapperCh3FifoPushSrcAddr_u sourceAddressRegister;
	RegDmacWrapperCh3FifoPushDestAddr_u destinationAddressRegister; 
	RegDmacWrapperCh3FifoPushCReg_u triggerRegister;

 
 	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	
	sourceAddressRegister.val = 0;
	destinationAddressRegister.val = 0;
    triggerRegister.val = 0;


	pDmaDesc->source = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR(pDmaDesc->source);	
	pDmaDesc->destination = CONVERT_WLAN_SHRAM_ADDR_TO_DMA_SHRAM_ADDR(pDmaDesc->destination);	

		
	sourceAddressRegister.bitFields.ch3FifoPushSrcAddr = pDmaDesc->source;
	destinationAddressRegister.bitFields.ch3FifoPushDestAddr = (uint32)pDmaDesc->destination;

   	triggerRegister.bitFields.ch3FifoPushLength = pDmaDesc->length ;
	triggerRegister.bitFields.ch3FifoPushLast = TRUE;

	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_SRC_ADDR, sourceAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_DEST_ADDR, destinationAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_C_REG, triggerRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);	


}

void dmaDriverHostIfToHostHandler(dmaDesc_t* pDmaDesc)
{
	TX_INTERRUPT_SAVE_AREA;

	RegDmacWrapperCh3FifoPushSrcAddr_u sourceAddressRegister;
	RegDmacWrapperCh3FifoPushDestAddr_u destinationAddressRegister; 
	RegDmacWrapperCh3FifoPushCReg_u triggerRegister;

 
 	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	
	sourceAddressRegister.val = 0;
	destinationAddressRegister.val = 0;
    triggerRegister.val = 0;
	
	pDmaDesc->source = CONVERT_WLAN_HOST_IF_ADDR_TO_DMA_HOST_IF_ADDR(pDmaDesc->source);	
	pDmaDesc->destination = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pDmaDesc->destination);	
	sourceAddressRegister.bitFields.ch3FifoPushSrcAddr = pDmaDesc->source;
	destinationAddressRegister.bitFields.ch3FifoPushDestAddr = (uint32)pDmaDesc->destination;

   	triggerRegister.bitFields.ch3FifoPushLength = pDmaDesc->length ;
	triggerRegister.bitFields.ch3FifoPushLast = TRUE;

	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_SRC_ADDR, sourceAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_DEST_ADDR, destinationAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_C_REG, triggerRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);	


}

void dmaDriverRxcountersToHostHandler(dmaDesc_t* pDmaDesc)
{
	TX_INTERRUPT_SAVE_AREA;

	RegDmacWrapperCh3FifoPushSrcAddr_u sourceAddressRegister;
	RegDmacWrapperCh3FifoPushDestAddr_u destinationAddressRegister; 
	RegDmacWrapperCh3FifoPushCReg_u triggerRegister;

 
 	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	
	sourceAddressRegister.val = 0;
	destinationAddressRegister.val = 0;
    triggerRegister.val = 0;

	pDmaDesc->source = CONVERT_WLAN_RXCOUNTER_ADDR_TO_DMA_RXCOUNTER_ADDR(pDmaDesc->source);	
	pDmaDesc->destination = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pDmaDesc->destination);	
	
	sourceAddressRegister.bitFields.ch3FifoPushSrcAddr = pDmaDesc->source;
	destinationAddressRegister.bitFields.ch3FifoPushDestAddr = (uint32)pDmaDesc->destination;

   	triggerRegister.bitFields.ch3FifoPushLength = pDmaDesc->length ;
	triggerRegister.bitFields.ch3FifoPushLast = TRUE;

	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_SRC_ADDR, sourceAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_DEST_ADDR, destinationAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_C_REG, triggerRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);	


}

void dmaDriverBaacountersToHostHandler(dmaDesc_t* pDmaDesc)
{
	TX_INTERRUPT_SAVE_AREA;

	RegDmacWrapperCh3FifoPushSrcAddr_u sourceAddressRegister;
	RegDmacWrapperCh3FifoPushDestAddr_u destinationAddressRegister; 
	RegDmacWrapperCh3FifoPushCReg_u triggerRegister;

 
 	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	
	sourceAddressRegister.val = 0;
	destinationAddressRegister.val = 0;
    triggerRegister.val = 0;
						
	pDmaDesc->source = CONVERT_WLAN_BAACOUNTER_ADDR_TO_DMA_BAACOUNTER_ADDR(pDmaDesc->source);	
	pDmaDesc->destination = CONVERT_HOST_DDR_MEMORY_ADDR_TO_DMA_DDR_MEMORY_ADDR(pDmaDesc->destination);	
	
	sourceAddressRegister.bitFields.ch3FifoPushSrcAddr = pDmaDesc->source;
	destinationAddressRegister.bitFields.ch3FifoPushDestAddr = (uint32)pDmaDesc->destination;

   	triggerRegister.bitFields.ch3FifoPushLength = pDmaDesc->length ;
	triggerRegister.bitFields.ch3FifoPushLast = TRUE;

	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_SRC_ADDR, sourceAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_DEST_ADDR, destinationAddressRegister.val);
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_FIFO_PUSH_C_REG, triggerRegister.val);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);	


}



void dmaDriverSkipHandler(dmaDesc_t* pDmaDesc)
{
	TX_INTERRUPT_SAVE_AREA;
	
    OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	dmaManagerDmaHwDone();
    OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

void dmaDriverInvalidHandler(dmaDesc_t* pDmaDesc)
{
	ASSERT(0);
}

void DmaDriver_ActivateHW(dmaDesc_t* pDmaDesc)
{
	dmaHwHandler[pDmaDesc->direction](pDmaDesc);
}


ISR_VOID isr_DmaDone(void)
{
	RegDmacWrapperAgent3IntClearReg_u clearInterruptRegister;
	RegDmacWrapperAgent3PendIntReg_u  statusInterruptRegister;
	
	clearInterruptRegister.val = 0;
	statusInterruptRegister.val = 0;
	
	RegAccess_Read(REG_DMAC_WRAPPER_AGENT_3_PEND_INT_REG,&statusInterruptRegister.val);
	DEBUG_ASSERT(statusInterruptRegister.bitFields.agent3LastJobDonePendInt == 0x8);
	
	clearInterruptRegister.bitFields.agent3LastJobDoneIntClear = 0x8;
	RegAccess_Write(REG_DMAC_WRAPPER_AGENT_3_INT_CLEAR_REG, clearInterruptRegister.val);

	dmaManagerDmaHwDone();

}

#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

void Dma_HwInit(void)
{
	RegDmaIntEnableReg_u dmaIntEnable;
	RegDmacWrapperBaReg_u 		dmacBaseAddress;
	RegDmacWrapperConfigReg_u   dmacConfig;
	RegDmacWrapperMiscReg_u		dmacMisc;
	RegDmacWrapperSenderAlignerEn_u senderAlignerEn;
	RegDmacWrapperAgent0IntMaskReg_u dmacAgent0IntMask;
	RegDmacWrapperAgent1IntMaskReg_u dmacAgent1IntMask;
	RegDmacWrapperAgent2IntMaskReg_u dmacAgent2IntMask;
	RegDmacWrapperAgent3IntMaskReg_u dmacAgent3IntMask;
	RegDmacWrapperCh0ConfigReg_u 	 dmacCh0Config;	
	RegDmacWrapperCh1ConfigReg_u 	 dmacCh1Config;	
	RegDmacWrapperCh2ConfigReg_u	 dmacCh2Config;	
	RegDmacWrapperCh3ConfigReg_u	 dmacCh3Config;


	dmaIntEnable.val		= 0;
	dmacBaseAddress.val		= 0;
	dmacConfig.val 			= 0;
	dmacMisc.val			= 0;
	senderAlignerEn.val		= 0;
	dmacAgent0IntMask.val	= 0;
	dmacAgent1IntMask.val 	= 0;
	dmacAgent2IntMask.val	= 0;
	dmacAgent3IntMask.val	= 0;
	dmacCh0Config.val		= 0;	
	dmacCh1Config.val		= 0;	
	dmacCh2Config.val		= 0;	
	dmacCh3Config.val		= 0;
	
	/* 0x800  RAM BA - BAR0 + SHRAM_OFFSET  */
	dmacBaseAddress.val =  System_GetXbarAddress() + SHARED_RAM_OFFSET_FROM_BAR0;
	RegAccess_Write(REG_DMAC_WRAPPER_BA_REG, dmacBaseAddress.val);

	/* 0x804 Config - 0x0020_0000 */
	dmacConfig.bitFields.chManipBa = CONVERT_BYTES_TO_DOUBLE_WORDS((uint32)DmaWrapperDb.ManipListsShramBuffer - (uint32)SHARED_RAM_BASE_ADDR);
	dmacConfig.bitFields.chCodeAlloc = DMAC_WRAPPER_CHANNEL_CODING_ALLOCATED_SPACE;	 // check if correct 
	RegAccess_Write(REG_DMAC_WRAPPER_CONFIG_REG, dmacConfig.val);

	/* 0x810 Misc -  value: 0x0080_280d /  0x0480_280d (aligner valid) */ 
	dmacMisc.bitFields.monHdrOffset = DMAC_WRAPPER_HEADER_MONITOR_OFFSET;      			  /* 001101 */
	dmacMisc.bitFields.monChSel     = DMAC_WRAPPER_HEADER_MONITOR_CHANNEL_0;   			  /* 000      */
	dmacMisc.bitFields.monHdrEn     = DMAC_WRAPPER_HEADER_MONITOR_ENABLE;      			  /* 1         */
	dmacMisc.bitFields.lastJobIdChSel = DMAC_WRAPPER_LAST_JOB_ID_INT_CHANNEL_SELECTION_2; /* 010     */
	dmacMisc.bitFields.txBufferFullMargin = DMAC_WRAPPER_TX_BUFFER_FULL_MARGIN;           /* 0010000000  */
	dmacMisc.bitFields.wordAlign = 0x1;

	RegAccess_Write(REG_DMAC_WRAPPER_MISC_REG, dmacMisc.val);

	senderAlignerEn.bitFields.senderAlignerEn = DMAC_WRAPPER_SENDER_ALIGNER_ENABLE;
	RegAccess_Write(REG_DMAC_WRAPPER_SENDER_ALIGNER_EN, senderAlignerEn.val);

	/* 0xa00 Int Enable Agent #0 (TX) - value: 0x1000 */
	dmacAgent0IntMask.bitFields.agent0LastJobDoneIntEn = DMAC_WRAPPER_CHANNEL_0_LAST_JOB_DONE_INT;
	RegAccess_Write(REG_DMAC_WRAPPER_AGENT_0_INT_MASK_REG, dmacAgent0IntMask.val);

	/* 0xa10 Int Enable Agent #1 (Rx) - value: 0x2000 */
	dmacAgent1IntMask.bitFields.agent1LastJobDoneIntEn = DMAC_WRAPPER_CHANNEL_1_LAST_JOB_DONE_INT;
	RegAccess_Write(REG_DMAC_WRAPPER_AGENT_1_INT_MASK_REG, dmacAgent1IntMask.val);

	/* 0xa20 Int Enable Agent #2 (Host) - value: 0x4f00 */
	dmacAgent2IntMask.bitFields.agent2LastJobDoneIntEn = DMAC_WRAPPER_CHANNEL_2_LAST_JOB_DONE_INT ;
	dmacAgent2IntMask.bitFields.agent2LastJobIdIntEn = DMAC_WRAPPER_ALL_CHANNELS_LAST_JOB_ID_ENABLE;
	RegAccess_Write(REG_DMAC_WRAPPER_AGENT_2_INT_MASK_REG, dmacAgent2IntMask.val);

	/* 0xa30 Int Enable Agent #3 (Upper) - value: 0x8000 */
	dmacAgent3IntMask.bitFields.agent3LastJobDoneIntEn = DMAC_WRAPPER_CHANNEL_3_LAST_JOB_DONE_INT;
	RegAccess_Write(REG_DMAC_WRAPPER_AGENT_3_INT_MASK_REG, dmacAgent3IntMask.val);

	/* 0xc00 Channel #0 TX config - value:0xca0   (0xb110010100000) / 0x620 (0xb011000100000) (aligner enabled) */
	dmacCh0Config.bitFields.ch0Priority = DMAC_WRAPPER_CHANNEL_CONFIG_PRIORITY_0;
	dmacCh0Config.bitFields.ch0EndianSwap = DMAC_WRAPPER_CHANNEL_CONFIG_NO_SWAP;
	dmacCh0Config.bitFields.ch0ExtFcEnable = DMAC_WRAPPER_CHANNEL_CONFIG_EXTERNAL_FLOW_CONTROL_INPUT_DISABLE;
	dmacCh0Config.bitFields.ch0TxbufFcEnable = DMAC_WRAPPER_CHANNEL_CONFIG_TX_CYCLIC_BUFF_FLOW_CONTROL_ENABLE;
	dmacCh0Config.bitFields.ch0WmbMode= DMAC_WRAPPER_CHANNEL_CONFIG_WRITE_BARRIER_MODE_DISABLE;
	dmacCh0Config.bitFields.ch0Opt = 	DMAC_WRAPPER_CHANNEL_CONFIG_LOAD_OPTIMIZATION_DISABLE;
	dmacCh0Config.bitFields.ch0PrgLen = DMAC_WRAPPER_CHANNEL_CONFIG_SIZEOF_PROGRAM_ALIGNER_ENABLED;
	RegAccess_Write(REG_DMAC_WRAPPER_CH0_CONFIG_REG, dmacCh0Config.val);

	/* 0xc10 Channel #1 config - value:0xc41  (0xb110001000001) */
	dmacCh1Config.bitFields.ch1Priority = DMAC_WRAPPER_CHANNEL_CONFIG_PRIORITY_1; 
	dmacCh1Config.bitFields.ch1EndianSwap = DMAC_WRAPPER_CHANNEL_CONFIG_NO_SWAP;	 							/* 00 */
	dmacCh1Config.bitFields.ch1ExtFcEnable = DMAC_WRAPPER_CHANNEL_CONFIG_EXTERNAL_FLOW_CONTROL_INPUT_DISABLE;	/* 0	  */
	dmacCh1Config.bitFields.ch1TxbufFcEnable = DMAC_WRAPPER_CHANNEL_CONFIG_TX_CYCLIC_BUFF_FLOW_CONTROL_DISABLE; /* 0	  */
	dmacCh1Config.bitFields.ch1WmbMode= DMAC_WRAPPER_CHANNEL_CONFIG_WRITE_BARRIER_MODE_ENABLE;		 		    /* 1	  */
	dmacCh1Config.bitFields.ch1Opt = DMAC_WRAPPER_CHANNEL_CONFIG_LOAD_OPTIMIZATION_DISABLE;					    /* 0   */
	dmacCh1Config.bitFields.ch1PrgLen = DMAC_WRAPPER_CHANNEL_CONFIG_SIZEOF_PROGRAM;					     		/* 1100   */			
	RegAccess_Write(REG_DMAC_WRAPPER_CH1_CONFIG_REG, dmacCh1Config.val);

	/* 0xc20 Channel #2 config - value:0xc42  (0xb110001000010) */
	dmacCh2Config.bitFields.ch2Priority = DMAC_WRAPPER_CHANNEL_CONFIG_PRIORITY_2; 								 /* 10 */
	dmacCh2Config.bitFields.ch2EndianSwap = DMAC_WRAPPER_CHANNEL_CONFIG_NO_SWAP;	 							 /* 00	  */
	dmacCh2Config.bitFields.ch2ExtFcEnable = DMAC_WRAPPER_CHANNEL_CONFIG_EXTERNAL_FLOW_CONTROL_INPUT_DISABLE;	 /* 0	  */
	dmacCh2Config.bitFields.ch2TxbufFcEnable = DMAC_WRAPPER_CHANNEL_CONFIG_TX_CYCLIC_BUFF_FLOW_CONTROL_DISABLE;  /* 0	  */
	dmacCh2Config.bitFields.ch2WmbMode= DMAC_WRAPPER_CHANNEL_CONFIG_WRITE_BARRIER_MODE_ENABLE;		 			 /* 1	  */
	dmacCh2Config.bitFields.ch2Opt = DMAC_WRAPPER_CHANNEL_CONFIG_LOAD_OPTIMIZATION_DISABLE;			 			 /* 0 	  */
	dmacCh2Config.bitFields.ch2PrgLen = DMAC_WRAPPER_CHANNEL_CONFIG_SIZEOF_PROGRAM;					     		 /* 1100   */			
	RegAccess_Write(REG_DMAC_WRAPPER_CH2_CONFIG_REG, dmacCh2Config.val);

	/* 0xc30 Channel #3 config - value:0xc43  (0xb110001000011) */
	dmacCh3Config.bitFields.ch3Priority = DMAC_WRAPPER_CHANNEL_CONFIG_PRIORITY_3;
	dmacCh3Config.bitFields.ch3EndianSwap = DMAC_WRAPPER_CHANNEL_CONFIG_NO_SWAP;	 							 /* 00	  */
	dmacCh3Config.bitFields.ch3ExtFcEnable = DMAC_WRAPPER_CHANNEL_CONFIG_EXTERNAL_FLOW_CONTROL_INPUT_DISABLE;	 /* 0	  */
	dmacCh3Config.bitFields.ch3TxbufFcEnable = DMAC_WRAPPER_CHANNEL_CONFIG_TX_CYCLIC_BUFF_FLOW_CONTROL_DISABLE;  /* 0	  */
	dmacCh3Config.bitFields.ch3WmbMode= DMAC_WRAPPER_CHANNEL_CONFIG_WRITE_BARRIER_MODE_ENABLE;		 			 /* 1	  */
	dmacCh3Config.bitFields.ch3Opt = DMAC_WRAPPER_CHANNEL_CONFIG_LOAD_OPTIMIZATION_DISABLE;			 			 /* 0	  */
	dmacCh3Config.bitFields.ch3PrgLen = DMAC_WRAPPER_CHANNEL_CONFIG_SIZEOF_PROGRAM;		 						 /* 1100 */ 		
	RegAccess_Write(REG_DMAC_WRAPPER_CH3_CONFIG_REG, dmacCh3Config.val);


	/* Enable DMA Interrupts */
	dmaIntEnable.bitFields.interruptEnable = DMA_ENABLE_INTERRUPTS_ALL_CHANNELS;	
	RegAccess_Write(REG_WLAN_ARM_DMA_INT_EN, dmaIntEnable.val);

	memcpy32(&DmaWrapperDb.ManipListsShramBuffer, &DmacWrapperManipulationLists, (DMAC_WRAPPER_MANIPULATION_LISTS_DWORD_SIZE));
	memcpy32(&DmaWrapperDb.ChannelProgramsShramBuffer, &DmacWrapperChannelPrograms, (DMAC_WRAPPER_CHANNEL_PROGRAMS_DWORD_SIZE));

}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif


