/***********************************************************************************
 File:			Intialization_HwHandler.c
 Module:		Initialization Module
 Purpose:		
 Description:	FW driver for TX Selector module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "MacHtExtensionsRegs.h"
#include "MacRabRegs.h"
#include "HwDrivers_Api.h"
#include "loggerAPI.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_UTILS 
#define LOG_LOCAL_FID 2

/* Ht Extensions Sw Reset Mask - According RegMacHtExtensionsSwResetsRelease_u */
#define MAC_HT_EXTENSIONS_SW_RESET_RES0_MASK 				(0x1)
#define MAC_HT_EXTENSIONS_SW_RESET_STATISTICS_MASK 			(0x2)
#define MAC_HT_EXTENSIONS_SW_RESET_SEMAPHORE_MASK	 		(0x4)
#define MAC_HT_EXTENSIONS_SW_RESET_RES1_MASK 				(0x8)
#define MAC_HT_EXTENSIONS_SW_RESET_LOGGER_MASK 				(0x10)
#define MAC_HT_EXTENSIONS_SW_RESET_DDR_DMA_MASK 			(0x20)
#define MAC_HT_EXTENSIONS_SW_RESET_MAC_GENRISC_TX_MASK 		(0x40)
#define MAC_HT_EXTENSIONS_SW_RESET_DELINEATOR_MASK 			(0x80)
#define MAC_HT_EXTENSIONS_SW_RESET_MAC_BLOCK_ACK_MASK 		(0x100)
#define MAC_HT_EXTENSIONS_SW_RESET_TXC_TEST_FIFO_MASK 		(0x200)
#define MAC_HT_EXTENSIONS_SW_RESET_MAC_TRAINER_MASK 		(0x400)
#define MAC_HT_EXTENSIONS_SW_RESET_RES11_MASK 				(0x800)
#define MAC_HT_EXTENSIONS_SW_RESET_TX_STREAMER_MASK 		(0x1000)
#define MAC_HT_EXTENSIONS_SW_RESET_MAC_GENRISC_RX_MASK 		(0x2000)
#define MAC_HT_EXTENSIONS_SW_RESET_MAC_GENRISC_HOST_MASK 	(0x4000)
#define MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_LMAC_REG_MASK 	(0x8000)
#define MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_UMAC_REG_MASK 	(0x10000)
#define MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_RX_REG_MASK 	(0x20000)
#define MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_HOST_REG_MASK 	(0x40000)
#define MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_TX_REG_MASK 	(0x80000)
#define MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_CORE_MASK 		(0x100000)
#define MAC_HT_EXTENSIONS_SW_RESET_RX_LISTS_DLM_MASK 		(0x200000)
#define MAC_HT_EXTENSIONS_SW_RESET_RX_DATA_DLM_MASK 		(0x400000)
#define MAC_HT_EXTENSIONS_SW_RESET_TX_LISTS_DLM_MASK 		(0x800000)
#define MAC_HT_EXTENSIONS_SW_RESET_TX_DATA_DLM_MASK 		(0x1000000)
#define MAC_HT_EXTENSIONS_SW_RESET_DLM_REG_MASK 			(0x2000000)
#define MAC_HT_EXTENSIONS_SW_RESET_RX_OUT_HOST_IF_MASK 		(0x4000000)
#define MAC_HT_EXTENSIONS_SW_RESET_RX_IN_HOST_IF_MASK 		(0x8000000)
#define MAC_HT_EXTENSIONS_SW_RESET_TX_OUT_HOST_IF_MASK 		(0x10000000)
#define MAC_HT_EXTENSIONS_SW_RESET_TX_IN_HOST_IF_MASK 		(0x20000000)
#define MAC_HT_EXTENSIONS_SW_RESET_HOST_IF_REG_MASK 		(0x40000000)
#define MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_AGER_MASK 		(0x80000000)


#define MAC_HT_EXTENSIONS_SW_RESET_GENRISCS_MASK   (MAC_HT_EXTENSIONS_SW_RESET_MAC_GENRISC_TX_MASK | \
													MAC_HT_EXTENSIONS_SW_RESET_MAC_GENRISC_RX_MASK | \
													MAC_HT_EXTENSIONS_SW_RESET_MAC_GENRISC_HOST_MASK)

#define MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_MASK  (MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_LMAC_REG_MASK | \
													MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_UMAC_REG_MASK  | \
													MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_RX_REG_MASK	| \
													MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_HOST_REG_MASK	| \
													MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_TX_REG_MASK    | \
													MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_CORE_MASK 		| \
													MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_AGER_MASK)

#define MAC_HT_EXTENSIONS_SW_RESET_DLM_MASK			(MAC_HT_EXTENSIONS_SW_RESET_RX_LISTS_DLM_MASK | \
													 MAC_HT_EXTENSIONS_SW_RESET_RX_DATA_DLM_MASK  | \
													 MAC_HT_EXTENSIONS_SW_RESET_TX_LISTS_DLM_MASK | \
													 MAC_HT_EXTENSIONS_SW_RESET_TX_DATA_DLM_MASK  | \
													 MAC_HT_EXTENSIONS_SW_RESET_DLM_REG_MASK)
													 
#define MAC_HT_EXTENSIONS_SW_RESET_HOST_IF_ACC_MASK (MAC_HT_EXTENSIONS_SW_RESET_RX_OUT_HOST_IF_MASK | MAC_HT_EXTENSIONS_SW_RESET_RX_IN_HOST_IF_MASK |\
													 MAC_HT_EXTENSIONS_SW_RESET_TX_OUT_HOST_IF_MASK | MAC_HT_EXTENSIONS_SW_RESET_TX_IN_HOST_IF_MASK | \
													 MAC_HT_EXTENSIONS_SW_RESET_HOST_IF_REG_MASK)


#define MAC_HT_EXTENSIONS_SW_RESET_REG_VALUE (MAC_HT_EXTENSIONS_SW_RESET_STATISTICS_MASK | MAC_HT_EXTENSIONS_SW_RESET_SEMAPHORE_MASK | \
											  MAC_HT_EXTENSIONS_SW_RESET_LOGGER_MASK	| MAC_HT_EXTENSIONS_SW_RESET_DDR_DMA_MASK | \
										 	  MAC_HT_EXTENSIONS_SW_RESET_DELINEATOR_MASK | MAC_HT_EXTENSIONS_SW_RESET_MAC_BLOCK_ACK_MASK | \
										 	  MAC_HT_EXTENSIONS_SW_RESET_TXC_TEST_FIFO_MASK | MAC_HT_EXTENSIONS_SW_RESET_MAC_TRAINER_MASK | \
											  MAC_HT_EXTENSIONS_SW_RESET_TX_STREAMER_MASK | \
											  MAC_HT_EXTENSIONS_SW_RESET_GENRISCS_MASK | MAC_HT_EXTENSIONS_SW_RESET_Q_MANAGER_MASK | \
											  MAC_HT_EXTENSIONS_SW_RESET_DLM_MASK | MAC_HT_EXTENSIONS_SW_RESET_HOST_IF_ACC_MASK)
										

/* Mac Rab Reg1 Sw Reset Mask - According RegMacRabPasSwResetRegRelease_u */
#define MAC_RAB_SW_RESET_RES0_MASK 				(0x1)
#define MAC_RAB_SW_RESET_RES1_MASK 				(0x2)
#define MAC_RAB_SW_RESET_RES2_MASK	 			(0x4)
#define MAC_RAB_SW_RESET_RES3_MASK 				(0x8)
#define MAC_RAB_SW_RESET_TIM 					(0x10)
#define MAC_RAB_SW_RESET_TIM_REG_MASK 			(0x20)
#define MAC_RAB_SW_RESET_DEL_MASK 				(0x40)
#define MAC_RAB_SW_RESET_DEL_REG_MASK 			(0x80)
#define MAC_RAB_SW_RESET_TCC_MASK 				(0x100)
#define MAC_RAB_SW_RESET_TX_DMA_MON_MASK 		(0x200)
#define MAC_RAB_SW_RESET_RXC_MASK 				(0x400)
#define MAC_RAB_SW_RESET_RXC_REG_MASK 			(0x800)
#define MAC_RAB_SW_RESET_RXF_MASK 				(0x1000)
#define MAC_RAB_SW_RESET_RXF_REG_MASK 			(0x2000)
#define MAC_RAB_SW_RESET_RCC_MASK 				(0x4000)
#define MAC_RAB_SW_RESET_BEACON_TIMERS_MASK 	(0x8000)
#define MAC_RAB_SW_RESET_RXD_MASK 				(0x10000)
#define MAC_RAB_SW_RESET_RXD_REG_MASK 			(0x20000)
#define MAC_RAB_SW_RESET_DUR_MASK 				(0x40000)
#define MAC_RAB_SW_RESET_DUR_REG_MASK 			(0x80000)
#define MAC_RAB_SW_RESET_RTA_MASK 				(0x100000)
#define MAC_RAB_SW_RESET_BF_MASK 				(0x200000)
#define MAC_RAB_SW_RESET_WEP_MASK 				(0x400000)
#define MAC_RAB_SW_RESET_AGGR_BUILDER_MASK 		(0x800000)
#define MAC_RAB_SW_RESET_AGGR_BUILDER_REG_MASK 	(0x1000000)
#define MAC_RAB_SW_RESET_ADDR2INDEX_MASK 		(0x2000000)
#define MAC_RAB_SW_RESET_ADDR2INDEX_REG_MASK 	(0x4000000)
#define MAC_RAB_SW_RESET_TX_HANDLER_MASK 		(0x8000000)
#define MAC_RAB_SW_RESET_TX_HANDLER_REG_MASK 	(0x10000000)
#define MAC_RAB_SW_RESET_TX_SELECTOR_MASK 		(0x20000000)
#define MAC_RAB_SW_RESET_TX_SELECTOR_REG_MASK 	(0x40000000)
#define MAC_RAB_SW_RESET_BEACON_TIMERS_REG_MASK (0x80000000)

/* Reset Value  0xBFF3C0*/
#define MAC_RAB_SW_RESET_REG1_VALUE ( MAC_RAB_SW_RESET_DEL_MASK | MAC_RAB_SW_RESET_DEL_REG_MASK | \
									MAC_RAB_SW_RESET_TCC_MASK | MAC_RAB_SW_RESET_TX_DMA_MON_MASK | \
									MAC_RAB_SW_RESET_RXF_MASK | MAC_RAB_SW_RESET_RXF_REG_MASK | MAC_RAB_SW_RESET_RCC_MASK | MAC_RAB_SW_RESET_BEACON_TIMERS_MASK | \
									MAC_RAB_SW_RESET_RXD_MASK | MAC_RAB_SW_RESET_RXD_REG_MASK | MAC_RAB_SW_RESET_DUR_MASK | MAC_RAB_SW_RESET_DUR_REG_MASK | \
									MAC_RAB_SW_RESET_RTA_MASK | MAC_RAB_SW_RESET_BF_MASK | MAC_RAB_SW_RESET_AGGR_BUILDER_MASK)

/* Mac Rab Reg2 Sw Reset Mask - According RegMacRabPasSwResetReg2Release_u */
#define MAC_RAB_SW_RESET_TXH_TXC_MASK 				(0x1)
#define MAC_RAB_SW_RESET_TXH_TXC_REG_MASK 			(0x2)
#define MAC_RAB_SW_RESET_TXH_NTD_MASK	 			(0x4)
#define MAC_RAB_SW_RESET_TXH_NTD_REG_MASK 			(0x8)
#define MAC_RAB_SW_RESET_TX_DMA_ALIGNER 			(0x10)
#define MAC_RAB_SW_RESET_BA_ANALYZER_REG_MASK 		(0x20)
#define MAC_RAB_SW_RESET_PROTECTED_DB_MASK 			(0x40)
#define MAC_RAB_SW_RESET_PROTECTED_DB_REG_MASK 		(0x80)
#define MAC_RAB_SW_RESET_LIBERATOR_MASK 			(0x100)
#define MAC_RAB_SW_RESET_RX_CLASSIFIER_MASK 		(0x200)
#define MAC_RAB_SW_RESET_RX_CLASSIFIER_REG_MASK 	(0x400)
#define MAC_RAB_SW_RESET_PS_SETTINGS_MASK 			(0x800)
#define MAC_RAB_SW_RESET_PS_SETTINGS_REG_MASK 		(0x1000)
#define MAC_RAB_SW_RESET_RX_PP_MASK 				(0x2000)
#define MAC_RAB_SW_RESET_TX_SEQUENCER_MASK 			(0x4000)
/* Reset Value  0x20*/
#define MAC_RAB_SW_RESET_REG2_VALUE	(MAC_RAB_SW_RESET_BA_ANALYZER_REG_MASK) 

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
#if defined (ENET_INC_LMAC)
#pragma ghs section text=".initialization" 
#endif
void Initialization_HwHandler_ResetHw(void)
{		
	//reset sw_resets register in HT extentions (Should we assert modules to reset ???)
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_RELEASE,MAC_HT_EXTENSIONS_SW_RESET_REG_VALUE);
	/* Assert Modules to Reset */
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_REG_ASSERT,MAC_RAB_SW_RESET_REG1_VALUE);
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_REG2_ASSERT,MAC_RAB_SW_RESET_REG2_VALUE);
	/* Release Modules from Reset*/
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_REG_RELEASE,MAC_RAB_SW_RESET_REG1_VALUE);
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_REG2_RELEASE,MAC_RAB_SW_RESET_REG2_VALUE);	
}
#if defined (ENET_INC_LMAC)
#pragma ghs section text=default
#endif

