/***********************************************************************************
 File:			Intialization_HwHandler.c
 Module:		Initialization Module
 Purpose:		
 Description:	FW driver for TX Selector module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "MacHtExtensionsRegs.h"
#include "MacRabRegs.h"
#include "MacGeneralRegs.h"
#include "HwDrivers_Api.h"
#include "loggerAPI.h"
#include "Initialization_Api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_UTILS 
#define LOG_LOCAL_FID 3

#define SECURITY_ENABLE_DYNAMIC_CLOCKS	(0x7F)
#define TX_SEL_DYNAMIC_CLOCKS			(0x7F)
#define DELIA_ENABLE_DYNAMIC_CLOCKS		(0xF)
#define AUTO_RESP_ENABLE_DYNAMIC_CLOCKS	(0x3)
#define BAA_ENABLE_DYNAMIC_CLOCKS		(0x7F)
#define BSRC_DYNAMIC_CLOCKS				(0x7)
#define OTFA_DYNAMIC_CLOCKS				(0x3)

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
void Initialization_HwHandler_ResetHw(void)
{
	RegMacRabPasSwResetRegAssert_u 			RabPasSwResetRegAssertReg;
	RegMacRabPasSwResetReg2Assert_u 		RabPasSwResetReg2AssertReg;
	RegMacHtExtensionsClkControlRegDynEn_u	HtExtensionsClkControlRegDynEnReg;
	RegMacHtExtensionsClkControlRegDynEn2_u	HtExtensionsClkControlRegDynEn2;
#if defined (PAC_EXTRAPOLATOR_CLOCK_ALWAYS_ON) || defined (BSRC_CLOCK_ALWAYS_ON)
	RegMacHtExtensionsClkControlRegForceOn2_u	HtExtensionsClkControlRegForceOn2Reg;
#endif
#if defined (ENET_INC_LMAC0)	
	RegMacGeneralPasSwResetRegAssert_u		GeneralPasSwResetRegAssertReg;
	RegMacGeneralPasSwResetReg2Assert_u		GeneralPasSwResetReg2AssertReg;
	RegMacGeneralClkControlRegDynEn_u		GeneralClkControlRegDynEnReg;
#if defined (RXPP_COUNTERS_CLOCK_ALWAYS_ON)
	RegMacGeneralClkControlRegForceOn_u 	GeneralClkControlRegForceOnReg;
#endif

#endif



		
	// Get a clean reg.
	RabPasSwResetRegAssertReg.val = 0;
	RabPasSwResetReg2AssertReg.val = 0;
	HtExtensionsClkControlRegDynEnReg.val = 0;
	HtExtensionsClkControlRegDynEn2.val = 0;
#if defined (PAC_EXTRAPOLATOR_CLOCK_ALWAYS_ON) || defined (BSRC_CLOCK_ALWAYS_ON)
	HtExtensionsClkControlRegForceOn2Reg.val = 0;
#endif
#if defined (ENET_INC_LMAC0)	
	GeneralPasSwResetRegAssertReg.val = 0;
	GeneralPasSwResetReg2AssertReg.val = 0;	
	GeneralClkControlRegDynEnReg.val = 0;
#if defined (RXPP_COUNTERS_CLOCK_ALWAYS_ON)
	GeneralClkControlRegForceOnReg.val = 0;
#endif	
#endif

#if defined (ENET_INC_LMAC0)	
	// Prepare dynamic clock enabling - common for both bands (need to be done only once - in LM0)
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManager0 		= TRUE; // Clock Dynamic Enable Q_MANAGER_0
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManager1 		= TRUE; // Clock Dynamic Enable Q_MANAGER_1
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManager2 		= TRUE; // Clock Dynamic Enable Q_MANAGER_2
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManager3 		= TRUE; // Clock Dynamic Enable Q_MANAGER_3
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm0				= TRUE; // Clock Dynamic Enable DLM_0
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm1				= TRUE; // Clock Dynamic Enable DLM_1
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm2				= TRUE; // Clock Dynamic Enable DLM_2
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm3				= TRUE; // Clock Dynamic Enable DLM_3
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm4				= TRUE; // Clock Dynamic Enable DLM_4
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm5				= TRUE; // Clock Dynamic Enable DLM_5
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm6				= TRUE; // Clock Dynamic Enable DLM_6
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm7				= TRUE; // Clock Dynamic Enable DLM_7
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm8				= TRUE; // Clock Dynamic Enable DLM_8
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManagerAger		= TRUE; // Clock Dynamic Enable Q_MANAGER_AGER
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnRxPp0				= TRUE; // Clock Dynamic Enable RxPp_0
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnRxPp1				= TRUE; // Clock Dynamic Enable RxPp_1
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDma0				= TRUE; // Clock Dynamic Enable DMA_0
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDma1				= TRUE; // Clock Dynamic Enable DMA_1
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnTxLiberator		= TRUE; // Clock Dynamic Enable Tx liberator
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnRxLiberator		= TRUE; // Clock Dynamic Enable Rx liberator
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnProtDb			= TRUE; // Clock Dynamic Enable PROT_DB
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnSemaphore			= TRUE; // Clock Dynamic Enable Semaphore
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnRxAddr1ToVapIdx	= TRUE; /// Clock Dynamic Enable Rx address1 to VAP index
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnLogger 			= TRUE; // Clock Dynamic Enable Logger

#if defined (RXPP_COUNTERS_CLOCK_ALWAYS_ON)
	//due to Hw issue in dynamic clock of RxPP counters, we keep it always on (https://jira-chd.intel.com/browse/WLANVLSIIP-3308)
	GeneralClkControlRegForceOnReg.bitFields.clkControlForceOnRxPp0			= TRUE;
#endif	

#endif

	// Prepare dynamic clock enabling - per band
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacGenriscTx 				 = TRUE;	// Clock Dynamic Enable MAC_GENRISC_TX
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacGenriscRx 				 = TRUE;	// Clock Dynamic Enable MAC_GENRISC_RX
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacGenriscTxStm				 = TRUE;	// Clock Dynamic Enable MAC_GENRISC_TX_STM
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacGenriscRxStm				 = TRUE;	// Clock Dynamic Enable MAC_GENRISC_RX_STM
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxMsduParser 				 = TRUE;	// Clock Dynamic Enable MSDU_PARSER
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxMsduParserLogger			 = TRUE;	// Clock Dynamic Enable MSDU_PARSER_LOGGER
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxClassifier					 = TRUE;	// Clock Dynamic Enable Rx Classifier
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnTxHc							 = TRUE;	// Clock Dynamic Enable TX_HC
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacAddr2Index				 = TRUE;	// Clock Dynamic Enable MAC_ADDR2INDEX
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnTxDmaAligner 				 = TRUE;	// Clock Dynamic Enable TX_DMA_ALIGNER
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxCoordinatorStatusTrace 	 = TRUE;	// Clock Dynamic Enable RX Coordinator status trace
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxCoordinatorStatusTraceFifos = TRUE;	// Clock Dynamic Enable RX Coordinator status trace fifos
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxCoordinatorWrapUp			 = TRUE;	// Clock Dynamic Enable RX Coordinator wrap up
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxCoordinatorStatistics		 = TRUE;	// Clock Dynamic Enable RX Coordinator statistics
	HtExtensionsClkControlRegDynEnReg.bitFields.secEngSwGclkEn								 = SECURITY_ENABLE_DYNAMIC_CLOCKS;	// Security Clock Dynamic Enable
	HtExtensionsClkControlRegDynEnReg.bitFields.delSwGclkEn									 = DELIA_ENABLE_DYNAMIC_CLOCKS;		// Delia Clock Dynamic Enable
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnAutoResp						 = AUTO_RESP_ENABLE_DYNAMIC_CLOCKS;	// Clock Dynamic Enable Auto response. bit [0] - dynamic enable for auto resp general logic. bit[1] -  dynamic enable for frame gen and length calculation
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnTxPdAcc						 = TRUE;	// Clock Dynamic Enable TX_PD Acc
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnPreAgg						 = TRUE;	// Clock Dynamic Enable Pre Agg
	HtExtensionsClkControlRegDynEnReg.bitFields.beaconTimersSwGclkEn						 = TRUE;	// Clock Dynamic Enable Beacon Timers

	// Reg2
	HtExtensionsClkControlRegDynEn2.bitFields.otfaSwGclkEn									 = OTFA_DYNAMIC_CLOCKS;	// OTFA Clock Dynamic Enable
	HtExtensionsClkControlRegDynEn2.bitFields.txSequencerSwGclkEn							 = TRUE;
	HtExtensionsClkControlRegDynEn2.bitFields.txSelSwGclkEn									 = TX_SEL_DYNAMIC_CLOCKS;
	HtExtensionsClkControlRegDynEn2.bitFields.clkControlDynEnTfGenerator					 = TRUE;
	HtExtensionsClkControlRegDynEn2.bitFields.clkControlDynEnMbfm							 = TRUE;
	HtExtensionsClkControlRegDynEn2.bitFields.psSettingSwGclkEn								 = TRUE;
	HtExtensionsClkControlRegDynEn2.bitFields.bsrcSwGclkEn									 = BSRC_DYNAMIC_CLOCKS;
	HtExtensionsClkControlRegDynEn2.bitFields.clkControlDynEnUlPostRx						 = TRUE;
	HtExtensionsClkControlRegDynEn2.bitFields.rxcSwGclkEn									 = TRUE;
	HtExtensionsClkControlRegDynEn2.bitFields.baaSwGclkEn									 = BAA_ENABLE_DYNAMIC_CLOCKS;	// BAA Clock Dynamic Enable
	HtExtensionsClkControlRegDynEn2.bitFields.pacExtrapGclkEn								 = TRUE;

#if defined (PAC_EXTRAPOLATOR_CLOCK_ALWAYS_ON)
	// due to Hw issue in PAC Extrapolator, we turn off the gated clock, and keep it always on.
	HtExtensionsClkControlRegForceOn2Reg.bitFields.pacExtrapGclkBypass						 = TRUE;
#endif

#if defined (BSRC_CLOCK_ALWAYS_ON)
	//due to Hw issue in BSRC (https://jira-chd.intel.com/browse/WLANVLSIIP-3063)
	HtExtensionsClkControlRegForceOn2Reg.bitFields.bsrcGclkBypass 							 = BSRC_DYNAMIC_CLOCKS;
#endif

	// Prepare RAB Reg1 for reset (per band)
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTxPdAcc		 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTxPdAccReg		 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTxHc			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTxHcReg		 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTim			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTimReg			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertDel			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertDelReg			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTcc			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertRxc			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertRxcReg			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertRxf			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertRxfReg			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertRcc			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertBeaconTimers	 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertRxd			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertRxdReg			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertDur			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertDurReg			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertRta			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertBf				 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertWep			 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertAggBuilder		 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertAggBuilderReg 	 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertAddr2Index		 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertAddr2IndexReg 	 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTxHandler 		 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTxHandlerReg	 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTxSelector		 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertTxSelectorReg 	 = TRUE;
	RabPasSwResetRegAssertReg.bitFields.swResetAssertBeaconTimersReg = TRUE;   

	// Prepare RAB Reg2 for reset (per band)
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertTxhTxc			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertTxhTxcReg			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertTxhNtd			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertTxhNtdReg			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertTxDmaAligner 		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertBaAnalizer		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertOtfa				 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertOtfaReg			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertLiberatorReg 		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertRxClas			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertRxClasReg			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertPsSetting			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertPsSettingReg 		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertTfGenerator		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertTxSequencer		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertPacExtrap			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertPacExtrapReg 		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertTfGeneratorReg	 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertGenriscTx			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertGenriscRx			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertRxMsduParser 		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertRxMsduParserReg	 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertRxMsduParserLogger = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertRxCoordinator		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertMbfm				 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertUlPostRx			 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertUlPostRxReg		 = TRUE;
	RabPasSwResetReg2AssertReg.bitFields.swResetAssertBsrc				 = TRUE;

#if defined (ENET_INC_LMAC0)	
	// Prepare Generael Reg1 for reset -common for both bands (need to be done only once - in LM0)
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertDmacWrapper	 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertDataLogger 	 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertHostGenrisc	 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertMacBlockAck	 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertMacTrainer 	 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertSemaphore		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertHostIf0		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertHostIf1		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertHostIf2		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertHostIf3		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertHostIf4		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertRxPp			 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertProtDb 		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertProtDbReg		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertLiberator		 = TRUE;
	GeneralPasSwResetRegAssertReg.bitFields.swResetAssertRxLiberator	 = TRUE;

	// Prepare Generael Reg2 for reset -common for both bands (need to be done only once - in LM0)
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager0 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager1 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager2 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager3 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager4 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager5 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager6 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager7 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager8 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager9 	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager10	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager11	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager12	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager13	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager14	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager15	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager16	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager17	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManager18	 = TRUE;
	GeneralPasSwResetReg2AssertReg.bitFields.swResetAssertQManagerAger	 = TRUE;
#endif


	// Turn on the  dynamic clocks
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_CLK_CONTROL_REG_DYN_EN, HtExtensionsClkControlRegDynEnReg.val);
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_CLK_CONTROL_REG_DYN_EN2, HtExtensionsClkControlRegDynEn2.val);

#if defined (PAC_EXTRAPOLATOR_CLOCK_ALWAYS_ON) || defined (BSRC_CLOCK_ALWAYS_ON)
	// Force the Pac Extrapolator clock to be on and or the BSRC clock to be on
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_CLK_CONTROL_REG_FORCE_ON2, HtExtensionsClkControlRegForceOn2Reg.val);
#endif

#if defined (ENET_INC_LMAC0)	
	RegAccess_Write(REG_MAC_GENERAL_CLK_CONTROL_REG_DYN_EN, GeneralClkControlRegDynEnReg.val);

#if defined (RXPP_COUNTERS_CLOCK_ALWAYS_ON)
	// Force the RxPP counters clock to be on
	RegAccess_Write(REG_MAC_GENERAL_CLK_CONTROL_REG_FORCE_ON, GeneralClkControlRegForceOnReg.val);
#endif	


#endif

	// Assert Modules to Reset
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_REG_ASSERT, RabPasSwResetRegAssertReg.val);
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_REG2_ASSERT, RabPasSwResetReg2AssertReg.val);
#if defined (ENET_INC_LMAC0)	
	RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_REG_ASSERT, GeneralPasSwResetRegAssertReg.val);
	RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_REG2_ASSERT, GeneralPasSwResetReg2AssertReg.val);
#endif

	// Release Modules from Reset (register of release is the same content as register of assert)
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_REG_RELEASE, RabPasSwResetRegAssertReg.val);
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_REG2_RELEASE, RabPasSwResetReg2AssertReg.val);	
#if defined (ENET_INC_LMAC0)	
	RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_REG_RELEASE, GeneralPasSwResetRegAssertReg.val);
	RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_REG2_RELEASE, GeneralPasSwResetReg2AssertReg.val);
#endif	

}
