/***********************************************************************************
 File:			Intialization_HwHandler.c
 Module:		Initialization Module
 Purpose:		
 Description:	FW driver for TX Selector module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "MacHtExtensionsRegs.h"
#include "MacRabRegs.h"
#include "MacGeneralRegs.h"
#include "HwDrivers_Api.h"
#include "loggerAPI.h"
#include "Initialization_Api.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_UTILS 
#define LOG_LOCAL_FID 3

#define SECURITY_ENABLE_DYNAMIC_CLOCKS		(0x7F)
#define TX_SEL_DYNAMIC_CLOCKS				(0xFF)
#define DELIA_ENABLE_DYNAMIC_CLOCKS			(0xF)
#define AUTO_RESP_ENABLE_DYNAMIC_CLOCKS		(0x3)
#define BAA_ENABLE_DYNAMIC_CLOCKS			(0xFF)
#define BSRC_DYNAMIC_CLOCKS					(0xF)
#define OTFA_DYNAMIC_CLOCKS					(0x1)
#define HOST_IF_DYNAMIC_CLOCKS				(0x1F)
#define Q_MANAGER_REG_TOP_DYNAMIC_CLOCKS	(0x1FF)
#define Q_MANAGER_DLM_DYNAMIC_CLOCKS		(0x3FF)
#define Q_MANAGER_REG_DYNAMIC_CLOCKS		(0x1FF)
#define NUM_OF_CYCLES_TO_WAIT_FOR_LS_MODE   (0x8)


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
void Initialization_HwHandler_ResetHw(void)
{
    RegMacRabPasSwResetSyncRegAssert_u          RabPasSwResetSyncRegAssertReg;
    RegMacRabPasSwResetAsyncRegAssert_u         RabPasSwResetAsyncRegAssertReg;
	RegMacHtExtensionsClkControlRegDynEn_u	    HtExtensionsClkControlRegDynEnReg;
	RegMacHtExtensionsClkControlRegDynEn2_u	    HtExtensionsClkControlRegDynEnReg2;	
	RegMacHtExtensionsClkControlRegDynEn3_u	    HtExtensionsClkControlRegDynEnReg3;	
	RegMacHtExtensionsClkControlRegMpaArb_u 	HtExtensionsClkControlRegMpaArbReg;
#if defined (ENET_INC_LMAC0)
	RegMacGeneralPasSwResetSyncRegAssert_u		GeneralPasSwResetSyncRegAssertReg;
	RegMacGeneralPasSwResetSyncReg2Assert_u		GeneralPasSwResetSyncReg2AssertReg;
    RegMacGeneralPasSwResetAsyncRegAssert_u     GeneralPasSwResetAsyncRegAssertReg;
	RegMacGeneralClkControlRegDynEn_u		    GeneralClkControlRegDynEnReg;	
	RegMacGeneralClkControlRegForceOn_u 		GeneralClkControlRegForceOnReg;
	RegMacGeneralIramSleepCtrl_u				GeneralIramSleepCtrlReg;
	RegMacGeneralLsModeControl_u				GeneralLsModeCtrlReg;
#endif


		
	// Get a clean reg.
	RabPasSwResetSyncRegAssertReg.val = 0;
	RabPasSwResetAsyncRegAssertReg.val = 0;
	HtExtensionsClkControlRegDynEnReg.val = 0;
	HtExtensionsClkControlRegDynEnReg2.val = 0;
	HtExtensionsClkControlRegDynEnReg3.val = 0;
	HtExtensionsClkControlRegMpaArbReg.val = 0;
#if defined (ENET_INC_LMAC0)	
	GeneralPasSwResetSyncRegAssertReg.val = 0;
	GeneralPasSwResetSyncReg2AssertReg.val = 0;	
    GeneralPasSwResetAsyncRegAssertReg.val = 0;
	GeneralClkControlRegDynEnReg.val = 0;	
	GeneralClkControlRegForceOnReg.val = 0; // Clear clkControlForceOnDescRamArb and clkControlForceOnSharedRamArb, which are set by default
	GeneralIramSleepCtrlReg.val = 0;
	GeneralLsModeCtrlReg.val = 0;
#endif


#if defined (ENET_INC_LMAC0)	
	// Prepare dynamic clock enabling - common for both bands (need to be done only once - in LM0)
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManager0 		= TRUE; // Clock Dynamic Enable Q_MANAGER_0
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManager1 		= TRUE; // Clock Dynamic Enable Q_MANAGER_1
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManager2 		= TRUE; // Clock Dynamic Enable Q_MANAGER_2
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManager3 		= TRUE; // Clock Dynamic Enable Q_MANAGER_3
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm0				= TRUE; // Clock Dynamic Enable DLM_0
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm1				= TRUE; // Clock Dynamic Enable DLM_1
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm2				= TRUE; // Clock Dynamic Enable DLM_2
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm3				= TRUE; // Clock Dynamic Enable DLM_3
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm4				= TRUE; // Clock Dynamic Enable DLM_4
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm5				= TRUE; // Clock Dynamic Enable DLM_5
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm6				= TRUE; // Clock Dynamic Enable DLM_6
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm7				= TRUE; // Clock Dynamic Enable DLM_7
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDlm8				= TRUE; // Clock Dynamic Enable DLM_8
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnQManagerAger		= TRUE; // Clock Dynamic Enable Q_MANAGER_AGER
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnRxPp0				= TRUE; // Clock Dynamic Enable RxPp_0
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnRxPp1				= TRUE; // Clock Dynamic Enable RxPp_1
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDma0				= TRUE; // Clock Dynamic Enable DMA_0
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDma1				= TRUE; // Clock Dynamic Enable DMA_1
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnTxLiberator		= TRUE; // Clock Dynamic Enable Tx liberator
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnRxLiberator		= TRUE; // Clock Dynamic Enable Rx liberator
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnProtDb			= TRUE; // Clock Dynamic Enable PROT_DB
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnSemaphore			= TRUE; // Clock Dynamic Enable Semaphore
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnRxAddr1ToVapIdx	= TRUE; /// Clock Dynamic Enable Rx address1 to VAP index
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnLogger 			= TRUE; // Clock Dynamic Enable Logger
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnGenriscHost       = TRUE; // Clock Dynamic Enable Host GenRisc
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnStatCnt 			= TRUE; //Clock Dynamic Enable all Statistics counters.
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnDescRamArb		= TRUE; //Clock Dynamic Enable for descriptor RAM arbiter
	GeneralClkControlRegDynEnReg.bitFields.clkControlDynEnSharedRamArb		= TRUE; //Clock Dynamic Enable for sharedRAM arbiter
#endif

	// Prepare dynamic clock enabling - per band
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacGenriscTx 				 = TRUE;	// Clock Dynamic Enable MAC_GENRISC_TX
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacGenriscRx 				 = TRUE;	// Clock Dynamic Enable MAC_GENRISC_RX
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacGenriscTxStm				 = TRUE;	// Clock Dynamic Enable MAC_GENRISC_TX_STM
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacGenriscRxStm				 = TRUE;	// Clock Dynamic Enable MAC_GENRISC_RX_STM
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxMsduParser 				 = TRUE;	// Clock Dynamic Enable MSDU_PARSER
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxMsduParserLogger			 = TRUE;	// Clock Dynamic Enable MSDU_PARSER_LOGGER
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxClassifier					 = TRUE;	// Clock Dynamic Enable Rx Classifier
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnTxHc							 = TRUE;	// Clock Dynamic Enable TX_HC
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnMacAddr2Index				 = TRUE;	// Clock Dynamic Enable MAC_ADDR2INDEX
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnTxDmaAligner 				 = TRUE;	// Clock Dynamic Enable TX_DMA_ALIGNER
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxCoordinatorStatusTrace 	 = TRUE;	// Clock Dynamic Enable RX Coordinator status trace
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxCoordinatorStatusTraceFifos = TRUE;	// Clock Dynamic Enable RX Coordinator status trace fifos
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxCoordinatorWrapUp			 = TRUE;	// Clock Dynamic Enable RX Coordinator wrap up
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnRxCoordinatorStatistics		 = TRUE;	// Clock Dynamic Enable RX Coordinator statistics
	HtExtensionsClkControlRegDynEnReg.bitFields.secEngSwGclkEn								 = SECURITY_ENABLE_DYNAMIC_CLOCKS;	// Security Clock Dynamic Enable
	HtExtensionsClkControlRegDynEnReg.bitFields.delSwGclkEn									 = DELIA_ENABLE_DYNAMIC_CLOCKS;		// Delia Clock Dynamic Enable
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnAutoResp						 = AUTO_RESP_ENABLE_DYNAMIC_CLOCKS;	// Clock Dynamic Enable Auto response. bit [0] - dynamic enable for auto resp general logic. bit[1] -  dynamic enable for frame gen and length calculation
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnTxPdAcc						 = TRUE;	// Clock Dynamic Enable TX_PD Acc
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnPreAgg						 = TRUE;	// Clock Dynamic Enable Pre Agg
	HtExtensionsClkControlRegDynEnReg.bitFields.beaconTimersSwGclkEn						 = TRUE;	// Clock Dynamic Enable Beacon Timers
	HtExtensionsClkControlRegDynEnReg.bitFields.bestruGclkEn								 = FALSE; //FALSE - Best RU is disabled; TRUE - Best RU is enabled
	HtExtensionsClkControlRegDynEnReg.bitFields.clkControlDynEnUlPostRx 					 = TRUE;	

	// Reg2
	HtExtensionsClkControlRegDynEnReg2.bitFields.otfaSwGclkEn									= OTFA_DYNAMIC_CLOCKS;	// OTFA Clock Dynamic Enable
	HtExtensionsClkControlRegDynEnReg2.bitFields.txSequencerSwGclkEn							= TRUE;
	HtExtensionsClkControlRegDynEnReg2.bitFields.txSelSwGclkEn									= TX_SEL_DYNAMIC_CLOCKS;
	HtExtensionsClkControlRegDynEnReg2.bitFields.clkControlDynEnTfGenerator					 	= TRUE;
	HtExtensionsClkControlRegDynEnReg2.bitFields.clkControlDynEnMbfm							= TRUE;
	HtExtensionsClkControlRegDynEnReg2.bitFields.psSettingSwGclkEn								= TRUE;
	HtExtensionsClkControlRegDynEnReg2.bitFields.bsrcSwGclkEn									= BSRC_DYNAMIC_CLOCKS;
	HtExtensionsClkControlRegDynEnReg2.bitFields.rxcSwGclkEn									= TRUE;
	HtExtensionsClkControlRegDynEnReg2.bitFields.baaSwGclkEn									= BAA_ENABLE_DYNAMIC_CLOCKS;	// BAA Clock Dynamic Enable
	HtExtensionsClkControlRegDynEnReg2.bitFields.pacExtrapGclkEn								= TRUE;

    HtExtensionsClkControlRegDynEnReg2.bitFields.txhMapSwGclkEn                                 = TRUE;
    HtExtensionsClkControlRegDynEnReg2.bitFields.txhTxcSwGclkEn                                 = TRUE;
    HtExtensionsClkControlRegDynEnReg2.bitFields.txhNtdSwGclkEn                                 = TRUE;
    HtExtensionsClkControlRegDynEnReg2.bitFields.durSwGclkEn                                    = TRUE;

	// Reg3
	HtExtensionsClkControlRegDynEnReg3.bitFields.bestruGclkSwEn									= FALSE;	// Best RU SW-API Enable

	// Keep gclk_en on, turn gclk_bypass off
	HtExtensionsClkControlRegMpaArbReg.bitFields.swGclkEnMdRam = TRUE;
	HtExtensionsClkControlRegMpaArbReg.bitFields.swGclkEnTxCircRam = TRUE;
	HtExtensionsClkControlRegMpaArbReg.bitFields.swGclkEnRxCircRam = TRUE;

    // Prepare RAB Regs for reset (per band)
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxPdAcc                = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxHc                   = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTim                    = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertDel                    = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertRxc                    = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertBeaconTimers           = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertDur                    = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertSecurity               = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertPreAgg                 = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertAddr2Index             = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxHandler              = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxSelector             = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxhTxc                 = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxhNtd                 = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertBaAnalizer             = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertOtfa                   = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertRxClas                 = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertPsSetting              = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTfGenerator            = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxSequencer            = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertPacExtrap              = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertRxMsduParser           = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertRxCoordinator          = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertMbfm                   = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertUlPostRx               = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertBsrc                   = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertAutoResp               = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertGenriscTx              = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertGenriscRx              = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxDmaAligner           = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertRta                    = TRUE;
    RabPasSwResetSyncRegAssertReg.bitFields.swResetAssertBestru                 = TRUE;

    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTxPdAccReg            = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTxHcReg               = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTimReg                = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertDelReg                = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertRxcReg                = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertBeaconTimersReg       = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertDurReg                = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertSecurityReg           = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertPreAggReg             = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertAddr2IndexReg         = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTxHandlerReg          = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTxSelectorReg         = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTxhTxcReg             = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTxhNtdReg             = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertBaAnalizerReg         = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertOtfaReg               = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertRxClasReg             = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertPsSettingReg          = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTfGeneratorReg        = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTxSequencerReg        = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertPacExtrapReg          = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertRxMsduParserReg       = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertRxCoordinatorReg      = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertMbfmReg               = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertUlPostRxReg           = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertBsrcReg               = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertAutoRespReg           = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertGenriscTxReserved     = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertGenriscRxReserved     = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertTxDmaAlignerReserved  = TRUE;
    RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertRtaReserved           = TRUE;
	RabPasSwResetAsyncRegAssertReg.bitFields.swResetAssertBestruReg				= TRUE;
        

#if defined (ENET_INC_LMAC0)	
	// Prepare Generael Regs for reset -common for both bands (need to be done only once - in LM0)
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertDataLogger          = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertRxAddr1ToVapIdx     = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertProtDb              = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertRxPp                = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertDmacWrapper         = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertHostGenrisc         = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertTrafficIndicator    = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertSemaphore           = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertHostIf              = HOST_IF_DYNAMIC_CLOCKS;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertTxLiberator         = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertRxLiberator         = TRUE;
    GeneralPasSwResetSyncRegAssertReg.bitFields.swResetAssertSmcMem              = FALSE; //we must not reset it, otherwise uppoer mac will not be able to access to shram when polling on LM done

    GeneralPasSwResetSyncReg2AssertReg.bitFields.swResetAssertQManagerAger       = TRUE;
    GeneralPasSwResetSyncReg2AssertReg.bitFields.swResetAssertQManagerDlm        = Q_MANAGER_DLM_DYNAMIC_CLOCKS;

    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertDataLoggerReg      = TRUE;
    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertRxAddr1ToVapIdxReg = TRUE;
    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertProtDbReg          = TRUE;
    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertRxPpReg            = TRUE;
    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertDmacWrapperReg     = TRUE;
    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertArmDma0            = TRUE;
    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertArmDma1            = TRUE;
    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertHostIfReg          = FALSE; //Host IF must not be reset because HOST IRQ reg is located there
    GeneralPasSwResetAsyncRegAssertReg.bitFields.swResetAssertQManagerReg        = Q_MANAGER_REG_DYNAMIC_CLOCKS;

	GeneralIramSleepCtrlReg.bitFields.swLsModeEnIram = 0x0; // TBD - turn off for now.
	GeneralIramSleepCtrlReg.bitFields.swDsModeEnIram = 0x0; // TBD - turn off for now.
	
	GeneralLsModeCtrlReg.bitFields.swLsModeEnDescRam   = TRUE;
	GeneralLsModeCtrlReg.bitFields.swLsModeEnSharedRam = TRUE;	
	GeneralLsModeCtrlReg.bitFields.swLsModeTargetDescRam   = NUM_OF_CYCLES_TO_WAIT_FOR_LS_MODE;
	
	GeneralLsModeCtrlReg.bitFields.swLsModeTargetSharedRam = NUM_OF_CYCLES_TO_WAIT_FOR_LS_MODE;
#endif

	// Turn on the  dynamic clocks
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_CLK_CONTROL_REG_DYN_EN,  HtExtensionsClkControlRegDynEnReg.val);
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_CLK_CONTROL_REG_DYN_EN2, HtExtensionsClkControlRegDynEnReg2.val);
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_CLK_CONTROL_REG_DYN_EN3, HtExtensionsClkControlRegDynEnReg3.val);
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_CLK_CONTROL_REG_MPA_ARB, HtExtensionsClkControlRegMpaArbReg.val);

#if defined (ENET_INC_LMAC0)	
	RegAccess_Write(REG_MAC_GENERAL_CLK_CONTROL_REG_DYN_EN, GeneralClkControlRegDynEnReg.val);
	RegAccess_Write(REG_MAC_GENERAL_CLK_CONTROL_REG_FORCE_ON, GeneralClkControlRegForceOnReg.val);
	RegAccess_Write(REG_MAC_GENERAL_IRAM_SLEEP_CTRL, GeneralIramSleepCtrlReg.val);
	RegAccess_Write(REG_MAC_GENERAL_LS_MODE_CONTROL, GeneralLsModeCtrlReg.val);	
#endif

	// Assert Modules to Reset
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_SYNC_REG_ASSERT, RabPasSwResetSyncRegAssertReg.val);
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_ASYNC_REG_ASSERT, RabPasSwResetAsyncRegAssertReg.val);
#if defined (ENET_INC_LMAC0)	
	RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_SYNC_REG_ASSERT, GeneralPasSwResetSyncRegAssertReg.val);
	RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_SYNC_REG2_ASSERT, GeneralPasSwResetSyncReg2AssertReg.val);
    RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_ASYNC_REG_ASSERT, GeneralPasSwResetAsyncRegAssertReg.val);
#endif

	// Release Modules from Reset (register of release is the same content as register of assert)
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_SYNC_REG_RELEASE, RabPasSwResetSyncRegAssertReg.val);
	RegAccess_Write(REG_MAC_RAB_PAS_SW_RESET_ASYNC_REG_RELEASE, RabPasSwResetAsyncRegAssertReg.val);	
#if defined (ENET_INC_LMAC0)	
	RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_SYNC_REG_RELEASE, GeneralPasSwResetSyncRegAssertReg.val);
	RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_SYNC_REG2_RELEASE, GeneralPasSwResetSyncReg2AssertReg.val);
    RegAccess_Write(REG_MAC_GENERAL_PAS_SW_RESET_ASYNC_REG_RELEASE, GeneralPasSwResetAsyncRegAssertReg.val);
#endif	

}
