/* CMSynergyVer %full_filespec: um_init.c;3.1.7.1.1:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET Upper MAC SW
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/um_init.c $
 **
 ** VERSION:        $Revision: #1 $
 **
 ** DATED:          $Date: 2003/10/27 $
 **
 ** AUTHOR:         S Sondergaard
 **
 ** DESCRIPTION:    Main entry point for enet pc application
 **
 ** LAST MODIFIED BY:   $Author: njk $
 **
 ****************************************************************************
 **
 **            Copyright (c) TTPCom, 2001
 **
 ****************************************************************************/

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "ErrorHandler_Api.h"
#include "ieee80211.h"
#include "frame.h"
#include "msgid.h"
#include "stringLibApi.h"
#include "um_init.h"
#include "ErrorHandler_Api.h"
#include "queue_utility.h"      /* Queue handling routines */
#include "ProcessManager_Api.h"
#include "encryptor.h"
#include "ServicesHandler_Api.h"
#include "Hdk_Api.h"
#include "shram_man_msgs.h"
#include "HostInterface_API.h"
#include "BSSmanager_API.h"
#include "CoC_Api.h"
#include "TsManager_API.h"
#include "ChannelSwitchManager_Api.h"
#include "ResourceManager_API.h"
#include "shram_interruptSection.h"
#include "VapDatabase_Api.h"
#include "StaDatabase_Api.h"
#include "DmaManager_Api.h"
#include "Mac2index_Api.h"
#include "HwSecurity_API.h"
#include "BaAnalyzer_Api.h"
#include "TxHandler_Api.h"
#include "DeliaRecipes_Api.h"
#include "GroupDatabase_Api.h"
#include "Pauser_Api.h"
#include "Pac_Api.h"
#include "RxPp_Api.h"
#if !defined(ENET_INC_ARCH_WAVE600)
#include "RxClassifier_Api.h"
#include "RxHandler_Api.h"
#endif // ENET_INC_ARCH_WAVE600
#include "HwQManager_API.h"
#include "RxManager_Api.h"
#include "Statistics_Api.h"
#include "HostInterfaceAcc_Api.h"
#include "HwLoggerAPI.h"
#include "Qos_Api.h"
#include "CsaManager_Api.h"
#include "CtsManager_Api.h"
#include "SmpsManager_Api.h"
#include "PsManager_Api.h"
#include "Ager_Api.h"
#include "InterfererDetection_Api.h"
#include "TxMulticastHandler_API.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "SenderInterface_Api.h"
#endif
#include "PhyDriver_API.h"
#include "PacketTrafficArbitrator_api.h"
#include "GroupManager_API.h"
#include "Atf_Api.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "RxCoordinator_Api.h"
#include "ConfigurationManager_api.h"
#endif //defined (ENET_INC_ARCH_WAVE600)
#ifdef ENET_INC_ARCH_WAVE600
#include "ProcessManagerCdb_Api.h"
#include "HeGroupManager_API.h"
#include "TwtManager_API.h"
#endif
#include "HdkCdbManagerTask_api.h"

/***************************************************************************/
/***                  Local Constants                                    ***/
/***************************************************************************/

/***************************************************************************/
/*                    External Definitions                               ***/
/***************************************************************************/

/****************************************************************************/
/*    Public Routines                                                       */
/****************************************************************************/
 

/****************************************************************************
 **
 ** NAME:           vUMAC_Init
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    Initialisation of all the modules of the Upper MAC.
 **
 **
 ****************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void vUMAC_Init(void)
{ 	
	SET_DEBUG_CHI(0x80003100);
    vMIB_Init();
	SET_DEBUG_CHI(0x80003101);
    vUM_IF_Init();
	SET_DEBUG_CHI(0x80003102);
#if	defined (ENET_INC_ARCH_WAVE600) //Should be run before LM_Init
	HdkCdbManager_Init();
	SET_DEBUG_CHI(0x80003104);
#endif
	vLMI_Init();
	SET_DEBUG_CHI(0x80003105);
    vENC_Init(); // Security Manager init
	StaDb_Init();
	GroupDB_Init();
	SET_DEBUG_CHI(0x80003111);
#ifndef ENET_INC_ARCH_WAVE600	
	Mac2Index_Initialize(); // in wave500 init is here. In wave600 init is in LM.
	SET_DEBUG_CHI(0x80003112);
	HwSecurity_Init(); // in wave500 init is here. In wave600 init is in LM.
#endif
	SET_DEBUG_CHI(0x80003113);
	DmaManager_Init();
	SET_DEBUG_CHI(0x80003114);
	SET_DEBUG_CHI(0x80003120);
	statisticsManagerInit();    
	SET_DEBUG_CHI(0x80003121);
    Atf_Manager_init();
	SET_DEBUG_CHI(0x80003122);	
#ifndef ENET_INC_ARCH_WAVE600	
	CoC_Init(); // in wave500 init is here. In wave600 init is in LM.
	SET_DEBUG_CHI(0x80003123);
#endif
#ifndef ENET_INC_ARCH_WAVE600
	HDK_Init();
	SET_DEBUG_CHI(0x80003124);	
	ServicesHandler_Init(); // in wave500 init is here. In wave600 init is in LM.
	SET_DEBUG_CHI(0x80003125);	
	ProcessManager_Init();	// in wave500 init is here. In wave600 init is in LM.
	SET_DEBUG_CHI(0x80003126);	
	InterfererDetection_Initialize(); // in wave500 init is here. In wave600 init is in LM.
	SET_DEBUG_CHI(0x80003127);	
	ChannelSwitchManager_Initialize(); // in wave500 init is here. In wave600 init is in LM.
#endif
	csaManager_Init();
	ctsManager_Init();
	GroupManager_Initialize();
	SET_DEBUG_CHI(0x80003132);	
	smpsManager_Init();
	SharedRamInt_Init();
	SET_DEBUG_CHI(0x80003133);	
	RxPp_Init();
	SET_DEBUG_CHI(0x80003134);	
#if !defined(ENET_INC_ARCH_WAVE600)
	RxClassifier_Init(); 
	SET_DEBUG_CHI(0x80003135);
#endif
   	/* InitializeHw Q Manager */
	HwQManager_Init();
	SET_DEBUG_CHI(0x80003136);	
	ResourceManager_Init();
	SET_DEBUG_CHI(0x80003137);
	RxManager_Initialize();
	SET_DEBUG_CHI(0x80003138);
#ifndef ENET_INC_ARCH_WAVE600	
	RxHandler_Init();
	TxPauser_Initialize();  // in wave500 init is here. In wave600 init is in LM.
	SET_DEBUG_CHI(0x80003139);	
	PsManager_Init();		// in wave500 init is here. In wave600 init is in LM.
#endif
	SET_DEBUG_CHI(0x80003140);
    HostIfAcc_Init();
	SET_DEBUG_CHI(0x80003141);
	Qos_Initialize();
	SET_DEBUG_CHI(0x80003142);
	HostInterfaceRings_Init();
	SET_DEBUG_CHI(0x80003143);
	Ager_Initialize();
	HwLogger_Init(); 
	SET_DEBUG_CHI(0x80003144);	
	
#ifndef ENET_INC_ARCH_WAVE600	
	BaAnalyzer_InitializeBaaStatusFifo();
	SET_DEBUG_CHI(0x80003145);	
#endif
	Pac_RxcInitializeRamParameters();
	SET_DEBUG_CHI(0x80003146);
#ifndef ENET_INC_ARCH_WAVE600
	Pac_RxfInitializeNoBaAgreementFifo(); // In wave600 there is no RXF. This is initialized by RXC in the LM (Pac_RxcInitializeNoBaAgreementFifo)
	SET_DEBUG_CHI(0x80003147);	
#endif
	MulticastHandler_Init();
	SET_DEBUG_CHI(0x80003148);	
#ifndef ENET_INC_ARCH_WAVE600	
	PhyDrv_ClearPhyInterrupts();
	SET_DEBUG_CHI(0x80003149);	
	/* Inialize the TXHD HW modules*/
	TxHandler_Initialize(); // in wave500 init is here. In wave600 init is in LM.
	SET_DEBUG_CHI(0x80003150);
	Sender_Initialize();
	DeliaRecipes_ConstructRecipes(); // in wave500 init is here. In wave600 init is in LM.
	SET_DEBUG_CHI(0x80003151);
#endif
	SET_DEBUG_CHI(0x80003152);

#ifdef ENET_INC_ARCH_WAVE600
	RxCoordinator_Init();
	ProcessManagerCdbInit();
#endif
#ifdef PTA_BUILD_IN_PLAT
	PacketTrafficArbitratorTask_Init();
	SET_DEBUG_CHI(0x80003153);
#endif
#ifdef ENET_INC_ARCH_WAVE600
	SET_DEBUG_CHI(0x80003154);
	heGroupManager_Init();
	SET_DEBUG_CHI(0x80003155);
    TwtManager_Initialize();
    SET_DEBUG_CHI(0x80003156);
#endif 

}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif


