/*****************************************************************************
*    
*   Source File: logger.h
*
*   AUTHOR: Ariel Groenteman
*
*   Description: Header for the Logger Module. This file includes function
*                declarations for use in FW components
*
*       
*   Copyright: 
*       
*   Revision History:
*
*****************************************************************************/

#ifndef __LOGGER_H_
#define __LOGGER_H_

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "shram_man_msgs.h"
#include "init_ifmsg.h"


#include "shram_logger_buffers.h"
#include "loggerAPI.h"
#include "mhi_umi.h"

/******************************************************/
/***						Logprep Additions Start	***/
/******************************************************/
#include "logmacro_mixins.h"
#include "formats.h"
#include "logdefs.h"
#include "enet_pas.h"
/******************************************************/
/***						Logprep Additions End	***/
/******************************************************/

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
#define DISABLE_LOGGER_DEBUG

#define LOGGER_INACTIVITY_TIMEOUT      (1000)                  //buffer swap timeout in milliseconds
#define LOGGER_DEBUG_INFO_SIZE (LOGGER_BUFFER_SIZE/LOGPKT_EVENT_HDR_SIZE)


/******************************************************************************/
/***						Type Definition									***/
/******************************************************************************/
/*     enum definitions     */

struct _mtlk_log_buf_entry_t
{
    char dataByte;
} ;

typedef struct
{
    uint8 *buf;
    uint8 gid;
    uint8 fid;
    uint16 lid;
} LoggerBufferDebugInfo_t;

typedef struct
{
    uint8*   buffer_p;
    uint32  length;
    uint8   originCpu;
	bool bufferInUse; 
	uint8 bufferId;
} LoggerBufferInfo_t;

typedef struct LogAgentLocalParamTag
{
    LogAgentLoggerGroupsBitMap_t    groupFilters;           //groupFilters bit map
    LogAgentSeverityLevel_t         severityLevel;          //severityLevel level
    LogAgentState_e                 state;
    uint8                            *currentBufferWrite_p;
    uint32                          currentBufferId;
    LoggerBufferInfo_t              loggerBufferInfo[LOGGER_NUM_OF_BUFFERS];
    uint32                          missedLogsDueToLackOfBuffers;
    uint32                          missedLogsDueToLackOfBD;
#ifndef DISABLE_LOGGER_DEBUG
    LoggerBufferDebugInfo_t         loggerBufferDebugInfo[LOGGER_NUM_OF_BUFFERS][LOGGER_DEBUG_INFO_SIZE];
    uint32                          loggerBufferDebugInfoCounter[LOGGER_NUM_OF_BUFFERS];
#endif    
    bool                            isOn;
#if defined (ENET_INC_UMAC)
	uint8 							numOfOngoingBuffers;
	bool 							setStateCfmIsPending;
	K_MSG							*mcKmsg_p;
	uint32 							totalBuffersSent;
	bool							sendMsgToHostValid;				/* TRUE: we have a pending buffer that needs to be sent to HOST */
	uint8							sendMsgToHostbufferId;			/* Index to which buffer we need to send to HOST. Valid only in case sendMessageToHostValid = TRUE */
	bool							logInProgress;					/* Wraps the logger code to prevent log prempting log */
	uint32							sizeViolationCounter;			/* How many times did we try to place a packet larger than the buffer */
	uint32							logInProgressViolationCounter;	/* How many times did we try to activate Logger while it is running (Logger "premption" is not healty) */
#endif
} LogAgentLocalParam_t;


/******************************************************************************/
/***						Macros											***/
/******************************************************************************/



/******************************************************************************/
/***						Public Function Declaration						***/
/******************************************************************************/

void Logger_InitLoggerLocalParam(void);
void Logger_StopBufferTimer(void);
void Logger_SetLogAgentMode(LogAgentState_e stateReq);
void Logger_SetSeverity(LogAgentSeverityLevel_t newSeverityLevel);
void Logger_SetFilter(LogAgentLoggerGroupsBitMap_t gidFilterMask);
void LocateAndReleaseBuffer(uint32 bufferIdToRelease);
bool IsLoggerEnabled(void);
Status_e Logger_CheckFilters(int32 level, int32 gid, bool *flag);
void Logger_SendBufferToHost(uint32 bufferIndex, uint8 *toSendBuffer_p, uint32 toSendLength, uint8 OriginCpu);
void Logger_FlushAllBuffers(void);
void Logger_IncMissedLogsDueToLackOfBD(void);
void Logger_SendBuffer(LoggerBufferInfo_t *bufferInfo_p);
void LoggerMarkEndOfBuffer(void);
void LoggerHandlePendingSetModeReq(void);
void LoggerDeferSetModeCfm(K_MSG *kMsg_p);
void LoggerDecOngoingBuffersNum(void);

/******************************************************/
/***						Logprep Additions Start	***/
/******************************************************/
BOOL mtlk_log_check_version(uint16 major, uint16 minor);
int mtlk_log_get_flags(int level, int oid, uint8 gid);
mtlk_log_buf_entry_t *mtlk_log_new_pkt_reserve(uint32 pkt_size, uint8 **ppdata);
void mtlk_log_new_pkt_release(mtlk_log_buf_entry_t *buf);
uint32 mtlk_log_get_timestamp(void);

mtlk_log_buf_entry_t *logReserveBuffer(uint32 len);
void logFillLogEvent(uint32 oid, uint8 gid, uint32 fid, uint32 lid, uint32 len, OUT uint8 **buff_p);
void logReleaseBuffer(mtlk_log_buf_entry_t *p, uint32 len);

/******************************************************/
/***						Logprep Additions End	***/
/******************************************************/

/******************************************************************************/
/***						external Public Variables						***/
/******************************************************************************/



/******************************************************************************/
/***						Statistics & Debug								***/
/******************************************************************************/



#endif /* __LOGGER_H_ */
