/*****************************************************************************
*    
*   Source File: loggerAPI.h
*	
*	AUTHOR: Ariel Groenteman
*
*   Description: external API of the logger to modules outside FW 
*       
*   Copyright: 
*       
*   Revision History:
*
*****************************************************************************/

#ifndef __LOGGER_API_H_
#define __LOGGER_API_H_

/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "OSAL_Api.h"
#include "mhi_umi.h"
#include "HwLoggerHeader_Descriptors.h"


#define LOG_LOCAL_GID GLOBAL_GID_LOGGER /* specific module GID */
#define LOG_LOCAL_FID 3                 /* specific FID within this GID */

/******************************************************************************/
/***						Constant Defines								***/
/******************************************************************************/
#ifdef CPU_MIPS
#define UNUSED_PARAM(pMsg)   (pMsg = pMsg)
#endif

#ifdef CPU_ARC
#define UNUSED_PARAM(pMsg) do { (void)(pMsg); } while (0)

#endif


#define LOGGER_NUM_OF_BUFFERS (2) // per CPU

#define NUM_OF_LOGGER_BUFFER_DESCRIPTORS	(SYSTEM_NUM_OF_CORES * LOGGER_NUM_OF_BUFFERS)   //number of logger vector area descriptors


/******************************************************/
/***						Logprep Additions Start	***/
/******************************************************/
//#define RTLOG_MAX_DLEVEL    (0)
#if defined DEBUG_LOGGER_ENABLE
#define TLOG_FLAG
#if defined (ENET_INC_UMAC)
#if defined (ENET_INC_ARCH_WAVE600)
#define RTLOG_MAX_DLEVEL    (0)
#else
#define RTLOG_MAX_DLEVEL    (-1)
#endif
#elif defined (ENET_INC_LMAC)
#define RTLOG_MAX_DLEVEL    (0)
#endif
#else
#define RTLOG_MAX_DLEVEL    (-1)
#endif

#define RTLOG_FLAGS         1 /* RTLF_REMOTE_ENABLED */
#define MTLK_ASSERT(x) ASSERT(x)
//#define MTLK_ASSERT(x)
typedef bool BOOL;

// note: serial trace is supported only in umac 
#ifdef SERIAL_TRACE_ENABLE 
#define SERIAL_TRACE(data_p, val1, val2, val3) SerialTrace(data_p, val1, val2, val3)
#else 
#define SERIAL_TRACE(data_p, val1, val2, val3)
#endif // SERIAL_TRACE_ENABLE


/******************************************************/
/***						Logprep Additions End	***/
/******************************************************/
#if !defined (ENET_INC_ARCH_WAVE600)
#if defined (ENET_INC_LMAC)
typedef unsigned int size_t;
#endif //#if defined (ENET_INC_UMAC)
#endif //#if !defined (ENET_INC_ARCH_WAVE600)

#include "log.h"
/******************************************************************************/
/***						Type Definition									***/
/******************************************************************************/


/*  enum definitions  */
typedef enum
{
	KERNEL_EVENT_SEND_MSG,
	KERNEL_EVENT_RECV_KNL_MSG,
	KERNEL_EVENT_RECV_FROM_HOST_MSG,
	KERNEL_EVENT_SEND_TO_HOST_MSG,	
	KERNEL_EVENT_SEND_DIRECT_MSG,
	KERNEL_EVENT_SEND_ISR_MSG,
	KERNEL_EVENT_SEND_TIMEOUT_MSG,
	KERNEL_EVENT_TASK_START,
	KERNEL_EVENT_TASK_FINISH,
	KERNEL_EVENT_NUM_OF_TASKS,
} LogKernelEvents_e;


/* struct definitions */


/******************************************************************************/
/***						Macros											***/
/******************************************************************************/
#if defined (ENET_INC_UMAC)
#define LOGGER_API_LOG_KERNEL_EVENT(kernelEvent,kMsg_p) LoggerApi_LogKernelEvent(kernelEvent,kMsg_p);
#else
#define LOGGER_API_LOG_KERNEL_EVENT(kernelEvent,kMsg_p) 
#endif

/* Turn On\Off logs per group */
#define LM_CALIBRATION_LOGS_ON	0 // Enable logs for calibration in LM
#ifdef ENET_INC_ARCH_WAVE600
#define DUT_LOGS_ON
#endif 

#define LOGGER_DEFUALT_PRIORITY				1 


/******************************************************************************/
/***						Public Function Declaration						***/
/******************************************************************************/

void LoggerApi_LoggerInit(void);
void LoggerApi_SetFilter(UmiLoggerMsgSetFilter_t *filterMsg);
#if defined (ENET_INC_UMAC)
void LOGGER_Task(K_MSG *psMsg);
#endif
#ifdef DEBUG_UM_INTERFACE
void LoggerApi_SetSeverity(UmiLoggerMsgSetSeverity_t *severityMsg);
#endif
void LoggerApi_FlushBuffer(UmiLoggerMsgFlushBuffer_t *flushMsg_p);
void LoggerApi_LogKernelEvent(LogKernelEvents_e kernelEvent, K_MSG *kMsg_p);
#if defined (ENET_INC_UMAC)
void LoggerApi_SendLmBufferToHost(K_MSG *psMsg);
#endif
void LoggerApi_ProcessBufferAfterDmaComplete(uint8 logBufferId);

#if defined (ENET_INC_UMAC)
void LoggerApi_SetLogAgentMode(K_MSG *psMsg);
void LoggerApi_SetLoggerMode(K_MSG *kMsg_p, uint32 loggerNewState, uint32 targetCPU);
void LoggerApi_HandleGeneralCfm(K_MSG *psMsg);
void LoggerApi_HandleDbgTraceRes(K_MSG *kMsg_p);
uint32 LoggerAPIGetPoolStart(void* inMemAllocated_p, uint32 inNBuffers);
void LoggerApiTestSerialTrace(uint32 val1, uint32 val2, uint32 val3);
uint16 LoggerApi_GetLoggerStationIndex(void);
void LoggerApi_SetLoggerStationIndex(uint16 loggerStationIndex);
#endif
#if defined (ENET_INC_LMAC)
void LoggerApi_LmProcessReqFromUM(K_MSG *kMsg_p);
#endif
void SerialTrace(const char *data_p, uint32 val1, uint32 val2, uint32 val3);
void LoggerApiMarkEndOfBuffer(void);

#ifdef TLOG_FLAG
void TLOG0(K_MSG *kMsg_p, bool isFromDriver);
#endif

#ifndef ENET_INC_ARCH_WAVE600
void logFillMsgHdrTemplate(UMI_ADD_STREAM_REQ_t* addStreamStructurePtr);
#else
void logFillMsgHdrTemplate(HwLoggerHeader_t* hwLoggerHeaderPtr);
#endif

void LoggerApi_AddStream(K_MSG *kMsg_p);
void LoggerApi_RemoveStream(K_MSG *kMsg_p);


/******************************************************************************/
/***						external Public Variables						***/
/******************************************************************************/


/******************************************************************************/
/***					Statistics & Debug									***/
/******************************************************************************/



#endif /* __LOGGER_API_H_ */
