/***********************************************************************************
File:			logmacros.h
Module:			
Purpose:
Description:	
************************************************************************************/

#include "System_GlobalDefinitions.h"
#include "loggerAPI.h"

#if (RTLOG_MAX_DLEVEL < 0)
#define TLOG_Sender0(message, message_type, message_size)
#define SLOG0(src_task_id, dst_task_id, message_type, message)
#define ILOG0_V(fmt)
#define ILOG0_D(fmt, d1)
#define ILOG0_DD(fmt, d1, d2)
#define ILOG0_DDD(fmt, d1, d2, d3)
#define ILOG0_DDDD(fmt, d1, d2, d3, d4)
#else
void __TLOG_Sender0_1(uint16 src_task_id, uint16 dst_task_id, uint8 message_type, uint16 message_code, uint16 message_size, char *message);
#define TLOG_Sender0(message, message_type, message_size) __TLOG_Sender0_1(message->header.sFrom.taskID, message->header.sTo.taskID, message_type, message->header.tKMsgType, message_size, (char *)message->abData);

void __SLOG0_1(uint8 gid, uint8 fid, uint16 lid, uint16 src_task_id, uint16 dst_task_id, uint16 message_size, char *message);
#define SLOG0(src_task_id, dst_task_id, message_type, message) __SLOG0_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, src_task_id, dst_task_id, sizeof(*message), (char *)message)

void __ILOG0_V_1(uint8 gid, uint8 fid, uint16 lid);
#define ILOG0_V(fmt) __ILOG0_V_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__)

void __ILOG0_D_1(uint8 gid, uint8 fid, uint16 lid, int32 d1);
#define ILOG0_D(fmt, d1) __ILOG0_D_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1))

void __ILOG0_DD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2);
#define ILOG0_DD(fmt, d1, d2) __ILOG0_DD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2))

void __ILOG0_DDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3);
#define ILOG0_DDD(fmt, d1, d2, d3) __ILOG0_DDD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2), (int32) (d3))

void __ILOG0_DDDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3, int32 d4);
#define ILOG0_DDDD(fmt, d1, d2, d3, d4) __ILOG0_DDDD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2), (int32) (d3), (int32) (d4))

#endif

#if (RTLOG_MAX_DLEVEL < 1)
#define SLOG1(src_task_id, dst_task_id, message_type, message)
#define ILOG1_V(fmt)
#define ILOG1_D(fmt, d1)
#define ILOG1_DD(fmt, d1, d2)
#define ILOG1_DDD(fmt, d1, d2, d3)
#define ILOG1_DDDD(fmt, d1, d2, d3, d4)
#else
void __SLOG1_1(uint8 gid, uint8 fid, uint16 lid, uint16 src_task_id, uint16 dst_task_id, uint16 message_size, char *message);
#define SLOG1(src_task_id, dst_task_id, message_type, message) __SLOG1_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, src_task_id, dst_task_id, sizeof(*message), (char *)message)

void __ILOG1_D_1(uint8 gid, uint8 fid, uint16 lid, int32 d1);
#define ILOG1_D(fmt, d1) __ILOG1_D_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1))

void __ILOG1_DD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2);
#define ILOG1_DD(fmt, d1, d2) __ILOG1_DD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2))

void __ILOG1_DDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3);
#define ILOG1_DDD(fmt, d1, d2, d3) __ILOG1_DDD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2), (int32) (d3))

void __ILOG1_DDDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3, int32 d4);
#define ILOG1_DDDD(fmt, d1, d2, d3, d4) __ILOG1_DDDD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2), (int32) (d3), (int32) (d4))

#endif

#if (RTLOG_MAX_DLEVEL < 2)
#define SLOG2(src_task_id, dst_task_id, message_type, message)
#define ILOG2_V(fmt)
#define ILOG2_D(fmt, d1)
#define ILOG2_DD(fmt, d1, d2)
#define ILOG2_DDD(fmt, d1, d2, d3)
#define ILOG2_DDDD(fmt, d1, d2, d3, d4)
#else
void __SLOG2_1(uint8 gid, uint8 fid, uint16 lid, uint16 src_task_id, uint16 dst_task_id, uint16 message_size, char *message);
#define SLOG2(src_task_id, dst_task_id, message_type, message) __SLOG2_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, src_task_id, dst_task_id, sizeof(*message), (char *)message)

void __ILOG2_V_1(uint8 gid, uint8 fid, uint16 lid);
#define ILOG2_V(fmt) __ILOG2_V_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__)

void __ILOG2_D_1(uint8 gid, uint8 fid, uint16 lid, int32 d1);
#define ILOG2_D(fmt, d1) __ILOG2_D_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1))

void __ILOG2_DD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2);
#define ILOG2_DD(fmt, d1, d2) __ILOG2_DD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2))

void __ILOG2_DDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3);
#define ILOG2_DDD(fmt, d1, d2, d3) __ILOG2_DDD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2), (int32) (d3))

void __ILOG2_DDDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3, int32 d4);
#define ILOG2_DDDD(fmt, d1, d2, d3, d4) __ILOG2_DDDD_1(LOG_LOCAL_GID, LOG_LOCAL_FID, __LINE__, (int32) (d1), (int32) (d2), (int32) (d3), (int32) (d4))

#endif

