
/*----------- These Lines are a Prefix ---------*/
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "logger.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID GLOBAL_GID_LOGGER
#define LOG_LOCAL_FID 1

#if (RTLOG_MAX_DLEVEL >= 0)

static void logMacros_ILOG(uint8 gid, uint8 fid, uint16 lid, uint16 level, uint16 argc, int32 argv[])
{
	int idx;
	
#if (RTLOG_FLAGS & (RTLF_REMOTE_ENABLED | RTLF_CONSOLE_ENABLED))
	int flags__ = mtlk_log_get_flags(level, 1, gid);
#endif
#if (RTLOG_FLAGS & RTLF_REMOTE_ENABLED)
	if ((flags__ & LOG_TARGET_REMOTE) != 0)
	{
		size_t datalen__ = (LOGPKT_SCALAR_SIZE(int32) * argc);
		mtlk_log_buf_entry_t *pbuf__;
		TX_INTERRUPT_SAVE_AREA;
    
		OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	
		pbuf__ = logReserveBuffer(datalen__);
    
		if (pbuf__ != NULL)
		{
			uint8 *p__ = (uint8*)pbuf__;
		
			logFillLogEvent(1, gid, fid, lid, datalen__, &p__);
		
			/* We do not copy the whole structure to avoid issues with  */
			/* incorrect packing. Client side assumes this structure    */
			/* is 1-byte packed, but some compilers have issues with    */
			/* creation of such structures.                             */
			/* WARNING: Because of this type of usage order of fields   */
			/* in the sctructure is important and must be preserved.    */
			
			for (idx = 0; idx < argc; idx++)
			{
				LOGPKT_PUT_INT32(argv[idx]);
			}
		
			logReleaseBuffer(pbuf__, datalen__);
		}
		OSAL_ENABLE_INTERRUPTS(interrupt_save);
	}
#endif
}


static void logMacros_SLOG(uint8 gid, uint8 fid, uint16 lid, uint16 level, uint16 src_task_id, uint16 dst_task_id, uint16 message_size, char *message)
{
#if (RTLOG_FLAGS & (RTLF_REMOTE_ENABLED | RTLF_CONSOLE_ENABLED))
  int flags__ = mtlk_log_get_flags(level, 1, gid);
#endif
#if (RTLOG_FLAGS & RTLF_REMOTE_ENABLED)
  if ((flags__ & LOG_TARGET_REMOTE) != 0)
  {
    size_t datalen__ = LOGPKT_SIGNAL_SIZE(message_size);
    mtlk_log_signal_t mtlk_log_signal;
    mtlk_log_buf_entry_t *pbuf__;
    TX_INTERRUPT_SAVE_AREA;
    
    OSAL_DISABLE_INTERRUPTS(&interrupt_save);
    
    pbuf__ = logReserveBuffer(datalen__);
    
    if (pbuf__ != NULL)
    {
      uint8 *p__ = (uint8*)pbuf__;

	  logFillLogEvent(1, gid, fid, lid, datalen__, &p__);

      mtlk_log_signal.src_task_id = src_task_id;
      mtlk_log_signal.dst_task_id = dst_task_id;
      mtlk_log_signal.len = message_size;
      
      LOGPKT_PUT_SIGNAL(mtlk_log_signal, message);

      logReleaseBuffer(pbuf__, datalen__);
    }
   	OSAL_ENABLE_INTERRUPTS(interrupt_save);
  }
#endif
}

void __TLOG_Sender0_1(uint16 src_task_id, uint16 dst_task_id, uint8 message_type, uint16 message_code, uint16 message_size, char *message)
{
#if (RTLOG_FLAGS & (RTLF_REMOTE_ENABLED | RTLF_CONSOLE_ENABLED))
  int flags__ = mtlk_log_get_flags(0, 1, 0);
#endif
#if (RTLOG_FLAGS & RTLF_REMOTE_ENABLED)
  if ((flags__ & LOG_TARGET_REMOTE) != 0)
  {
    size_t datalen__ = LOGPKT_TLOG_SIZE(message_size);
    mtlk_log_TLOG_t mtlk_log_TLOG;
    mtlk_log_buf_entry_t *pbuf__;
    TX_INTERRUPT_SAVE_AREA;
    
    OSAL_DISABLE_INTERRUPTS(&interrupt_save);
    
    pbuf__ = logReserveBuffer(datalen__);
    
    if (pbuf__ != NULL)
    {
      uint8 *p__ = (uint8*)pbuf__;

	  logFillLogEvent(1, 0, message_type, message_code, datalen__, &p__);

      mtlk_log_TLOG.src_task_id = src_task_id;
      mtlk_log_TLOG.dst_task_id = dst_task_id;
      mtlk_log_TLOG.len = message_size;
      
      LOGPKT_PUT_TLOG(mtlk_log_TLOG, message);

      logReleaseBuffer(pbuf__, datalen__);
    }
   OSAL_ENABLE_INTERRUPTS(interrupt_save);
  }
#endif
}
#endif /* RTLOG_MAX_DLEVEL >= 0 */

#if (RTLOG_MAX_DLEVEL >= 0)

void __SLOG0_1(uint8 gid, uint8 fid, uint16 lid, uint16 src_task_id, uint16 dst_task_id, uint16 message_size, char *message)
{
	logMacros_SLOG(gid, fid, lid, 0, src_task_id, dst_task_id, message_size, (char *)message);
}

void __ILOG0_V_1(uint8 gid, uint8 fid, uint16 lid)
{
	logMacros_ILOG(gid, fid, lid, 0, 0, NULL);
}

void __ILOG0_D_1(uint8 gid, uint8 fid, uint16 lid, int32 d1)
{
	int32 paramArray[1];
	
	paramArray[0] = d1;

	logMacros_ILOG(gid, fid, lid, 0, 1, paramArray);
}

void __ILOG0_DD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2)
{
	int32 paramArray[2];
	
	paramArray[0] = d1;
	paramArray[1] = d2;

	logMacros_ILOG(gid, fid, lid, 0, 2, paramArray);
}

void __ILOG0_DDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3)
{
	int32 paramArray[3];
	
	paramArray[0] = d1;
	paramArray[1] = d2;
	paramArray[2] = d3;

	logMacros_ILOG(gid, fid, lid, 0, 3, paramArray);
}

void __ILOG0_DDDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3, int32 d4)
{
	int32 paramArray[4];
	
	paramArray[0] = d1;
	paramArray[1] = d2;
	paramArray[2] = d3;
	paramArray[3] = d4;

	logMacros_ILOG(gid, fid, lid, 0, 4, paramArray);
}

#endif

#if (RTLOG_MAX_DLEVEL >= 1)

void __SLOG1_1(uint8 gid, uint8 fid, uint16 lid, uint16 src_task_id, uint16 dst_task_id, uint16 message_size, char *message)
{
	logMacros_SLOG(gid, fid, lid, 1, src_task_id, dst_task_id, message_size, (char *)message);
}

void __ILOG1_V_1(uint8 gid, uint8 fid, uint16 lid)
{
	logMacros_ILOG(gid, fid, lid, 1, 0, NULL);
}

void __ILOG1_D_1(uint8 gid, uint8 fid, uint16 lid, int32 d1)
{
	int32 paramArray[1];
	
	paramArray[0] = d1;

	logMacros_ILOG(gid, fid, lid, 1, 1, paramArray);
}

void __ILOG1_DD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2)
{
	int32 paramArray[2];
	
	paramArray[0] = d1;
	paramArray[1] = d2;

	logMacros_ILOG(gid, fid, lid, 1, 2, paramArray);
}

void __ILOG1_DDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3)
{
	int32 paramArray[3];
	
	paramArray[0] = d1;
	paramArray[1] = d2;
	paramArray[2] = d3;

	logMacros_ILOG(gid, fid, lid, 1, 3, paramArray);
}

void __ILOG1_DDDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3, int32 d4)
{
	int32 paramArray[4];
	
	paramArray[0] = d1;
	paramArray[1] = d2;
	paramArray[2] = d3;
	paramArray[3] = d4;

	logMacros_ILOG(gid, fid, lid, 1, 4, paramArray);
}

#endif

#if (RTLOG_MAX_DLEVEL >= 2)

void __SLOG2_1(uint8 gid, uint8 fid, uint16 lid, uint16 src_task_id, uint16 dst_task_id, uint16 message_size, char *message)
{
	logMacros_SLOG(gid, fid, lid, 2, src_task_id, dst_task_id, message_size, (char *)message);
}

void __ILOG2_V_1(uint8 gid, uint8 fid, uint16 lid)
{
	logMacros_ILOG(gid, fid, lid, 2, 0, NULL);
}

void __ILOG2_D_1(uint8 gid, uint8 fid, uint16 lid, int32 d1)
{
	int32 paramArray[1];
	
	paramArray[0] = d1;

	logMacros_ILOG(gid, fid, lid, 2, 1, paramArray);
}

void __ILOG2_DD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2)
{
	int32 paramArray[2];
	
	paramArray[0] = d1;
	paramArray[1] = d2;

	logMacros_ILOG(gid, fid, lid, 2, 2, paramArray);
}

void __ILOG2_DDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3)
{
	int32 paramArray[3];
	
	paramArray[0] = d1;
	paramArray[1] = d2;
	paramArray[2] = d3;

	logMacros_ILOG(gid, fid, lid, 2, 3, paramArray);
}

void __ILOG2_DDDD_1(uint8 gid, uint8 fid, uint16 lid, int32 d1, int32 d2, int32 d3, int32 d4)
{
	int32 paramArray[4];
	
	paramArray[0] = d1;
	paramArray[1] = d2;
	paramArray[2] = d3;
	paramArray[3] = d4;

	logMacros_ILOG(gid, fid, lid, 2, 4, paramArray);
}


#endif


