/* CMSynergyVer %full_filespec: MT_QSmachine.h;5:incl:1 % */
//***************************************************************
//
// File:	    MT_QSmachine.h
//
// Purpose:     Decision Making Module for Queue Switch events (TSF request timer).
// Description: This module holds all the information regarding switch events, and make
//              desicions about the next event, which has the highest priority, to configure.
//              Desicion making algorithm is implemented exclusively inside the module, where
//              the user can only ask (configure) new event, but has no effect about it's 
//              priority.
//
//***************************************************************

#ifndef MT_QSMACHINE_H
#define MT_QSMACHINE_H

#include <System_GlobalDefinitions.h>
#include <System_Configuration.h>

/************************/
/* Constant definitions */
/************************/

typedef enum NSE            /* Next Switch Event */
{
	/* DTIM period events */
    NSE_BCN_CP,     
    NSE_DTIM_END,    
	
	/* BE workaround events */
	NSE_BE_ERR_STA,
	NSE_BE_ERR_END,

	/* Program HW protection */
	NSE_FRAME_TTL_EXPIRED_START,
	NSE_FRAME_TTL_EXPIRED_END,

	/* Dummy Event */
	NSE_NONE,			

	/* UMAC initiate QS (using a message) */
	NSE_MSG,

	NSE_TX_CANCEL,
	/* Temperature check request QS */
	NSE_TEMPERATURE_CHECK,
	NSE_TOTAL_NUM,
	
	NSE_ABORT				=14,
	NSE_OUT_OF_RANGE,

} NSE_t;

typedef enum QSaction {
	QS_ACTION_PROGRAM,
	QS_ACTION_ABORT,
	QS_ACTION_RESCHED,
	QS_ACTION_OCCURED,
} QSaction_t;


typedef struct MT_QSparms {
	uint8 	 	 u8valid;
	uint8	 	 u8direction;	
	bool		 boForcePrg;
	uint32	 	 u32time;
	enum NSE 	 eEvent; //not a must parameter, could be calculate from the array 		
} MT_QSparms_t;

typedef struct {
	MT_QSparms_t	sEvents[NSE_TOTAL_NUM];
	MT_QSparms_t	*psNSE;
	uint8			u8direction;
	bool			boState;
} MT_QSmachine_t;

#define QS_THRESHOLD		40	/* uSec */

#define QS_DIRECTION_TOGGLE	2

/* Important Note: QS_STATUS and QS_EFFECT definitions MUST where chosen carefully, and each number have 
 * an important meaning (bitwise operations). Both should be changed (if ever) correspondingly.
 */
#define QS_STATUS_NOT_VALID	 	0
#define QS_STATUS_RESCHED		1
#define QS_STATUS_POSTPONED		3
#define QS_STATUS_VALID			7
#define QS_STATUS_ABORTED		8

#define QS_EFFECT_DISABLE  	0
#define QS_EFFECT_RESCHED	1
#define QS_EFFECT_POSTPONSE 3
#define QS_EFFECT_NONE 		15

#define LOWER32BITS	0x00000000FFFFFFFF

/*********************************/
/* Function prototypes			 */
/*********************************/
extern bool 		 MT_QSMinsertEvent (QSaction_t eSwitchAction, NSE_t eNseEvent, uint32 u32time, uint8 u8direction);

extern bool 		 MT_QSMgetState(void);
extern enum NSE 	 MT_QSMgetActiveEvent (void);
//extern MT_QSparms_t* MT_QSMgetEvent (NSE_t eEvent);



/*********************/
/* Macro definitions */
/*********************/


#endif	/* #ifndef MT_QSMACHINE_H */
