/* CMSynergyVer %full_filespec: lm.h;52.2.6:incl:1 % */
/****************************************************************************
****************************************************************************
**
** COMPONENT:      ENET SW - Lower MAC
**
** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_lower/lm.h $
**
** DESCRIPTION:    Intra LM header file
**
** AUTHOR:         John Gladman
**
** THIS VERSION:   $Revision: #11 $
**   CHANGED ON:   $Date: 2004/03/25 $
**           BY:   $Author: jh3 $
**
****************************************************************************
**
** Copyright (c) 2004 TTPCom Limited
**
****************************************************************************
****************************************************************************/
#ifndef __LM_H
#define __LM_H

#include "mt_sysdefs.h"
#include "lmi.h"
#include "frame.h"
#include "BSSmanager_API.h"
#include "enet_pas.h"

/*********************/
/* Macro definitions */
/*********************/


/************************/
/* Constant definitions */
/************************/
/* Time Unit Constant */
#define TUC                     1024
/* Recipe Constants */
#define MAX_RECIPE_INSTRUCTIONS 23
/* Recipe indexes */
#define RCP_IDX_BEACON          0   /* Fixed */
#define RCP_IDX_ACK             1
#define RCP_IDX_CTS             2
#define RCP_IDX_ACK0            3   /* Ack Ping-Pong 3 - 10 */
//#define RCP_IDX_ACK1            4
#define RCP_IDX_NACK0           11  /* Nack Ping Pong 11 - 18 */
//#define RCP_IDX_NACK1           12
#define RCP_IDX_AGG_BASE        19  /* Aggregate recipe 19 - 26 [4 queue * 2 recipe each] */
#define RCP_IDX_BLOCK_ACK       27  /* BlockAck recipe    */
#define NUM_OF_RECIPIES     28 /* <L.H> must be global due to upper and lower mac share this memory section  */
/* TTCS Constants */
#define NUM_OF_TTCS             28
#define DEFAULT_TTCS            0   /*  0 ~ 3  */
#define NORMAL_TTCS             4   /*    4    */
#define POS_RESP_TTCS           5   /*  5 ~ 12 */
#define NEG_RESP_TTCS           13  /* 13 ~ 20 */
#define ACK_TTCS                21
#define CTS_TTCS                22
#define BEACON_TTCS             23
#define DEFAULT1_TTCS           24
#define NORMAL1_TTCS            25
#define BLOCK_ACK_TTCS          26
#define NULL_TTCS               27
#define NULL_INT_RTN    ((K_STATE (*)(K_MSG *))0)


/******************************/
/* Internal type declarations */
/******************************/

typedef struct RECIPETag   /* RECIPE */
{
    uint32 u32Instructions[MAX_RECIPE_INSTRUCTIONS];
} RECIPE;


/******************************/
/* Intra LM data declarations */
/******************************/

/* lmmain.c */
/* Function pointers set up depending on 802.11a or 802.11b mode selection */
extern struct ENET_TTCS sTTCSskeletonSifs;
extern struct ENET_TTCS sTTCSskeletonSifsWithTimeout;
extern struct ENET_TTCS sTTCSskeletonSifsWithTimeout11b;
extern struct ENET_TTCS sTTCSskeletonSifsAgg;
extern struct ENET_TTCS sTTCSskeletonDifs;
extern struct ENET_TTCS sTTCSskeletonDifsWithTimeout;
extern struct ENET_TTCS sTTCSskeletonDifsWithTimeout11b;
PRAGMA_START_DATA
extern struct ENET_TTCS asTTCSs[];
PRAGMA_END_DATA

/**********************************/
/* Intra LM function declarations */
/**********************************/
/* lmmain.c */
extern void vLM_Init(void);
extern void vLM_Enable(void);
extern void Lm_WaitForUm(void);
extern void lmGetBcl(K_MSG * ptK_MSG);
extern void lmSetBcl(K_MSG * ptK_MSG);

/* lmutil.c */
#if defined(CALCULATE_CPU_IDLE_TIME)
//extern void vGenerateCPUIdleIndication(uint32 totalSleepTime,uint32 countTicks,uint32 TSFLow);
#endif
extern void vDCFinit(void);
extern void vSetSlotDuration11g(uint32 uiSlotType11g);
extern void HWInit(void);
PRAGMA_START_DATA
typedef uint32 GENERAL_PURPOSE_WORD_SIZE;
extern struct ENET_TTCS asTTCSs[];
extern RECIPE asRECIPEs[];
extern uint32 MT_SHARED_RAM_words[];
extern GENERAL_PURPOSE_WORD_SIZE au32DurationAdjust[];
PRAGMA_END_DATA
/* MT_MAC_HT_extensions.c */
extern void vConfigFDC(void);
extern void vFC2_CRC_INIT(void);
extern void vBA_INIT(void);
void vDUR_INIT(void);
/* lmint.c */
extern void vClearSignalMask(uint32 u32BitMask);
extern void vClearAllSignalMask(void);
void vSetSignalMask(uint32 u32BitMask);
uint32 vGetSignalMask(void);

#endif /* __LM_H */
