/* CMSynergyVer %full_filespec: lm_statistics.h;6.1.2.1.1.1.5.1.1:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET Lower MAC SW
 **
 ** MODULE:         ..\WL\develop\src\mac\mac_lower\lm_statistics.h $
 **
 ** VERSION:        $Revision: $
 **
 ** DATED:          $Date: 2005/08/01 $
 **
 ** AUTHOR:         Hagit Hay
 **
 ** DESCRIPTION:    Statistics header
 **
 **
 ** LAST MODIFIED BY:   
 **
 **
 ****************************************************************************/

#ifndef LM_STATISTICS_INC
#define LM_STATISTICS_INC

#if defined (ENET_INC_DEBUG_LM_STATS)

#include <lmi.h>
#include <lminfra.h>

/*********************************/
/* Function prototypes			 */
/*********************************/

void MT_LMstatRxCplt (uint32 uiCond);
void MT_LMstatNackEvnt (K_MSG *ptK_MSG, DCTX *psDTCX, uint32 uiCond, uint32 pri);
void MT_LMstatFSDUretire (LM_FSDU *psLM_FSDU, lowerTxQtype_t eQtype);

/************************/
/* Constant definitions */
/************************/

typedef enum lmStatPerPriority {
	/* <H.H>:
	 * Transmission statics:
	 * 	(-) Counters for frames are placed when Tx Start indication occurs.
	 *	(-) Counters for failed/retry transactions are placed when a NACK event occurs.
	 *	(-) Failed transaction is optional due to two reasons: frame has reached retry
	 *		limit or time to live (TTL) has expired.
	 */
	 MT_LM_STAT_TX_UNICAST_DATA_MPDU,
	 MT_LM_STAT_TX_UNICAST_OTHR_MPDU,  
	 MT_LM_STAT_TX_MULTICAST_MPDU, 	  
	 MT_LM_STAT_NOT_IN_USE,	//MT_LM_STAT_TX_BEACON,			  
	 MT_LM_STAT_TX_AMPDU,		   	  
	 MT_LM_STAT_NOT_IN_USE_1, //MT_LM_STAT_TX_N_MPDU_IN_AMPDU,	   
	 MT_LM_STAT_NOT_IN_USE_2, //MT_LM_STAT_TX_RTS,				  
	 MT_LM_STAT_NOT_IN_USE_3, //MT_LM_STAT_TX_CTS,
	 MT_LM_STAT_NOT_IN_USE_4, //MT_LM_STAT_TX_RETRY,		   	  
	 MT_LM_STAT_NOT_IN_USE_5, //MT_LM_STAT_TX_FAILED_RETRY_LIMIT, 
	 MT_LM_STAT_NOT_IN_USE_6, //MT_LM_STAT_TX_FAILED_TTL, //10
	 MT_LM_STAT_NOT_IN_USE_7, //MT_LM_STAT_TX_FAILED_DISCONNECT_TTL,
	 MT_LM_STAT_NOT_IN_USE_8, //MT_LM_STAT_TX_START_WAITRSP,	  
	 MT_LM_STAT_NOT_IN_USE_9, //MT_LM_STAT_TX_START_SCAN,	
 	 MT_LM_STAT_NOT_IN_USE_10, //MT_LM_STAT_TX_ABORT,	  
	/* <H.H>:
	 * UMAC-LMAC statistics:
	 * These statistics are calculated when the LMAC access and handles FSDUs from 
	 * the Tx queue (where the UMAC puts frames which should be transmitted).  
	 */
	MT_LM_STAT_UM_UNICAST_DATA_MPDU,	//15
	MT_LM_STAT_UM_UNICAST_OTHR_MPDU,
	MT_LM_STAT_UM_MULTICAST_MPDU,
	MT_LM_STAT_UM_AMPDU,		   	   
	MT_LM_STAT_UM_N_MPDU_IN_AMPDU,  
	/* <H.H>:
	 * Control frames statistics:
	 *	(-) TIMEOUT - ACK/BA/CTS was not received and timer has reached timeout limit.
	 * 	(-) FAILURE - frame was received instead of ACK/BA/CTS which was expected.
	 *	(-) CTS_FAILURE applies to "CTS to self" mechanism when chain is broken (tx abort event).
	 * Note: If frame has CRC error (FCS according RXD indication) then the proper counter 
	 * (FAILURE) will be increased as well as the FCS counter.
	 */
	MT_LM_STAT_ACK_TIMEOUT,	//20
	MT_LM_STAT_ACK_FAILURE,
	MT_LM_STAT_BA_TIMEOUT, 
	MT_LM_STAT_BA_FAILURE, 
	MT_LM_STAT_RTS_TIMEOUT,
	MT_LM_STAT_RTS_FAILURE, //25
	MT_LM_STAT_NOT_IN_USE_11, //MT_LM_STAT_RTS_SUCCESS,
	MT_LM_STAT_NOT_IN_USE_12, //MT_LM_STAT_CTS_FAILURE,

	MT_LM_STAT_PER_PRIORITY_TOTAL_NUM	=28
} lmStatPerPriority_t;

typedef enum lmStatGeneral {
	/* <H.H>:
	 * Received statics:
	 * 	(-) Counters for frames are placed when Rx complete indication occurs.
	 *	(-) BACK is being count separatly when received after BA-Request and after
	 *		aggregate with normal ack policy.
	 */
	MT_LM_STAT_RX_QOS_UNICAST_MPDU		=0,
	MT_LM_STAT_RX_UNICAST_MPDU,	  
	MT_LM_STAT_RX_MULTICAST_MPDU,  
	MT_LM_STAT_RX_NOACK_MPDU,	  
	MT_LM_STAT_RX_NAV_LOAD,
	MT_LM_STAT_RX_AMPDU,			  
	MT_LM_STAT_RX_N_MPDU_IN_AMPDU, 
	MT_LM_STAT_NOT_IN_USE_1, //MT_LM_STAT_RX_ACK,			  
	MT_LM_STAT_NOT_IN_USE_2, //MT_LM_STAT_RX_BA_BAR,		  
	MT_LM_STAT_NOT_IN_USE_3, //MT_LM_STAT_RX_BA_AGG,
	MT_LM_STAT_RX_BA,
	MT_LM_STAT_RX_RTS,		  
	MT_LM_STAT_RX_OTHR,			  
	/* <H.H>:
	 * General errors, in common for all priority:
	 *	(-) Cyclic buffer in shared RAM is overflow.
	 *	(-) NTD fifo queue is overflow. 
	 *	(-) Frame Check Sequence (FCS) error.
	 *	(-) FCS_FAILURE contain the sum of error counter for both legacy and aggregate 
	 *		frames (including error in sub-frames in aggregate).
	 */
	MT_LM_STAT_CYCBUF_OVERFLOW			=13, 	
	MT_LM_STAT_NTDFIFO_OVERFLOW,
	MT_LM_STAT_NOT_IN_USE_4, //MT_LM_STAT_Q_SWITCH,
	MT_LM_STAT_FCS_FAILURE,	   
	MT_LM_STAT_FCS_FAILURE_AGG, 
	/* <H.H>:
	 * Q switch events divided into categories.
	 * For simplisity, the order is according to NSE enum (defined in MT_QSmachine.h).
	 */
	MT_LM_STAT_NOT_IN_USE_5, //MT_LM_STAT_Q_SWITCH_DTIM_START		=18,
	MT_LM_STAT_NOT_IN_USE_6, //MT_LM_STAT_Q_SWITCH_DTIM_END,
	MT_LM_STAT_NOT_IN_USE_7, //MT_LM_STAT_Q_SWITCH_BE_START,
	MT_LM_STAT_NOT_IN_USE_8, //MT_LM_STAT_Q_SWITCH_BE_END,	  
	MT_LM_STAT_NOT_IN_USE_9, //MT_LM_STAT_Q_SWITCH_FRAME_TTL_EXPIRED_START,	  
	MT_LM_STAT_NOT_IN_USE_10, //MT_LM_STAT_Q_SWITCH_FRAME_TTL_EXPIRED_END,	  
	MT_LM_STAT_NOT_IN_USE_11, //MT_LM_STAT_Q_SWITCH_NONE_ABORT,
	MT_LM_STAT_NOT_IN_USE_12, //MT_LM_STAT_Q_SWITCH_STOP_REQ,
	MT_LM_STAT_NOT_IN_USE_13, //MT_LM_STAT_Q_SWITCH_PAUSE_11H_SILENCE,
	MT_LM_STAT_NOT_IN_USE_14, //MT_LM_STAT_Q_SWITCH_PAUSE_11H_NON_SILENCE,
	MT_LM_STAT_NOT_IN_USE_15, //MT_LM_STAT_Q_SWITCH_PAUSE_OFF,
	MT_LM_STAT_NOT_IN_USE_16, //MT_LM_STAT_Q_SWITCH_PAUSE_DISCONN,
	MT_LM_STAT_NOT_IN_USE_17, //MT_LM_STAT_Q_SWITCH_PAUSE_CLOSE_AGGR,
	/* <H.H>:
	 * Interrupt statistics.
	 * Counters for each interrupt that the LMAC could receive. The counter are
	 * placed in the compatible	ISR and being increased also when the interrupt 
	 * is masked.
	 */
	MT_LM_STAT_NOT_IN_USE_28				=33,	   
	MT_LM_STAT_EVT_HW_TSF,	   
	MT_LM_STAT_EVT_HW_CYCBUF_OVERFLOW, 
	MT_LM_STAT_EVT_HW_DEL_LEN_ERR,	   
	MT_LM_STAT_EVT_HW_EOF_ERR,	   
	MT_LM_STAT_NOT_IN_USE_18, //MT_LM_STAT_EVT_HW_RX_ERR,	   
	MT_LM_STAT_EVT_HW_TX_ERR,	   
	MT_LM_STAT_NOT_IN_USE_19, //MT_LM_STAT_EVT_HW_DELIA_TOGGLE,	   
	MT_LM_STAT_EVT_UM_M_REQ_RES,
	MT_LM_STAT_NOT_IN_USE_20, //MT_LM_STAT_EVT_UM_MPS_REQ,  
	MT_LM_STAT_NOT_IN_USE_21, //MT_LM_STAT_EVT_UM_CF_REQ,   
	MT_LM_STAT_NOT_IN_USE_22, //MT_LM_STAT_EVT_UM_UPS_REQ,  
	MT_LM_STAT_NOT_IN_USE_23, //MT_LM_STAT_EVT_UM_DCF_REQ,  
	MT_LM_STAT_NOT_IN_USE_24, //MT_LM_STAT_EVT_UM_TXQS_REQ, 
	MT_LM_STAT_EVT_UM_RX_RES,   
	MT_LM_STAT_NOT_IN_USE_25, //MT_LM_STAT_EVT_UM_DEBUG_RES,
	/* <H.H>:
	 * Lm-UM queues statistics.
	 *
	 */
	MT_LM_STAT_Q_CF						=49,	  
	MT_LM_STAT_NOT_IN_USE_26, //MT_LM_STAT_Q_UPS,  
	MT_LM_STAT_EVT_ASSERT_TO_UM_FROM_LM0, //MT_LM_STAT_Q_MPS,  
	MT_LM_STAT_EVT_ASSERT_TO_UM_FROM_LM1			=52,
	MT_LM_STAT_EVT_ASSERT_TO_LM0_FROM_UM,
	MT_LM_STAT_EVT_ASSERT_TO_LM1_FROM_UM,
	MT_LM_STAT_EVT_ASSERT_TO_LM0_FROM_LM1,
	MT_LM_STAT_EVT_ASSERT_TO_LM1_FROM_LM0,

	MT_LM_STAT_TX_PRIORITY_0		    =57,
	MT_LM_STAT_TX_PRIORITY_1,
	MT_LM_STAT_TX_PRIORITY_2,
	MT_LM_STAT_TX_PRIORITY_3,

	MT_LM_STAT_RDT_NO_MEASUREMENTS,

	MT_LM_STAT_BEACON_ABORT				=62,

	MT_LM_STAT_GENERAL_TOTAL_NUM		=63
} lmStatGeneral_t;			 


/*******************************/
/* Global variable definitions */
/*******************************/



/* <H.H>:
 * There are two arrays which holds LMAC statistics which distinct by priority parameter.
 * When there is a meaning, statistics are collected separatly per EDCF priority.
 * Total size of the array is ... Byte.
 */
extern uint32 MT_LM_STAT_GENERAL[MT_LM_STAT_GENERAL_TOTAL_NUM];
extern uint32 MT_LM_STAT_PER_PRIORITY[MAX_USER_PRIORITIES][MT_LM_STAT_PER_PRIORITY_TOTAL_NUM];

/*********************/
/* Macro definitions */
/*********************/
 																
#define MT_LM_STAT_PP_INC(priority,stat)  		MT_LM_STAT_PER_PRIORITY[priority][stat]++
#define MT_LM_STAT_INC(stat)					MT_LM_STAT_GENERAL[stat]++
#define MT_LM_STAT_PP_ADD(priority,stat,num)  	MT_LM_STAT_PER_PRIORITY[priority][stat] = MT_LM_STAT_PER_PRIORITY[priority][stat] + (num)
#define MT_LM_STAT_ADD(stat,num)  				MT_LM_STAT_GENERAL[stat] = MT_LM_STAT_GENERAL[stat] + (num)
#define	MT_LM_STAT_PP_GET(priority,stat)		MT_LM_STAT_PER_PRIORITY[priority][stat]
#define	MT_LM_STAT_GET(stat)					MT_LM_STAT_GENERAL[stat]

#define MT_LM_STAT_RX_CPLT(uiCond)					  		MT_LMstatRxCplt(uiCond)
#define MT_LM_STAT_NACK_EVNT(ptK_MSG, psDTCX, uiCond, pri)	MT_LMstatNackEvnt(ptK_MSG, psDTCX, uiCond, pri)
#define MT_LM_STAT_FSDU_RETIRE(psLM_FSDU, eQtype)		  	MT_LMstatFSDUretire (psLM_FSDU, eQtype)

#else	/* #if defined( ENET_INC_DEBUG_LM_STATS ) */

#define MT_LM_STAT_PP_INC(priority,stat) 
#define MT_LM_STAT_INC(stat) 
#define MT_LM_STAT_PP_ADD(priority,stat,num)
#define MT_LM_STAT_ADD(stat,num)
#define	MT_LM_STAT_PP_GET(priority,stat)  0
#define	MT_LM_STAT_GET(stat)              0

#define MT_LM_STAT_RX_CPLT(cond)
#define MT_LM_STAT_NACK_EVNT(ptK_MSG, psDTCX, uiCond, pri)
#define MT_LM_STAT_FSDU_RETIRE(psLM_FSDU, eQtype)


#endif /* #if defined( ENET_INC_DEBUG_LM_STATS ) */

 
#endif /* #ifndef LM_STATISTICS_INC */

