/* CMSynergyVer %full_filespec: lmi.h;36.1.1:incl:1 % */
/**************************************************************************
***************************************************************************
**
** COMPONENT:        Lower MAC
**
** MODULE:           $File: //bwp/enet/demo153_sw/develop/src/mac_lower/lmi.h $
**
** VERSION:          $Revision: #4 $
**
** DATED:            $Date: 2004/03/25 $
**
** AUTHOR:           S Sondergaard
**
** DESCRIPTION:      Lower MAC Public Interface
**
** CHANGE HISTORY:
**
**   $Log: lmi.h $
**   Revision 1.2  2003/02/11 17:41:29Z  prh
**   Make selection of 802.11b Short/Long Preamble selection similar to 802.11g.
**   Revision 1.45  2002/12/04 13:03:03Z  jag1
**   Added Lower MAC test mode interface.
**   Revision 1.44  2002/11/18 11:51:21Z  prh
**   Replace LM_CONFIRM for now.
**   Revision 1.43  2002/11/18 11:29:47Z  prh
**   Remove LM_CONFIRM structure.
**   Revision 1.42  2002/11/13 16:50:08Z  prh
**   Pad LM_FSDU structure for alignment.
**   Revision 1.41  2002/10/28 11:01:54Z  jag1
**   Additions and modifications in support of 802.11g.
**   Revision 1.40  2002/09/19 15:33:30Z  prh
**   LM_BEACON replaced by the identical LM_PRE_TBTT.
**   Revision 1.39  2002/08/27 12:30:22Z  mrg
**   Corrected previous merging (re-added PCF lists in beacon structs)
**   Revision 1.38  2002/08/20 09:23:47Z  mrg
**   Updates from 11b testing
**   Revision 1.37  2002/07/22 12:23:39Z  prh
**   Remove newly added CF-Pollable queues, as we
**   now use the MPS, UPS and CF queues during the CFP.
**   Revision 1.36  2002/07/17 14:22:31Z  djh
**   Added LM_MAN_FATAL_REQ for debug purposes
**   Revision 1.35  2002/06/25 14:39:39Z  mrg
**   Added PCF interface.
**   Revision 1.34  2002/04/25 13:19:19Z  ifo
**   Renamed LM_PHY_RATES to LM_PHY_RATES_11A for clarity
**   Revision 1.33  2002/04/17 13:59:03Z  smk
**   LMI supports setting of basic rate set
**   Revision 1.32  2002/04/12 09:07:00Z  ifo
**   Added comments to document added configure parameters.
**   Revision 1.31  2002/04/12 07:36:42Z  jag1
**   FSDU structure and additional interface changes.
**   Revision 1.30  2002/03/21 10:54:35Z  djh
**   Tweaked LM_BEACON definition due to CodeWarrior's indigestion of some typedefs
**   Revision 1.29  2002/03/20 16:39:59Z  prh
**   Make PRE_TBTT ind and res use the same parameters.
**   Revision 1.28  2002/02/04 12:03:31Z  jag1
**   Renamed shadow in and out receive pointers.
**   Revision 1.27  2002/01/18 10:18:26Z  jgs
**   LM_CAPABILITIES_CFM - removed u16RatesMask11a,
**   u16RatesMask11b - replaced with u16RatesMask
**   Revision 1.26  2002/01/09 08:46:22Z  ifo
**   Woops - fixed LM_JOIN to LM_START
**   Revision 1.25  2002/01/08 12:54:16Z  ifo
**   Made LM_JOIN and LM_START the same structure.
**   (Changes to way TSF delta is propagated).
**   Revision 1.24  2002/01/03 16:39:58Z  prh
**   Add new format for TSF adjust in LM_JOIN command.
**   Revision 1.23  2001/12/19 11:19:17Z  jgs
**   Merged in 11b changes
**   Revision 1.22  2001/12/18 10:36:35Z  jag1
**   New definitions for LM FSDU states.
**   Revision 1.21  2001/12/03 11:11:36Z  jag1
**   Corrected typo and de-tabbed.
**   Revision 1.20  2001/11/28 09:49:45Z  ifo
**   Merged in 1.8.1 branch.
**   Revision 1.19  2001/11/27 16:15:33Z  prh
**   Change power mode setting from bool to uint16.
**   Revision 1.18.1.3  2001/11/28 09:46:33Z  ifo
**   Fixed ordering of elements in PHY header.
**   Revision 1.18.1.2  2001/11/26 11:18:30Z  ifo
**   Modified interrupt masks to match int_gen.h in the drivers directory.
**   - needs merged into Peter's chnages.
**   Revision 1.18.1.1  2001/11/13 16:12:59Z  ifo
**   Duplicate revision
**   Revision 1.18  2001/11/13 16:12:59Z  prh
**   Re-design complete TX and PS tasks and communications.
**   Revision 1.17  2001/10/24 12:55:33Z  prh
**   Modify TSF adjust message parameters, so LM can do the calculations.
**   Revision 1.16  2001/10/12 10:08:29Z  jag1
**   Inter-processor signal interrupts defined.
**   Revision 1.15  2001/08/10 15:05:12Z  prh
**   Remove unwanted padding.
**   Revision 1.14  2001/08/09 10:16:01Z  prh
**   BSS/PS LMI Management messages now belong to sourcing modules.
**   Revision 1.13  2001/08/06 15:58:34Z  ifo
**   Fixed volatiles.
**   Revision 1.12  2001/08/06 14:19:29Z  ifo
**   Reordered to combine struct and typedefs.
**   Added volatile where appropriate.
**   Revision 1.11  2001/07/25 07:17:27Z  ifo
**   Modified Rx header struct to match hardware.
**   Revision 1.10  2001/07/10 10:25:19Z  ifo
**   Removed tabs.
**   Added structure LM_RCVREC as in LMI document.
**   Revision 1.9  2001/07/06 14:21:02Z  prh
**   Make FSDU for probe request (LM_PRESCAN) referenced by a pointer.
**   This is consistent with beacon packet.
**   Revision 1.8  2001/07/06 14:15:12Z  jag1
**   Additional definitions added and TABs removed.
**   Revision 1.7  2001/06/12 15:09:45Z  ifo
**   * Added types (to match coding standards)
**   * Adding missing messge: LM_MR_NEW
**   * Fixed names to match LMI spec.
**   * Fxied 56->54 (mbps)
**   Revision 1.6  2001/05/24 13:47:49Z  ifo
**   Removed enums and converted to simple macros fro C100 use.
**   Revision 1.5  2001/05/23 09:09:11Z  ses
**   More details.
**   Revision 1.4  2001/05/22 16:21:11Z  ses
**   Interim version.
**   Revision 1.3  2001/05/11 12:29:08Z  ifo
**   Added LMI structures for queues.
**   Revision 1.2  2001/04/20 11:07:41Z  prh
**   Add LM_MPDU structure, and modify LM_FSDU structure.
**   Revision 1.1  2001/03/09 16:46:43Z  lde
**   Initial revision
**
** LAST MODIFIED BY:   $Author: jh3 $
**                     $Modtime:$
**
****************************************************************************
*
* Copyright (c) 2001 TTPCom Limited
*
****************************************************************************/

#ifndef LMI_INCLUDED
#define LMI_INCLUDED

#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include "HdkTask.h"
#include "ieee80211.h"
#include "MT_lmi.h"
#include "MT_NSSMemoryPool.h"
#include "mhi_umi_propr.h"
#include "mhi_mac_event.h"
#include "enet_pas.h"
#include "mhi_mib_id.h"
#include "CalibrationsDefines.h"
#include "SharedDbTypes.h"

/***************************************************************************/
/***                       Types and Defines                             ***/
/***************************************************************************/

#define BAND_5_2_GHZ UMI_PHY_TYPE_BAND_5_2_GHZ
#define BAND_2_4_GHZ UMI_PHY_TYPE_BAND_2_4_GHZ


//typedef enum eLM_PHY_RATES
//{                               PHY    Rate   TCR_Rate
#define    LM_PHY_11A_RATE_6        0 // ,  11A/G  0      0x00
#define    LM_PHY_11A_RATE_9        1 // ,  11A/G  1      0x01
#define    LM_PHY_11A_RATE_12       2 // ,  11A/G  2      0x02
#define    LM_PHY_11A_RATE_18       3 // ,  11A/G  3      0x03
#define    LM_PHY_11A_RATE_24       4 // ,  11A/G  4      0x04
#define    LM_PHY_11A_RATE_36       5 // ,  11A/G  5      0x05
#define    LM_PHY_11A_RATE_48       6 // ,  11A/G  6      0x06
#define    LM_PHY_11A_RATE_54       7 // ,  11A/G  7      0x07
                             //    
#define    LM_PHY_11B_RATE_2_SHORT  8 // ,  11B/G  8      0x21
#define    LM_PHY_11B_RATE_5_SHORT  9 // ,  11B/G  9      0x22
#define    LM_PHY_11B_RATE_11_SHORT 10// ,  11B/G  10     0x23
                             //    
#define    LM_PHY_11B_RATE_1        11// ,  11B/G  11     0x24
#define    LM_PHY_11B_RATE_2        12// ,  11B/G  12     0x25
#define    LM_PHY_11B_RATE_5        13// ,  11B/G  13     0x26
#define    LM_PHY_11B_RATE_11       14// ,  11B/G  14     0x27
                             //    
#define    LM_PHY_11N_RATE_6_5      15// ,  11N    15     0x40
#define    LM_PHY_11N_RATE_13       16// ,  11N    16     0x41
#define    LM_PHY_11N_RATE_19_5     17// ,  11N    17     0x42
#define    LM_PHY_11N_RATE_26       18// ,  11N    18     0x43
#define    LM_PHY_11N_RATE_39       19// ,  11N    19     0x44
#define    LM_PHY_11N_RATE_52       20// ,  11N    20     0x45
#define    LM_PHY_11N_RATE_58_5     21// ,  11N    21     0x46
#define    LM_PHY_11N_RATE_65       22// ,  11N    22     0x47
#define    LM_PHY_11N_RATE_13_R2    23// ,  11N    23     0x48
#define    LM_PHY_11N_RATE_26_R2    24// ,  11N    24     0x49
#define    LM_PHY_11N_RATE_39_R2    25// ,  11N    25     0x4A
#define    LM_PHY_11N_RATE_52_R2    26// ,  11N    26     0x4B
#define    LM_PHY_11N_RATE_78_R2    27// ,  11N    27     0x4C
#define    LM_PHY_11N_RATE_104_R2   28// ,  11N    28     0x4D
#define    LM_PHY_11N_RATE_117_R2   29// ,  11N    29     0x4E
#define    LM_PHY_11N_RATE_130_R2   30// ,  11N    30     0x4F
#define    LM_PHY_11N_RATE_6_DUP    31//    11N    31     0x50
#define	   LM_PHY_11N_RATE_130_SCP	31//	64QAM 5/6 SCP

#if 0
/* Maximum bytes per 11N rates (according to 5.4ms).
 * Time limitation should include protection (RTS/CTS + 2*sifs).
 * sizeof(CTS)+sizeof(RTS)+2*sifs = (20 + 14) [bytes, worst case, rate-6Mbps] + 32 uSec = 128 uSec ~ 140 uSec.
 * => Aggregate air time should be limited to: 5.4 - 0.14 = 5.26mSec
 */
#define    LM_PHY_11N_RATE_6_DUP_MAX_BYTES   3945
#define    LM_PHY_11N_RATE_6_5_MAX_BYTES     4273
#define    LM_PHY_11N_RATE_13_MAX_BYTES      8547
#define    LM_PHY_11N_RATE_19_5_MAX_BYTES    12821
#define    LM_PHY_11N_RATE_26_MAX_BYTES      17095
#define    LM_PHY_11N_RATE_39_MAX_BYTES      25642
#define    LM_PHY_11N_RATE_52_MAX_BYTES      34190
#define    LM_PHY_11N_RATE_58_5_MAX_BYTES    38135
#define    LM_PHY_11N_RATE_65_MAX_BYTES      42737

/* Maximum bytes per 11N rates (according to 2.4ms).
 * Time limitation should include protection (RTS/CTS + 2*sifs).
 * sizeof(CTS)+sizeof(RTS)+2*sifs = (20 + 14) [bytes, worst case, rate-6Mbps] + 32 uSec = 128 uSec ~ 140 uSec.
 * => Aggregate air time should be limited to: 2.4 - 0.14 = 2.26mSec
 */
#define    LM_PHY_11N_11H_RATE_6_DUP_MAX_BYTES    1695
#define    LM_PHY_11N_11H_RATE_6_5_MAX_BYTES      1836
#define    LM_PHY_11N_11H_RATE_13_MAX_BYTES       3672
#define    LM_PHY_11N_11H_RATE_19_5_MAX_BYTES     5508
#define    LM_PHY_11N_11H_RATE_26_MAX_BYTES       7345
#define    LM_PHY_11N_11H_RATE_39_MAX_BYTES       11017 
#define    LM_PHY_11N_11H_RATE_52_MAX_BYTES       14690
#define    LM_PHY_11N_11H_RATE_58_5_MAX_BYTES     16526
#define    LM_PHY_11N_11H_RATE_65_MAX_BYTES       18362
#else
#define    LM_PHY_11N_RATE_6_DUP_MAX_BYTES   1695
#define    LM_PHY_11N_RATE_6_5_MAX_BYTES     1695
#define    LM_PHY_11N_RATE_13_MAX_BYTES      1709
#define    LM_PHY_11N_RATE_19_5_MAX_BYTES    2564
#define    LM_PHY_11N_RATE_26_MAX_BYTES      3419
#define    LM_PHY_11N_RATE_39_MAX_BYTES      5128
#define    LM_PHY_11N_RATE_52_MAX_BYTES      6838
#define    LM_PHY_11N_RATE_58_5_MAX_BYTES    7627
#define    LM_PHY_11N_RATE_65_MAX_BYTES      8547

#define    LM_PHY_11N_11H_RATE_6_DUP_MAX_BYTES    1695
#define    LM_PHY_11N_11H_RATE_6_5_MAX_BYTES      1695
#define    LM_PHY_11N_11H_RATE_13_MAX_BYTES       1709
#define    LM_PHY_11N_11H_RATE_19_5_MAX_BYTES     2564
#define    LM_PHY_11N_11H_RATE_26_MAX_BYTES       3419
#define    LM_PHY_11N_11H_RATE_39_MAX_BYTES       5128 
#define    LM_PHY_11N_11H_RATE_52_MAX_BYTES       6838
#define    LM_PHY_11N_11H_RATE_58_5_MAX_BYTES     7627
#define    LM_PHY_11N_11H_RATE_65_MAX_BYTES       8547
#endif
//} eLM_PHY_RATES;

#define LM_PHY_11A_FIRST_RATE           LM_PHY_11A_RATE_6
#define LM_PHY_11A_LAST_RATE            LM_PHY_11A_RATE_54

#define LM_PHY_11B_FIRST_RATE           LM_PHY_11B_RATE_2_SHORT
#define LM_PHY_11B_LAST_RATE            LM_PHY_11B_RATE_11       

#define LM_PHY_11G_FIRST_RATE           LM_PHY_11A_FIRST_RATE
#define LM_PHY_11G_LAST_RATE            LM_PHY_11B_LAST_RATE 

#define LM_PHY_11N_FIRST_RATE           LM_PHY_11N_RATE_6_5
#define LM_PHY_11N_LAST_RATE            LM_PHY_11N_RATE_6_DUP

#define LM_PHY_11A_MAX_RATES            8
#define LM_PHY_11B_SHORT_RATES          3
#define LM_PHY_11B_LONG_RATES           4
#define LM_PHY_11B_MAX_RATES            (LM_PHY_11B_SHORT_RATES+LM_PHY_11B_LONG_RATES)
#define LM_PHY_11N_R1_MAX_RATES			8
#define LM_PHY_11N_R2_MAX_RATES			8
#define LM_PHY_11N_MAX_RATES            ( LM_PHY_11N_R1_MAX_RATES + LM_PHY_11N_R2_MAX_RATES ) + 1 //add 1 for LM_PHY_11N_RATE_6_DUP rate
#define LM_PHY_11G_MAX_RATES            (LM_PHY_11A_MAX_RATES+LM_PHY_11B_MAX_RATES)

#define PROTOCOL_11_AC_NUM_OF_MCS        10

#define LM_PHY_MAX_RATES                (LM_PHY_11A_MAX_RATES+LM_PHY_11B_MAX_RATES+LM_PHY_11N_MAX_RATES)
#define LM_PHY_DUR_RATES                (2*LM_PHY_MAX_RATES) // CB duplicates the number of rates
#define LM_PHY_LOOKUP_TABLE_SIZE		16

#define NUM_RATES_NCB           (LM_PHY_MAX_RATES-1) // exclude 11n rate 32 (CB/DUP)
#define NUM_RATES_CB            LM_PHY_MAX_RATES
#define NUM_RATES_TOTAL         (NUM_RATES_NCB+NUM_RATES_CB)                    // total number of rates

#define LM_PHY_11A_RATE_MSK             0x000000FF
#define LM_PHY_11B_RATE_MSK             0x00007F00
#define LM_PHY_11B_SHORT_RATE_MSK       0x00000700
#define LM_PHY_11B_LONG_RATE_MSK        (LM_PHY_11B_RATE_MSK & (~LM_PHY_11B_SHORT_RATE_MSK))
#define LM_PHY_11N_RATE_MSK             0xFFFF8000
#define LM_PHY_11N_MIMO_RATE_MSK        0x7F800000
#define LM_PHY_11N_NO_MIMO_RATE_MSK     0x007F8000
#define LM_PHY_11G_RATE_MSK             (LM_PHY_11A_RATE_MSK|LM_PHY_11B_RATE_MSK)

#define LM_PHY_11B_PREAMBLE_MSK         0x04
#define LM_PHY_11B_SHORT_PREAMBLE       0x00
#define LM_PHY_11B_LONG_PREAMBLE        LM_PHY_11B_PREAMBLE_MSK

#define LM_PHY_11AX_LOW_NSS_RATE_MSK	(0x06000000)	//bits 25,26,37,38,49,50,61,62
#define LM_PHY_11AX_HIGH_NSS_RATE_MSK	(0x60060060)

#define LM_PHY_11A_RATE_6_MSK           (1 << LM_PHY_11A_RATE_6       )
#define LM_PHY_11A_RATE_9_MSK           (1 << LM_PHY_11A_RATE_9       )
#define LM_PHY_11A_RATE_12_MSK          (1 << LM_PHY_11A_RATE_12      )
#define LM_PHY_11A_RATE_18_MSK          (1 << LM_PHY_11A_RATE_18      )
#define LM_PHY_11A_RATE_24_MSK          (1 << LM_PHY_11A_RATE_24      )
#define LM_PHY_11A_RATE_36_MSK          (1 << LM_PHY_11A_RATE_36      )
#define LM_PHY_11A_RATE_48_MSK          (1 << LM_PHY_11A_RATE_48      )
#define LM_PHY_11A_RATE_54_MSK          (1 << LM_PHY_11A_RATE_54      )

#define LM_PHY_11B_RATE_2_SHORT_MSK     (1 << LM_PHY_11B_RATE_2_SHORT )
#define LM_PHY_11B_RATE_5_SHORT_MSK     (1 << LM_PHY_11B_RATE_5_SHORT )
#define LM_PHY_11B_RATE_11_SHORT_MSK    (1 << LM_PHY_11B_RATE_11_SHORT)

#define LM_PHY_11B_RATE_1_MSK           (1 << LM_PHY_11B_RATE_1       )
#define LM_PHY_11B_RATE_2_MSK           (1 << LM_PHY_11B_RATE_2       )
#define LM_PHY_11B_RATE_5_MSK           (1 << LM_PHY_11B_RATE_5       )
#define LM_PHY_11B_RATE_11_MSK          (1 << LM_PHY_11B_RATE_11      )

#define LM_PHY_11N_RATE_6_5_MSK         (1 << LM_PHY_11N_RATE_6_5     )
#define LM_PHY_11N_RATE_13_MSK          (1 << LM_PHY_11N_RATE_13      )
#define LM_PHY_11N_RATE_19_5_MSK        (1 << LM_PHY_11N_RATE_19_5    )
#define LM_PHY_11N_RATE_26_MSK          (1 << LM_PHY_11N_RATE_26      )
#define LM_PHY_11N_RATE_39_MSK          (1 << LM_PHY_11N_RATE_39      )
#define LM_PHY_11N_RATE_52_MSK          (1 << LM_PHY_11N_RATE_52      )
#define LM_PHY_11N_RATE_58_5_MSK        (1 << LM_PHY_11N_RATE_58_5    )
#define LM_PHY_11N_RATE_65_MSK          (1 << LM_PHY_11N_RATE_65      )
#define LM_PHY_11N_RATE_13_R2_MSK       (1 << LM_PHY_11N_RATE_13_R2   )
#define LM_PHY_11N_RATE_26_R2_MSK       (1 << LM_PHY_11N_RATE_26_R2   )
#define LM_PHY_11N_RATE_39_R2_MSK       (1 << LM_PHY_11N_RATE_39_R2   )
#define LM_PHY_11N_RATE_52_R2_MSK       (1 << LM_PHY_11N_RATE_52_R2   )
#define LM_PHY_11N_RATE_78_R2_MSK       (1 << LM_PHY_11N_RATE_78_R2   )
#define LM_PHY_11N_RATE_104_R2_MSK      (1 << LM_PHY_11N_RATE_104_R2  )
#define LM_PHY_11N_RATE_117_R2_MSK      (1 << LM_PHY_11N_RATE_117_R2  )
#define LM_PHY_11N_RATE_130_R2_MSK      (1 << LM_PHY_11N_RATE_130_R2  )
#define LM_PHY_11N_RATE_6_DUP_MSK       (1 << LM_PHY_11N_RATE_6_DUP   )
#define LM_PHY_11N_RATE_130_SCP_MSK		(1 << LM_PHY_11N_RATE_130_SCP )

#define	LM_PHY_11A_BPSK_MSK				( LM_PHY_11A_RATE_6_MSK  | LM_PHY_11A_RATE_9_MSK  )
#define	LM_PHY_11A_QPSK_MSK				( LM_PHY_11A_RATE_12_MSK | LM_PHY_11A_RATE_18_MSK )
#define	LM_PHY_11A_QAM16_MSK			( LM_PHY_11A_RATE_24_MSK | LM_PHY_11A_RATE_36_MSK )
#define	LM_PHY_11A_QAM64_MSK			( LM_PHY_11A_RATE_48_MSK | LM_PHY_11A_RATE_54_MSK )

#define	LM_PHY_11N_BPSK_R1_MSK			( LM_PHY_11N_RATE_6_5_MSK )
#define	LM_PHY_11N_QPSK_R1_MSK			( LM_PHY_11N_RATE_13_MSK | LM_PHY_11N_RATE_19_5_MSK )
#define	LM_PHY_11N_QAM16_R1_MSK			( LM_PHY_11N_RATE_26_MSK | LM_PHY_11N_RATE_39_MSK   )
#define	LM_PHY_11N_QAM64_R1_MSK			( LM_PHY_11N_RATE_52_MSK | LM_PHY_11N_RATE_58_5_MSK | LM_PHY_11N_RATE_65_MSK )

#define	LM_PHY_11N_BPSK_R2_MSK			( LM_PHY_11N_RATE_13_R2_MSK )
#define	LM_PHY_11N_QPSK_R2_MSK			( LM_PHY_11N_RATE_26_R2_MSK  | LM_PHY_11N_RATE_39_R2_MSK )
#define	LM_PHY_11N_QAM16_R2_MSK			( LM_PHY_11N_RATE_52_R2_MSK  | LM_PHY_11N_RATE_78_R2_MSK )
#define	LM_PHY_11N_QAM64_R2_MSK			( LM_PHY_11N_RATE_104_R2_MSK | LM_PHY_11N_RATE_117_R2_MSK | LM_PHY_11N_RATE_130_R2_MSK )

#define	LM_PHY_11N_BPSK_MSK				( LM_PHY_11N_BPSK_R1_MSK  | LM_PHY_11N_BPSK_R2_MSK  )
#define	LM_PHY_11N_QPSK_MSK				( LM_PHY_11N_QPSK_R1_MSK  | LM_PHY_11N_QPSK_R2_MSK  )
#define	LM_PHY_11N_QAM16_MSK			( LM_PHY_11N_QAM16_R1_MSK | LM_PHY_11N_QAM16_R2_MSK )
#define	LM_PHY_11N_QAM64_MSK			( LM_PHY_11N_QAM64_R1_MSK | LM_PHY_11N_QAM64_R2_MSK )

#define LM_PHY_11N_R1_MSK				( LM_PHY_11N_BPSK_R1_MSK | LM_PHY_11N_QPSK_R1_MSK | LM_PHY_11N_QAM16_R1_MSK | LM_PHY_11N_QAM64_R1_MSK )
#define LM_PHY_11N_R2_MSK				( LM_PHY_11N_BPSK_R2_MSK | LM_PHY_11N_QPSK_R2_MSK | LM_PHY_11N_QAM16_R2_MSK | LM_PHY_11N_QAM64_R2_MSK )

#define LM_PHY_11N_R1_MAX_RATES			8
#define LM_PHY_11N_R2_MAX_RATES			8

#define LM_PHY_11A_RA_RATE_MSK			( LM_PHY_11A_RATE_MSK ) /* mask for 11A RA */
#define LM_PHY_11B_LONG_RA_RATE_MSK		(LM_PHY_11B_LONG_RATE_MSK)
#define LM_PHY_11B_SHORT_RA_RATE_MSK	(LM_PHY_11B_SHORT_RATE_MSK)
#define LM_PHY_11G_LONG_RA_RATE_MSK		( LM_PHY_11A_RATE_MSK | LM_PHY_11B_LONG_RA_RATE_MSK  & ~( LM_PHY_11B_RATE_5_MSK | LM_PHY_11B_RATE_11_MSK ) ) /* mask for 11G RA (with 11B long preamble supported only) */
#define LM_PHY_11G_SHORT_RA_RATE_MSK	( LM_PHY_11A_RATE_MSK | LM_PHY_11B_SHORT_RA_RATE_MSK & ~( LM_PHY_11B_RATE_5_SHORT_MSK | LM_PHY_11B_RATE_11_SHORT_MSK ) ) /* mask for 11G RA (with 11B short preamble supported) */

#define LM_PHY_11N_RA_RATE_MSK			( LM_PHY_11N_RATE_MSK ) /* mask for 11N RA */

#define RATE_SHIFT_FROM_SHORT_TO_LONG	4

#define MIB_MANDATORY_RATES_A (LM_PHY_11A_RATE_6_MSK \
                        | LM_PHY_11A_RATE_12_MSK     \
                        | LM_PHY_11A_RATE_24_MSK)

// 11B Mandatory 1
#define MIB_BASIC_RATE_SET_1_B (LM_PHY_11B_RATE_1_MSK \
                        | LM_PHY_11B_RATE_2_MSK )

// 11B Mandatory 2
#define MIB_BASIC_RATE_SET_2_B (LM_PHY_11B_RATE_1_MSK \
                        | LM_PHY_11B_RATE_2_MSK \
                        | LM_PHY_11B_RATE_5_MSK \
                        | LM_PHY_11B_RATE_11_MSK)

// WiFi requires #1 to be the OOB set (out of the box)
#define MIB_BASIC_RATE_SET_1_G (MIB_BASIC_RATE_SET_2_B)
#define MIB_BASIC_RATE_SET_2_G (MIB_MANDATORY_RATES_A | MIB_BASIC_RATE_SET_2_B)

// ------------------------------ FSDU Rate ----------------------------------

// u8TxRate bit fields
#define LM_MCS_RATE_SFT           0
#define LM_MCS_RATE_MASK          0x1f // 5 bits MCS[0:3,5]
#define LM_11B_RATE_SFT           5
#define LM_11B_RATE_MASK          (1 << LM_11B_RATE_SFT) // 1 bit
#define LM_11N_RATE_SFT           6
#define LM_11N_RATE_MASK          (1 << LM_11N_RATE_SFT) // 1 bit
#define LM_PHY_TYPE_RATE_SFT      LM_11B_RATE_SFT
#define LM_PHY_TYPE_RATE_MASK     (LM_11B_RATE_MASK | LM_11N_RATE_MASK) // 2 bits 11N|11B

// u8ExtendedRate bit fields are set in the same order used by the TCRs
#define LM_11B_MAC_ANT_SEL_SFT    7
#define LM_11B_MAC_ANT_SEL_MASK   (1<<LM_11B_MAC_ANT_SEL_SFT)
#define LM_11B_ANT_SEL_SFT        6
#define LM_11B_ANT_SEL_MASK       (3 << LM_11B_ANT_SEL_SFT)
#define LM_SOUNDING_SFT           5
#define LM_SOUNDING_MASK          (1 << LM_SOUNDING_SFT)
#define LM_CB_RATE_SFT            4
#define LM_CB_RATE_MASK           (1 << LM_CB_RATE_SFT)
#define LM_LDPC_RATE_SFT          3
#define LM_LDPC_RATE_MASK         (1 << LM_LDPC_RATE_SFT)
#define LM_STBC_RATE_SFT          1
#define LM_STBC_RATE_MASK         (3 << LM_STBC_RATE_SFT)
#define LM_SCP_RATE_SFT           0
#define LM_SCP_RATE_MASK          (1 << LM_SCP_RATE_SFT)

/* Long or Short slot mode */

#define LM_LONG_SLOT_11G    0
#define LM_SHORT_SLOT_11G   1

/* the size of array for holding information for general porpuse 	*/
/* uint32 MT_SHARED_RAM_words[] 									*/

/* MASK FOR DELIMITER LENGTH */
#define DELIM_MASK_LENGTH           0xFFF


typedef enum
{
    ZERO_DELIMITER = 0,
    ZERO_WORD,
    MAX_WORDS_SIZE
} GENERAL_PURPOSE_WORDS_E;

#if !defined (ENET_INC_ARCH_WAVE600)
typedef enum _PHYMode_e
{
	PHY_MODE_11AG = 0,
	PHY_MODE_11B ,
	PHY_MODE_11N ,
	PHY_MODE_11AC ,
    PHY_MODE_LAST
} PhyMode_e;
#endif
/*****************************************************************************
* Interface structure
*/



#define LM_MANAGEMENT_QUEUE_LENGTH    11 

/* separate typedefs in order to forward reference */

typedef struct LM_VECTOR_BLOCK     LM_VECTOR_BLOCK;

typedef uint32 LM_SIGNATURE;

/* request/confirm indicate/respond */
/*** Root Vector Block ***/
struct LM_VECTOR_BLOCK
{
    LM_SIGNATURE    u32Signature;               /* LM signature */
#if defined (ENET_INC_ARCH_WAVE600)
	LM_SIGNATURE	u32Lm1Signature;			/* LM1 signature */
	int32			dummy[3]; 					//donot remove it, need sync with driver
#else
	int32			dummy[4];					//donot remove it, need sync with driver
#endif	
};


/* Management Message Queues */
typedef struct QPB
{
    void * volatile pvHead;
    void * volatile pvTail;
    uint16 numElements;
    uint16 maxPayload;
} QPB;

/* Management queue storage */
typedef struct LM_MAN_QUEUE
{
    QPB    sQPB;
	uint32 write_cnt;
	uint32 read_cnt;
    void * pvEntry[LM_MANAGEMENT_QUEUE_LENGTH];
} LM_MAN_QUEUE;


#define LM_VB_SIGNATURE  0xAAAA5555
#define UM_VB_SIGNATURE  0xBBBB6666

/* instance */
volatile extern LM_VECTOR_BLOCK sLMvectorBlock;

#define UBYTE_MASK_VALUE                        0xFF
#define USHORT_MASK_VALUE                       0xFFFF
#define UWORD_MASK_VALUE                        0xFFFFFFFF

#define ARRAY_SIZE(a)       (sizeof(a) / sizeof(a[0]))

#define STRUCT_OFFSET(s, e) ((uint32)(&(((struct s *)0)->e)))

#define LM_CFG_PHY_TYPE_802_11A          UMI_PHY_TYPE_802_11A    /* 802.11a  */
#define LM_CFG_PHY_TYPE_802_11B          UMI_PHY_TYPE_802_11B    /* 802.11b  */
#define LM_CFG_PHY_TYPE_802_11G          UMI_PHY_TYPE_802_11G    /* 802.11g  */
#define LM_CFG_PHY_TYPE_802_11B_L        UMI_PHY_TYPE_802_11B_L    /* 802.11b with long preamble (used by the TUM only) */
#define LM_CFG_PHY_TYPE_802_11N_5_2_BAND UMI_PHY_TYPE_802_11N_5_2_BAND
#define LM_CFG_PHY_TYPE_802_11N_2_4_BAND UMI_PHY_TYPE_802_11N_2_4_BAND
#ifdef ENET_INC_ARCH_WAVE600
#define MAX_TPC_POWER_LEVELS	64 //For now we use Gen5 TPC range for Link adaptaion (MAX_TPC_POWER_LEVELS), need to align it to GEN6 range (96 values, -12->84)
#else
#define MAX_TPC_POWER_LEVELS	64
#endif
	
typedef struct LA_SET_TPC_DATA
{
#ifdef ENET_INC_ARCH_WAVE600
	uint8  regulationLimit[4]; // TBD  -use MAX_NUM_OF_BW when TPC will support BW 160
	uint8 regulationLimitMU[4];
	uint8 regulationLimitBF[4];
#else
	uint8  regulationLimit[3];
	uint8 regulationLimitMU[3];
	uint8 regulationLimitBF[3];
#endif

	uint8* internalPowerUpperLimit;
	
	uint8* internalPowerLowerLimit;

	uint8 tpcpPwerVectorStep;
	uint8 txPower11B;	
	uint8 indexOffset		: 1;
	uint8 tpcPowerVectorLen : 7;
	uint8 ant0PowerBoost	: 2;
	uint8 ant1PowerBoost	: 2;
	uint8 ant2PowerBoost	: 2;
	uint8 ant3PowerBoost	: 2;
} LA_SET_TPC_DATA_t;


typedef struct LA_SET_CHANNEL_DATA
{
	LA_SET_TPC_DATA_t tpcInfo;
	uint8 antennaConnectedMask;
	uint8 frequency_index;
	uint8 band				: 1;
    uint8 wlanBandwidthMax  : 3;
	uint8 reserved			: 4;
	
} LA_SET_CHANNEL_DATA_t;

#if defined(CALCULATE_CPU_IDLE_TIME)
typedef struct LM_CPU_IDLE_IND
{
   uint32 totalSleepTime;
   uint32 countTicks;
   uint32 TSFLow;
}LM_CPU_IDLE_IND;
#endif

typedef struct LmBeaconCsaInd_s
{
	uint8 vapId;
} LmBeaconCsaInd_t;

typedef struct lmGenericMsgType_tag
{	
    uint32 data1;
    uint32 data2;
    uint32 data3;
}lmGenericMsgType_t;


typedef struct LmFreqJumpMode
{
	uint8 freqJumpMode;
} LmFreqJumpMode_t;

void vInitMsgQ(struct LM_MAN_QUEUE * psLM_MAN_QUEUE);
void vPutMsgQ(void * pvMsgHandle, struct LM_MAN_QUEUE * psLM_MAN_QUEUE);
void * pvGetMsgQ(struct LM_MAN_QUEUE * psLM_MAN_QUEUE);

#endif /* LMI_INCLUDED */
