/* CMSynergyVer %full_filespec: protocol.h;2.7.3.1.1.1:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      Lower MAC
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_lower/protocol.h $
 **
 ** VERSION:        $Revision: #1 $
 **
 ** DATED:          $Date: 2003/10/27 $
 **
 ** AUTHOR:         John Gladman
 **
 ** DESCRIPTION:    Register definitions for Enet IC.
 **
 ** LAST MODIFIED BY:   $Author: njk $
 **                     $Modtime$
 **
 ****************************************************************************
 *
 *  (c) Copyright 2001, TTPCom
 *
 ****************************************************************************/

#ifndef PROTOCOL_INCLUDED
#define PROTOCOL_INCLUDED


#include "shram.h"
/****************************/
/* 802.11 frame definitions */
/****************************/

/* Frame Control field within header */

#define FRM_CTRL_VER_MSK    0x03
#define FRM_CTRL_VER_SFT    0
#define FRM_CTRL_VER_0      (0x00 << FRM_CTRL_VER_SFT)

#define FRM_CTRL_TYPE_MSK   0x0C
#define FRM_CTRL_TYPE_SFT   2
#define FRM_CTRL_TYPE_MGMT  (0x00 << FRM_CTRL_TYPE_SFT)
#define FRM_CTRL_TYPE_CTRL  (0x01 << FRM_CTRL_TYPE_SFT)
#define FRM_CTRL_TYPE_DATA  (0x02 << FRM_CTRL_TYPE_SFT)

#define FRM_CTRL_SUBTYPE_MSK    0xF0
#define FRM_CTRL_SUBTYPE_SFT    4

#define FRM_CTRL_SUBTYPE_ASSOCIATION_REQ    (0x00 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_ASSOCIATION_RES    (0x01 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_REASSOCIATION_REQ  (0x02 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_REASSOCIATION_RES  (0x03 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_PROBE_REQ          (0x04 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_PROBE_RES          (0x05 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_BEACON             (0x08 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_ATIM               (0x09 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_DISASSOCIATION     (0x0A << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_AUTHENTICATION     (0x0B << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_DEAUTHENTICATION   (0x0C << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_ACTION             (0x0D << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_ACTION_NO_ACK      (0x0E << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_BAR				(0x08 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_PSPOLL             (0x0A << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_RTS                (0x0B << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_CTS                (0x0C << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_ACK                (0x0D << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_CFEND              (0x0E << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_CFEND_ACK          (0x0F << FRM_CTRL_SUBTYPE_SFT)

#define FRM_CTRL_SUBTYPE_DATA               (0x00 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_DATA_CFACK         (0x01 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_DATA_CFPOLL        (0x02 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_DATA_CFACK_CFPOLL  (0x03 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_NULL               (0x04 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_CFACK              (0x05 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_CFPOLL             (0x06 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_CFACK_CFPOLL       (0x07 << FRM_CTRL_SUBTYPE_SFT)

/* QoS frame sub-type definitions */

#define FRM_CTRL_QOS_CFACK_BIT_MSK              (0x01 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_QOS_CFPOLL_BIT_MSK             (0x02 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_QOS_NDATA_MSK                  (0x04 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_QOS_BIT_MSK                    (0x08 << FRM_CTRL_SUBTYPE_SFT)

#define FRM_CTRL_SUBTYPE_QOS_DATA               (0x08 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_QOS_DATA_CFACK         (0x09 << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_QOS_DATA_CFPOLL        (0x0A << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_QOS_DATA_CFACK_CFPOLL  (0x0B << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_QOS_NULL               (0x0C << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_QOS_CFACK              (0x0D << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_QOS_CFPOLL             (0x0E << FRM_CTRL_SUBTYPE_SFT)
#define FRM_CTRL_SUBTYPE_QOS_CFACK_CFPOLL       (0x0F << FRM_CTRL_SUBTYPE_SFT)

#define FRM_CTRL_DATA_BIT_MSK               (FRM_CTRL_SUBTYPE_NULL)
#define FRM_CTRL_CFACK_BIT_MSK              (FRM_CTRL_SUBTYPE_DATA_CFACK)
#define FRM_CTRL_CFPOLL_BIT_MSK             (FRM_CTRL_SUBTYPE_DATA_CFPOLL)

#define FRM_CTRL_TO_DS_MSK                  0x0100
#define FRM_CTRL_FROM_DS_MSK                0x0200
#define FRM_CTRL_MORE_FRAG_MSK              0x0400
#define FRM_CTRL_RETRY_MSK                  0x0800
#define FRM_CTRL_PWR_MGT_MSK                0x1000
#define FRM_CTRL_MORE_DATA_MSK              0x2000
#define FRM_CTRL_WEP_MSK                    0x4000
#define FRM_CTRL_ORDER_MSK                  0x8000

/* Combine type and subtype for convenience */

#define FRM_CTRL_ASSOCIATION_REQ    (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_ASSOCIATION_REQ)
#define FRM_CTRL_ASSOCIATION_RES    (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_ASSOCIATION_RES)
#define FRM_CTRL_REASSOCIATION_REQ  (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_REASSOCIATION_REQ)
#define FRM_CTRL_REASSOCIATION_RES  (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_REASSOCIATION_RES)
#define FRM_CTRL_PROBE_REQ          (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_PROBE_REQ)
#define FRM_CTRL_PROBE_RES          (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_PROBE_RES)
#define FRM_CTRL_BEACON             (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_BEACON)
#define FRM_CTRL_ATIM               (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_ATIM)
#define FRM_CTRL_DISASSOCIATION     (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_DISASSOCIATION)
#define FRM_CTRL_AUTHENTICATION     (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_AUTHENTICATION)
#define FRM_CTRL_DEAUTHENTICATION   (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_DEAUTHENTICATION)
#define FRM_CTRL_ACTION             (FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_ACTION)
#define FRM_CTRL_BAR                (FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_BAR)
#define FRM_CTRL_PSPOLL             (FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_PSPOLL)
#define FRM_CTRL_RTS                (FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_RTS)
#define FRM_CTRL_CTS                (FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_CTS)
#define FRM_CTRL_ACK                (FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_ACK)
#define FRM_CTRL_CFEND              (FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_CFEND)
#define FRM_CTRL_CFEND_ACK          (FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_CFEND_ACK)

#define FRM_CTRL_DATA               (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_DATA)
#define FRM_CTRL_DATA_CFACK         (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_DATA_CFACK)
#define FRM_CTRL_DATA_CFPOLL        (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_DATA_CFPOLL)
#define FRM_CTRL_DATA_CFACK_CFPOLL  (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_DATA_CFACK_CFPOLL)
#define FRM_CTRL_NULL               (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_NULL)
#define FRM_CTRL_CFACK              (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_CFACK)
#define FRM_CTRL_CFPOLL             (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_CFPOLL)
#define FRM_CTRL_CFACK_CFPOLL       (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_CFACK_CFPOLL)

#define FRM_CTRL_QOS_DATA               (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_QOS_DATA)
#define FRM_CTRL_QOS_DATA_CFACK         (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_QOS_DATA_CFACK)
#define FRM_CTRL_QOS_DATA_CFPOLL        (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_QOS_DATA_CFPOLL)
#define FRM_CTRL_QOS_DATA_CFACK_CFPOLL  (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_QOS_DATA_CFACK_CFPOLL)
#define FRM_CTRL_QOS_NULL               (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_QOS_NULL)
#define FRM_CTRL_QOS_CFACK              (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_QOS_CFACK)
#define FRM_CTRL_QOS_CFPOLL             (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_QOS_CFPOLL)
#define FRM_CTRL_QOS_CFACK_CFPOLL       (FRM_CTRL_TYPE_DATA | FRM_CTRL_SUBTYPE_QOS_CFACK_CFPOLL)

/* Address1, 2, etc. */

#define ADDR_MULTICAST_BIT_MSK      0x01

/* Sequence Control field within header */

#define SEQ_CTRL_FRAG_SFT   0
#define SEQ_CTRL_FRAG_MSK   0x000F
#define SEQ_CTRL_FRAG_LSB   (0x1U << SEQ_CTRL_FRAG_SFT)

#define SEQ_CTRL_SEQ_SFT    4
#define SEQ_CTRL_SEQ_MSK    0xFFF0
#define SEQ_CTRL_SEQ_LSB    (0x1U << SEQ_CTRL_SEQ_SFT)

/* QoS control field */

#define QOS_CTRL_8021D_TAG_SFT          0
#define QOS_CTRL_8021D_TAG_MSK          (0x7U << QOS_CTRL_8021D_TAG_SFT)

#define QOS_CTRL_ACK_POLICY_SFT         5
#define QOS_CTRL_ACK_POLICY_MSK         (0x3U << QOS_CTRL_ACK_POLICY_SFT)

#define QOS_CTRL_ACK_POLICY_NRM_ACK     (0x0U << QOS_CTRL_ACK_POLICY_SFT)
#define QOS_CTRL_ACK_POLICY_RESERVED    (0x2U << QOS_CTRL_ACK_POLICY_SFT)
#define QOS_CTRL_ACK_POLICY_NO_ACK      (0x1U << QOS_CTRL_ACK_POLICY_SFT)
#define QOS_CTRL_ACK_POLICY_GROUP_ACK   (0x3U << QOS_CTRL_ACK_POLICY_SFT)

/* duration/ID field */


/******************************/
/* Frame field size constants */
/******************************/

#define SIZEOF_FRM_CRC          4

#define SIZEOF_TSF              8

#define SIZEOF_BAR_PAYLOAD		4

#define FRAME_CONTROL_LEN		2

#define DUR_FIELD_LEN			2

#define MAC_ADDRESS_LEN         6

#define IE_ID_AND_LENGTH_LEN	2

/******************************/
/*  Frames specific constants */
/******************************/
#define BA_FRAME_BA_CTRL_SIZE		 2
#define BA_FRAME_BA_SSN_SIZE		 2
#define BA_FRAME_BA_BITMAP_SIZE		 8
#define BA_INFORMATION_SIZE          (BA_FRAME_BA_SSN_SIZE + BA_FRAME_BA_BITMAP_SIZE)
#define BA_FRAME_ONLY_DATA_SIZE      (BA_FRAME_BA_CTRL_SIZE + BA_INFORMATION_SIZE)

#define ACK_CONTROL_FIELD 			 (FRM_CTRL_VER_0 | FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_ACK)
#define BA_CONTROL_FIELD             (FRM_CTRL_VER_0 | FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_QOS_DATA_CFACK)
#define CTS_AUTO_RESPONSE_CONTROL_FIELD (FRM_CTRL_VER_0 | FRM_CTRL_TYPE_CTRL | FRM_CTRL_SUBTYPE_CTS)
//#define BF_REPORT_CONTROL_FIELD      (FRM_CTRL_VER_0 | FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_ACTION_NO_ACK | FRM_CTRL_ORDER_MSK)
#define BF_REPORT_CONTROL_FIELD      (FRM_CTRL_VER_0 | FRM_CTRL_TYPE_MGMT | FRM_CTRL_SUBTYPE_ACTION_NO_ACK)


#define ACTION_CATEGORY_AND_FIELD_SIZE   2
#define LOWER_TSF_SIZE                   4
#define SEQUENCE_NUMBER_SIZE             2


/*************************/
/* Size of frame headers */
/*************************/

#define SIZEOF_MGMT_HDR         24
#define SIZEOF_PSPOLL_HDR       16
#define SIZEOF_RTS_HDR          16
#define SIZEOF_CTS_HDR          10
#define SIZEOF_ACK_HDR          10
#define SIZEOF_BLOCK_ACK_HDR    16 /* blockack header till blockack control field */
#define SIZEOF_BAR_HDR			16
#define SIZEOF_CFEND_HDR        16
#define SIZEOF_CFEND_ACK_HDR    16
#define SIZEOF_NRM_DATA_HDR     24
#define SIZEOF_LNG_DATA_HDR     30

/*************************************************/
/* Size of BlockAck Data headers section 7.2.1.8 */
/*************************************************/
#define SIZEOF_BLOCK_ACK_CONTROL 2
#define SIZEOF_BLOCK_ACK_SSN     2
#define SIZEOF_BLOCK_ACK_BITMAP  8
/* Link Adaptaion */
#define SIZEOF_LA_HT_HDR         4 /* Sizeof link adaptation HT Header */

#define SIZEOF_FCS_HDR           4 /* size of the FCS (crc) field*/

#define SIZEOF_QOS_NRM_DATA_HDR 26
#define SIZEOF_QOS_LNG_DATA_HDR 32


#define SIZEOF_PSPOLL_FRM       (SIZEOF_PSPOLL_HDR    + SIZEOF_FRM_CRC)
#define SIZEOF_RTS_FRM          (SIZEOF_RTS_HDR       + SIZEOF_FRM_CRC)
#define SIZEOF_CTS_FRM          (SIZEOF_CTS_HDR       + SIZEOF_FRM_CRC)
#define SIZEOF_ACK_FRM          (SIZEOF_ACK_HDR       + SIZEOF_FRM_CRC)
#define SIZEOF_BLOCK_ACK_FRM    (SIZEOF_BLOCK_ACK_HDR + \
                                SIZEOF_BLOCK_ACK_CONTROL + \
                                SIZEOF_BLOCK_ACK_SSN + \
                                SIZEOF_BLOCK_ACK_BITMAP + SIZEOF_FRM_CRC)
#define SIZEOF_NDP_FRM          (SIZEOF_NRM_DATA_HDR + SIZEOF_FRM_CRC)                       
#define SIZEOF_CFEND_FRM        (SIZEOF_CFEND_HDR     + SIZEOF_FRM_CRC)
#define SIZEOF_CFEND_ACK_FRM    (SIZEOF_CFEND_ACK_HDR + SIZEOF_FRM_CRC)
#define SIZEOF_LA_HT_ACK_FRM    (SIZEOF_ACK_HDR + SIZEOF_LA_HT_HDR + SIZEOF_FRM_CRC) /* Link adaptation Ack */
#define SIZEOF_LA_HT_BA_FRM     (SIZEOF_BLOCK_ACK_HDR + \
                                SIZEOF_LA_HT_HDR + \
                                SIZEOF_BLOCK_ACK_CONTROL + \
                                SIZEOF_BLOCK_ACK_SSN + \
                                SIZEOF_BLOCK_ACK_BITMAP + SIZEOF_FRM_CRC) /* Link adaptation Ack */


/*************************/
/* 802.11a PHY constants */
/*************************/


/*******************/
/* Class Frame */
/*******************/
#define FRAME_CLASS_1       1
#define FRAME_CLASS_2       2
#define FRAME_CLASS_3       3
#define FRAME_CLASS_INVALID 0xFF

/*******************/
/* Subtypes */
/*******************/
#define BAR_SUBTYPE 			0x8
#define BA_SUBTYPE   			0x9
#define ACK_SUBTYPE 			0xD


#define NDPA_SUBTYPE			0x5
#define TRIGGER_FRAME_SUBTYPE 	0x2


#endif /* PROTOCOL_INCLUDED */

