/* CMSynergyVer %full_filespec: MT_MAC_PAC_regs.h;3:incl:2 % */
/*******************************************************************
*                                                                  
*  MAC_PAC.h
*   Chip Name: 'Hyperion'                                  
*   Do not modify this file directly                               
*   To update the file, modify registers excel file                          
*   and run the macro 'Create H Files for MIPS SW'           
*   Written by: Avri Golan                                         
*                                                                  
*******************************************************************/

/* Production Date: 13/04/05  */

#ifndef MAC_PAC_regs_H_FILE
#define MAC_PAC_regs_H_FILE

/* TSF_HW_EVENT0_ENABLE */
/* TSF HW event 0 response enable */
#define REG_TSF_HW_EVENT0_ENABLE          0x0500
#define REG_TSF_HW_EVENT0_ENABLE_MASK     0x00000001
#define REG_TSF_HW_EVENT0_ENABLE_SHIFT    0
#define REG_TSF_HW_EVENT0_ENABLE_WIDTH    1

/* TSF_HW_EVENT1_ENABLE */
/* TSF HW event 1 response enable */
#define REG_TSF_HW_EVENT1_ENABLE          0x0500
#define REG_TSF_HW_EVENT1_ENABLE_MASK     0x00000002
#define REG_TSF_HW_EVENT1_ENABLE_SHIFT    1
#define REG_TSF_HW_EVENT1_ENABLE_WIDTH    1

/* UNUSED1 */
#define REG_UNUSED1          0x0500
#define REG_UNUSED1_MASK     0x0000fffc
#define REG_UNUSED1_SHIFT    2
#define REG_UNUSED1_WIDTH    14

/* SW_TX_REQ0_SET */
/* SW Tx request 0 enable */
#define REG_SW_TX_REQ0_SET          0x0500
#define REG_SW_TX_REQ0_SET_MASK     0x00010000
#define REG_SW_TX_REQ0_SET_SHIFT    16
#define REG_SW_TX_REQ0_SET_WIDTH    1

/* SW_TX_REQ1_SET */
/* SW Tx request 1 enable */
#define REG_SW_TX_REQ1_SET          0x0500
#define REG_SW_TX_REQ1_SET_MASK     0x00020000
#define REG_SW_TX_REQ1_SET_SHIFT    17
#define REG_SW_TX_REQ1_SET_WIDTH    1

/* UNUSED2 */
#define REG_UNUSED2          0x0500
#define REG_UNUSED2_MASK     0x000c0000
#define REG_UNUSED2_SHIFT    18
#define REG_UNUSED2_WIDTH    2

/* SW_TX_REQ0_RESET */
/* SW Tx request 0 enable */
#define REG_SW_TX_REQ0_RESET          0x0500
#define REG_SW_TX_REQ0_RESET_MASK     0x00100000
#define REG_SW_TX_REQ0_RESET_SHIFT    20
#define REG_SW_TX_REQ0_RESET_WIDTH    1

/* SW_TX_REQ1_RESET */
/* SW Tx request 1 enable */
#define REG_SW_TX_REQ1_RESET          0x0500
#define REG_SW_TX_REQ1_RESET_MASK     0x00200000
#define REG_SW_TX_REQ1_RESET_SHIFT    21
#define REG_SW_TX_REQ1_RESET_WIDTH    1

/* UNUSED3 */
#define REG_UNUSED3          0x0500
#define REG_UNUSED3_MASK     0x00c00000
#define REG_UNUSED3_SHIFT    22
#define REG_UNUSED3_WIDTH    2

/* NO_TX_REQ0_SET */
/* No Tx request 0 enable */
#define REG_NO_TX_REQ0_SET          0x0500
#define REG_NO_TX_REQ0_SET_MASK     0x01000000
#define REG_NO_TX_REQ0_SET_SHIFT    24
#define REG_NO_TX_REQ0_SET_WIDTH    1

/* NO_TX_REQ1_SET */
/* No Tx request 1 enable */
#define REG_NO_TX_REQ1_SET          0x0500
#define REG_NO_TX_REQ1_SET_MASK     0x02000000
#define REG_NO_TX_REQ1_SET_SHIFT    25
#define REG_NO_TX_REQ1_SET_WIDTH    1

/* UNUSED4 */
#define REG_UNUSED4          0x0500
#define REG_UNUSED4_MASK     0x0c000000
#define REG_UNUSED4_SHIFT    26
#define REG_UNUSED4_WIDTH    2

/* NO_TX_REQ0_RESET */
/* No Tx request 0 enable */
#define REG_NO_TX_REQ0_RESET          0x0500
#define REG_NO_TX_REQ0_RESET_MASK     0x10000000
#define REG_NO_TX_REQ0_RESET_SHIFT    28
#define REG_NO_TX_REQ0_RESET_WIDTH    1

/* NO_TX_REQ1_RESET */
/* No Tx request 1 enable */
#define REG_NO_TX_REQ1_RESET          0x0500
#define REG_NO_TX_REQ1_RESET_MASK     0x20000000
#define REG_NO_TX_REQ1_RESET_SHIFT    29
#define REG_NO_TX_REQ1_RESET_WIDTH    1

/* UNUSED5 */
#define REG_UNUSED5          0x0500
#define REG_UNUSED5_MASK     0xc0000000
#define REG_UNUSED5_SHIFT    30
#define REG_UNUSED5_WIDTH    2

/* RX_EVENT_RESP_ENABLE */
/* Rx event response enables */
#define REG_RX_EVENT_RESP_ENABLE          0x0504
#define REG_RX_EVENT_RESP_ENABLE_MASK     0x3fffffff
#define REG_RX_EVENT_RESP_ENABLE_SHIFT    0
#define REG_RX_EVENT_RESP_ENABLE_WIDTH    30

/* RESP_TIMEOUTA */
#define REG_RESP_TIMEOUTA          0x0504
#define REG_RESP_TIMEOUTA_MASK     0x40000000
#define REG_RESP_TIMEOUTA_SHIFT    30
#define REG_RESP_TIMEOUTA_WIDTH    1

/* RESP_TIMEOUTB */
#define REG_RESP_TIMEOUTB          0x0504
#define REG_RESP_TIMEOUTB_MASK     0x80000000
#define REG_RESP_TIMEOUTB_SHIFT    31
#define REG_RESP_TIMEOUTB_WIDTH    1

/* RX_EVENT_RESP_MULTI_SHOT */
/* Rx event response enables */
#define REG_RX_EVENT_RESP_MULTI_SHOT          0x0508
#define REG_RX_EVENT_RESP_MULTI_SHOT_MASK     0x3fffffff
#define REG_RX_EVENT_RESP_MULTI_SHOT_SHIFT    0
#define REG_RX_EVENT_RESP_MULTI_SHOT_WIDTH    30

/* UNUSED6 */
#define REG_UNUSED6          0x0508
#define REG_UNUSED6_MASK     0x40000000
#define REG_UNUSED6_SHIFT    30
#define REG_UNUSED6_WIDTH    1

/* RESP_TIMEOUT_MULTI_SHOT */
#define REG_RESP_TIMEOUT_MULTI_SHOT          0x0508
#define REG_RESP_TIMEOUT_MULTI_SHOT_MASK     0x80000000
#define REG_RESP_TIMEOUT_MULTI_SHOT_SHIFT    31
#define REG_RESP_TIMEOUT_MULTI_SHOT_WIDTH    1

/* RX_EVENT_RESP_PRIORITY */
/* Rx event repsonse priorities */
#define REG_RX_EVENT_RESP_PRIORITY          0x050c
#define REG_RX_EVENT_RESP_PRIORITY_MASK     0x3fffffff
#define REG_RX_EVENT_RESP_PRIORITY_SHIFT    0
#define REG_RX_EVENT_RESP_PRIORITY_WIDTH    30

/* UNUSED7 */
#define REG_UNUSED7          0x050c
#define REG_UNUSED7_MASK     0x40000000
#define REG_UNUSED7_SHIFT    30
#define REG_UNUSED7_WIDTH    1

/* RESP_TIMEOUT__PRIORITY */
#define REG_RESP_TIMEOUT__PRIORITY          0x050c
#define REG_RESP_TIMEOUT__PRIORITY_MASK     0x80000000
#define REG_RESP_TIMEOUT__PRIORITY_SHIFT    31
#define REG_RESP_TIMEOUT__PRIORITY_WIDTH    1

/* RX_EVENT_RESP_REQUEUE_OVERRIDE */
/* Rx event re-queue overrides */
#define REG_RX_EVENT_RESP_REQUEUE_OVERRIDE          0x0510
#define REG_RX_EVENT_RESP_REQUEUE_OVERRIDE_MASK     0x3fffffff
#define REG_RX_EVENT_RESP_REQUEUE_OVERRIDE_SHIFT    0
#define REG_RX_EVENT_RESP_REQUEUE_OVERRIDE_WIDTH    30

/* UNUSED8 */
#define REG_UNUSED8          0x0510
#define REG_UNUSED8_MASK     0xc0000000
#define REG_UNUSED8_SHIFT    30
#define REG_UNUSED8_WIDTH    2

/* RX_EVENT_NAV_LOADA */
/* Rx event NAV load, [1:0] are for Rx event 0, etc. */
#define REG_RX_EVENT_NAV_LOADA          0x0514
#define REG_RX_EVENT_NAV_LOADA_MASK     0xffffffff
#define REG_RX_EVENT_NAV_LOADA_SHIFT    0
#define REG_RX_EVENT_NAV_LOADA_WIDTH    32

/* RX_EVENT_NAV_LOADB */
/* Rx event NAV load */
#define REG_RX_EVENT_NAV_LOADB          0x0518
#define REG_RX_EVENT_NAV_LOADB_MASK     0x0fffffff
#define REG_RX_EVENT_NAV_LOADB_SHIFT    0
#define REG_RX_EVENT_NAV_LOADB_WIDTH    28

/* UNUSED9 */
#define REG_UNUSED9          0x0518
#define REG_UNUSED9_MASK     0xf0000000
#define REG_UNUSED9_SHIFT    28
#define REG_UNUSED9_WIDTH    4

/* RX_SW_EVENT_ENABLE */
/* Rx event response enables, 0 and 1 are CRC error */
#define REG_RX_SW_EVENT_ENABLE          0x051c
#define REG_RX_SW_EVENT_ENABLE_MASK     0x3fffffff
#define REG_RX_SW_EVENT_ENABLE_SHIFT    0
#define REG_RX_SW_EVENT_ENABLE_WIDTH    30

/* UNRECOGNISED */
#define REG_UNRECOGNISED          0x051c
#define REG_UNRECOGNISED_MASK     0x40000000
#define REG_UNRECOGNISED_SHIFT    30
#define REG_UNRECOGNISED_WIDTH    1

/* RESP_TIMEOUT_ENABLE */
#define REG_RESP_TIMEOUT_ENABLE          0x051c
#define REG_RESP_TIMEOUT_ENABLE_MASK     0x80000000
#define REG_RESP_TIMEOUT_ENABLE_SHIFT    31
#define REG_RESP_TIMEOUT_ENABLE_WIDTH    1

/* RESP_RX_EVENT_STATUS */
#define REG_RESP_RX_EVENT_STATUS          0x0520
#define REG_RESP_RX_EVENT_STATUS_MASK     0x0000003f
#define REG_RESP_RX_EVENT_STATUS_SHIFT    0
#define REG_RESP_RX_EVENT_STATUS_WIDTH    6

/* UNUSED10 */
#define REG_UNUSED10          0x0520
#define REG_UNUSED10_MASK     0x00000040
#define REG_UNUSED10_SHIFT    6
#define REG_UNUSED10_WIDTH    1

/* RESP_RX_STORED */
#define REG_RESP_RX_STORED          0x0520
#define REG_RESP_RX_STORED_MASK     0x00000080
#define REG_RESP_RX_STORED_SHIFT    7
#define REG_RESP_RX_STORED_WIDTH    1

/* PTCS_REQ */
#define REG_PTCS_REQ          0x0520
#define REG_PTCS_REQ_MASK     0x00007f00
#define REG_PTCS_REQ_SHIFT    8
#define REG_PTCS_REQ_WIDTH    7

/* UNUSED11 */
#define REG_UNUSED11          0x0520
#define REG_UNUSED11_MASK     0x00008000
#define REG_UNUSED11_SHIFT    15
#define REG_UNUSED11_WIDTH    1

/* PTCS_EVENT_STATUS */
#define REG_PTCS_EVENT_STATUS          0x0520
#define REG_PTCS_EVENT_STATUS_MASK     0x00030000
#define REG_PTCS_EVENT_STATUS_SHIFT    16
#define REG_PTCS_EVENT_STATUS_WIDTH    2

/* CHAIN */
#define REG_CHAIN          0x0520
#define REG_CHAIN_MASK     0x000c0000
#define REG_CHAIN_SHIFT    18
#define REG_CHAIN_WIDTH    2

/* PTCS_ABORT_STATUS */
#define REG_PTCS_ABORT_STATUS          0x0520
#define REG_PTCS_ABORT_STATUS_MASK     0x00700000
#define REG_PTCS_ABORT_STATUS_SHIFT    20
#define REG_PTCS_ABORT_STATUS_WIDTH    3

/* UNUSED12 */
#define REG_UNUSED12          0x0520
#define REG_UNUSED12_MASK     0x00800000
#define REG_UNUSED12_SHIFT    23
#define REG_UNUSED12_WIDTH    1

/* RESP_RX_EVENT */
#define REG_RESP_RX_EVENT          0x0520
#define REG_RESP_RX_EVENT_MASK     0x01000000
#define REG_RESP_RX_EVENT_SHIFT    24
#define REG_RESP_RX_EVENT_WIDTH    1

/* PTCS_EVENT */
#define REG_PTCS_EVENT          0x0520
#define REG_PTCS_EVENT_MASK     0x02000000
#define REG_PTCS_EVENT_SHIFT    25
#define REG_PTCS_EVENT_WIDTH    1

/* TSF_HW_EVENT0 */
#define REG_TSF_HW_EVENT0          0x0520
#define REG_TSF_HW_EVENT0_MASK     0x04000000
#define REG_TSF_HW_EVENT0_SHIFT    26
#define REG_TSF_HW_EVENT0_WIDTH    1

/* TSF_HW_EVENT1 */
#define REG_TSF_HW_EVENT1          0x0520
#define REG_TSF_HW_EVENT1_MASK     0x08000000
#define REG_TSF_HW_EVENT1_SHIFT    27
#define REG_TSF_HW_EVENT1_WIDTH    1

/* TSF_REQ_SWITCH */
#define REG_TSF_REQ_SWITCH          0x0520
#define REG_TSF_REQ_SWITCH_MASK     0x10000000
#define REG_TSF_REQ_SWITCH_SHIFT    28
#define REG_TSF_REQ_SWITCH_WIDTH    1

/* TSF_REQ_SWITCH_STATUS */
#define REG_TSF_REQ_SWITCH_STATUS          0x0520
#define REG_TSF_REQ_SWITCH_STATUS_MASK     0x20000000
#define REG_TSF_REQ_SWITCH_STATUS_SHIFT    29
#define REG_TSF_REQ_SWITCH_STATUS_WIDTH    1

/* OVERFLOW */
/* NTD status FIFO overflow */
#define REG_OVERFLOW          0x0520
#define REG_OVERFLOW_MASK     0x40000000
#define REG_OVERFLOW_SHIFT    30
#define REG_OVERFLOW_WIDTH    1

/* EMPTY */
/* NTD status FIFO empty */
#define REG_EMPTY          0x0520
#define REG_EMPTY_MASK     0x80000000
#define REG_EMPTY_SHIFT    31
#define REG_EMPTY_WIDTH    1

/* RESP_RX_EVENT_STATUS_PEEK */
#define REG_RESP_RX_EVENT_STATUS_PEEK          0x0524
#define REG_RESP_RX_EVENT_STATUS_PEEK_MASK     0x0000003f
#define REG_RESP_RX_EVENT_STATUS_PEEK_SHIFT    0
#define REG_RESP_RX_EVENT_STATUS_PEEK_WIDTH    6

/* UNUSED13 */
#define REG_UNUSED13          0x0524
#define REG_UNUSED13_MASK     0x00000040
#define REG_UNUSED13_SHIFT    6
#define REG_UNUSED13_WIDTH    1

/* RESP_RX_STORED_PEEK */
#define REG_RESP_RX_STORED_PEEK          0x0524
#define REG_RESP_RX_STORED_PEEK_MASK     0x00000080
#define REG_RESP_RX_STORED_PEEK_SHIFT    7
#define REG_RESP_RX_STORED_PEEK_WIDTH    1

/* PTCS_REQ_PEEK */
#define REG_PTCS_REQ_PEEK          0x0524
#define REG_PTCS_REQ_PEEK_MASK     0x00007f00
#define REG_PTCS_REQ_PEEK_SHIFT    8
#define REG_PTCS_REQ_PEEK_WIDTH    7

/* UNUSED14 */
#define REG_UNUSED14          0x0524
#define REG_UNUSED14_MASK     0x00008000
#define REG_UNUSED14_SHIFT    15
#define REG_UNUSED14_WIDTH    1

/* PTCS_EVENT_STATUS_PEEK */
#define REG_PTCS_EVENT_STATUS_PEEK          0x0524
#define REG_PTCS_EVENT_STATUS_PEEK_MASK     0x00030000
#define REG_PTCS_EVENT_STATUS_PEEK_SHIFT    16
#define REG_PTCS_EVENT_STATUS_PEEK_WIDTH    2

/* CHAIN_PEEK */
#define REG_CHAIN_PEEK          0x0524
#define REG_CHAIN_PEEK_MASK     0x000c0000
#define REG_CHAIN_PEEK_SHIFT    18
#define REG_CHAIN_PEEK_WIDTH    2

/* PTCS_ABORT_STATUS_PEEK */
#define REG_PTCS_ABORT_STATUS_PEEK          0x0524
#define REG_PTCS_ABORT_STATUS_PEEK_MASK     0x00700000
#define REG_PTCS_ABORT_STATUS_PEEK_SHIFT    20
#define REG_PTCS_ABORT_STATUS_PEEK_WIDTH    3

/* UNUSED15 */
#define REG_UNUSED15          0x0524
#define REG_UNUSED15_MASK     0x00800000
#define REG_UNUSED15_SHIFT    23
#define REG_UNUSED15_WIDTH    1

/* RESP_RX_EVENT_PEEK */
#define REG_RESP_RX_EVENT_PEEK          0x0524
#define REG_RESP_RX_EVENT_PEEK_MASK     0x01000000
#define REG_RESP_RX_EVENT_PEEK_SHIFT    24
#define REG_RESP_RX_EVENT_PEEK_WIDTH    1

/* PTCS_EVENT_PEEK */
#define REG_PTCS_EVENT_PEEK          0x0524
#define REG_PTCS_EVENT_PEEK_MASK     0x02000000
#define REG_PTCS_EVENT_PEEK_SHIFT    25
#define REG_PTCS_EVENT_PEEK_WIDTH    1

/* TSF_HW_EVENT0_PEEK */
#define REG_TSF_HW_EVENT0_PEEK          0x0524
#define REG_TSF_HW_EVENT0_PEEK_MASK     0x04000000
#define REG_TSF_HW_EVENT0_PEEK_SHIFT    26
#define REG_TSF_HW_EVENT0_PEEK_WIDTH    1

/* TSF_HW_EVENT1_PEEK */
#define REG_TSF_HW_EVENT1_PEEK          0x0524
#define REG_TSF_HW_EVENT1_PEEK_MASK     0x08000000
#define REG_TSF_HW_EVENT1_PEEK_SHIFT    27
#define REG_TSF_HW_EVENT1_PEEK_WIDTH    1

/* TSF_REQ_SWITCH_PEEK */
#define REG_TSF_REQ_SWITCH_PEEK          0x0524
#define REG_TSF_REQ_SWITCH_PEEK_MASK     0x10000000
#define REG_TSF_REQ_SWITCH_PEEK_SHIFT    28
#define REG_TSF_REQ_SWITCH_PEEK_WIDTH    1

/* TSF_REQ_SWITCH_STATUS_PEEK */
#define REG_TSF_REQ_SWITCH_STATUS_PEEK          0x0524
#define REG_TSF_REQ_SWITCH_STATUS_PEEK_MASK     0x20000000
#define REG_TSF_REQ_SWITCH_STATUS_PEEK_SHIFT    29
#define REG_TSF_REQ_SWITCH_STATUS_PEEK_WIDTH    1

/* OVERFLOW_PEEK */
/* NTD status FIFO overflow */
#define REG_OVERFLOW_PEEK          0x0524
#define REG_OVERFLOW_PEEK_MASK     0x40000000
#define REG_OVERFLOW_PEEK_SHIFT    30
#define REG_OVERFLOW_PEEK_WIDTH    1

/* EMPTY_PEEK */
/* NTD status FIFO empty */
#define REG_EMPTY_PEEK          0x0524
#define REG_EMPTY_PEEK_MASK     0x80000000
#define REG_EMPTY_PEEK_SHIFT    31
#define REG_EMPTY_PEEK_WIDTH    1

/* AUTO_NO_TX0_ENA */
#define REG_AUTO_NO_TX0_ENA          0x0528
#define REG_AUTO_NO_TX0_ENA_MASK     0x00000001
#define REG_AUTO_NO_TX0_ENA_SHIFT    0
#define REG_AUTO_NO_TX0_ENA_WIDTH    1

/* AUTO_NO_TX1_ENA */
#define REG_AUTO_NO_TX1_ENA          0x0528
#define REG_AUTO_NO_TX1_ENA_MASK     0x00000002
#define REG_AUTO_NO_TX1_ENA_SHIFT    1
#define REG_AUTO_NO_TX1_ENA_WIDTH    1

/* ENABLE_EXTRA_ROWS */
#define REG_ENABLE_EXTRA_ROWS          0x0528
#define REG_ENABLE_EXTRA_ROWS_MASK     0x00000004
#define REG_ENABLE_EXTRA_ROWS_SHIFT    2
#define REG_ENABLE_EXTRA_ROWS_WIDTH    1

/* ENABLE_TXC_PTCS_STATUS */
#define REG_ENABLE_TXC_PTCS_STATUS          0x0528
#define REG_ENABLE_TXC_PTCS_STATUS_MASK     0x00000008
#define REG_ENABLE_TXC_PTCS_STATUS_SHIFT    3
#define REG_ENABLE_TXC_PTCS_STATUS_WIDTH    1

/* UNUSED16 */
#define REG_UNUSED16          0x0528
#define REG_UNUSED16_MASK     0x000000f0
#define REG_UNUSED16_SHIFT    4
#define REG_UNUSED16_WIDTH    4

/* NTD_STATE */
#define REG_NTD_STATE          0x0528
#define REG_NTD_STATE_MASK     0x00001f00
#define REG_NTD_STATE_SHIFT    8
#define REG_NTD_STATE_WIDTH    5

/* UNUSED17 */
#define REG_UNUSED17          0x0528
#define REG_UNUSED17_MASK     0x0000e000
#define REG_UNUSED17_SHIFT    13
#define REG_UNUSED17_WIDTH    3

/* RX_LOW_REQ */
#define REG_RX_LOW_REQ          0x0528
#define REG_RX_LOW_REQ_MASK     0x001f0000
#define REG_RX_LOW_REQ_SHIFT    16
#define REG_RX_LOW_REQ_WIDTH    5

/* RESP_TIMEOUT_REQ */
#define REG_RESP_TIMEOUT_REQ          0x0528
#define REG_RESP_TIMEOUT_REQ_MASK     0x00200000
#define REG_RESP_TIMEOUT_REQ_SHIFT    21
#define REG_RESP_TIMEOUT_REQ_WIDTH    1

/* TSF_HW1_REQ */
#define REG_TSF_HW1_REQ          0x0528
#define REG_TSF_HW1_REQ_MASK     0x00400000
#define REG_TSF_HW1_REQ_SHIFT    22
#define REG_TSF_HW1_REQ_WIDTH    1

/* TSF_HW0_REQ */
#define REG_TSF_HW0_REQ          0x0528
#define REG_TSF_HW0_REQ_MASK     0x00800000
#define REG_TSF_HW0_REQ_SHIFT    23
#define REG_TSF_HW0_REQ_WIDTH    1

/* RX_HIGH_REQ */
#define REG_RX_HIGH_REQ          0x0528
#define REG_RX_HIGH_REQ_MASK     0x1f000000
#define REG_RX_HIGH_REQ_SHIFT    24
#define REG_RX_HIGH_REQ_WIDTH    5

/* UNUSED18 */
#define REG_UNUSED18          0x0528
#define REG_UNUSED18_MASK     0xe0000000
#define REG_UNUSED18_SHIFT    29
#define REG_UNUSED18_WIDTH    3

/* PTCS_POINTER_TABLE_BASE */
/* Start address of a table in shared memory, comprising one 32-bit pointer to a PTCS for each event or request code from the NTD block. */
#define REG_PTCS_POINTER_TABLE_BASE          0x0600
#define REG_PTCS_POINTER_TABLE_BASE_MASK     0x003fff00
#define REG_PTCS_POINTER_TABLE_BASE_SHIFT    8
#define REG_PTCS_POINTER_TABLE_BASE_WIDTH    14

/* TXC_STATE */
/* Diagnostic observation of the state machine */
#define REG_TXC_STATE          0x0604
#define REG_TXC_STATE_MASK     0x0000001f
#define REG_TXC_STATE_SHIFT    0
#define REG_TXC_STATE_WIDTH    5

/* UNUSED19 */
#define REG_UNUSED19          0x0604
#define REG_UNUSED19_MASK     0x00000020
#define REG_UNUSED19_SHIFT    5
#define REG_UNUSED19_WIDTH    1

/* IFS_COMPLETE */
/* IFS_complete flag */
#define REG_IFS_COMPLETE          0x0604
#define REG_IFS_COMPLETE_MASK     0x00000040
#define REG_IFS_COMPLETE_SHIFT    6
#define REG_IFS_COMPLETE_WIDTH    1

/* BACKOFF_COMPLETE */
/* Backoff_complete flag (non EDCF) */
#define REG_BACKOFF_COMPLETE          0x0604
#define REG_BACKOFF_COMPLETE_MASK     0x00000080
#define REG_BACKOFF_COMPLETE_SHIFT    7
#define REG_BACKOFF_COMPLETE_WIDTH    1

/* PTCS_INDEX */
/* Which PTCS is currently being processed or most recently completed */
#define REG_PTCS_INDEX          0x0604
#define REG_PTCS_INDEX_MASK     0x00003f00
#define REG_PTCS_INDEX_SHIFT    8
#define REG_PTCS_INDEX_WIDTH    6

/* LAST_RX_CRC_ERROR */
/* Last received frame had a CRC error */
#define REG_LAST_RX_CRC_ERROR          0x0604
#define REG_LAST_RX_CRC_ERROR_MASK     0x00004000
#define REG_LAST_RX_CRC_ERROR_SHIFT    14
#define REG_LAST_RX_CRC_ERROR_WIDTH    1

/* MAC_CLEAR_CHAN_ASSESS */
/* Set when MAC believes the channel to be busy.  Derived from NAV, RXC, TXC and PHY CCA. */
#define REG_MAC_CLEAR_CHAN_ASSESS          0x0604
#define REG_MAC_CLEAR_CHAN_ASSESS_MASK     0x00008000
#define REG_MAC_CLEAR_CHAN_ASSESS_SHIFT    15
#define REG_MAC_CLEAR_CHAN_ASSESS_WIDTH    1

/* PRIORITY */
/* Priority currently being serviced */
#define REG_PRIORITY          0x0604
#define REG_PRIORITY_MASK     0x00030000
#define REG_PRIORITY_SHIFT    16
#define REG_PRIORITY_WIDTH    2

/* UNUSED20 */
#define REG_UNUSED20          0x0604
#define REG_UNUSED20_MASK     0x000c0000
#define REG_UNUSED20_SHIFT    18
#define REG_UNUSED20_WIDTH    2

/* EDCF_BACKOFF_COMPLETE */
/* Backoff complete for each EDCF priority */
#define REG_EDCF_BACKOFF_COMPLETE          0x0604
#define REG_EDCF_BACKOFF_COMPLETE_MASK     0x00f00000
#define REG_EDCF_BACKOFF_COMPLETE_SHIFT    20
#define REG_EDCF_BACKOFF_COMPLETE_WIDTH    4

/* UNUSED21 */
#define REG_UNUSED21          0x0604
#define REG_UNUSED21_MASK     0x03000000
#define REG_UNUSED21_SHIFT    24
#define REG_UNUSED21_WIDTH    2

/* AIFS_COMPLETE */
/* AIFS complete for each EDCF priority */
#define REG_AIFS_COMPLETE          0x0604
#define REG_AIFS_COMPLETE_MASK     0x3c000000
#define REG_AIFS_COMPLETE_SHIFT    26
#define REG_AIFS_COMPLETE_WIDTH    4

/* UNUSED22 */
#define REG_UNUSED22          0x0604
#define REG_UNUSED22_MASK     0xc0000000
#define REG_UNUSED22_SHIFT    30
#define REG_UNUSED22_WIDTH    2

/* EDCF_PRIORITY_ENABLE */
/* Selects which EDCF priorities use the acitive PTCS (rather than default) */
#define REG_EDCF_PRIORITY_ENABLE          0x0608
#define REG_EDCF_PRIORITY_ENABLE_MASK     0x0000000f
#define REG_EDCF_PRIORITY_ENABLE_SHIFT    0
#define REG_EDCF_PRIORITY_ENABLE_WIDTH    4

/* ALT_BACKOFF_0 */
/* Backoff to be used when priority 0 defers because of an internal collision */
#define REG_ALT_BACKOFF_0          0x060c
#define REG_ALT_BACKOFF_0_MASK     0x000003ff
#define REG_ALT_BACKOFF_0_SHIFT    0
#define REG_ALT_BACKOFF_0_WIDTH    10

/* ALT_BACKOFF_1 */
/* Backoff to be used when priority 1 defers because of an internal collision */
#define REG_ALT_BACKOFF_1          0x0610
#define REG_ALT_BACKOFF_1_MASK     0x000003ff
#define REG_ALT_BACKOFF_1_SHIFT    0
#define REG_ALT_BACKOFF_1_WIDTH    10

/* ALT_BACKOFF_2 */
/* Backoff to be used when priority 2 defers because of an internal collision */
#define REG_ALT_BACKOFF_2          0x0614
#define REG_ALT_BACKOFF_2_MASK     0x000003ff
#define REG_ALT_BACKOFF_2_SHIFT    0
#define REG_ALT_BACKOFF_2_WIDTH    10

/* EDCF_CONTEXT */
#define REG_EDCF_CONTEXT          0x0618
#define REG_EDCF_CONTEXT_MASK     0x0000000f
#define REG_EDCF_CONTEXT_SHIFT    0
#define REG_EDCF_CONTEXT_WIDTH    4

/* TSF_FAST_DIVIDE */
/* Number of fast clock periods per microsecond - 1 */
#define REG_TSF_FAST_DIVIDE          0x0700
#define REG_TSF_FAST_DIVIDE_MASK     0x000000ff
#define REG_TSF_FAST_DIVIDE_SHIFT    0
#define REG_TSF_FAST_DIVIDE_WIDTH    8

/* TSF_SLOW_FRAC_INCR */
/* Slow prescaler integer increment per clock */
#define REG_TSF_SLOW_FRAC_INCR          0x0700
#define REG_TSF_SLOW_FRAC_INCR_MASK     0x0001ff00
#define REG_TSF_SLOW_FRAC_INCR_SHIFT    8
#define REG_TSF_SLOW_FRAC_INCR_WIDTH    9

/* TSF_SLOW_INT_INCR */
/* Slow prescaler fractional increment per clock */
#define REG_TSF_SLOW_INT_INCR          0x0700
#define REG_TSF_SLOW_INT_INCR_MASK     0x007e0000
#define REG_TSF_SLOW_INT_INCR_SHIFT    17
#define REG_TSF_SLOW_INT_INCR_WIDTH    6

/* NAV_FAST_DIVIDE */
/* Number of fast clock periods per microsecond - 1 */
#define REG_NAV_FAST_DIVIDE          0x0700
#define REG_NAV_FAST_DIVIDE_MASK     0xff000000
#define REG_NAV_FAST_DIVIDE_SHIFT    24
#define REG_NAV_FAST_DIVIDE_WIDTH    8

/* NAV_SLOW_FRAC_INCR */
/* Timers slow prescaler fractional increment per clock */
#define REG_NAV_SLOW_FRAC_INCR          0x0704
#define REG_NAV_SLOW_FRAC_INCR_MASK     0x000001ff
#define REG_NAV_SLOW_FRAC_INCR_SHIFT    0
#define REG_NAV_SLOW_FRAC_INCR_WIDTH    9

/* NAV_SLOW_INT_INCR */
/* Timers slow prescaler integer increment per clock */
#define REG_NAV_SLOW_INT_INCR          0x0704
#define REG_NAV_SLOW_INT_INCR_MASK     0x00007e00
#define REG_NAV_SLOW_INT_INCR_SHIFT    9
#define REG_NAV_SLOW_INT_INCR_WIDTH    6

/* UNUSED23 */
#define REG_UNUSED23          0x0704
#define REG_UNUSED23_MASK     0x00008000
#define REG_UNUSED23_SHIFT    15
#define REG_UNUSED23_WIDTH    1

/* IFS_DIVIDE */
/* IFS timer prescaler divide ratio */
#define REG_IFS_DIVIDE          0x0704
#define REG_IFS_DIVIDE_MASK     0x00ff0000
#define REG_IFS_DIVIDE_SHIFT    16
#define REG_IFS_DIVIDE_WIDTH    8

/* SLOT_DIVIDE */
/* Slot timer prescaler divide ratio */
#define REG_SLOT_DIVIDE          0x0704
#define REG_SLOT_DIVIDE_MASK     0x1f000000
#define REG_SLOT_DIVIDE_SHIFT    24
#define REG_SLOT_DIVIDE_WIDTH    5

/* TIME_TSF_HW_EVENT0 */
/* TSF time at which TSF HW event 0 occurs, up to 2^23 us after current TSF */
#define REG_TIME_TSF_HW_EVENT0          0x0708
#define REG_TIME_TSF_HW_EVENT0_MASK     0x00ffffff
#define REG_TIME_TSF_HW_EVENT0_SHIFT    0
#define REG_TIME_TSF_HW_EVENT0_WIDTH    24

/* UNUSED24 */
#define REG_UNUSED24          0x0708
#define REG_UNUSED24_MASK     0x3f000000
#define REG_UNUSED24_SHIFT    24
#define REG_UNUSED24_WIDTH    6

/* HW_ENABLETSF_HW_EVENT0 */
/* Enable hardware event 0 */
#define REG_HW_ENABLETSF_HW_EVENT0          0x0708
#define REG_HW_ENABLETSF_HW_EVENT0_MASK     0x40000000
#define REG_HW_ENABLETSF_HW_EVENT0_SHIFT    30
#define REG_HW_ENABLETSF_HW_EVENT0_WIDTH    1

/* SW_ENABLE_TSF_HW_EVENT0 */
/* Enable software event 0 */
#define REG_SW_ENABLE_TSF_HW_EVENT0          0x0708
#define REG_SW_ENABLE_TSF_HW_EVENT0_MASK     0x80000000
#define REG_SW_ENABLE_TSF_HW_EVENT0_SHIFT    31
#define REG_SW_ENABLE_TSF_HW_EVENT0_WIDTH    1

/* TIME_TSF_HW_EVENT1 */
/* TSF time at which TSF HW event 1 occurs, up to 2^23 us after current TSF */
#define REG_TIME_TSF_HW_EVENT1          0x070c
#define REG_TIME_TSF_HW_EVENT1_MASK     0x00ffffff
#define REG_TIME_TSF_HW_EVENT1_SHIFT    0
#define REG_TIME_TSF_HW_EVENT1_WIDTH    24

/* UNUSED25 */
#define REG_UNUSED25          0x070c
#define REG_UNUSED25_MASK     0x3f000000
#define REG_UNUSED25_SHIFT    24
#define REG_UNUSED25_WIDTH    6

/* HW_ENABLETSF_HW_EVENT1 */
/* Enable hardware event 1 */
#define REG_HW_ENABLETSF_HW_EVENT1          0x070c
#define REG_HW_ENABLETSF_HW_EVENT1_MASK     0x40000000
#define REG_HW_ENABLETSF_HW_EVENT1_SHIFT    30
#define REG_HW_ENABLETSF_HW_EVENT1_WIDTH    1

/* SW_ENABLE_TSF_HW_EVENT1 */
/* Enable software event 1 */
#define REG_SW_ENABLE_TSF_HW_EVENT1          0x070c
#define REG_SW_ENABLE_TSF_HW_EVENT1_MASK     0x80000000
#define REG_SW_ENABLE_TSF_HW_EVENT1_SHIFT    31
#define REG_SW_ENABLE_TSF_HW_EVENT1_WIDTH    1

/* TIME_TSF_REQ_SWITCH */
/* TSF time at which the request switch occurs. */
#define REG_TIME_TSF_REQ_SWITCH          0x0710
#define REG_TIME_TSF_REQ_SWITCH_MASK     0x00ffffff
#define REG_TIME_TSF_REQ_SWITCH_SHIFT    0
#define REG_TIME_TSF_REQ_SWITCH_WIDTH    24

/* UNUSED26 */
#define REG_UNUSED26          0x0710
#define REG_UNUSED26_MASK     0x1f000000
#define REG_UNUSED26_SHIFT    24
#define REG_UNUSED26_WIDTH    5

/* TO_1 */
/* 0 - Switch to queue 0; 1 - Switch to queue 1 */
#define REG_TO_1          0x0710
#define REG_TO_1_MASK     0x20000000
#define REG_TO_1_SHIFT    29
#define REG_TO_1_WIDTH    1

/* HW_ENABLE_TSF_REQ_SWITCH */
/* Enable hardware event */
#define REG_HW_ENABLE_TSF_REQ_SWITCH          0x0710
#define REG_HW_ENABLE_TSF_REQ_SWITCH_MASK     0x40000000
#define REG_HW_ENABLE_TSF_REQ_SWITCH_SHIFT    30
#define REG_HW_ENABLE_TSF_REQ_SWITCH_WIDTH    1

/* SW_ENABLE_TSF_REQ_SWITCH */
/* Enable software event 4 */
#define REG_SW_ENABLE_TSF_REQ_SWITCH          0x0710
#define REG_SW_ENABLE_TSF_REQ_SWITCH_MASK     0x80000000
#define REG_SW_ENABLE_TSF_REQ_SWITCH_SHIFT    31
#define REG_SW_ENABLE_TSF_REQ_SWITCH_WIDTH    1

/* TIME_TSF_SW_EVENT2 */
/* TSF time at which TSF SW event 2 occurs. */
#define REG_TIME_TSF_SW_EVENT2          0x0714
#define REG_TIME_TSF_SW_EVENT2_MASK     0x00ffffff
#define REG_TIME_TSF_SW_EVENT2_SHIFT    0
#define REG_TIME_TSF_SW_EVENT2_WIDTH    24

/* UNUSED27 */
#define REG_UNUSED27          0x0714
#define REG_UNUSED27_MASK     0x7f000000
#define REG_UNUSED27_SHIFT    24
#define REG_UNUSED27_WIDTH    7

/* ENABLE_TSF_SW_EVENT2 */
/* Enable software event 2 */
#define REG_ENABLE_TSF_SW_EVENT2          0x0714
#define REG_ENABLE_TSF_SW_EVENT2_MASK     0x80000000
#define REG_ENABLE_TSF_SW_EVENT2_SHIFT    31
#define REG_ENABLE_TSF_SW_EVENT2_WIDTH    1

/* TIME_TSF_SW_EVENT3 */
/* TSF time at which TSF SW event 3 occurs. */
#define REG_TIME_TSF_SW_EVENT3          0x0718
#define REG_TIME_TSF_SW_EVENT3_MASK     0x00ffffff
#define REG_TIME_TSF_SW_EVENT3_SHIFT    0
#define REG_TIME_TSF_SW_EVENT3_WIDTH    24

/* UNUSED28 */
#define REG_UNUSED28          0x0718
#define REG_UNUSED28_MASK     0x7f000000
#define REG_UNUSED28_SHIFT    24
#define REG_UNUSED28_WIDTH    7

/* ENABLE_TSF_SW_EVENT3 */
/* Enable software event 3 */
#define REG_ENABLE_TSF_SW_EVENT3          0x0718
#define REG_ENABLE_TSF_SW_EVENT3_MASK     0x80000000
#define REG_ENABLE_TSF_SW_EVENT3_SHIFT    31
#define REG_ENABLE_TSF_SW_EVENT3_WIDTH    1

/* TIME_TSF_NAV_LOAD */
/* TSF time at which TSF NAV load event occurs. */
#define REG_TIME_TSF_NAV_LOAD          0x071c
#define REG_TIME_TSF_NAV_LOAD_MASK     0x00ffffff
#define REG_TIME_TSF_NAV_LOAD_SHIFT    0
#define REG_TIME_TSF_NAV_LOAD_WIDTH    24

/* UNUSED29 */
#define REG_UNUSED29          0x071c
#define REG_UNUSED29_MASK     0x3f000000
#define REG_UNUSED29_SHIFT    24
#define REG_UNUSED29_WIDTH    6

/* HW_ENABLE_TSF_NAV_LOAD */
/* Enable hardware event */
#define REG_HW_ENABLE_TSF_NAV_LOAD          0x071c
#define REG_HW_ENABLE_TSF_NAV_LOAD_MASK     0x40000000
#define REG_HW_ENABLE_TSF_NAV_LOAD_SHIFT    30
#define REG_HW_ENABLE_TSF_NAV_LOAD_WIDTH    1

/* UNUSED30 */
#define REG_UNUSED30          0x071c
#define REG_UNUSED30_MASK     0x80000000
#define REG_UNUSED30_SHIFT    31
#define REG_UNUSED30_WIDTH    1

/* RX_NAV_LOAD_DURATION */
/* Duration loaded into the NAV timer when a Rx event with "load NAV from Rx NAV load duration register" enabled. */
#define REG_RX_NAV_LOAD_DURATION          0x0720
#define REG_RX_NAV_LOAD_DURATION_MASK     0x0000ffff
#define REG_RX_NAV_LOAD_DURATION_SHIFT    0
#define REG_RX_NAV_LOAD_DURATION_WIDTH    16

/* TSF_NAV_LOAD_DURATION */
/* Value to be loaded into the NAV timer when the TSF NAV load event occurs or when a Rx event occurs with load NAV from TSF NAV load duration register . */
#define REG_TSF_NAV_LOAD_DURATION          0x0724
#define REG_TSF_NAV_LOAD_DURATION_MASK     0x0000ffff
#define REG_TSF_NAV_LOAD_DURATION_SHIFT    0
#define REG_TSF_NAV_LOAD_DURATION_WIDTH    16

/* TIME_RXD_TSF_COMP */
/* TSF time to compare with TSF Timer */
#define REG_TIME_RXD_TSF_COMP          0x0728
#define REG_TIME_RXD_TSF_COMP_MASK     0x00ffffff
#define REG_TIME_RXD_TSF_COMP_SHIFT    0
#define REG_TIME_RXD_TSF_COMP_WIDTH    24

/* ENABLE_RXD_TSF_COMP */
/* Set for enabled. Reset for disabled. Set and reset by software. */
#define REG_ENABLE_RXD_TSF_COMP          0x0728
#define REG_ENABLE_RXD_TSF_COMP_MASK     0x80000000
#define REG_ENABLE_RXD_TSF_COMP_SHIFT    31
#define REG_ENABLE_RXD_TSF_COMP_WIDTH    1

/* PERIOD_TICK_TIMER */
/* Tick timer period in microseconds */
#define REG_PERIOD_TICK_TIMER          0x072c
#define REG_PERIOD_TICK_TIMER_MASK     0x0000ffff
#define REG_PERIOD_TICK_TIMER_SHIFT    0
#define REG_PERIOD_TICK_TIMER_WIDTH    16

/* UNUSED31 */
#define REG_UNUSED31          0x072c
#define REG_UNUSED31_MASK     0x7fff0000
#define REG_UNUSED31_SHIFT    16
#define REG_UNUSED31_WIDTH    15

/* ENABLE_TICK_TIMER */
/* Set for enabled. Reset for disabled. Set and reset by software. */
#define REG_ENABLE_TICK_TIMER          0x072c
#define REG_ENABLE_TICK_TIMER_MASK     0x80000000
#define REG_ENABLE_TICK_TIMER_SHIFT    31
#define REG_ENABLE_TICK_TIMER_WIDTH    1

/* PERIOD_SLOT_TIMER */
/* Set to (8 * slot period) - 1, slot period in microseconds */
#define REG_PERIOD_SLOT_TIMER          0x0730
#define REG_PERIOD_SLOT_TIMER_MASK     0x000003ff
#define REG_PERIOD_SLOT_TIMER_SHIFT    0
#define REG_PERIOD_SLOT_TIMER_WIDTH    10

/* UNUSED32 */
#define REG_UNUSED32          0x0730
#define REG_UNUSED32_MASK     0xfffffc00
#define REG_UNUSED32_SHIFT    10
#define REG_UNUSED32_WIDTH    22

/* NAV_ENABLE */
/* When set the NAV timer is enabled and it will decrement every 1 us until it reaches zero. When reset the NAV timer is disabled and the value will not change. */
#define REG_NAV_ENABLE          0x0734
#define REG_NAV_ENABLE_MASK     0x00000001
#define REG_NAV_ENABLE_SHIFT    0
#define REG_NAV_ENABLE_WIDTH    1

/* TSF_ENABLE */
/* When set the TSF timer is enabled and it will increment every 1 us, wrapping (resetting to zero) when it reaches it's maximum value. When reset the TSF timer is disabled and the software can load the TSF timer by writing to the TSF timer low and TSF timer high registers. */
#define REG_TSF_ENABLE          0x0734
#define REG_TSF_ENABLE_MASK     0x00000002
#define REG_TSF_ENABLE_SHIFT    1
#define REG_TSF_ENABLE_WIDTH    1

/* TSF_NUDGE */
/* Setting this bit causes the TSF timer to be adjusted (nudged) by TSF adjustment (a small signed value). This bit set by the software and is reset by the hardware when the adjustment is complete. */
#define REG_TSF_NUDGE          0x0734
#define REG_TSF_NUDGE_MASK     0x00000004
#define REG_TSF_NUDGE_SHIFT    2
#define REG_TSF_NUDGE_WIDTH    1

/* UNUSED33 */
#define REG_UNUSED33          0x0734
#define REG_UNUSED33_MASK     0x000000f8
#define REG_UNUSED33_SHIFT    3
#define REG_UNUSED33_WIDTH    5

/* TSF_ADJ */
/* Signed TSF adjustment value, a negative value puts the TSF time back, a positive value puts the TSF time forwards. */
#define REG_TSF_ADJ          0x0734
#define REG_TSF_ADJ_MASK     0x0001ff00
#define REG_TSF_ADJ_SHIFT    8
#define REG_TSF_ADJ_WIDTH    9

/* UNUSED34 */
#define REG_UNUSED34          0x0734
#define REG_UNUSED34_MASK     0x00fe0000
#define REG_UNUSED34_SHIFT    17
#define REG_UNUSED34_WIDTH    7

/* TSF_SW_EVENT0 */
/* Set by hardware when tsf_sw_event0 occurs.  Write '1' to clear the sw_enable bit in the tsf_hw_event0 register, thus clearing the event. */
#define REG_TSF_SW_EVENT0          0x0734
#define REG_TSF_SW_EVENT0_MASK     0x01000000
#define REG_TSF_SW_EVENT0_SHIFT    24
#define REG_TSF_SW_EVENT0_WIDTH    1

/* TSF_SW_EVENT1 */
/* Set by hardware when tsf_sw_event1 occurs.  Write '1' to clear the sw_enable bit in the tsf_hw_event1 register, thus clearing the event. */
#define REG_TSF_SW_EVENT1          0x0734
#define REG_TSF_SW_EVENT1_MASK     0x02000000
#define REG_TSF_SW_EVENT1_SHIFT    25
#define REG_TSF_SW_EVENT1_WIDTH    1

/* TSF_SW_EVENT2 */
/* Set by hardware when tsf_sw_event2 occurs.  Write '1' to clear the sw_enable bit in the tsf_sw_event2 register, thus clearing the event. */
#define REG_TSF_SW_EVENT2          0x0734
#define REG_TSF_SW_EVENT2_MASK     0x04000000
#define REG_TSF_SW_EVENT2_SHIFT    26
#define REG_TSF_SW_EVENT2_WIDTH    1

/* TSF_SW_EVENT3 */
/* Set by hardware when tsf_sw_event3 occurs.  Write '1' to clear the sw_enable bit in the tsf_sw_event3 register, thus clearing the event. */
#define REG_TSF_SW_EVENT3          0x0734
#define REG_TSF_SW_EVENT3_MASK     0x08000000
#define REG_TSF_SW_EVENT3_SHIFT    27
#define REG_TSF_SW_EVENT3_WIDTH    1

/* TSF_SW_EVENT4 */
/* Set by hardware when tsf_sw_event4 (TSF request switch) occurs.  Write '1' to clear the sw_enable bit in the tsf_req_switch register, thus clearing the event. */
#define REG_TSF_SW_EVENT4          0x0734
#define REG_TSF_SW_EVENT4_MASK     0x10000000
#define REG_TSF_SW_EVENT4_SHIFT    28
#define REG_TSF_SW_EVENT4_WIDTH    1

/* UNUSED35 */
#define REG_UNUSED35          0x0734
#define REG_UNUSED35_MASK     0xe0000000
#define REG_UNUSED35_SHIFT    29
#define REG_UNUSED35_WIDTH    3

/* TSF_TIMER_LOW */
/* Bits 31:0 of the TSF Timer.  Can only be written when timer_control.tsf_enable is zero. */
#define REG_TSF_TIMER_LOW          0x0738
#define REG_TSF_TIMER_LOW_MASK     0xffffffff
#define REG_TSF_TIMER_LOW_SHIFT    0
#define REG_TSF_TIMER_LOW_WIDTH    32

/* TSF_TIMER_HIGH */
/* Bits 63:32 of the TSF Timer.  Can only be written when timer_control.tsf_enable is zero. */
#define REG_TSF_TIMER_HIGH          0x073c
#define REG_TSF_TIMER_HIGH_MASK     0xffffffff
#define REG_TSF_TIMER_HIGH_SHIFT    0
#define REG_TSF_TIMER_HIGH_WIDTH    32

/* NAV_TIMER */
/* NAV timer */
#define REG_NAV_TIMER          0x0740
#define REG_NAV_TIMER_MASK     0x0000ffff
#define REG_NAV_TIMER_SHIFT    0
#define REG_NAV_TIMER_WIDTH    16

/* TIMER_TICK */
/* Tick timer */
#define REG_TIMER_TICK          0x0744
#define REG_TIMER_TICK_MASK     0x0000ffff
#define REG_TIMER_TICK_SHIFT    0
#define REG_TIMER_TICK_WIDTH    16

/* TIMER_SLOT */
/* Slot timer */
#define REG_TIMER_SLOT          0x0748
#define REG_TIMER_SLOT_MASK     0x000003ff
#define REG_TIMER_SLOT_SHIFT    0
#define REG_TIMER_SLOT_WIDTH    10

/* BACKOFF_COUNTER */
/* Backoff counter */
#define REG_BACKOFF_COUNTER          0x074c
#define REG_BACKOFF_COUNTER_MASK     0x000003ff
#define REG_BACKOFF_COUNTER_SHIFT    0
#define REG_BACKOFF_COUNTER_WIDTH    10

/* IFS_TIMER */
/* IFS timer */
#define REG_IFS_TIMER          0x0750
#define REG_IFS_TIMER_MASK     0x00001fff
#define REG_IFS_TIMER_SHIFT    0
#define REG_IFS_TIMER_WIDTH    13

/* RESP_TIMER */
/* Response timer */
#define REG_RESP_TIMER          0x0754
#define REG_RESP_TIMER_MASK     0x00001fff
#define REG_RESP_TIMER_SHIFT    0
#define REG_RESP_TIMER_WIDTH    13

/* TIMER_RX_FRAME */
/* Timer value (same units as TSF) */
#define REG_TIMER_RX_FRAME          0x0758
#define REG_TIMER_RX_FRAME_MASK     0x0000ffff
#define REG_TIMER_RX_FRAME_SHIFT    0
#define REG_TIMER_RX_FRAME_WIDTH    16

/* PRESCALE_LOAD */
/* Value to put into prescaler at start of frame */
#define REG_PRESCALE_LOAD          0x0758
#define REG_PRESCALE_LOAD_MASK     0x00ff0000
#define REG_PRESCALE_LOAD_SHIFT    16
#define REG_PRESCALE_LOAD_WIDTH    8

/* RAM_BASE_ADDRESS */
/* Pointer to table; word-aligned (bottom two bits are always zero). */
#define REG_RAM_BASE_ADDRESS          0x0400
#define REG_RAM_BASE_ADDRESS_MASK     0x007ffffc
#define REG_RAM_BASE_ADDRESS_SHIFT    2
#define REG_RAM_BASE_ADDRESS_WIDTH    21

#define REG_AUTO_RATE_OFFSETS_BASE_ADDR 0x4a4

/* CFP_END_TIME */
/* The time for the end of the CFP expressed in Time Units  */
#define REG_CFP_END_TIME          0x0404
#define REG_CFP_END_TIME_MASK     0x0000ffff
#define REG_CFP_END_TIME_SHIFT    0
#define REG_CFP_END_TIME_WIDTH    16

/* TSF_START_TIME_ADJUST */
/* Value is in us and signed. */
#define REG_TSF_START_TIME_ADJUST          0x0408
#define REG_TSF_START_TIME_ADJUST_MASK     0x00000fff
#define REG_TSF_START_TIME_ADJUST_SHIFT    0
#define REG_TSF_START_TIME_ADJUST_WIDTH    12

/* POWER_MGMT */
/* Power management HOB bit */
#define REG_POWER_MGMT          0x040c
#define REG_POWER_MGMT_MASK     0x00000001
#define REG_POWER_MGMT_SHIFT    0
#define REG_POWER_MGMT_WIDTH    1

/* NAV_ADJUST */
/* Adjustment in microseconds to be subtracted from extracted Duration values which are loaded to th NAV timer. */
#define REG_NAV_ADJUST          0x0410
#define REG_NAV_ADJUST_MASK     0x0000007f
#define REG_NAV_ADJUST_SHIFT    0
#define REG_NAV_ADJUST_WIDTH    7

/* TABLE_MASK */
/* Which bits of Rx PHY Rate are used to index the response table */
#define REG_TABLE_MASK          0x0414
#define REG_TABLE_MASK_MASK     0x000000ff
#define REG_TABLE_MASK_SHIFT    0
#define REG_TABLE_MASK_WIDTH    8

/* NO_ACK */
/* Bits 0-3 supress ACK for ACK policy 03 */
#define REG_NO_ACK          0x0418
#define REG_NO_ACK_MASK     0x0000000f
#define REG_NO_ACK_SHIFT    0
#define REG_NO_ACK_WIDTH    4

/* TSF_FIELD_TIME */
/* Offset within transmitted frame to start of TSF field */
#define REG_TSF_FIELD_TIME          0x041c
#define REG_TSF_FIELD_TIME_MASK     0x000001ff
#define REG_TSF_FIELD_TIME_SHIFT    0
#define REG_TSF_FIELD_TIME_WIDTH    9

/* AIR_ACCUM_0 */
/* Write anything to clear all four accumualtors and copy the old values to air_counter[3:0] */
#define REG_AIR_ACCUM_0          0x0420
#define REG_AIR_ACCUM_0_MASK     0x00ffffff
#define REG_AIR_ACCUM_0_SHIFT    0
#define REG_AIR_ACCUM_0_WIDTH    24

/* AIR_ACCUM_1 */
#define REG_AIR_ACCUM_1          0x0424
#define REG_AIR_ACCUM_1_MASK     0x00ffffff
#define REG_AIR_ACCUM_1_SHIFT    0
#define REG_AIR_ACCUM_1_WIDTH    24

/* AIR_ACCUM_2 */
#define REG_AIR_ACCUM_2          0x0428
#define REG_AIR_ACCUM_2_MASK     0x00ffffff
#define REG_AIR_ACCUM_2_SHIFT    0
#define REG_AIR_ACCUM_2_WIDTH    24

/* AIR_ACCUM_3 */
#define REG_AIR_ACCUM_3          0x042c
#define REG_AIR_ACCUM_3_MASK     0x00ffffff
#define REG_AIR_ACCUM_3_SHIFT    0
#define REG_AIR_ACCUM_3_WIDTH    24

/* AIR_COUNTER_0 */
#define REG_AIR_COUNTER_0          0x0430
#define REG_AIR_COUNTER_0_MASK     0x00ffffff
#define REG_AIR_COUNTER_0_SHIFT    0
#define REG_AIR_COUNTER_0_WIDTH    24

/* AIR_COUNTER_1 */
#define REG_AIR_COUNTER_1          0x0434
#define REG_AIR_COUNTER_1_MASK     0x00ffffff
#define REG_AIR_COUNTER_1_SHIFT    0
#define REG_AIR_COUNTER_1_WIDTH    24

/* AIR_COUNTER_2 */
#define REG_AIR_COUNTER_2          0x0438
#define REG_AIR_COUNTER_2_MASK     0x00ffffff
#define REG_AIR_COUNTER_2_SHIFT    0
#define REG_AIR_COUNTER_2_WIDTH    24

/* AIR_COUNTER_3 */
#define REG_AIR_COUNTER_3          0x043c
#define REG_AIR_COUNTER_3_MASK     0x00ffffff
#define REG_AIR_COUNTER_3_SHIFT    0
#define REG_AIR_COUNTER_3_WIDTH    24

/* AUTO_RESET */
/* When set, the air accumualtors are automatically cleared and copied to the air counters in response to transmitting a beacon frame (with the"becaon" bit set in the PTCS */
#define REG_AUTO_RESET          0x0440
#define REG_AUTO_RESET_MASK     0x00000001
#define REG_AUTO_RESET_SHIFT    0
#define REG_AUTO_RESET_WIDTH    1

/* NO_ACK_ADJUST */
/* Prevents the duration of the ACK+SIFS response for each received frame from being added to air accumulators */
#define REG_NO_ACK_ADJUST          0x0440
#define REG_NO_ACK_ADJUST_MASK     0x00000002
#define REG_NO_ACK_ADJUST_SHIFT    1
#define REG_NO_ACK_ADJUST_WIDTH    1

/* TXOP_JUMP_TABLE_BASE */
#define REG_TXOP_JUMP_TABLE_BASE          0x450
#define REG_TXOP_JUMP_TABLE_BASE_MASK     0x00ffffc0
#define REG_TXOP_JUMP_TABLE_BASE_SHIFT    6
#define REG_TXOP_JUMP_TABLE_BASE_WIDTH    18

/* TS8 */
#define REG_TS8          0x454
#define REG_TS8_MASK     0x00000007
#define REG_TS8_SHIFT    0
#define REG_TS8_WIDTH    3

/* TS9 */
#define REG_TS9          0x454
#define REG_TS9_MASK     0x00000070
#define REG_TS9_SHIFT    4
#define REG_TS9_WIDTH    3

/* TS10 */
#define REG_TS10          0x454
#define REG_TS10_MASK     0x00000700
#define REG_TS10_SHIFT    8
#define REG_TS10_WIDTH    3

/* TS11 */
#define REG_TS11          0x454
#define REG_TS11_MASK     0x00007000
#define REG_TS11_SHIFT    12
#define REG_TS11_WIDTH    3

/* TS12 */
#define REG_TS12          0x454
#define REG_TS12_MASK     0x00070000
#define REG_TS12_SHIFT    16
#define REG_TS12_WIDTH    3

/* TS13 */
#define REG_TS13          0x454
#define REG_TS13_MASK     0x00700000
#define REG_TS13_SHIFT    20
#define REG_TS13_WIDTH    3

/* TS14 */
#define REG_TS14          0x454
#define REG_TS14_MASK     0x07000000
#define REG_TS14_SHIFT    24
#define REG_TS14_WIDTH    3

/* TS15 */
#define REG_TS15          0x454
#define REG_TS15_MASK     0x70000000
#define REG_TS15_SHIFT    28
#define REG_TS15_WIDTH    3

/* WME_PRIORITY_MAP */
#define REG_WME_PRIORITY_MAP          0x458
#define REG_WME_PRIORITY_MAP_MASK     0x0000ffff
#define REG_WME_PRIORITY_MAP_SHIFT    0
#define REG_WME_PRIORITY_MAP_WIDTH    16

/* TXOP_DURATION_COMPENSATE */
#define REG_TXOP_DURATION_COMPENSATE          0x45c
#define REG_TXOP_DURATION_COMPENSATE_MASK     0x00003fff
#define REG_TXOP_DURATION_COMPENSATE_SHIFT    0
#define REG_TXOP_DURATION_COMPENSATE_WIDTH    14

/* FRAME_DURATION */
#define REG_FRAME_DURATION          0x460
#define REG_FRAME_DURATION_MASK     0x00003fff
#define REG_FRAME_DURATION_SHIFT    0
#define REG_FRAME_DURATION_WIDTH    14

/* TXOP_BUDGET_COMPENSATE */
#define REG_TXOP_BUDGET_COMPENSATE          0x464
#define REG_TXOP_BUDGET_COMPENSATE_MASK     0x00003fff
#define REG_TXOP_BUDGET_COMPENSATE_SHIFT    0
#define REG_TXOP_BUDGET_COMPENSATE_WIDTH    14

/* TXOP_BUDGET_AVAILABLE */
#define REG_TXOP_BUDGET_AVAILABLE          0x468
#define REG_TXOP_BUDGET_AVAILABLE_MASK     0x00000001
#define REG_TXOP_BUDGET_AVAILABLE_SHIFT    0
#define REG_TXOP_BUDGET_AVAILABLE_WIDTH    1

/* LATCHED_TXOP_LIMIT_COUNTER */
#define REG_LATCHED_TXOP_LIMIT_COUNTER          0x46c
#define REG_LATCHED_TXOP_LIMIT_COUNTER_MASK     0x00003fff
#define REG_LATCHED_TXOP_LIMIT_COUNTER_SHIFT    0
#define REG_LATCHED_TXOP_LIMIT_COUNTER_WIDTH    14

/* SNOOP_FIFO_ADDR */
#define REG_SNOOP_FIFO_ADDR          0x470
#define REG_SNOOP_FIFO_ADDR_MASK     0x000f00ff
#define REG_SNOOP_FIFO_ADDR_SHIFT    0
#define REG_SNOOP_FIFO_ADDR_WIDTH    12

/* CRC_USAGE_MODE */
#define REG_CRC_USAGE_MODE          0x474
#define REG_CRC_USAGE_MODE_MASK     0x00000001
#define REG_CRC_USAGE_MODE_SHIFT    0
#define REG_CRC_USAGE_MODE_WIDTH    1

/* SIFS_AND_PREAMBLE_LEGACY */
#define REG_SIFS_AND_PREAMBLE_LEGACY          0x478
#define REG_SIFS_AND_PREAMBLE_LEGACY_MASK     0x000000ff
#define REG_SIFS_AND_PREAMBLE_LEGACY_SHIFT    0
#define REG_SIFS_AND_PREAMBLE_LEGACY_WIDTH    8

/* SIFS_AND_PREAMBLE_11B_SHORT */
#define REG_SIFS_AND_PREAMBLE_11B_SHORT          0x478
#define REG_SIFS_AND_PREAMBLE_11B_SHORT_MASK     0x0000ff00
#define REG_SIFS_AND_PREAMBLE_11B_SHORT_SHIFT    8
#define REG_SIFS_AND_PREAMBLE_11B_SHORT_WIDTH    8

/* SIFS_AND_PREAMBLE_11B_LONG */
#define REG_SIFS_AND_PREAMBLE_11B_LONG          0x478
#define REG_SIFS_AND_PREAMBLE_11B_LONG_MASK     0x00ff0000
#define REG_SIFS_AND_PREAMBLE_11B_LONG_SHIFT    16
#define REG_SIFS_AND_PREAMBLE_11B_LONG_WIDTH    8

/* SIFS_AND_PREAMBLE_11N */
#define REG_SIFS_AND_PREAMBLE_11N          0x478
#define REG_SIFS_AND_PREAMBLE_11N_MASK     0xff000000
#define REG_SIFS_AND_PREAMBLE_11N_SHIFT    24
#define REG_SIFS_AND_PREAMBLE_11N_WIDTH    8

/* RATE_MASK */
/* UNDOCUMENTED - for confirmation of 11g feature */
#define REG_RATE_MASK          0x0480
#define REG_RATE_MASK_MASK     0x000000ff
#define REG_RATE_MASK_SHIFT    0
#define REG_RATE_MASK_WIDTH    8

/* TSF_FIELD_TIME1 */
#define REG_TSF_FIELD_TIME1          0x484
#define REG_TSF_FIELD_TIME1_MASK     0x01ffffff
#define REG_TSF_FIELD_TIME1_SHIFT    0
#define REG_TSF_FIELD_TIME1_WIDTH    25

/* TSF_FIELD_TIME2 */
#define REG_TSF_FIELD_TIME2          0x488
#define REG_TSF_FIELD_TIME2_MASK     0x01ffffff
#define REG_TSF_FIELD_TIME2_SHIFT    0
#define REG_TSF_FIELD_TIME2_WIDTH    25

/* TSF_FIELD_TIME3 */
#define REG_TSF_FIELD_TIME3          0x048c
#define REG_TSF_FIELD_TIME3_MASK     0x01ffffff
#define REG_TSF_FIELD_TIME3_SHIFT    0
#define REG_TSF_FIELD_TIME3_WIDTH    25

/* AUTO_REPLY_HT_SUPPORT_ENABLE */
#define REG_AUTO_REPLY_HT_SUPPORT_ENABLE          0x490
#define REG_AUTO_REPLY_HT_SUPPORT_ENABLE_MASK     0x00000001
#define REG_AUTO_REPLY_HT_SUPPORT_ENABLE_SHIFT    0
#define REG_AUTO_REPLY_HT_SUPPORT_ENABLE_WIDTH    1

/* ZERO_DURATION_OF_NON_FRAGMENT_ENABLE */
#define REG_ZERO_DURATION_OF_NON_FRAGMENT_ENABLE          0x490
#define REG_ZERO_DURATION_OF_NON_FRAGMENT_ENABLE_MASK     0x00000002
#define REG_ZERO_DURATION_OF_NON_FRAGMENT_ENABLE_SHIFT    1
#define REG_ZERO_DURATION_OF_NON_FRAGMENT_ENABLE_WIDTH    1

/* NAV_UPDATE_VALUE_AID */
#define REG_NAV_UPDATE_VALUE_AID          0x494
#define REG_NAV_UPDATE_VALUE_AID_MASK     0x0000ffff
#define REG_NAV_UPDATE_VALUE_AID_SHIFT    0
#define REG_NAV_UPDATE_VALUE_AID_WIDTH    16

/* RX_CONTROL */
/* Master Rx Enable switch */
#define REG_RX_CONTROL          0x0300
#define REG_RX_CONTROL_MASK     0x00000001
#define REG_RX_CONTROL_SHIFT    0
#define REG_RX_CONTROL_WIDTH    1

/* EARLY_ENABLE_DEASSERT */
/* Deassert PHY Enable for last word */
#define REG_EARLY_ENABLE_DEASSERT          0x0300
#define REG_EARLY_ENABLE_DEASSERT_MASK     0x00000002
#define REG_EARLY_ENABLE_DEASSERT_SHIFT    1
#define REG_EARLY_ENABLE_DEASSERT_WIDTH    1

/* FRAME_MARK_ENABLE */
/* Write an 0055aaFF marker at each frame boundary */
#define REG_FRAME_MARK_ENABLE          0x0300
#define REG_FRAME_MARK_ENABLE_MASK     0x00000008
#define REG_FRAME_MARK_ENABLE_SHIFT    3
#define REG_FRAME_MARK_ENABLE_WIDTH    1

/* RX_BUFFER_SIZE */
/* Rx Buffer size = 2^(12+rx_buffer_size), range 010 => 4K4M */
#define REG_RX_BUFFER_SIZE          0x0300
#define REG_RX_BUFFER_SIZE_MASK     0x000000f0
#define REG_RX_BUFFER_SIZE_SHIFT    4
#define REG_RX_BUFFER_SIZE_WIDTH    4

/* RESERVED_STORAGE_SIZE */
/* No of 32-bit words at start of Rx record */
#define REG_RESERVED_STORAGE_SIZE          0x0300
#define REG_RESERVED_STORAGE_SIZE_MASK     0x00003f00
#define REG_RESERVED_STORAGE_SIZE_SHIFT    8
#define REG_RESERVED_STORAGE_SIZE_WIDTH    6

/* UNUSED36 */
#define REG_UNUSED36          0x0300
#define REG_UNUSED36_MASK     0x00004000
#define REG_UNUSED36_SHIFT    14
#define REG_UNUSED36_WIDTH    1

/* KEEP_BAD_FRAMES */
/* Retain frames when PHY ERROR indicated */
#define REG_KEEP_BAD_FRAMES          0x0300
#define REG_KEEP_BAD_FRAMES_MASK     0x00008000
#define REG_KEEP_BAD_FRAMES_SHIFT    15
#define REG_KEEP_BAD_FRAMES_WIDTH    1

/* AUTO_DISCARD */
/* Discard frames selected by decision matrix (RXD) */
#define REG_AUTO_DISCARD          0x0300
#define REG_AUTO_DISCARD_MASK     0x00010000
#define REG_AUTO_DISCARD_SHIFT    16
#define REG_AUTO_DISCARD_WIDTH    1

/* AUTO_KEEP */
/* Retain only frames selected by decision matrix (RXD) */
#define REG_AUTO_KEEP          0x0300
#define REG_AUTO_KEEP_MASK     0x00020000
#define REG_AUTO_KEEP_SHIFT    17
#define REG_AUTO_KEEP_WIDTH    1

/* CCA */
/* PHY CCA */
#define REG_CCA          0x0300
#define REG_CCA_MASK     0x00040000
#define REG_CCA_SHIFT    18
#define REG_CCA_WIDTH    1

/* CCA_VALID */
/* PHY CCA is valid */
#define REG_CCA_VALID          0x0300
#define REG_CCA_VALID_MASK     0x00080000
#define REG_CCA_VALID_SHIFT    19
#define REG_CCA_VALID_WIDTH    1

/* RX_BUFFER_NEAR_FULL */
/* Space < near_full_threshold */
#define REG_RX_BUFFER_NEAR_FULL          0x0300
#define REG_RX_BUFFER_NEAR_FULL_MASK     0x00100000
#define REG_RX_BUFFER_NEAR_FULL_SHIFT    20
#define REG_RX_BUFFER_NEAR_FULL_WIDTH    1

/* RX_BUFFER_OVERFLOW */
/* RO, Write '1' to clear */
#define REG_RX_BUFFER_OVERFLOW          0x0300
#define REG_RX_BUFFER_OVERFLOW_MASK     0x00200000
#define REG_RX_BUFFER_OVERFLOW_SHIFT    21
#define REG_RX_BUFFER_OVERFLOW_WIDTH    1

/* RX_FIFO_OVERFLOW */
/* RO, Write '1' to clear */
#define REG_RX_FIFO_OVERFLOW          0x0300
#define REG_RX_FIFO_OVERFLOW_MASK     0x00400000
#define REG_RX_FIFO_OVERFLOW_SHIFT    22
#define REG_RX_FIFO_OVERFLOW_WIDTH    1

/* RECEIVE_BUSY */
/* Write PHY Status after received frame */
#define REG_RECEIVE_BUSY          0x0300
#define REG_RECEIVE_BUSY_MASK     0x00800000
#define REG_RECEIVE_BUSY_SHIFT    23
#define REG_RECEIVE_BUSY_WIDTH    1

/* APPEND_STATUS */
/* Append late-sampled PHY Status to received frame */
#define REG_APPEND_STATUS          0x0300
#define REG_APPEND_STATUS_MASK     0x01000000
#define REG_APPEND_STATUS_SHIFT    24
#define REG_APPEND_STATUS_WIDTH    1

/* APPEND_CRC */
/* Replace appended PHY Status(31) with CRC Error bit */
#define REG_APPEND_CRC          0x0300
#define REG_APPEND_CRC_MASK     0x02000000
#define REG_APPEND_CRC_SHIFT    25
#define REG_APPEND_CRC_WIDTH    1

/* RX_BUFFER_IN_POINTER */
/* maintained by H/W */
#define REG_RX_BUFFER_IN_POINTER          0x0304
#define REG_RX_BUFFER_IN_POINTER_MASK     0x003ffffc
#define REG_RX_BUFFER_IN_POINTER_SHIFT    2
#define REG_RX_BUFFER_IN_POINTER_WIDTH    20

/* RX_BUFFER_OUT_POINTER */
/* maintained by S/W */
#define REG_RX_BUFFER_OUT_POINTER          0x0308
#define REG_RX_BUFFER_OUT_POINTER_MASK     0x003ffffc
#define REG_RX_BUFFER_OUT_POINTER_SHIFT    2
#define REG_RX_BUFFER_OUT_POINTER_WIDTH    20

/* NEAR_FULL_THRESHOLD */
#define REG_NEAR_FULL_THRESHOLD          0x030c
#define REG_NEAR_FULL_THRESHOLD_MASK     0x000001fc
#define REG_NEAR_FULL_THRESHOLD_SHIFT    2
#define REG_NEAR_FULL_THRESHOLD_WIDTH    7

/* CCA_VALID_DELAY */
#define REG_CCA_VALID_DELAY          0x0310
#define REG_CCA_VALID_DELAY_MASK     0x000007ff
#define REG_CCA_VALID_DELAY_SHIFT    0
#define REG_CCA_VALID_DELAY_WIDTH    11

/* REDUCED_FREQ_CCA_VALID_DELAY */
#define REG_REDUCED_FREQ_CCA_VALID_DELAY          0x0310
#define REG_REDUCED_FREQ_CCA_VALID_DELAY_MASK     0x07ff0000
#define REG_REDUCED_FREQ_CCA_VALID_DELAY_SHIFT    16
#define REG_REDUCED_FREQ_CCA_VALID_DELAY_WIDTH    11

/* CCA_IFS_COMPENSATION */
#define REG_CCA_IFS_COMPENSATION          0x0314
#define REG_CCA_IFS_COMPENSATION_MASK     0x000007ff
#define REG_CCA_IFS_COMPENSATION_SHIFT    0
#define REG_CCA_IFS_COMPENSATION_WIDTH    11

/* REDUCED_FREQ_CCA_IFS_COMPENSATION */
#define REG_REDUCED_FREQ_CCA_IFS_COMPENSATION          0x0314
#define REG_REDUCED_FREQ_CCA_IFS_COMPENSATION_MASK     0x07ff0000
#define REG_REDUCED_FREQ_CCA_IFS_COMPENSATION_SHIFT    16
#define REG_REDUCED_FREQ_CCA_IFS_COMPENSATION_WIDTH    11

/* RXRDY_IFS_COMPENSATION */
#define REG_RXRDY_IFS_COMPENSATION          0x0318
#define REG_RXRDY_IFS_COMPENSATION_MASK     0x000007ff
#define REG_RXRDY_IFS_COMPENSATION_SHIFT    0
#define REG_RXRDY_IFS_COMPENSATION_WIDTH    11

/* REDUCED_FREQ_RXRDY_IFS_COMPENSATION */
#define REG_REDUCED_FREQ_RXRDY_IFS_COMPENSATION          0x0318
#define REG_REDUCED_FREQ_RXRDY_IFS_COMPENSATION_MASK     0x07ff0000
#define REG_REDUCED_FREQ_RXRDY_IFS_COMPENSATION_SHIFT    16
#define REG_REDUCED_FREQ_RXRDY_IFS_COMPENSATION_WIDTH    11

/* RXC_STATE */
#define REG_RXC_STATE          0x031c
#define REG_RXC_STATE_MASK     0x0000000f
#define REG_RXC_STATE_SHIFT    0
#define REG_RXC_STATE_WIDTH    4

/* RX_APPEND_STATUS_ENABLE */
#define REG_RX_APPEND_STATUS_ENABLE          0x320
#define REG_RX_APPEND_STATUS_ENABLE_MASK     0x00000001
#define REG_RX_APPEND_STATUS_ENABLE_SHIFT    0
#define REG_RX_APPEND_STATUS_ENABLE_WIDTH    1

/* RX_APPEND_STATUS_OFFSET */
#define REG_RX_APPEND_STATUS_OFFSET          0x320
#define REG_RX_APPEND_STATUS_OFFSET_MASK     0x0000001e
#define REG_RX_APPEND_STATUS_OFFSET_SHIFT    1
#define REG_RX_APPEND_STATUS_OFFSET_WIDTH    4

/* MT_FORCE_HW_CCA */
#define REG_MT_FORCE_HW_CCA          0x324
#define REG_MT_FORCE_HW_CCA_MASK     0x00000001
#define REG_MT_FORCE_HW_CCA_SHIFT    0
#define REG_MT_FORCE_HW_CCA_WIDTH    1

/* MT_FORCE_SW_CCA */
#define REG_MT_FORCE_SW_CCA          0x324
#define REG_MT_FORCE_SW_CCA_MASK     0x00000002
#define REG_MT_FORCE_SW_CCA_SHIFT    1
#define REG_MT_FORCE_SW_CCA_WIDTH    1

/* MT_FORCED_SW_CCA */
#define REG_MT_FORCED_SW_CCA          0x324
#define REG_MT_FORCED_SW_CCA_MASK     0x00000004
#define REG_MT_FORCED_SW_CCA_SHIFT    2
#define REG_MT_FORCED_SW_CCA_WIDTH    1

/* FULL_TSF */
#define REG_FULL_TSF          0x334
#define REG_FULL_TSF_MASK     0x00000001
#define REG_FULL_TSF_SHIFT    0
#define REG_FULL_TSF_WIDTH    1

/* READY_FIX_ENABLE_ADDR */
#define REG_READY_FIX_ENABLE_ADDR          0x338
#define REG_READY_FIX_ENABLE_ADDR_MASK     0x00000001
#define REG_READY_FIX_ENABLE_ADDR_SHIFT    0
#define REG_READY_FIX_ENABLE_ADDR_WIDTH    1

/* BF_ENTRY_BASE_ADDRESS */
#define REG_BF_ENTRY_BASE_ADDRESS          0x33c
#define REG_BF_ENTRY_BASE_ADDRESS_MASK     0x00ffffff
#define REG_BF_ENTRY_BASE_ADDRESS_SHIFT    0
#define REG_BF_ENTRY_BASE_ADDRESS_WIDTH    24

/* BF_ASCENDING_ORDER_TABLE_31_0 */
#define REG_BF_ASCENDING_ORDER_TABLE_31_0          0x340
#define REG_BF_ASCENDING_ORDER_TABLE_31_0_MASK     0xffffffff
#define REG_BF_ASCENDING_ORDER_TABLE_31_0_SHIFT    0
#define REG_BF_ASCENDING_ORDER_TABLE_31_0_WIDTH    32

/* BF_ASCENDING_ORDER_TABLE_63_32 */
#define REG_BF_ASCENDING_ORDER_TABLE_63_32          0x344
#define REG_BF_ASCENDING_ORDER_TABLE_63_32_MASK     0xffffffff
#define REG_BF_ASCENDING_ORDER_TABLE_63_32_SHIFT    0
#define REG_BF_ASCENDING_ORDER_TABLE_63_32_WIDTH    32

/* BF_LAST_RELIABELY_USED_TABLE_31_0 */
#define REG_BF_LAST_RELIABELY_USED_TABLE_31_0          0x348
#define REG_BF_LAST_RELIABELY_USED_TABLE_31_0_MASK     0xffffffff
#define REG_BF_LAST_RELIABELY_USED_TABLE_31_0_SHIFT    0
#define REG_BF_LAST_RELIABELY_USED_TABLE_31_0_WIDTH    32

/* BF_LAST_RELIABELY_USED_TABLE_63_32 */
#define REG_BF_LAST_RELIABELY_USED_TABLE_63_32          0x34c
#define REG_BF_LAST_RELIABELY_USED_TABLE_63_32_MASK     0xffffffff
#define REG_BF_LAST_RELIABELY_USED_TABLE_63_32_SHIFT    0
#define REG_BF_LAST_RELIABELY_USED_TABLE_63_32_WIDTH    32

/* BF_SUPPORTED_TABLE */
#define REG_BF_SUPPORTED_TABLE          0x350
#define REG_BF_SUPPORTED_TABLE_MASK     0x0000ffff
#define REG_BF_SUPPORTED_TABLE_SHIFT    0
#define REG_BF_SUPPORTED_TABLE_WIDTH    16

/* BF_RX_ONLY_EXPLICIT_MODE */
#define REG_BF_RX_ONLY_EXPLICIT_MODE          0x354
#define REG_BF_RX_ONLY_EXPLICIT_MODE_MASK     0x00000001
#define REG_BF_RX_ONLY_EXPLICIT_MODE_SHIFT    0
#define REG_BF_RX_ONLY_EXPLICIT_MODE_WIDTH    1

/* BF_HALF_NUM_CLKS_AFTER_ENABLE */
#define REG_BF_HALF_NUM_CLKS_AFTER_ENABLE          0x358
#define REG_BF_HALF_NUM_CLKS_AFTER_ENABLE_MASK     0x0000000f
#define REG_BF_HALF_NUM_CLKS_AFTER_ENABLE_SHIFT    0
#define REG_BF_HALF_NUM_CLKS_AFTER_ENABLE_WIDTH    4

/* BF_NUM_CLKS_TX_VALID */
#define REG_BF_NUM_CLKS_TX_VALID          0x358
#define REG_BF_NUM_CLKS_TX_VALID_MASK     0x000003f0
#define REG_BF_NUM_CLKS_TX_VALID_SHIFT    4
#define REG_BF_NUM_CLKS_TX_VALID_WIDTH    6

/* BF_NUM_EXPLICIT_ENTRIES */
#define REG_BF_NUM_EXPLICIT_ENTRIES          0x35c
#define REG_BF_NUM_EXPLICIT_ENTRIES_MASK     0x00000007
#define REG_BF_NUM_EXPLICIT_ENTRIES_SHIFT    0
#define REG_BF_NUM_EXPLICIT_ENTRIES_WIDTH    3

/* BF_SEMAPHORE_ENTRY_INDEX */
#define REG_BF_SEMAPHORE_ENTRY_INDEX          0x360
#define REG_BF_SEMAPHORE_ENTRY_INDEX_MASK     0x0000001f
#define REG_BF_SEMAPHORE_ENTRY_INDEX_SHIFT    0
#define REG_BF_SEMAPHORE_ENTRY_INDEX_WIDTH    5

/* BF_SEMAPHORE_DATABASE */
#define REG_BF_SEMAPHORE_DATABASE          0x360
#define REG_BF_SEMAPHORE_DATABASE_MASK     0x00000020
#define REG_BF_SEMAPHORE_DATABASE_SHIFT    5
#define REG_BF_SEMAPHORE_DATABASE_WIDTH    1

/* BF_RX_DEBUG_BYPASS */
#define REG_BF_RX_DEBUG_BYPASS          0x364
#define REG_BF_RX_DEBUG_BYPASS_MASK     0x00000001
#define REG_BF_RX_DEBUG_BYPASS_SHIFT    0
#define REG_BF_RX_DEBUG_BYPASS_WIDTH    1

/* BF_TX_DEBUG_BYPASS */
#define REG_BF_TX_DEBUG_BYPASS          0x364
#define REG_BF_TX_DEBUG_BYPASS_MASK     0x00000002
#define REG_BF_TX_DEBUG_BYPASS_SHIFT    1
#define REG_BF_TX_DEBUG_BYPASS_WIDTH    1

/* TX_STATE_MACHINE */
#define REG_TX_STATE_MACHINE          0x368
#define REG_TX_STATE_MACHINE_MASK     0x00000007
#define REG_TX_STATE_MACHINE_SHIFT    0
#define REG_TX_STATE_MACHINE_WIDTH    3

/* RX_STATE_MACHINE */
#define REG_RX_STATE_MACHINE          0x368
#define REG_RX_STATE_MACHINE_MASK     0x00000038
#define REG_RX_STATE_MACHINE_SHIFT    3
#define REG_RX_STATE_MACHINE_WIDTH    3

/* TABLE_ASCENDING_ORDER_STATE_MACHINE */
#define REG_TABLE_ASCENDING_ORDER_STATE_MACHINE          0x368
#define REG_TABLE_ASCENDING_ORDER_STATE_MACHINE_MASK     0x000000c0
#define REG_TABLE_ASCENDING_ORDER_STATE_MACHINE_SHIFT    6
#define REG_TABLE_ASCENDING_ORDER_STATE_MACHINE_WIDTH    2

/* ADDRESS_TO_INDEX_STATE_MACHINE */
#define REG_ADDRESS_TO_INDEX_STATE_MACHINE          0x368
#define REG_ADDRESS_TO_INDEX_STATE_MACHINE_MASK     0x00000300
#define REG_ADDRESS_TO_INDEX_STATE_MACHINE_SHIFT    8
#define REG_ADDRESS_TO_INDEX_STATE_MACHINE_WIDTH    2

/* EXPLICIT_INDEX_STATE_MACHINE */
#define REG_EXPLICIT_INDEX_STATE_MACHINE          0x368
#define REG_EXPLICIT_INDEX_STATE_MACHINE_MASK     0x00000c00
#define REG_EXPLICIT_INDEX_STATE_MACHINE_SHIFT    10
#define REG_EXPLICIT_INDEX_STATE_MACHINE_WIDTH    2

/* NUMBER_OF_IMPLICIT_ENTRIES */
#define REG_NUMBER_OF_IMPLICIT_ENTRIES          0x368
#define REG_NUMBER_OF_IMPLICIT_ENTRIES_MASK     0x0001f000
#define REG_NUMBER_OF_IMPLICIT_ENTRIES_SHIFT    12
#define REG_NUMBER_OF_IMPLICIT_ENTRIES_WIDTH    5

/* BF_RX_STATISTIC_COUNTER */
#define REG_BF_RX_STATISTIC_COUNTER          0x36c
#define REG_BF_RX_STATISTIC_COUNTER_MASK     0x0000ffff
#define REG_BF_RX_STATISTIC_COUNTER_SHIFT    0
#define REG_BF_RX_STATISTIC_COUNTER_WIDTH    16

/* BF_TX_STATISTIC_COUNTER */
#define REG_BF_TX_STATISTIC_COUNTER          0x370
#define REG_BF_TX_STATISTIC_COUNTER_MASK     0x0000ffff
#define REG_BF_TX_STATISTIC_COUNTER_SHIFT    0
#define REG_BF_TX_STATISTIC_COUNTER_WIDTH    16

/* BF_ENABLE */
#define REG_BF_ENABLE          0x374
#define REG_BF_ENABLE_MASK     0x00000001
#define REG_BF_ENABLE_SHIFT    0
#define REG_BF_ENABLE_WIDTH    1

/* BASE_0 */
#define REG_BASE_0          0x0200
#define REG_BASE_0_MASK     0x007ffffc
#define REG_BASE_0_SHIFT    2
#define REG_BASE_0_WIDTH    21

/* BASE_1 */
#define REG_BASE_1          0x0204
#define REG_BASE_1_MASK     0x007ffffc
#define REG_BASE_1_SHIFT    2
#define REG_BASE_1_WIDTH    21

/* BASE_2 */
#define REG_BASE_2          0x0208
#define REG_BASE_2_MASK     0x007ffffc
#define REG_BASE_2_SHIFT    2
#define REG_BASE_2_WIDTH    21

/* BASE_3 */
#define REG_BASE_3          0x020c
#define REG_BASE_3_MASK     0x007ffffc
#define REG_BASE_3_SHIFT    2
#define REG_BASE_3_WIDTH    21

/* BASE_4 */
#define REG_BASE_4          0x0210
#define REG_BASE_4_MASK     0x007ffffc
#define REG_BASE_4_SHIFT    2
#define REG_BASE_4_WIDTH    21

/* BASE_5 */
#define REG_BASE_5          0x0214
#define REG_BASE_5_MASK     0x007ffffc
#define REG_BASE_5_SHIFT    2
#define REG_BASE_5_WIDTH    21

/* BASE_6 */
#define REG_BASE_6          0x0218
#define REG_BASE_6_MASK     0x007ffffc
#define REG_BASE_6_SHIFT    2
#define REG_BASE_6_WIDTH    21

/* RETURN_ADDRESS */
#define REG_RETURN_ADDRESS          0x021c
#define REG_RETURN_ADDRESS_MASK     0x007ffffc
#define REG_RETURN_ADDRESS_SHIFT    2
#define REG_RETURN_ADDRESS_WIDTH    21

/* RECIPE_POINTER */
#define REG_RECIPE_POINTER          0x0220
#define REG_RECIPE_POINTER_MASK     0x007ffffc
#define REG_RECIPE_POINTER_SHIFT    2
#define REG_RECIPE_POINTER_WIDTH    21

/* DELIA_STATUS */
#define REG_DELIA_STATUS          0x0224
#define REG_DELIA_STATUS_MASK     0x00000001
#define REG_DELIA_STATUS_SHIFT    0
#define REG_DELIA_STATUS_WIDTH    1

/* IFS_COMPENSATION */
/* Delay from TX_PHY_READY fall to last bit on air */
#define REG_IFS_COMPENSATION          0x0228
#define REG_IFS_COMPENSATION_MASK     0x0000ffff
#define REG_IFS_COMPENSATION_SHIFT    0
#define REG_IFS_COMPENSATION_WIDTH    16

/* REDUCED_FREQ_IFS_COMPENSATION */
/* Delay from TX_PHY_READY fall to last bit on air */
#define REG_REDUCED_FREQ_IFS_COMPENSATION          0x0228
#define REG_REDUCED_FREQ_IFS_COMPENSATION_MASK     0xffff0000
#define REG_REDUCED_FREQ_IFS_COMPENSATION_SHIFT    16
#define REG_REDUCED_FREQ_IFS_COMPENSATION_WIDTH    16

/* CCA_COMPENSATION */
/* Delay from TX_PHY_READY fall to CCA refernce point; must be greater than ifs_compensation */
#define REG_CCA_COMPENSATION          0x022c
#define REG_CCA_COMPENSATION_MASK     0x0000ffff
#define REG_CCA_COMPENSATION_SHIFT    0
#define REG_CCA_COMPENSATION_WIDTH    16

/* REDUCED_FREQ_CCA_COMPENSATION */
/* Delay from TX_PHY_READY fall to CCA refernce point; must be greater than ifs_compensation */
#define REG_REDUCED_FREQ_CCA_COMPENSATION          0x022c
#define REG_REDUCED_FREQ_CCA_COMPENSATION_MASK     0xffff0000
#define REG_REDUCED_FREQ_CCA_COMPENSATION_SHIFT    16
#define REG_REDUCED_FREQ_CCA_COMPENSATION_WIDTH    16

/* PHY_AUTO_START */
#define REG_PHY_AUTO_START          0x230
#define REG_PHY_AUTO_START_MASK     0x00000001
#define REG_PHY_AUTO_START_SHIFT    0
#define REG_PHY_AUTO_START_WIDTH    1

/* EXPLICIT_RATE_MASK */
#define REG_EXPLICIT_RATE_MASK          0x230
#define REG_EXPLICIT_RATE_MASK_MASK     0x0000ff00
#define REG_EXPLICIT_RATE_MASK_SHIFT    8
#define REG_EXPLICIT_RATE_MASK_WIDTH    8

/* INDEXED_JUMP_ADDR */
#define REG_INDEXED_JUMP_ADDR          0x234
#define REG_INDEXED_JUMP_ADDR_MASK     0x007ffffc
#define REG_INDEXED_JUMP_ADDR_SHIFT    2
#define REG_INDEXED_JUMP_ADDR_WIDTH    21

/* DELIA_WORD_COUNT */
#define REG_DELIA_WORD_COUNT          0x238
#define REG_DELIA_WORD_COUNT_MASK     0x0000ffff
#define REG_DELIA_WORD_COUNT_SHIFT    0
#define REG_DELIA_WORD_COUNT_WIDTH    16

/* LAST_FETCHED_INSTRUCTION */
#define REG_LAST_FETCHED_INSTRUCTION          0x23c
#define REG_LAST_FETCHED_INSTRUCTION_MASK     0xffffffff
#define REG_LAST_FETCHED_INSTRUCTION_SHIFT    0
#define REG_LAST_FETCHED_INSTRUCTION_WIDTH    32

/* AUTO_POWER_MODE */
#define REG_AUTO_POWER_MODE          0x240
#define REG_AUTO_POWER_MODE_MASK     0x00000001
#define REG_AUTO_POWER_MODE_SHIFT    0
#define REG_AUTO_POWER_MODE_WIDTH    1

/* AUTO_IS_QBF_MODE */
#define REG_AUTO_IS_QBF_MODE          0x240
#define REG_AUTO_IS_QBF_MODE_MASK     0x00000002
#define REG_AUTO_IS_QBF_MODE_SHIFT    1
#define REG_AUTO_IS_QBF_MODE_WIDTH    1

/* AUTO_NELTF_MODE */
#define REG_AUTO_NELTF_MODE          0x240
#define REG_AUTO_NELTF_MODE_MASK     0x00000004
#define REG_AUTO_NELTF_MODE_SHIFT    2
#define REG_AUTO_NELTF_MODE_WIDTH    1

/* AUTO_NOT_SOUNDING_MODE */
#define REG_AUTO_NOT_SOUNDING_MODE          0x240
#define REG_AUTO_NOT_SOUNDING_MODE_MASK     0x00000008
#define REG_AUTO_NOT_SOUNDING_MODE_SHIFT    3
#define REG_AUTO_NOT_SOUNDING_MODE_WIDTH    1

/* AUTO_SMOOTHING_MODE */
#define REG_AUTO_SMOOTHING_MODE          0x240
#define REG_AUTO_SMOOTHING_MODE_MASK     0x00000010
#define REG_AUTO_SMOOTHING_MODE_SHIFT    4
#define REG_AUTO_SMOOTHING_MODE_WIDTH    1

/* READ DATA */
/* fsdu_fifo_status */
#define REG_READ_DATA          0x244
#define REG_READ_DATA_MASK     0x0001fffc
#define REG_READ_DATA_SHIFT    2
#define REG_READ_DATA_WIDTH    15

/* BYTES_IN_FIFO */
/* bytes_in_fifo */
#define REG_BYTES_IN_FIFO          0x244
#define REG_BYTES_IN_FIFO_MASK     0x01f00000
#define REG_BYTES_IN_FIFO_SHIFT    20
#define REG_BYTES_IN_FIFO_WIDTH    5

/* FSDU_FIFO_FULL */
/* fsdu_fifo_full */
#define REG_FSDU_FIFO_FULL          0x244
#define REG_FSDU_FIFO_FULL_MASK     0x40000000
#define REG_FSDU_FIFO_FULL_SHIFT    30
#define REG_FSDU_FIFO_FULL_WIDTH    1

/* FSDU_FIFO_EMPTY */
/* fsdu_fifo_empty */
#define REG_FSDU_FIFO_EMPTY          0x244
#define REG_FSDU_FIFO_EMPTY_MASK     0x80000000
#define REG_FSDU_FIFO_EMPTY_SHIFT    31
#define REG_FSDU_FIFO_EMPTY_WIDTH    1

/* CLEAN FIFO */
/* clean fifo */
#define REG_CLEAN_FIFO          0x248
#define REG_CLEAN_FIFO_MASK     0x00000001
#define REG_CLEAN_FIFO_SHIFT    0
#define REG_CLEAN_FIFO_WIDTH    1

/* EVENT_ENABLE */
/* Set each bit to enable event generation for the corresponding event */
#define REG_EVENT_ENABLE          0x0100
#define REG_EVENT_ENABLE_MASK     0x3fffffff
#define REG_EVENT_ENABLE_SHIFT    0
#define REG_EVENT_ENABLE_WIDTH    30

/* RX_ENABLE */
/* Set each bit to enable the corresponding receive condition to take part in rx_enable generation.  Bit 24 is for received frames which match none of the conditions. */
#define REG_RX_ENABLE          0x0104
#define REG_RX_ENABLE_MASK     0x7fffffff
#define REG_RX_ENABLE_SHIFT    0
#define REG_RX_ENABLE_WIDTH    31

/* ALL_EVENTS */
/* Each bit indicates that the corresponding event is active. */
#define REG_ALL_EVENTS          0x0108
#define REG_ALL_EVENTS_MASK     0x3fffffff
#define REG_ALL_EVENTS_SHIFT    0
#define REG_ALL_EVENTS_WIDTH    30

/* CRC_ERROR */
/* Generate frame abort on CRC error */
#define REG_CRC_ERROR          0x010c
#define REG_CRC_ERROR_MASK     0x00000004
#define REG_CRC_ERROR_SHIFT    2
#define REG_CRC_ERROR_WIDTH    1

/* PHY_ERROR */
/* Generate frame abort on error signalled by PHY */
#define REG_PHY_ERROR          0x010c
#define REG_PHY_ERROR_MASK     0x00000002
#define REG_PHY_ERROR_SHIFT    1
#define REG_PHY_ERROR_WIDTH    1

/* OVERFLOW_ABORT */
/* Generate frame abort on Input FIFO or Receive Buffer overflow */
#define REG_OVERFLOW_ABORT          0x010c
#define REG_OVERFLOW_ABORT_MASK     0x00000001
#define REG_OVERFLOW_ABORT_SHIFT    0
#define REG_OVERFLOW_ABORT_WIDTH    1

/* CONDITION_0 */
/* Which matrix columns contribute to event 0 */
#define REG_CONDITION_0          0x0110
#define REG_CONDITION_0_MASK     0xffffffff
#define REG_CONDITION_0_SHIFT    0
#define REG_CONDITION_0_WIDTH    32

/* CONDITION_1 */
/* Which matrix columns contribute to event 1 */
#define REG_CONDITION_1          0x0114
#define REG_CONDITION_1_MASK     0xffffffff
#define REG_CONDITION_1_SHIFT    0
#define REG_CONDITION_1_WIDTH    32

/* CONDITION_2 */
/* Which matrix columns contribute to event 2 */
#define REG_CONDITION_2          0x0118
#define REG_CONDITION_2_MASK     0xffffffff
#define REG_CONDITION_2_SHIFT    0
#define REG_CONDITION_2_WIDTH    32

/* CONDITION_3 */
/* Which matrix columns contribute to event 3 */
#define REG_CONDITION_3          0x011c
#define REG_CONDITION_3_MASK     0xffffffff
#define REG_CONDITION_3_SHIFT    0
#define REG_CONDITION_3_WIDTH    32

/* CONDITION_4 */
/* Which matrix columns contribute to event 4 */
#define REG_CONDITION_4          0x0120
#define REG_CONDITION_4_MASK     0xffffffff
#define REG_CONDITION_4_SHIFT    0
#define REG_CONDITION_4_WIDTH    32

/* CONDITION_5 */
/* Which matrix columns contribute to event 5 */
#define REG_CONDITION_5          0x0124
#define REG_CONDITION_5_MASK     0xffffffff
#define REG_CONDITION_5_SHIFT    0
#define REG_CONDITION_5_WIDTH    32

/* CONDITION_6 */
/* Which matrix columns contribute to event 6 */
#define REG_CONDITION_6          0x0128
#define REG_CONDITION_6_MASK     0xffffffff
#define REG_CONDITION_6_SHIFT    0
#define REG_CONDITION_6_WIDTH    32

/* CONDITION_7 */
/* Which matrix columns contribute to event 7 */
#define REG_CONDITION_7          0x012c
#define REG_CONDITION_7_MASK     0xffffffff
#define REG_CONDITION_7_SHIFT    0
#define REG_CONDITION_7_WIDTH    32

/* CONDITION_8 */
/* Which matrix columns contribute to event 8 */
#define REG_CONDITION_8          0x0130
#define REG_CONDITION_8_MASK     0xffffffff
#define REG_CONDITION_8_SHIFT    0
#define REG_CONDITION_8_WIDTH    32

/* CONDITION_9 */
/* Which matrix columns contribute to event 9 */
#define REG_CONDITION_9          0x0134
#define REG_CONDITION_9_MASK     0xffffffff
#define REG_CONDITION_9_SHIFT    0
#define REG_CONDITION_9_WIDTH    32

/* CONDITION_10 */
/* Which matrix columns contribute to event 10 */
#define REG_CONDITION_10          0x0138
#define REG_CONDITION_10_MASK     0xffffffff
#define REG_CONDITION_10_SHIFT    0
#define REG_CONDITION_10_WIDTH    32

/* CONDITION_11 */
/* Which matrix columns contribute to event 11 */
#define REG_CONDITION_11          0x013c
#define REG_CONDITION_11_MASK     0xffffffff
#define REG_CONDITION_11_SHIFT    0
#define REG_CONDITION_11_WIDTH    32

/* CONDITION_12 */
/* Which matrix columns contribute to event 12 */
#define REG_CONDITION_12          0x0140
#define REG_CONDITION_12_MASK     0xffffffff
#define REG_CONDITION_12_SHIFT    0
#define REG_CONDITION_12_WIDTH    32

/* CONDITION_13 */
/* Which matrix columns contribute to event 13 */
#define REG_CONDITION_13          0x0144
#define REG_CONDITION_13_MASK     0xffffffff
#define REG_CONDITION_13_SHIFT    0
#define REG_CONDITION_13_WIDTH    32

/* CONDITION_14 */
/* Which matrix columns contribute to event 14 */
#define REG_CONDITION_14          0x0148
#define REG_CONDITION_14_MASK     0xffffffff
#define REG_CONDITION_14_SHIFT    0
#define REG_CONDITION_14_WIDTH    32

/* CONDITION_15 */
/* Which matrix columns contribute to event 15 */
#define REG_CONDITION_15          0x014c
#define REG_CONDITION_15_MASK     0xffffffff
#define REG_CONDITION_15_SHIFT    0
#define REG_CONDITION_15_WIDTH    32

/* CONDITION_16 */
/* Which matrix columns contribute to event 16 */
#define REG_CONDITION_16          0x0150
#define REG_CONDITION_16_MASK     0xffffffff
#define REG_CONDITION_16_SHIFT    0
#define REG_CONDITION_16_WIDTH    32

/* CONDITION_17 */
/* Which matrix columns contribute to event 17 */
#define REG_CONDITION_17          0x0154
#define REG_CONDITION_17_MASK     0xffffffff
#define REG_CONDITION_17_SHIFT    0
#define REG_CONDITION_17_WIDTH    32

/* CONDITION_18 */
/* Which matrix columns contribute to event 18 */
#define REG_CONDITION_18          0x0158
#define REG_CONDITION_18_MASK     0xffffffff
#define REG_CONDITION_18_SHIFT    0
#define REG_CONDITION_18_WIDTH    32

/* CONDITION_19 */
/* Which matrix columns contribute to event 19 */
#define REG_CONDITION_19          0x015c
#define REG_CONDITION_19_MASK     0xffffffff
#define REG_CONDITION_19_SHIFT    0
#define REG_CONDITION_19_WIDTH    32

/* CONDITION_20 */
/* Which matrix columns contribute to event 20 */
#define REG_CONDITION_20          0x0160
#define REG_CONDITION_20_MASK     0xffffffff
#define REG_CONDITION_20_SHIFT    0
#define REG_CONDITION_20_WIDTH    32

/* CONDITION_21 */
/* Which matrix columns contribute to event 21 */
#define REG_CONDITION_21          0x0164
#define REG_CONDITION_21_MASK     0xffffffff
#define REG_CONDITION_21_SHIFT    0
#define REG_CONDITION_21_WIDTH    32

/* CONDITION_22 */
/* Which matrix columns contribute to event 22 */
#define REG_CONDITION_22          0x0168
#define REG_CONDITION_22_MASK     0xffffffff
#define REG_CONDITION_22_SHIFT    0
#define REG_CONDITION_22_WIDTH    32

/* CONDITION_23 */
/* Which matrix columns contribute to event 23 */
#define REG_CONDITION_23          0x016c
#define REG_CONDITION_23_MASK     0xffffffff
#define REG_CONDITION_23_SHIFT    0
#define REG_CONDITION_23_WIDTH    32

/* CONDITION_24 */
/* Which matrix columns contribute to event 24 */
#define REG_CONDITION_24          0x0170
#define REG_CONDITION_24_MASK     0xffffffff
#define REG_CONDITION_24_SHIFT    0
#define REG_CONDITION_24_WIDTH    32

/* CONDITION_25 */
/* Which matrix columns contribute to event 25 */
#define REG_CONDITION_25          0x0174
#define REG_CONDITION_25_MASK     0xffffffff
#define REG_CONDITION_25_SHIFT    0
#define REG_CONDITION_25_WIDTH    32

/* CONDITION_26 */
/* Which matrix columns contribute to event 26 */
#define REG_CONDITION_26          0x0178
#define REG_CONDITION_26_MASK     0xffffffff
#define REG_CONDITION_26_SHIFT    0
#define REG_CONDITION_26_WIDTH    32

/* CONDITION_27 */
/* Which matrix columns contribute to event 27 */
#define REG_CONDITION_27          0x017c
#define REG_CONDITION_27_MASK     0xffffffff
#define REG_CONDITION_27_SHIFT    0
#define REG_CONDITION_27_WIDTH    32

/* CONDITION_28 */
/* Which matrix columns contribute to event 28 */
#define REG_CONDITION_28          0x0180
#define REG_CONDITION_28_MASK     0xffffffff
#define REG_CONDITION_28_SHIFT    0
#define REG_CONDITION_28_WIDTH    32

/* CONDITION_29 */
/* Which matrix columns contribute to event 29 */
#define REG_CONDITION_29          0x0184
#define REG_CONDITION_29_MASK     0xffffffff
#define REG_CONDITION_29_SHIFT    0
#define REG_CONDITION_29_WIDTH    32

/* ACCUM_ENABLE */
/* For each receive condition, 1 = accumulate air time for frames matching this event.  Bit 24 is for received frames which match none of the conditions. */
#define REG_ACCUM_ENABLE          0x01a0
#define REG_ACCUM_ENABLE_MASK     0x7fffffff
#define REG_ACCUM_ENABLE_SHIFT    0
#define REG_ACCUM_ENABLE_WIDTH    31

/* DO_NOT_ACK_19 */
/* Connect "Do Not Ack" to column 19 in place of byte filter 11 */
#define REG_DO_NOT_ACK_19          0x01a4
#define REG_DO_NOT_ACK_19_MASK     0x00000001
#define REG_DO_NOT_ACK_19_SHIFT    0
#define REG_DO_NOT_ACK_19_WIDTH    1

/* CONTROL_CONCAT_27 */
/* Connect "Concat 27" to column 27 to recognize aggregate */
#define REG_CONTROL_CONCAT_27          0x01a4
#define REG_CONTROL_CONCAT_27_MASK     0x00000002
#define REG_CONTROL_CONCAT_27_SHIFT    1
#define REG_CONTROL_CONCAT_27_WIDTH    1

/*  RX_SYNC_EVENT_ENABLE */
#define REG_RX_SYNC_EVENT_ENABLE          0x01a8
#define REG_RX_SYNC_EVENT_ENABLE_MASK     0x3fffffff
#define REG_RX_SYNC_EVENT_ENABLE_SHIFT    0
#define REG_RX_SYNC_EVENT_ENABLE_WIDTH    30

/* BYTE_FILTER_CONTROL_0 */
#define REG_BYTE_FILTER_CONTROL_0          0x00
#define REG_BYTE_FILTER_CONTROL_0_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_0_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_0_WIDTH    8

/* MASK_FILTER_CONTROL_0 */
#define REG_MASK_FILTER_CONTROL_0          0x00
#define REG_MASK_FILTER_CONTROL_0_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_0_SHIFT    8
#define REG_MASK_FILTER_CONTROL_0_WIDTH    8

/* OFFSET_FILTER_CONTROL_0 */
#define REG_OFFSET_FILTER_CONTROL_0          0x00
#define REG_OFFSET_FILTER_CONTROL_0_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_0_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_0_WIDTH    8

/* BYTE_FILTER_CONTROL_1 */
#define REG_BYTE_FILTER_CONTROL_1          0x04
#define REG_BYTE_FILTER_CONTROL_1_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_1_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_1_WIDTH    8

/* MASKFILTER_CONTROL_1 */
#define REG_MASKFILTER_CONTROL_1          0x04
#define REG_MASKFILTER_CONTROL_1_MASK     0x0000ff00
#define REG_MASKFILTER_CONTROL_1_SHIFT    8
#define REG_MASKFILTER_CONTROL_1_WIDTH    8

/* OFFSET_FILTER_CONTROL_1 */
#define REG_OFFSET_FILTER_CONTROL_1          0x04
#define REG_OFFSET_FILTER_CONTROL_1_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_1_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_1_WIDTH    8

/* BYTE_FILTER_CONTROL_2 */
#define REG_BYTE_FILTER_CONTROL_2          0x08
#define REG_BYTE_FILTER_CONTROL_2_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_2_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_2_WIDTH    8

/* MASK_FILTER_CONTROL_2 */
#define REG_MASK_FILTER_CONTROL_2          0x08
#define REG_MASK_FILTER_CONTROL_2_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_2_SHIFT    8
#define REG_MASK_FILTER_CONTROL_2_WIDTH    8

/* OFFSETFILTER_CONTROL_2 */
#define REG_OFFSETFILTER_CONTROL_2          0x08
#define REG_OFFSETFILTER_CONTROL_2_MASK     0x00ff0000
#define REG_OFFSETFILTER_CONTROL_2_SHIFT    16
#define REG_OFFSETFILTER_CONTROL_2_WIDTH    8

/* BYTE_FILTER_CONTROL_3 */
#define REG_BYTE_FILTER_CONTROL_3          0x0c
#define REG_BYTE_FILTER_CONTROL_3_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_3_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_3_WIDTH    8

/* MASK_FILTER_CONTROL_3 */
#define REG_MASK_FILTER_CONTROL_3          0x0c
#define REG_MASK_FILTER_CONTROL_3_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_3_SHIFT    8
#define REG_MASK_FILTER_CONTROL_3_WIDTH    8

/* OFFSET_FILTER_CONTROL_3 */
#define REG_OFFSET_FILTER_CONTROL_3          0x0c
#define REG_OFFSET_FILTER_CONTROL_3_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_3_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_3_WIDTH    8

/* BYTE_FILTER_CONTROL_4 */
#define REG_BYTE_FILTER_CONTROL_4          0x010
#define REG_BYTE_FILTER_CONTROL_4_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_4_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_4_WIDTH    8

/* MASK_FILTER_CONTROL_4 */
#define REG_MASK_FILTER_CONTROL_4          0x010
#define REG_MASK_FILTER_CONTROL_4_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_4_SHIFT    8
#define REG_MASK_FILTER_CONTROL_4_WIDTH    8

/* OFFSET_FILTER_CONTROL_4 */
#define REG_OFFSET_FILTER_CONTROL_4          0x010
#define REG_OFFSET_FILTER_CONTROL_4_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_4_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_4_WIDTH    8

/* BYTE_FILTER_CONTROL_5 */
#define REG_BYTE_FILTER_CONTROL_5          0x014
#define REG_BYTE_FILTER_CONTROL_5_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_5_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_5_WIDTH    8

/* MASK_FILTER_CONTROL_5 */
#define REG_MASK_FILTER_CONTROL_5          0x014
#define REG_MASK_FILTER_CONTROL_5_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_5_SHIFT    8
#define REG_MASK_FILTER_CONTROL_5_WIDTH    8

/* OFFSET_FILTER_CONTROL_5 */
#define REG_OFFSET_FILTER_CONTROL_5          0x014
#define REG_OFFSET_FILTER_CONTROL_5_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_5_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_5_WIDTH    8

/* BYTE_FILTER_CONTROL_6 */
#define REG_BYTE_FILTER_CONTROL_6          0x018
#define REG_BYTE_FILTER_CONTROL_6_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_6_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_6_WIDTH    8

/* MASK_FILTER_CONTROL_6 */
#define REG_MASK_FILTER_CONTROL_6          0x018
#define REG_MASK_FILTER_CONTROL_6_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_6_SHIFT    8
#define REG_MASK_FILTER_CONTROL_6_WIDTH    8

/* OFFSET_FILTER_CONTROL_6 */
#define REG_OFFSET_FILTER_CONTROL_6          0x018
#define REG_OFFSET_FILTER_CONTROL_6_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_6_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_6_WIDTH    8

/* BYTE_FILTER_CONTROL_7 */
#define REG_BYTE_FILTER_CONTROL_7          0x01c
#define REG_BYTE_FILTER_CONTROL_7_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_7_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_7_WIDTH    8

/* MASK_FILTER_CONTROL_7 */
#define REG_MASK_FILTER_CONTROL_7          0x01c
#define REG_MASK_FILTER_CONTROL_7_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_7_SHIFT    8
#define REG_MASK_FILTER_CONTROL_7_WIDTH    8

/* OFFSET_FILTER_CONTROL_7 */
#define REG_OFFSET_FILTER_CONTROL_7          0x01c
#define REG_OFFSET_FILTER_CONTROL_7_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_7_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_7_WIDTH    8

/* BYTE_FILTER_CONTROL_8 */
#define REG_BYTE_FILTER_CONTROL_8          0x020
#define REG_BYTE_FILTER_CONTROL_8_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_8_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_8_WIDTH    8

/* MASK_FILTER_CONTROL_8 */
#define REG_MASK_FILTER_CONTROL_8          0x020
#define REG_MASK_FILTER_CONTROL_8_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_8_SHIFT    8
#define REG_MASK_FILTER_CONTROL_8_WIDTH    8

/* OFFSET_FILTER_CONTROL_8 */
#define REG_OFFSET_FILTER_CONTROL_8          0x020
#define REG_OFFSET_FILTER_CONTROL_8_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_8_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_8_WIDTH    8

/* BYTE_FILTER_CONTROL_9 */
#define REG_BYTE_FILTER_CONTROL_9          0x024
#define REG_BYTE_FILTER_CONTROL_9_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_9_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_9_WIDTH    8

/* MASK__FILTER_CONTROL_9 */
#define REG_MASK__FILTER_CONTROL_9          0x024
#define REG_MASK__FILTER_CONTROL_9_MASK     0x0000ff00
#define REG_MASK__FILTER_CONTROL_9_SHIFT    8
#define REG_MASK__FILTER_CONTROL_9_WIDTH    8

/* OFFSET_FILTER_CONTROL_9 */
#define REG_OFFSET_FILTER_CONTROL_9          0x024
#define REG_OFFSET_FILTER_CONTROL_9_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_9_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_9_WIDTH    8

/* BYTE_FILTER_CONTROL_10 */
#define REG_BYTE_FILTER_CONTROL_10          0x028
#define REG_BYTE_FILTER_CONTROL_10_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_10_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_10_WIDTH    8

/* MASK__FILTER_CONTROL_10 */
#define REG_MASK__FILTER_CONTROL_10          0x028
#define REG_MASK__FILTER_CONTROL_10_MASK     0x0000ff00
#define REG_MASK__FILTER_CONTROL_10_SHIFT    8
#define REG_MASK__FILTER_CONTROL_10_WIDTH    8

/* OFFSET_FILTER_CONTROL_10 */
#define REG_OFFSET_FILTER_CONTROL_10          0x028
#define REG_OFFSET_FILTER_CONTROL_10_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_10_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_10_WIDTH    8

/* BYTE_FILTER_CONTROL_11 */
#define REG_BYTE_FILTER_CONTROL_11          0x02c
#define REG_BYTE_FILTER_CONTROL_11_MASK     0x000000ff
#define REG_BYTE_FILTER_CONTROL_11_SHIFT    0
#define REG_BYTE_FILTER_CONTROL_11_WIDTH    8

/* MASK_FILTER_CONTROL_11 */
#define REG_MASK_FILTER_CONTROL_11          0x02c
#define REG_MASK_FILTER_CONTROL_11_MASK     0x0000ff00
#define REG_MASK_FILTER_CONTROL_11_SHIFT    8
#define REG_MASK_FILTER_CONTROL_11_WIDTH    8

/* OFFSET_FILTER_CONTROL_11 */
#define REG_OFFSET_FILTER_CONTROL_11          0x02c
#define REG_OFFSET_FILTER_CONTROL_11_MASK     0x00ff0000
#define REG_OFFSET_FILTER_CONTROL_11_SHIFT    16
#define REG_OFFSET_FILTER_CONTROL_11_WIDTH    8

/* LONG_FILTER_0_REF1 */
#define REG_LONG_FILTER_0_REF1          0x030
#define REG_LONG_FILTER_0_REF1_MASK     0xffffffff
#define REG_LONG_FILTER_0_REF1_SHIFT    0
#define REG_LONG_FILTER_0_REF1_WIDTH    32

/* LONG_FILTER_0_REF2 */
#define REG_LONG_FILTER_0_REF2          0x034
#define REG_LONG_FILTER_0_REF2_MASK     0xffffffff
#define REG_LONG_FILTER_0_REF2_SHIFT    0
#define REG_LONG_FILTER_0_REF2_WIDTH    32

/* LONG_FILTER_0_CONTROL */
#define REG_LONG_FILTER_0_CONTROL          0x038
#define REG_LONG_FILTER_0_CONTROL_MASK     0x000000ff
#define REG_LONG_FILTER_0_CONTROL_SHIFT    0
#define REG_LONG_FILTER_0_CONTROL_WIDTH    8

/* OFFSET_LONG_FILTER_0_CONTROL */
#define REG_OFFSET_LONG_FILTER_0_CONTROL          0x038
#define REG_OFFSET_LONG_FILTER_0_CONTROL_MASK     0x0000fc00
#define REG_OFFSET_LONG_FILTER_0_CONTROL_SHIFT    10
#define REG_OFFSET_LONG_FILTER_0_CONTROL_WIDTH    6

/* LONG_FILTER_1_REF1 */
#define REG_LONG_FILTER_1_REF1          0x03c
#define REG_LONG_FILTER_1_REF1_MASK     0xffffffff
#define REG_LONG_FILTER_1_REF1_SHIFT    0
#define REG_LONG_FILTER_1_REF1_WIDTH    32

/* LONG_FILTER_1_REF2 */
#define REG_LONG_FILTER_1_REF2          0x040
#define REG_LONG_FILTER_1_REF2_MASK     0xffffffff
#define REG_LONG_FILTER_1_REF2_SHIFT    0
#define REG_LONG_FILTER_1_REF2_WIDTH    32

/* LONG_FILTER_1_CONTROL */
#define REG_LONG_FILTER_1_CONTROL          0x044
#define REG_LONG_FILTER_1_CONTROL_MASK     0x000000ff
#define REG_LONG_FILTER_1_CONTROL_SHIFT    0
#define REG_LONG_FILTER_1_CONTROL_WIDTH    8

/* OFFSET_LONG_FILTER_1_CONTROL */
#define REG_OFFSET_LONG_FILTER_1_CONTROL          0x044
#define REG_OFFSET_LONG_FILTER_1_CONTROL_MASK     0x0000fc00
#define REG_OFFSET_LONG_FILTER_1_CONTROL_SHIFT    10
#define REG_OFFSET_LONG_FILTER_1_CONTROL_WIDTH    6

/* LONG_FILTER_2_REF1 */
#define REG_LONG_FILTER_2_REF1          0x048
#define REG_LONG_FILTER_2_REF1_MASK     0xffffffff
#define REG_LONG_FILTER_2_REF1_SHIFT    0
#define REG_LONG_FILTER_2_REF1_WIDTH    32

/* LONG_FILTER_2_REF2 */
#define REG_LONG_FILTER_2_REF2          0x04c
#define REG_LONG_FILTER_2_REF2_MASK     0xffffffff
#define REG_LONG_FILTER_2_REF2_SHIFT    0
#define REG_LONG_FILTER_2_REF2_WIDTH    32

/* LONG_FILTER_2_CONTROL */
#define REG_LONG_FILTER_2_CONTROL          0x050
#define REG_LONG_FILTER_2_CONTROL_MASK     0x000000ff
#define REG_LONG_FILTER_2_CONTROL_SHIFT    0
#define REG_LONG_FILTER_2_CONTROL_WIDTH    8

/* OFFSET_LONG_FILTER_2_CONTROL */
#define REG_OFFSET_LONG_FILTER_2_CONTROL          0x050
#define REG_OFFSET_LONG_FILTER_2_CONTROL_MASK     0x0000fc00
#define REG_OFFSET_LONG_FILTER_2_CONTROL_SHIFT    10
#define REG_OFFSET_LONG_FILTER_2_CONTROL_WIDTH    6
#endif 
