/***********************************************************************************
 File:		lm_StaDatabase.h
 Module:		lm
 Purpose: 	
 Description:	
 				
************************************************************************************/
#ifndef LM_STA_DATABASE_H_
#define LM_STA_DATABASE_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "StaDatabase_Api.h"
#include "linkAdaptation_api.h"
#include "mhi_umi.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void LM_FillStaCapabilities(UMI_STA_ADD *pAddSta);
void getSupportedRates(uint8 *ptr_ie_rates, uint8 array_len, uint32 *pu32OutCommonRates, uint32 *pu32OutBasicRates);

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct LmStaDbSwInfo
{
	/* General parameters */
#ifdef LINK_ADAPTATION_TEST_ENV
	IEEE_ADDR	macAddress;
#endif
	uint16		basicRates;
	uint16		supportedRates;
	/* Each STA is a part of a double linked list of all STAs in the same VAP*/
	StaId	   nextSid; 			
	StaId	   previousSid;
	StaState_e  state;
	uint8       vapIndex;
}LmStaDbSwInfo_t;

typedef struct LmStaDbObject
{
	uint8  	NumOfConnectedSta;
	StaId 	headIndexOfStaLinkList;
} LmStaDbObject_t;



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void Lm_StadBInit(void);
void Lm_AddStaToHeadOfList(LmStaDbObject_t* pLmStaDb, StaId stationIndex, uint8 vapIndex);
void Lm_removeStaFromList(LmStaDbObject_t* pLmStaDb, StaId stationIndex);
#ifdef LINK_ADAPTATION_TEST_ENV
StaId Lm_GetStaIndexByMacAddr(LmStaDbObject_t* pLmStaDb, IEEE_ADDR macAddr);
#endif
StaState_e getStaState(StaId staIndex);


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

extern LmStaDbObject_t LmStaDataBase;
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
extern LmStaDbSwInfo_t *StaDbSwEntries;
#else
extern LmStaDbSwInfo_t StaDbSwEntries[HW_NUM_OF_STATIONS];
#endif
extern const uint16 SupportedRateTo2xPhyRate[LM_PHY_MAX_RATES];
#endif /* LM_STA_DATABASE_H_ */


