/***********************************************************************************
 File:		lm_VapDatabase.h
 Module:		lm
 Purpose: 	
 Description:	
 				
************************************************************************************/
#ifndef LM_VAP_DATABASE_H_
#define LM_VAP_DATABASE_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "linkAdaptation_api.h"
#include "HwGlobalDefinitions.h"
#include "lm_StaDatabase.h"
#include "LinkAdaptation.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
typedef enum LmVapState
{
	LM_VAP_STATE_FREE = 0,
	LM_VAP_STATE_ADDED,
	LM_STATE_NUM_OF_STATES,
	LM_STATE_MAX_STATE,
}	LmVapState_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct LmVapDbSwInfo
{
	uint16		basicRates;
	uint16      mcBasicRates;
    uint8       mcRateIndex; // current used multicast rate index (must be basic rate) determine by the multicast dynamic rate mode
    uint8		numOfStations;
    uint8       sortBasicRateNumOfStationsCounter[BASICRATE_HIGHEST_SORT_RATE_INDEX]; // a counter for number of stations per basic rate that TX in this phy rate (or converted from non-legacy rate)
    uint8		supportedRateNumOfStationsCounter[BASICRATE_HIGHEST_SORT_RATE_INDEX];
    LmVapState_e      vapState;       //VAP state
#ifdef ENET_INC_ARCH_WAVE600
	uint8 		bssColor;
#endif //ENET_INC_ARCH_WAVE600
} LmVapDbSwInfo_t ;
//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void Lm_VapDbInit(void);
void LmVapDB_AddVap(UMI_SET_BSS *pAddVap);
void LmVapDB_RemoveVap(UMI_REMOVE_VAP *pRemoveVap);


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
extern LmVapDbSwInfo_t *LmVapDataBase;
#else
extern LmVapDbSwInfo_t LmVapDataBase[HW_NUM_OF_VAPS];
#endif


#endif /* LM_VAP_DATABASE_H_ */


