/***********************************************************************************
 File:		lm_StaDatabase.c.c
 Module:		lm
 Purpose: 	
 Description:	
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_MainApi.h"
#include "loggerAPI.h"
#include "lm_StaDatabase.h"
#include "stringLibApi.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "Protocol_PhyAttributes.h"
#include "lm_VapDatabase.h"
#include "ShramStationDatabase.h"
#include "LinkAdaptation.h"
#include "Estimators.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_LOWER_MAC
#define LOG_LOCAL_FID 0

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

#define PROTECTION_METHOD_RTS_CONF(x) (x&0x3)  
#define PROTECTION_METHOD_CTS2SELF_CONF(x) ((x<<2)&0xC)

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
LmStaDbObject_t LmStaDataBase;
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
LmStaDbSwInfo_t *StaDbSwEntries;
#else
LmStaDbSwInfo_t StaDbSwEntries[HW_NUM_OF_STATIONS];
#endif

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

const uint16 SupportedRateTo2xPhyRate[LM_PHY_MAX_RATES] = 
{
    LM_PHY_11A_DATARATE_6           , // 12   // 11A/G  0      0x00
    LM_PHY_11A_DATARATE_9           , // 18   // 11A/G  1      0x01
    LM_PHY_11A_DATARATE_12          , // 24   // 11A/G  2      0x02
    LM_PHY_11A_DATARATE_18          , // 36   // 11A/G  3      0x03
    LM_PHY_11A_DATARATE_24          , // 48   // 11A/G  4      0x04
    LM_PHY_11A_DATARATE_36          , // 72   // 11A/G  5      0x05
    LM_PHY_11A_DATARATE_48          , // 96   // 11A/G  6      0x06
    LM_PHY_11A_DATARATE_54          , // 108  // 11A/G  7      0x07
                            
    LM_PHY_11B_DATARATE_2_SHORT     , // 4    // 11B/G  8      0x21
    LM_PHY_11B_DATARATE_5_5_SHORT   , // 11   // 11B/G  9      0x22
    LM_PHY_11B_DATARATE_11_SHORT    , // 22   // 11B/G  10     0x23
                            
    LM_PHY_11B_DATARATE_1           , // 2    // 11B/G  11     0x24
    LM_PHY_11B_DATARATE_2           , // 4    // 11B/G  12     0x25
    LM_PHY_11B_DATARATE_5_5         , // 11   // 11B/G  13     0x26
    LM_PHY_11B_DATARATE_11          , // 22   // 11B/G  14     0x27
                            
    LM_PHY_11N_DATARATE_6_5         , // 13   // 11N    15     0x40
    LM_PHY_11N_DATARATE_13          , // 26   // 11N    16     0x41
    LM_PHY_11N_DATARATE_19_5        , // 38   // 11N    17     0x42
    LM_PHY_11N_DATARATE_26          , // 52   // 11N    18     0x43
    LM_PHY_11N_DATARATE_39          , // 78   // 11N    19     0x44
    LM_PHY_11N_DATARATE_52          , // 104  // 11N    20     0x45
    LM_PHY_11N_DATARATE_58_5        , // 117  // 11N    21     0x46
    LM_PHY_11N_DATARATE_65          , // 130  // 11N    22     0x47
    LM_PHY_11N_DATARATE_13_R2       , // 26   // 11N    23     0x48
    LM_PHY_11N_DATARATE_26_R2       , // 52   // 11N    24     0x49
    LM_PHY_11N_DATARATE_39_R2       , // 78   // 11N    25     0x4A
    LM_PHY_11N_DATARATE_52_R2       , // 104  // 11N    26     0x4B
    LM_PHY_11N_DATARATE_78_R2       , // 156  // 11N    27     0x4C
    LM_PHY_11N_DATARATE_104_R2      , // 208  // 11N    28     0x4D
    LM_PHY_11N_DATARATE_117_R2      , // 234  // 11N    29     0x4E
    LM_PHY_11N_DATARATE_130_R2      , // 260  // 11N    30     0x4F
    LM_PHY_11N_DATARATE_6_DUP         // 12   // 11N    31     0x50
};

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization_start" 
#endif

void Lm_StadBInit(void)
{
	StaId staIndex = 0;
	
	LmStaDataBase.NumOfConnectedSta = 0;
	LmStaDataBase.headIndexOfStaLinkList = DB_ASYNC_SID;
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
	System_MainAllocInitializationMemory((uint8 **)&StaDbSwEntries, (sizeof(LmStaDbSwInfo_t)*HW_NUM_OF_STATIONS));
#endif	
	for (staIndex = 0; staIndex < HW_NUM_OF_STATIONS; staIndex++)
	{
		/* Reset SW DB and mark all entries as free */
		memset(&(StaDbSwEntries[staIndex]), 0, sizeof(LmStaDbSwInfo_t));
		StaDbSwEntries[staIndex].state = STA_STATE_FREE;
	}
}
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default 
#endif


/**********************************************************************************

Lm_AddStaToHeadOfList 


Description:
------------

Input: 
-----

Returns:
--------
void - 
	
**********************************************************************************/

void Lm_AddStaToHeadOfList(LmStaDbObject_t* pLmStaDb, StaId stationIndex, uint8 vapIndex)
{

	/*add first station to queue*/
	if (pLmStaDb->headIndexOfStaLinkList == DB_ASYNC_SID)
	{
		StaDbSwEntries[stationIndex].previousSid = DB_ASYNC_SID;
		StaDbSwEntries[stationIndex].nextSid= DB_ASYNC_SID;
		
	}
	else
	{
		StaDbSwEntries[pLmStaDb->headIndexOfStaLinkList].previousSid = stationIndex;
		StaDbSwEntries[stationIndex].nextSid = pLmStaDb->headIndexOfStaLinkList;
		StaDbSwEntries[stationIndex].previousSid = DB_ASYNC_SID;
	}

	pLmStaDb->headIndexOfStaLinkList = stationIndex;
	StaDbSwEntries[stationIndex].vapIndex = vapIndex;
	StaDbSwEntries[stationIndex].state = STA_STATE_CONNECTED;

	pLmStaDb->NumOfConnectedSta++;


}

/**********************************************************************************

Lm_removeStaFromList 


Description:
------------

Input: 
-----

Returns:
--------
void - 
	
**********************************************************************************/

void Lm_removeStaFromList(LmStaDbObject_t* pLmStaDb, StaId stationIndex)
{
	
	LmStaDbSwInfo_t* pStaDbSwEntry = &(StaDbSwEntries[stationIndex]);
	StaId headIndexInLinkList = pLmStaDb->headIndexOfStaLinkList;
	StaId previousSid = pStaDbSwEntry->previousSid;
	StaId nextSid = pStaDbSwEntry->nextSid;

	if (pStaDbSwEntry->state != STA_STATE_FREE)
	{
		/* Remove the STA from the double linked list of STAs in this VAP*/ 	
		if (headIndexInLinkList == stationIndex)
		{
			// STA is first in list. Set new head 
			pLmStaDb->headIndexOfStaLinkList = pStaDbSwEntry->nextSid;
		}
		else
		{
			// STA is not first. Connect previous STA to next STA (if exists)
			StaDbSwEntries[pStaDbSwEntry->previousSid].nextSid = nextSid;
		}
		if (nextSid != DB_ASYNC_SID)
		{
		
			ASSERT(pStaDbSwEntry->nextSid < (HW_NUM_OF_STATIONS)) //KW_FW_FIX_M			
		
			// STA is not last. Connect next STA to previous STA
			StaDbSwEntries[pStaDbSwEntry->nextSid].previousSid = previousSid;
		}
 		/* Clear SW DB */
		memset(pStaDbSwEntry, 0, sizeof(LmStaDbSwInfo_t));

		pStaDbSwEntry->state = STA_STATE_FREE;

		pLmStaDb->NumOfConnectedSta--;
	}

}

/**********************************************************************************

Lm_GetStaIndexByMacAddr 


Description:
------------

Input: 
-----

Returns:
--------
void - 
	
**********************************************************************************/

#ifdef LINK_ADAPTATION_TEST_ENV
StaId Lm_GetStaIndexByMacAddr(LmStaDbObject_t* pLmStaDb, IEEE_ADDR macAddr)
{
	StaId nextSid = pLmStaDb->headIndexOfStaLinkList;

	if(pLmStaDb->NumOfConnectedSta !=0 )
	{
		/*If number of connected station != 1 nextSid must be differebnt than DB_ASYNC_SID*/
		ASSERT(nextSid != DB_ASYNC_SID);
		/*Go over all connected stations*/
		while ((nextSid != DB_ASYNC_SID) && (memcmp(macAddr.au8Addr, StaDbSwEntries[nextSid].macAddress.au8Addr,sizeof(IEEE_ADDR))))
		{
			/*Find MAC address*/
			
			nextSid = >StaDbSwEntries[nextSid].nextSid;
		}
	}

	return nextSid;
	
}
#endif

/**********************************************************************************

getStaState 


Description:
------------
Check if report arrived from sta in dB

Input: 
-----

Returns:
--------
void - 
	
**********************************************************************************/
StaState_e getStaState(StaId staIndex)
{
	DEBUG_ASSERT(staIndex<HW_NUM_OF_STATIONS);
	return StaDbSwEntries[staIndex].state;
}

/**********************************************************************************

LM_FillStaCapabilities 


Description:
------------

Input: 
-----

Returns:
--------
void - 
	
**********************************************************************************/

void LM_FillStaCapabilities(UMI_STA_ADD *pAddSta)
{
	LmStaDbSwInfo_t* pLmStaDbSwinfo = &StaDbSwEntries[pAddSta->u16SID];
	uint8 vapId = pAddSta->u8VapIndex;
	LmVapDbSwInfo_t* pLmVapDbSwInfo = &LmVapDataBase[vapId];
	uint32 staSupportedRates = 0;
	uint32 staBasicRateSet = 0;

	/*Set 11A\G, B lm vap*/
	getSupportedRates(&(pAddSta->u8Rates[0]), pAddSta->u8Rates_Length, &staSupportedRates, &staBasicRateSet);
	/*Take basic rate set from vap basic rates*/
	pLmStaDbSwinfo->basicRates = ((pLmVapDbSwInfo->basicRates) & LM_PHY_11G_RATE_MSK);
	DEBUG_ASSERT(pLmStaDbSwinfo->basicRates != 0);
	pLmStaDbSwinfo->supportedRates = staSupportedRates & LM_PHY_11G_RATE_MSK;

}

/****************************************************************************
**
** NAME:        vEL_GetSupportedRates
**
** Parameters:  psInIe - points to IE
**              pu32OutCommonRates - outputs common rate map
**              pu32OutBasicRates - outputs basic rate map
**
** Returns:     None
**
** Description: Decodes a supported rates or extended supported rates IE
**              and extracts the common and basic rate sets
**
****************************************************************************/
void getSupportedRates(uint8 *ptr_ie_rates,
								  uint8 array_len,
                                  uint32 *pu32OutCommonRates,
                                  uint32 *pu32OutBasicRates)
{
    uint32 ie_index, rate;
    uint8 ie_rate;

	DEBUG_ASSERT(array_len <= MAX_NUM_SUPPORTED_RATES);

	///DEBUG START//////
	//ptr_ie_rates[0] = 140;
	//array_len = 1;
	///DEBUG END//////

    for (ie_index = 0; ie_index < array_len; ie_index++)
    {
        ie_rate = ptr_ie_rates[ie_index];
#ifdef BEEROCK_DEBUG
//		ILOG0_D("[getSupportedRates] ie_rate = %d", ie_rate);
#endif
        // convert the current IE rate to sw rate
        rate = 0;
        while ( rate<LM_PHY_11G_MAX_RATES  && ((ie_rate & FM_RATE_MASK)!=SupportedRateTo2xPhyRate[rate] ))
        {
            rate++;
        }

        // if we found a matching rate - add it to the mask
        if (rate<LM_PHY_11G_MAX_RATES)
        {
            uint32 tmp = 1UL<<rate;

			/*11B set only short preamble and 1MB of the long preamble - HW will overide short with long if required*/
			
            // duplicate 11b rates to the long and the short reperesentation
          //  if ( tmp & LM_PHY_11B_RATE_MSK )
          //      tmp = (tmp | (tmp<<4) | (tmp<<4)) & LM_PHY_11B_RATE_MSK;

            // add to the mask
            *pu32OutCommonRates |= tmp;

            // add to the basic mask
            //if (ie_rate & FM_DATARATE_BASIC_MASK)
            {
                *pu32OutBasicRates |= tmp;
            }
        }
    }
}





