/***********************************************************************************
 File:		lm_StaDatabase.c.c
 Module:		lm
 Purpose: 	
 Description:	
 				
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_MainApi.h"
#include "loggerAPI.h"
#include "stringLibApi.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "linkAdaptation_api.h"
#include "lm_VapDatabase.h"
#include "StaDatabase_Api.h"
#include "lm_StaDatabase.h"
#include "ConfigurationManager_api.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_LOWER_MAC
#define LOG_LOCAL_FID 4


#define VAP_RATES_MASK_INIT_0 0xFFFFFFFF
#define VAP_RATES_MASK_INIT_1 0x007FFFFF
	

#define VAP_BASIC_RATES_SET_0 0x7FFF
#define VAP_BASIC_RATES_SET_1 0


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
static void getBasicRates(uint8 *ptr_ie_rates, uint8 array_len,uint32 *pu32OutBasicRates);

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
LmVapDbSwInfo_t *LmVapDataBase;
#else
LmVapDbSwInfo_t LmVapDataBase[HW_NUM_OF_VAPS];
#endif

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization_start" 
#endif
void Lm_VapDbInit()
{
	uint8 vapIndex;
	uint8 firstVapInBand = ConfigurationManager_GetFirstVapForMyBand();
	uint8 numOfVapsInBand = ConfigurationManager_GetNumOfVapsInMyBand();

#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
	System_MainAllocInitializationMemory((uint8 **)&LmVapDataBase, (sizeof(LmVapDbSwInfo_t)*HW_NUM_OF_VAPS));
#endif	
	memset(LmVapDataBase, 0, sizeof(LmVapDbSwInfo_t)*HW_NUM_OF_VAPS);
	for (vapIndex = firstVapInBand; vapIndex < (firstVapInBand + numOfVapsInBand); vapIndex++)
	{
		LmVapDataBase[vapIndex].vapState = LM_VAP_STATE_FREE;
	}	
}
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif

/**********************************************************************************

LmVapDB_AddVap


Description:
------------
Initiate Link adaptaion algorithm parameters

Input: 
-----

Returns:
--------
1 - if sta and vap have rates in common
0 -sta and vap have no rates in common
void - 
	
**********************************************************************************/

void LmVapDB_AddVap(UMI_SET_BSS *pAddVap)
{
	uint8 vapId =  pAddVap->vapId;
	LmVapDbSwInfo_t* pLmVapDbSwInfo = &LmVapDataBase[vapId];
	uint32 vapBasicRates = 0;

	/*Change vap state to LM_VAP_STATE_ADDED*/
	pLmVapDbSwInfo->vapState =  LM_VAP_STATE_ADDED;

	/*Set 11A\G, B */
	getBasicRates(&(pAddVap->u8Rates[0]), pAddVap->u8Rates_Length, &vapBasicRates);
	pLmVapDbSwInfo->basicRates = (vapBasicRates & LM_PHY_11G_RATE_MSK);
    pLmVapDbSwInfo->mcBasicRates = LM_PHY_11G_RATE_MSK;	/*Start with all legacy rates, MC data rate is not used until STA is added*/
#ifdef ENET_INC_ARCH_WAVE600
	pLmVapDbSwInfo->bssColor = pAddVap->u8HE_Bss_Color;
#endif //ENET_INC_ARCH_WAVE600

    /* DMR set counters to 0 */
    memset(pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter, 0, sizeof(pLmVapDbSwInfo->sortBasicRateNumOfStationsCounter));
    memset(pLmVapDbSwInfo->supportedRateNumOfStationsCounter, 0, sizeof(pLmVapDbSwInfo->supportedRateNumOfStationsCounter));
	pLmVapDbSwInfo->numOfStations = 0;
}
/**********************************************************************************

LmVapDB_AddVap


Description:
------------
Initiate Link adaptaion algorithm parameters

Input: 
-----

Returns:
--------
1 - if sta and vap have rates in common
0 -sta and vap have no rates in common
void - 
	
**********************************************************************************/

void LmVapDB_RemoveVap(UMI_REMOVE_VAP* pRemoveVap)
{
	uint8 vapId =  pRemoveVap->vapId;
	LmVapDbSwInfo_t* pLmVapDbSwinfo = &LmVapDataBase[vapId];

	/*Change vap state to LM_VAP_STATE_FREE*/
	pLmVapDbSwinfo->vapState =  LM_VAP_STATE_FREE;

}

/****************************************************************************
**
** NAME:        vEL_GetSupportedRates
**
** Parameters:  psInIe - points to IE
**              pu32OutCommonRates - outputs common rate map
**              pu32OutBasicRates - outputs basic rate map
**
** Returns:     None
**
** Description: Decodes a supported rates or extended supported rates IE
**              and extracts the common and basic rate sets
**
****************************************************************************/
static void getBasicRates(uint8 *ptr_ie_rates, uint8 array_len,uint32 *pu32OutBasicRates)
{
    uint32 ie_index, rate;
    uint8 ie_rate;

	DEBUG_ASSERT(array_len < MAX_NUM_SUPPORTED_RATES);

    for (ie_index = 0; ie_index < array_len; ie_index++)
    {
        ie_rate = ptr_ie_rates[ie_index];

        // convert the current IE rate to sw rate
        rate = 0;
        while ( rate<LM_PHY_11G_MAX_RATES  && (ie_rate & FM_RATE_MASK)!=SupportedRateTo2xPhyRate[rate] )
        {
            rate++;
        }

        // if we found a matching rate - add it to the mask
        if (rate<LM_PHY_11G_MAX_RATES)
        {
            uint32 tmp = 1UL<<rate;

            // duplicate 11b rates to the long and the short reperesentation
           // if ( tmp & LM_PHY_11B_RATE_MSK )
            //    tmp = (tmp | (tmp<<4) | (tmp<<4)) & LM_PHY_11B_RATE_MSK;

            // add to the mask
            *pu32OutBasicRates = ((uint32)*pu32OutBasicRates) | tmp;

        }
    }
}









