/* lmint.c */
/**************************************************************************
***************************************************************************
**
** COMPONENT:        ENET SW
**
** VERSION:          
**
** AUTHOR:           
**
** DESCRIPTION:      Lower MAC interrupt service routines.
**
**
****************************************************************************
*
* Copyright (c) 2001, 2002 TTPCom Limited
*
****************************************************************************/
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "System_Information.h"
#include "ErrorHandler_Api.h"
#include "OSAL_Api.h"
#include "OSAL_Interrupts.h"
#include "InterruptManager_Api.h"
#include "HwEventsAndErrors_Api.h"
#include "int_gen.h"
#include <ieee80211.h>
#include <enet_pas.h>
#include <shram_lmi_vectors.h>
#include <lmi.h>
#include "lm.h"
#include "lm_statistics.h"
#include <enet_brc.h>
#include "System_Timers.h"
#include "Debug_Trace.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_MAC_HT_extensions_regs.h"
#endif
#include "MacHtExtensionsRegs.h"
#include "RegAccess_Api.h"
#include "PhyDriver_API.h"
#include "TpcClbrHndlr.h"
#include "Pac_Api.h"
#include "CpuLoad_Api.h"
#include "EmeraldEnvRegs.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_Emerald_Env_regs.h"
#endif
#include "PacManager_api.h"
#include "Dut_Api.h"
#include "SenderInterface_Api.h"
#include "ipc_api.h"
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_LOWER_MAC
#define LOG_LOCAL_FID 2

/*******************************/
/* Static variable definitions */
/*******************************/

static uint32 u32SignalMask;

/******************************************************************************/
/***						Macros											***/
/******************************************************************************/


/******************************************************************************/
/***						Public Functions Definitions					***/
/******************************************************************************/
/***************************************************************************
**
** NAME         vGetSignalMask
**
** PARAMETERS   Nothing
**
** RETURNS      u32BitMask
**
** DESCRIPTION  This routine returns bits of the signal mask.
**
****************************************************************************/
uint32 vGetSignalMask(void)
{
	return (u32SignalMask);
}
/***************************************************************************
**
** NAME         vClearSignalMask
**
** PARAMETERS   u32BitMask
**
** RETURNS      Nothing
**
** DESCRIPTION  This routine clears bits of the signal mask.
**
****************************************************************************/
void vSetSignalMask(uint32 u32BitMask)
{
	TX_INTERRUPT_SAVE_AREA;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
//	AAA_DEBUG_LMI_MACRO(AAA_DebugLmi_vClearSignalMask, u32SignalMask, u32BitMask);
	IGEN_SET_MASK(u32SignalMask,u32BitMask);
	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

/***************************************************************************
**
** NAME         vClearSignalMask
**
** PARAMETERS   u32BitMask
**
** RETURNS      Nothing
**
** DESCRIPTION  This routine clears bits of the signal mask.
**
****************************************************************************/
void vClearSignalMask(uint32 u32BitMask)
{
	TX_INTERRUPT_SAVE_AREA;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	AAA_DEBUG_LMI_MACRO(AAA_DebugLmi_vClearSignalMask, u32SignalMask, u32BitMask);
	IGEN_CLEAR_MASK(u32SignalMask,u32BitMask);
	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}


/***************************************************************************
**
** NAME         vClearAllSignalMask
**
** PARAMETERS   
**
** RETURNS      Nothing
**
** DESCRIPTION  This routine clears all bits of the signal mask.
**
****************************************************************************/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization"
#endif
void vClearAllSignalMask(void)
{
	TX_INTERRUPT_SAVE_AREA;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	u32SignalMask = 0;
	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif


/***************************************************************************
**
** NAME         vLM_pac_tsf_timer_int(void)
**
** PARAMETERS   None
**
** RETURNS      Nothing
**
** DESCRIPTION  This routine services the PAC TSF timer interrupts.
**
****************************************************************************/
ISR_VOID vLM_pac_tsf_timer_int(void)
{
	ACCUMULATE_CPU_IDLE_TIME();
	MT_LM_STAT_INC(MT_LM_STAT_EVT_HW_TSF);
	
    if(Pac_TimIsSwEvent2Occured() == TRUE)
    {
		FATAL("Unused TSF timer"); //This timer is currently not used
		/* Clear interrupt source  - tsf_sw_event2 register */
        Pac_TimResetSwTimer2();
    }
	
    if (Pac_TimIsSwEvent3Occured() == TRUE)
    {
		FATAL("Unused TSF timer"); //This timer is currently not used
		/* Clear interrupt source  - tsf_sw_event3 register */
		Pac_TimResetSwTimer3();
    }
	//AAA_DEBUG_KERNEL_SCHEDULER_MACRO(AAA_DebugKernelSchduler_vLM_pac_tsf_timer_int,1,1);
}



/****************************************************************************
 **
 ** NAME:           LM_ClearAllInterrupts
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    clears all LM interrupts                
 **                 
 ****************************************************************************/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization"
#endif 
void LM_ClearAllInterrupts()
{
	TX_INTERRUPT_SAVE_AREA;
	
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	//clear SW timers interrupts
    Pac_TimResetSwTimer2();
    Pac_TimResetSwTimer3();
#ifndef ENET_INC_ARCH_WAVE600
	//clear RX control
	Pac_RxcClearRxBufferOverflow();
#endif
	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif




