/* CMSynergyVer %full_filespec: lmmain.c;52.4.1.1.1.4.4.1.5.1.2:csrc:1 % */
/**************************************************************************
***************************************************************************
**
** COMPONENT:        ENET SW - Lower MAC
**
** MODULE:           $File: //bwp/enet/demo153_sw/develop/src/mac_lower/lmmain.c $
**
** VERSION:          $Revision: #10 $
**
** AUTHOR:           John Gladman
**
** DESCRIPTION:      Lower MAC Public Interface
**
** CHANGE HISTORY:
**
**   $Log: lmmain.c $
**   Revision 1.2  2003/02/11 17:41:29Z  prh
**   Make selection of 802.11b Short/Long Preamble selection similar to 802.11g.
**   Revision 1.40  2002/12/09 15:06:39Z  jag1
**   Configure now re-selects the pseudo random number generator.
**   Revision 1.39  2002/12/04 13:05:01Z  jag1
**   Modified with changes to random number generator.
**   Revision 1.38  2002/10/28 11:00:59Z  jag1
**   Additions and modifications in support of 802.11g.
**   Revision 1.37  2002/08/29 10:52:09Z  ifo
**   Removed unsed code.
**   Revision 1.36  2002/08/20 09:23:59Z  mrg
**   Updates from 11b testing
**   Revision 1.35  2002/07/23 12:22:44Z  ifo
**   Interrupt between LMAC/UMAC use int_gen driver.
**   Revision 1.34  2002/07/22 12:27:54Z  ifo
**   Moved interrupt handling to interrupt.c
**   Revision 1.33  2002/07/22 12:23:40Z  prh
**   Remove newly added CF-Pollable queues, as we
**   now use the MPS, UPS and CF queues during the CFP.
**   Revision 1.32.1.2  2002/07/22 12:24:48Z  ifo
**   Moved interrupt handling to interrupt.c
**   Revision 1.32.1.1  2002/06/25 14:45:32Z  ifo
**   Duplicate revision
**   Revision 1.32  2002/06/25 14:45:32Z  mrg
**   Added initialisation of new PCF queues
**   Revision 1.31  2002/06/24 14:31:40Z  smk
**   add skeleton TTCS for SIFS timings
**   Revision 1.30  2002/05/03 14:41:35Z  jag1
**   Tidied.
**   Revision 1.29  2002/04/30 13:35:27Z  ifo
**   Allow CONFIGURE_REQ when in STOPPED state.
**   ...
**   Revision 1.1  2001/08/08 13:22:50Z  jag1
**   Initial revision
**
** LAST MODIFIED BY:   $Author: jh3 $
**                     $Date: 2004/03/25 $
**
****************************************************************************
*
* Copyright (c) 2001, 2002 TTPCom Limited
*
****************************************************************************/
//#include "enet_sw.h"
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "OSAL_Api.h"
#include <ieee80211.h>
#include <protocol.h>
#include "Dut_Api.h"
#include <shram_lmi_vectors.h>
#include <shram_man_queues.h>
#include <shram_rx_buffer.h>
#include <MT_shram_alignment.h>
#include "Pac_Api.h"
#include <enet_pas.h>
#include <enet_brc.h>
#include <PhyDriver_API.h>
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_MAC_HT_extensions_regs.h"
#endif
#include <int_gen.h>
#include "System_Timers.h"
#include "Debug_Trace.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_Emerald_Env_regs.h"
#else
#include "EmeraldEnvRegs.h"
#endif
#include "mt_sysrst.h"
#include "HwEventsAndErrors_Api.h"
#include <lmi.h>
#include "lm.h"
#include "lminfra.h"
#include "lm_statistics.h"
#include "PhyDriver_API.h"
#include "LmHdk_API.h"
#include "RficDriver_API.h"
#include "Afe_API.h"
#include "Indirect_API.h"
#include "CalibrationHandler.h"
#include "TpcClbrHndlr.h"
#include "mhi_umi_propr.h"
#include "Pac_Api.h"
#include "lmtimerUtility.h"
#include "mt_bcl_task.h"
#include "BeaconHandler_api.h"
#include "TxSelector_Api.h"
#include "StaDatabase_Api.h"
#include "VapDatabase_Api.h"
#include "shram_man_msgs.h"
#include "linkAdaptation_api.h"
#include "lm_StaDatabase.h"
#include "ProtectedDbLock_Api.h"
#include "lm_StaDatabase.h"
#include "lm_VapDatabase.h"
#include "Locker_Api.h"
#include "RegAccess_Api.h"
#include "PacManager_api.h"
#include "HwSemaphore_API.h"
#include "um_interface.h"
#include "InterfererDetection_Api.h"
#include "CoC_Api.h"
#include "ProcessManager_Api.h"
#include "ServicesHandler_Api.h"
#include "Pauser_Api.h"
#include "ChannelSwitchManager_Api.h"
#include "HostInterface_API.h"
#include "PsManager_Api.h"
#include "HwSecurity_API.h"
#include "Mac2index_Api.h"
#include "TxHandler_Api.h"
#include "DeliaRecipes_Api.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "Deaggregator_Api.h"
#include "RxHandler_Api.h"
#include "AutoResponse_Api.h"
#include "SenderInterface.h"
#include "SenderInterface_Api.h"
#include "BaAnalyzer_Api.h"
#include "UlPostRx_Api.h"
#include "Bsrc_Api.h"
#include "PreAggregator_Api.h"
#endif
#include "RxClassifier_Api.h"
#include "HwLoggerLogsDefinitions.h"
#include "HdkCdbManagerTask_api.h"
/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_LOWER_MAC
#define LOG_LOCAL_FID 3

extern uint32 SWD_isAssertFromUpperMAC;

/*********************/
/* Macro definitions */
/*********************/

/*********************************/
/* Forward function declarations */
/*********************************/
void vStartReq(K_MSG * ptK_MSG);

 
/*******************************/
/* Public variable definitions */
/*******************************/


/*******************************/
/* Static variable definitions */
/*******************************/


#if defined (HW_SEMAPHORE_DEBUG)
uint32 delayCounterTest;
#endif

/*******************************/
/* Public function definitions */
/*******************************/
extern	uint32	Utils_CountLeadingZeros	(uint32 num); 

/***************************************************************************
**
** NAME         vLM_Init(void)
**
** PARAMETERS   None
**
** DESCRIPTION  This routine initialises the Lower MAC (LM) state machine
**              etc.
**
****************************************************************************/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization"
#endif

void vLM_Init(void)
{
	/* This structure is meant for compiling the logs structrues in LMAC for debug purposes */
	HwLogs_u *hwLogs;
	UNUSED_PARAM(hwLogs);
	SET_DEBUG_CHI(0x80007700);

#if defined (ENET_INC_HW_FPGA) && defined (ENET_INC_LMAC1)
	if(ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
	{
	    /* Choose between real and Dummy PHY */
		HWInit();
		SET_DEBUG_CHI(0x80007701);
		/* Initialize Tx Selector */
		TxSelector_Init();
		SET_DEBUG_CHI(0x80007702);
#if defined(ENET_INC_ARCH_WAVE600)
		/* Initialize Beacon Handler */
		BeaconHandler_Init(); // In gen6 we init it here. In gen5 it is init after init is done (in kernel scheduler) since it overlays data with the init code.
#endif		
	}
	
#ifndef ENET_INC_ARCH_WAVE600	// No need to do it in Gen6
	Pac_RxcReset();
#endif

    /* Initialise variables */
#if defined (ENET_INC_LMAC0)
    sLMvectorBlock.u32Signature       = ~LM_VB_SIGNATURE;
#endif
#if defined (ENET_INC_LMAC1)
    sLMvectorBlock.u32Lm1Signature    = ~LM_VB_SIGNATURE;
#endif

    /* Enable all signals to the foreground task */
    vClearAllSignalMask();

#if defined(ENET_INC_ARCH_WAVE600)
	TimerUtiltyInit(); // In gen6 we init it here. In gen5 it is init after init is done (in kernel scheduler) since it overlays data with the init code.
	SET_DEBUG_CHI(0x80007703);

	Lm_StadBInit(); // In gen6 we init it here. In gen5 it is init after init is done (in kernel scheduler) since it overlays data with the init code.
#endif
	
#if defined(ENET_INC_LMAC1) 
	if (ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
	{
#if defined(ENET_INC_ARCH_WAVE600)
		Lm_VapDbInit();
		SET_DEBUG_CHI(0x80007708);	
		Mac2Index_Initialize();
		SET_DEBUG_CHI(0x80007704);
#endif
		LinkAdaptation_Init();

	}

#if defined (ENET_INC_HW_FPGA) && defined (ENET_INC_LMAC1)
	if(ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
	{
		ProtectedDbLock_Initialize();
	}
#if defined(ENET_INC_ARCH_WAVE600)
	// following module are inited in LM for wave600 and in UM for wave500
	HDK_Init();
	InterfererDetection_Initialize();
	SET_DEBUG_CHI(0x8000770C);

	CoC_Init();
	SET_DEBUG_CHI(0x8000770D);
	
	ServicesHandler_Init();
	SET_DEBUG_CHI(0x8000770E);
	
	ProcessManager_Init();
	SET_DEBUG_CHI(0x8000770F);
	
	ChannelSwitchManager_Initialize();
	SET_DEBUG_CHI(0x80007710);

#if defined (ENET_INC_HW_FPGA) && defined (ENET_INC_LMAC1)
	if(ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
	{
		// following HW drivers are inited in LM for wave600 and in UM for wave500
		Pac_RxcInitializeNoBaAgreementFifo(); // In gen5 this is done in RXF. There is no RXF in gen6. It was moved to RXC.
		SET_DEBUG_CHI(0x80007711);
		TxPauser_Initialize();	
		SET_DEBUG_CHI(0x80007712);
		PsManager_Init();
		SET_DEBUG_CHI(0x80007713);


		HwSecurity_Init();
		SET_DEBUG_CHI(0x80007714);
		TxHandler_Initialize();
		SET_DEBUG_CHI(0x80007715);
		DeliaRecipes_ConstructRecipes();
		SET_DEBUG_CHI(0x80007716);
		Deaggregator_Init(); // Wave600 only. Not exist in Wave500.
		SET_DEBUG_CHI(0x80007717);
		
		RxClassifier_Init();
		SET_DEBUG_CHI(0x80007718);
		AutoResponse_Init(); // Wave600 only. Not exist in Wave500.
		SET_DEBUG_CHI(0x80007719);
		Bsrc_Initialize();
	}

#if defined(ENET_INC_LMAC1) 
	if (ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
	{
		SET_DEBUG_CHI(0x8000771a);
		RxHandler_Init();
		SET_DEBUG_CHI(0x8000771b);
		Sender_Initialize();
		SET_DEBUG_CHI(0x80007b1a);
	}	
	
#endif
#if	!defined (ENET_INC_ARCH_WAVE600)
	HdkCdbManager_Init();			//in wave500 HdkCdbManager_Init is here. In wave600 post init is in UM.
#endif

	PacManager_PostInit();
	SET_DEBUG_CHI(0x8000771C);
#if defined(ENET_INC_ARCH_WAVE600)
	BaAnalyzer_InitializeBaaStatusFifo();
	PreAggregator_InitReportFifos();

	SET_DEBUG_CHI(0x8000771D);
	UlPostRx_InitializeFifos();
	SET_DEBUG_CHI(0x8000771E);
#if defined (ENET_INC_HW_FPGA) || defined (ENET_INC_LMAC1)
	if(ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND)
#endif
	{
		PhyDrv_ClearPhyInterrupts();
	}
	SET_DEBUG_CHI(0x8000771F);
#endif
}


void Lm_WaitForUm(void)
{
	while(1)
    {
#if defined (ENET_INC_LMAC0)	
   		if( sLMvectorBlock.u32Signature != UM_VB_SIGNATURE )
#endif
#if defined (ENET_INC_LMAC1)	
		if( sLMvectorBlock.u32Lm1Signature != UM_VB_SIGNATURE )
#endif

        {
        	continue;
        }
        break;
    }
}


void vLM_Enable(void)
{
    /* MARK SHRAM for testing alignment between LM and UM */
#if defined (ENET_INC_LMAC0)	
    u32Shram_LM_UM_alignment = (uint32)&u32Shram_LM_UM_alignment;
	sLMvectorBlock.u32Signature = LM_VB_SIGNATURE;
#endif
#if defined (ENET_INC_LMAC1)
	 u32Shram_LM1_UM_alignment = (uint32)&u32Shram_LM1_UM_alignment;
	sLMvectorBlock.u32Lm1Signature = LM_VB_SIGNATURE;
#endif
}

#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif



/********************************/
/* Static function declarations */
/********************************/

/**********************************************************************************

lmmain_HwSemaphoreTest 


Description:
------------
This function is used for testing HW semaphore:
The lower MAC is given time to lock location HW_SEMAPHORE_16_0 and then upper MAC tries to lock it 

Input: 
-----

Returns:
--------
	void - 
	
**********************************************************************************/
#if defined (HW_SEMAPHORE_DEBUG)
void  lmmain_HwSemaphoreTest()
{
	/* debug semaphore */
	//uint32 lockStatus = 0;
	//uint32 loop = 0;
	uint32 delay = 0;
	/* debug semaphore */
	
	/* debug trace */
	// lock
#if defined(ENET_INC_ARCH_WAVE600)	
	HW_SEMAPHORE_LOCK(HW_SEMAPHORE_TEST);
#else
	HW_SEMAPHORE_LOCK(HW_SEMAPHORE_16_0);
#endif
	ILOG0_V("[lmmain_HwSemaphoreTest 2] got the lock");


	// do an action (delay 2 seconds)
	
	for(delay = 0; delay < 49230769; delay++)
	{
		delayCounterTest++;
	}
	
	// free

	ILOG0_V("[lmmain_HwSemaphoreTest 3] try to free");
#if defined(ENET_INC_ARCH_WAVE600)	
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_TEST);
#else
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_16_0);
#endif

	// this is the original message that gets lost
	ILOG0_V("[lmmain_HwSemaphoreTest 4] lock is free");

	// Do we loose a "large" message
	//(0, 0, K_MSG, psMsg);


	/* debug semaphore */
	/*
	// debug semaphore 
	lockStatus = HwSemaphore_Read();
	ILOG0_D("[1] Try to get the lock. Lock status is %d", lockStatus);

	HwSemaphore_Lock(HW_SEMAPHORE_16_0);
	lockStatus = HwSemaphore_Read();
	ILOG0_D("[2] I got the lock. Lock status is %d", lockStatus);

	HwSemaphore_Free(HW_SEMAPHORE_16_0);
	lockStatus = HwSemaphore_Read();
	ILOG0_D("[3] I freed the lock. lock status is %d", lockStatus);
	*/
	// debug semaphore

}
#endif

/***************************************************************************
**
** NAME         vStartReq
**
** PARAMETERS   ptK_MSG      - pointer to kernel message
**
** DESCRIPTION  This routine handles starting a network.
**
****************************************************************************/
void vStartReq(K_MSG * ptK_MSG)
{
 	TX_INTERRUPT_SAVE_AREA;
	UNUSED_PARAM(ptK_MSG);
	/* disable interrupts   */
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	/*Config TIM - Slot time can be set when PHY mode is set*/
    Pac_TimSetSlotTimer(SLOT_TIME_11B);
	/* enable interrupts    */
	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}


/***************************************************************************
**
** NAME         lmGetBcl
**
** PARAMETERS   none
**
** DESCRIPTION  
**
****************************************************************************/
void lmGetBcl(K_MSG * ptK_MSG)
{
	UMI_BCL_REQUEST*	pBclMsg 	= (UMI_BCL_REQUEST*)pK_MSG_DATA(ptK_MSG);

	MT_vUM_CommonManQueryBclValueReq(pBclMsg);
	SET_OTHER_CPU_BIT(pBclMsg->Address);
	OSAL_SEND_MESSAGE(UMI_MC_MAN_QUERY_BCL_CFM, TASK_UM_IF_TASK, ptK_MSG, ptK_MSG->header.vapId);
}
/***************************************************************************
**
** NAME         lmSetBcl
**
** PARAMETERS   none
**
** DESCRIPTION  
**
****************************************************************************/
void lmSetBcl(K_MSG * ptK_MSG)
{
	UMI_BCL_REQUEST*	pBclMsg 	= (UMI_BCL_REQUEST*)pK_MSG_DATA(ptK_MSG);

	MT_vUM_CommonManSetBclValueReq(pBclMsg);
	SET_OTHER_CPU_BIT(pBclMsg->Address);
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_BCL_CFM, TASK_UM_IF_TASK, ptK_MSG, ptK_MSG->header.vapId);
}


#ifndef ENET_INC_ARCH_WAVE600
/***************************************************************************
**
** NAME 		lmLogFillMsgHdrTemplate
**
** PARAMETERS	none
**
** DESCRIPTION	
**
****************************************************************************/
void lmLogFillMsgHdrTemplate(K_MSG * ptK_MSG)
{
	logFillMsgHdrTemplate((UMI_ADD_STREAM_REQ_t*)ptK_MSG->abData);
	OSAL_SEND_MESSAGE(UMI_MC_MAN_ADD_STREAM_CFM, TASK_UM_IF_TASK, ptK_MSG, VAP_ID_DO_NOT_CARE);
}
#endif

