/* CMSynergyVer %full_filespec: lmutil.c;33.7.1.1.2.1.2.1.2.3.2.3:csrc:1 % */
/**************************************************************************
***************************************************************************
**
** COMPONENT:       ENET SW - Lower MAC
**
** MODULE:          \\WL\develop\src\mac\mac_lower\lmutil.c
**
** VERSION:         $Revision: #9 $
**
** AUTHOR:          John Gladman
**
** DESCRIPTION:     Lower MAC Utility Routines
**
** CHANGE HISTORY:
**
**   $Log: lmutil.c $
**   Revision 1.2  2003/02/11 17:41:30Z  prh
**   Make selection of 802.11b Short/Long Preamble selection similar to 802.11g.
**   Revision 1.41  2002/12/17 17:07:37Z  jag1
**   Changed functionality of LoadConditionMatrix routine.
**   Revision 1.40  2002/12/10 16:11:31Z  jag1
**   Include of System_Configuration.h added.
**   Revision 1.39  2002/12/06 11:54:50Z  prh
**   LM sets up tick timer for UM.
**   Revision 1.38  2002/12/04 13:06:45Z  jag1
**   Changes to random number generator.
**   Bug fix in SetSlotDuration.
**   Revision 1.37  2002/10/28 11:00:14Z  jag1
**   Additions and modifications in support of 802.11g.
**   Revision 1.36  2002/09/16 10:16:01Z  djh
**   Now seeds random number from MAC address on first call
**   Revision 1.35  2002/09/04 15:08:53Z  ifo
**   Fixed gross TSF adjustment for corner cases
**   (test 620 sometimes failed).
**   --- Added comments ---  ifo [2002/09/05 08:11:14Z]
**   PR3610_0042
**   Revision 1.34  2002/07/23 12:22:47Z  ifo
**   Interrupt between LMAC/UMAC use int_gen driver.
**   Revision 1.33  2002/07/16 09:55:45Z  smk
**   start of PCF code
**   Revision 1.32  2002/06/24 14:29:58Z  smk
**   initial PCF additions
**   receive matrix is altered to cope with the additional rows needed in PCF,
**   this means DCF is set up slightly differently.
**   Revision 1.31  2002/06/21 09:40:38Z  smk
**   modification of randomiser function due to lack of randomness in low bits
**   Revision 1.30  2002/05/10 16:04:13Z  jag1
**   Fixed problem with vAdjustTSF and added new routines.
**   Merged in branch 1.29.1.
**   ...
**   Revision 1.1  2001/08/08 13:22:47Z  jag1
**   Initial revision
**
** LAST MODIFIED BY:   $Author: jh3 $
**                     $Date: 2004/03/25 $
**
****************************************************************************
*
* Copyright (c) 2001, 2002 TTPCom Limited
*
****************************************************************************/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "System_Timers.h"
#include "ErrorHandler_Api.h"
#include "OSAL_Api.h"
#include "OSAL_Interrupts.h"
#include "InterruptManager_Api.h"
#include "stringLibApi.h"
#include "Dut_Api.h"
#include <protocol.h>
#include <enet_pas.h>
#include <PhyDriver_API.h>
#include <MT_MAC_PAC_regs.h>
#include <shram_man_queues.h>
#include <lmi.h>
#include <int_gen.h>
#include "lm.h"
#include "lminfra.h"
#include "mt_sysrst.h"
#include "PhyDriver_API.h"
#include "sysinfo.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_Emerald_Env_regs.h"
#else
#include "EmeraldEnvRegs.h"
#endif
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_MAC_HT_extensions_regs.h"
#endif
#include "MacHtExtensionsRegs.h"
#include "TpcClbrHndlr.h"
#include "HostInterface_API.h"
#include "MT_QSmachine.h"
#include "shram_lmi_vectors.h"
#include "Pac_Api.h"
#include "Debug_Trace.h"
#include "TxSelector_Api.h"
#include "BeaconHandler_api.h"
#include "RegAccess_Api.h"
#include "Protocol_PhyAttributes.h"
#include "MacRabRegs.h"
#include "VapDatabase_Api.h"
#include "BaAnalyzer_Api.h"
#include "Initialization_Api.h"
#include "HwBeamforming_Api.h"
#include "TxSequencer_Api.h"
#if defined(ENET_INC_ARCH_WAVE600)
#include "OtfAggregator_Api.h"
#include "PreAggregator_Api.h"
#include "TxHeaderConversion_Api.h"
#include "TxPdAcc_Api.h"
#include "UlPostRx_Api.h"
#include "HwMbfm_Api.h"
#else
#include "AggregationBuilder_Api.h"
#endif 

/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_LOWER_MAC
#define LOG_LOCAL_FID 6



/*********************************/
/* Forward function declarations */
/*********************************/

/*******************************/
/* Static variable definitions */
/*******************************/


/*******************************/
/* Public function definitions */
/*******************************/


/***************************************************************************
**
** NAME         vDCFinit(void)
**
** PARAMETERS   none
**
** RETURNS      Nothing
**
** DESCRIPTION  This routine (re)initialises the Infrastructure sub state-
**              machine for DCF traffic mode.  It is called on START or JOIN,
**              and also when returning to DCF after a period of PCF
**
****************************************************************************/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif
void vDCFinit(void)
{
#ifndef ENET_INC_ARCH_WAVE600 // There is no RxD in gen6	
    /* Program condition matrix rows */
	Pac_RxdLoadConditionMatrix();
#endif
}
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif

/***************************************************************************
**
** NAME         vSetSlotDuration11g
**
** PARAMETERS   uiSlotType11g - either LM_SHORT_SLOT_11G or LM_LONG_SLOT_11G
**
** RETURNS      Nothing
**
** DESCRIPTION  This routine makes appropriate adjustments to TTCSs to set
**              the size of the PHY slot.
**
****************************************************************************/

void vSetSlotDuration11g(uint32 uiSlotType11g)
{
    uint32 u32SlotTimerValue;

    if (uiSlotType11g == LM_SHORT_SLOT_11G) // update IFSs SW delays
    {
		u32SlotTimerValue = SLOT_TIME_11A; 
    }
    else
    {
		u32SlotTimerValue = SLOT_TIME_11B;
    }
    // Slot time adjustment
    Pac_TimSetSlotTimer(u32SlotTimerValue);
}

/********************************/
/* Static function declarations */
/********************************/

/***************************************************************************
**
** NAME         HWInit
**
** PARAMETERS   Initialize HW
**
** RETURNS      NONE
**
** DESCRIPTION  
**
****************************************************************************/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif
void HWInit()
{
	TX_INTERRUPT_SAVE_AREA;


	/* disable interrupts   */
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	/*    MAC reset         */
	Initialization_HwHandler_ResetHw();
	SET_DEBUG_CHI(0x80002341);
#ifndef ENET_INC_ARCH_WAVE600B    
    Pac_ClcInit();
#endif
	SET_DEBUG_CHI(0x80002342);
    /* Program TIM block  - must be prior to any phy start\stop*/
	Pac_TimInit();
	/* HW reset - phy & MAC */
	SET_DEBUG_CHI(0x80002343);

    Pac_RxcInit();
	SET_DEBUG_CHI(0x80002345);
	Pac_DurInit();
	SET_DEBUG_CHI(0x80002346);
	Pac_DeliniatorInit();
	SET_DEBUG_CHI(0x80002347);

#ifndef ENET_INC_ARCH_WAVE600 // There is no RxD in gen6	
	/*Init RXD*/
    Pac_RxdInit();
	SET_DEBUG_CHI(0x80002348);

#endif

    Pac_DeliaInit();


    /* Program TXC block */
	Pac_TxcInit();
	SET_DEBUG_CHI(0x80002349);
   	/* Configure FDC HW */
	vConfigFDC();
	SET_DEBUG_CHI(0x80002350);
    /* Init & Configure BA HW */
	vBA_INIT();
	SET_DEBUG_CHI(0x80002351);

	BaAnalyzer_Initialize();
	SET_DEBUG_CHI(0x80002352);

	TxSequencer_Init();
	SET_DEBUG_CHI(0x80002353);
#ifdef ENET_INC_ARCH_WAVE600
	PreAggregator_Initialize();
	OtfAggregator_Initialize();
	UlPostRx_Initialize();
	SET_DEBUG_CHI(0x80002354);
	HwMbfm_Init();
#else
	AggregationBuilder_Initialize();
	SET_DEBUG_CHI(0x80002354);
	HwBeamforming_Init();
#endif //ENET_INC_ARCH_WAVE600
	SET_DEBUG_CHI(0x80002355);

#ifndef ENET_INC_ARCH_WAVE600 // There is no RxF in gen6	
	/* Initialize RXF block */
	Pac_RxfInit();
	SET_DEBUG_CHI(0x80002356);
#else
	TxHeaderConversion_Initialize();
	SET_DEBUG_CHI(0x80002356);
	TxPdAcc_Initialize();
	SET_DEBUG_CHI(0x80002357);
#endif

	/* Program DCF block */
	vDCFinit();
	//clear all interrupts
	LM_ClearAllInterrupts();
	/* enable interrupts    */
	OSAL_ENABLE_INTERRUPTS(interrupt_save);
	/* enable phy           */
	SET_DEBUG_CHI(0x80002360);
#if defined(ENET_INC_LMAC1) 
	if (ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND) // Phy should not be activated in SB mode on LM1
#endif
	{
		PhyDrv_DisablePhy();
#ifdef ENET_USE_DUMMY_PHY
		PhyDrv_ResetAndEnable();
#endif
	}
	SET_DEBUG_CHI(0x80002004);
}
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif
