/* CMSynergyVer %full_filespec: lm_interface_task.c;5.7.2.2:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET Upper MAC SW
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/lm_interface_task.c $
 **
 ** VERSION:        $Revision: #6 $
 **
 ** DATED:          $Date: 2004/03/26 $
 **
 ** AUTHOR:         S Sondergaard
 **
 ** DESCRIPTION:    Lower MAC interface task
 **
 ** LAST MODIFIED BY:   $Author: jh3 $
 **
 ****************************************************************************
 *
 *  (c) Copyright 2001, TTPCom Limited
 *
 ****************************************************************************/


/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ieee80211.h"
#include "msgid.h"
#include "stringLibApi.h"
#include "int_gen.h"
#include "lmi.h"
#include "MT_lmi.h"
#include "mib_id.h"
#include "mib_ms.h"
#include "lm_interface.h"
#include "queue_utility.h"      /* Queue handling routines */
#include "init_ifmsg.h"
#include "shram_lmi_vectors.h"
#include "shram_man_msgs.h"
#include "shram_man_queues.h"
#include "shram_rx_buffer.h"
#include "database.h"
#include "enet_pas.h"
#include "enet_hrc.h"
#include "enet_brc.h"
#include "um_interface.h"
#include "MT_shram_alignment.h"
#include "MT_NSSMemoryPool.h"   /* Aggregation Object Pool */
#include "CalibrationManager.h"
#if defined (CPU_MIPS)
#include "MT_osutl.h"
#endif
#include "bss_manage_task.h"
 #include "ServicesHandler_Api.h"
#include "ErrorHandler_Api.h"
#include "PacketDescriptor.h"
#include "Pac_Api.h"
#include "shram_man_msgs.h"
#include "OSAL_Api.h"
 #include "ShramPacketDescriptors.h"//to be removed when PDs are insterted
#include "ResourceManager_API.h"
#include "shramTxDesc.h"
#include "ShramDataTxDescriptors.h"
#include "HwQManager_API.h"
 #include "BeaconHandler_api.h"
#include "linkAdaptation_api.h"
#include "ChannelSwitchManager_Api.h"
#include "ProcessManager_Api.h"
#include "mt_bcl_task.h"
#include "ShramEnd.h"
#include "ipc_api.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "HwMemoryMap.h"
#endif
#ifndef ENET_INC_ARCH_WAVE600
#include "AggregationBuilder_Api.h"
#endif 


/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_LOWER_MAC_IF
#define LOG_LOCAL_FID 0


/***************************************************************************/
/***                  Local Constants                                    ***/
/***************************************************************************/


/***************************************************************************/
/***                  Local Variables                                    ***/
/***************************************************************************/


/***************************************************************************/
/*                    External Definitions                               ***/
/***************************************************************************/



/***************************************************************************/
/***                  Function prototypes                                ***/
/***************************************************************************/



/***************************************************************************/
/***                  Static data                                        ***/
/***************************************************************************/

/***************************************************************************/
/***                  Constants and Macros                               ***/
/***************************************************************************/

/* Delay between polling LM for signature - in "for" loops */
#define LMI_MAX_POLL_DELAY              100


/***************************************************************************/
/***                  Public Routines                                    ***/
/***************************************************************************/

/****************************************************************************
 **
 ** NAME:           vLMI_Init
 **
 ** PARAMETERS:     none
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:
 **
 **
 ****************************************************************************/
volatile uint32  u32PollAttempts;
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

extern uint8 _fSHARED_RAM_DATA_TX_DESC[];

void vLMI_Init(void)
{
    uint32  u32PollDelay;	
#ifndef ENET_INC_ARCH_WAVE600
	Rd_t *pRd = (Rd_t*)(&(ShramEndSection[0]));
	TxPd_t *pPd = (TxPd_t *)(&(ShramEndSection[0]));
#endif //ENET_INC_ARCH_WAVE600
#if defined (ENET_INC_ARCH_WAVE600)
	PacketDescriptorsPtr = (uint32*)(_fSHARED_RAM_DATA_TX_DESC); //(uint32)DESCRIPTOR_RAM_BASE_ADDR (=0xA0400000);
#else
	PacketDescriptorsPtr = (uint32 *) ((uint32)(&(ShramEndSection[0])) - (NEXT_PD_NULL << 2));
#endif

#ifndef ENET_INC_ARCH_WAVE600	
	memset(&(ShramEndSection[0]), 0x0, sizeof(ShramEndSection));
	pPd->pdSource = HW_Q_MANAGER_DONE_LIST_ERROR;

	pRd = (Rd_t *)(&(ShramEndSection[0]));
	pRd->rdSource = HW_Q_MANAGER_RX_DONE_LIST_ERROR;
#endif //ENET_INC_ARCH_WAVE600

	sLMvectorBlock.u32Signature = UM_VB_SIGNATURE;
#ifdef ENET_INC_ARCH_WAVE600	
	sLMvectorBlock.u32Lm1Signature = UM_VB_SIGNATURE;
#endif

    /* Poll LM until vector block is valid */
    u32PollAttempts=0;
    while(1)
    {
        /* check if LM has started - if so read vector block */
#ifdef ENET_INC_ARCH_WAVE600	
        if((sLMvectorBlock.u32Signature != LM_VB_SIGNATURE) || (sLMvectorBlock.u32Lm1Signature != LM_VB_SIGNATURE))
#else		
        if( sLMvectorBlock.u32Signature != LM_VB_SIGNATURE )
#endif			
        {
            for( u32PollDelay=0; u32PollDelay<LMI_MAX_POLL_DELAY ; u32PollDelay++ )
            {
                /* NULL - just busy wait */
            }
            u32PollAttempts++;

            /* Poll again */
            continue;
        }
        /* Clear out magic for use if reset */
        sLMvectorBlock.u32Signature = 0;
#ifdef ENET_INC_ARCH_WAVE600	
		sLMvectorBlock.u32Lm1Signature = 0;
#endif		
        break;
    }

    /* Test the upper and the lower cpu shram is align */
    DEBUG_ASSERT( u32Shram_LM_UM_alignment == (uint32)&u32Shram_LM_UM_alignment);
    u32Shram_LM_UM_alignment = 0;
#ifdef ENET_INC_ARCH_WAVE600	
	DEBUG_ASSERT( u32Shram_LM1_UM_alignment == (uint32)&u32Shram_LM1_UM_alignment);
	u32Shram_LM1_UM_alignment = 0;
#endif	
}

#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

/****************************************************************************
 **

 ** NAME:           vLMI_ISR_IPC_TO_UM_FROM_LM0
 **
 ** PARAMETERS:
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    This is the ISR for Confirm events (LM_EVT_M_CFM) from the LM.
 **
 ****************************************************************************/
void vLMI_ISR_IPC_TO_UM_FROM_LM0(void)
{
	IpcNewMsgFromOtherCore_t *ipcNewMsgFromOtherCore_p;
	K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(IpcNewMsgFromOtherCore_t));
	ipcNewMsgFromOtherCore_p = (IpcNewMsgFromOtherCore_t*) pK_MSG_DATA(pMsg);
	ipcNewMsgFromOtherCore_p->queueType = IPC_QUEUE_TYPE_LM0_TO_UM; 
	OSAL_SEND_MESSAGE(IPC_NEW_MSG_FROM_OTHER_CORE, TASK_IPC, pMsg, VAP_ID_DO_NOT_CARE);
}

#if defined (ENET_INC_ARCH_WAVE600)

/****************************************************************************
 **

 ** NAME:           vLMI_ISR_IPC_TO_UM_FROM_LM1
 **
 ** PARAMETERS:
 **
 ** RETURN VALUES:  none
 **
 ** DESCRIPTION:    This is the ISR for Confirm events (LM_EVT_M_CFM) from the LM.
 **
 ****************************************************************************/
void vLMI_ISR_IPC_TO_UM_FROM_LM1(void)
{
	IpcNewMsgFromOtherCore_t *ipcNewMsgFromOtherCore_p;
	K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(IpcNewMsgFromOtherCore_t));
	ipcNewMsgFromOtherCore_p = (IpcNewMsgFromOtherCore_t*) pK_MSG_DATA(pMsg);
	ipcNewMsgFromOtherCore_p->queueType = IPC_QUEUE_TYPE_LM1_TO_UM; 
	OSAL_SEND_MESSAGE(IPC_NEW_MSG_FROM_OTHER_CORE, TASK_IPC, pMsg, VAP_ID_DO_NOT_CARE);
}		
#endif



