/* CMSynergyVer %full_filespec: queue_utility.c;4.1.2.1.4.3.4:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET MAC: lmi if queue
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/queue_utility.c $
 **
 ** VERSION:        $Revision: #5 $
 **
 ** DATED:          $Date: 2004/02/17 $
 **
 ** AUTHOR:         Omer Modlin
 **
 ** DESCRIPTION:    General lmac interface queue handling utilities.
 **
 ****************************************************************************/

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "OSAL_Interrupts.h"
#include "InterruptManager_Api.h"

#include "lmi.h"
 #include "Debug_Trace.h"

#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_QUEUE_MGMT
#define LOG_LOCAL_FID 0



/****************************************************************************
 **
 ** NAME:           vInitMsgQ
 **
 ** PARAMETERS:     psLM_MAN_QUEUE - pointer to queue to initialise
 **
 ** RETURNS:        Nothing
 **
 ** DESCRIPTION:    This routine performs initialisation of a message queue.
 **
 ****************************************************************************/

#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif
void vInitMsgQ(struct LM_MAN_QUEUE * psLM_MAN_QUEUE)
{
    psLM_MAN_QUEUE->sQPB.pvHead = psLM_MAN_QUEUE->pvEntry;
    psLM_MAN_QUEUE->sQPB.pvTail = psLM_MAN_QUEUE->pvEntry;
	psLM_MAN_QUEUE->write_cnt = 0;
	psLM_MAN_QUEUE->read_cnt = 0;
}
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif



/****************************************************************************
 **
 ** NAME:           vPutMsgQ
 **
 ** PARAMETERS:     pvMsgHandle    - handle to the message being queued
 **                 psLM_MAN_QUEUE - pointer to queue to receive the message
 **
 ** RETURNS:        Nothing
 **
 ** DESCRIPTION:    This routine adds a message to a message queue.
 **
 ****************************************************************************/

void vPutMsgQ(void * pvMsgHandle, struct LM_MAN_QUEUE * psLM_MAN_QUEUE)
{
	TX_INTERRUPT_SAVE_AREA;
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);	

	// Check queue overflow
	DEBUG_ASSERT((psLM_MAN_QUEUE->write_cnt - psLM_MAN_QUEUE->read_cnt) < (LM_MANAGEMENT_QUEUE_LENGTH - 1));

    *(void * *)(psLM_MAN_QUEUE->sQPB.pvTail) = pvMsgHandle;

    if (psLM_MAN_QUEUE->sQPB.pvTail ==
        &psLM_MAN_QUEUE->pvEntry[LM_MANAGEMENT_QUEUE_LENGTH - 1])
    {
        psLM_MAN_QUEUE->sQPB.pvTail = psLM_MAN_QUEUE->pvEntry;
    }
    else
    {
        psLM_MAN_QUEUE->sQPB.pvTail =
            ((void * *)psLM_MAN_QUEUE->sQPB.pvTail + 1);
    }
	
	psLM_MAN_QUEUE->write_cnt++;

	AAA_DEBUG_LMI_MACRO(AAA_DebugLmi_vPutMsgQ, psLM_MAN_QUEUE->write_cnt-psLM_MAN_QUEUE->read_cnt, ((K_MSG*)pvMsgHandle)->header.tKMsgType);

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

/****************************************************************************
 **
 ** NAME:           pvGetMsgQ
 **
 ** PARAMETERS:     psLM_MAN_QUEUE - pointer to management queue from which
 **                                  to retrieve a message.
 **
 ** RETURNS:        The handle of the retrieved message or NULL if the queue
 **                 is empty.
 **
 ** DESCRIPTION:    This routine gets a message from a management message
 **                 queue.
 **
 ****************************************************************************/

void * pvGetMsgQ(struct LM_MAN_QUEUE * psLM_MAN_QUEUE)
{
    void * pvTemp = (void *)NULL;
	TX_INTERRUPT_SAVE_AREA;
    OSAL_DISABLE_INTERRUPTS(&interrupt_save);

    if (psLM_MAN_QUEUE->sQPB.pvHead != psLM_MAN_QUEUE->sQPB.pvTail)
    {
        pvTemp = *(void * *)(psLM_MAN_QUEUE->sQPB.pvHead);

        if (psLM_MAN_QUEUE->sQPB.pvHead ==
            &psLM_MAN_QUEUE->pvEntry[LM_MANAGEMENT_QUEUE_LENGTH - 1])
        {
            psLM_MAN_QUEUE->sQPB.pvHead = psLM_MAN_QUEUE->pvEntry;
        }
        else
        {
            psLM_MAN_QUEUE->sQPB.pvHead =
                ((void * *)psLM_MAN_QUEUE->sQPB.pvHead + 1);
        }
		psLM_MAN_QUEUE->read_cnt++;
		AAA_DEBUG_LMI_MACRO(AAA_DebugLmi_pvGetMsgQ, psLM_MAN_QUEUE->write_cnt-psLM_MAN_QUEUE->read_cnt, ((K_MSG*)pvTemp)->header.tKMsgType);
    }


    OSAL_ENABLE_INTERRUPTS(interrupt_save);

    return pvTemp;
}


