#/*************************************************************************
# * mt_osmip.hs
# *
# * definitions for the MIPS architecture and assembly files
# *************************************************************************/

#/*****************************************************************************
.define  SIMULATOR , 0    # Simulator flag = 1 work with Green Hills Interrupts:
                          # All exceptions jump to 0x80000180 (Interrupts too).
                          # Static initializations of variables is done by the MIPS.
#/*****************************************************************************

.define C_SR    ,0
.define C_EPC   ,1
.define C_AT    ,2
.define C_V0    ,3
.define C_V1    ,4
.define C_A0    ,5
.define C_A1    ,6
.define C_A2    ,7
.define C_A3    ,8
.define C_T0    ,9
.define C_T1    ,10
.define C_T2    ,11
.define C_T3    ,12
.define C_T4    ,13
.define C_T5    ,14
.define C_T6    ,15
.define C_T7    ,16
.define C_T8    ,17
.define C_T9    ,18
.define C_RA    ,19
.define C_LO    ,20
.define C_HI    ,21
.define C_SRSCtl ,22
.define C_SIZE  ,23

##<E.Z> additional definitions for second register file
#.define C_SR    ,0 remain as above
#.define C_EPC   ,1 remain as above
.define C_LO2	,2
.define C_HI2	,3
.define C_SIZE2	,4

.define K0BASE 		,0x80000000
.define K0SIZE 		,0x20000000
.define K1BASE 		,0xa0000000
.define K1SIZE 		,0x20000000
.define K2BASE 		,0xc0000000
.define GEN_VECT 	,0x80000180
.define UTLB_VECT 	,0x80000000


# /* aliases for general registers */
.define zero	,$0
.define	AT		,$1		# /* assembler temporaries */
.define	v0		,$2		# /* value holders */
.define	v1		,$3
.define	a0		,$4		# /* arguments */
.define	a1		,$5
.define	a2		,$6
.define	a3		,$7
.define	t0		,$8		# /* temporaries */
.define	t1		,$9
.define	t2		,$10
.define	t3		,$11
.define	t4	    ,$12
.define	t5		,$13
.define	t6		,$14
.define	t7		,$15
.define	s0		,$16		# /* saved registers */
.define	s1		,$17
.define	s2		,$18
.define	s3		,$19
.define	s4		,$20
.define	s5		,$21
.define	s6		,$22
.define	s7		,$23
.define	t8		,$24		# /* temporaries */
.define	t9		,$25
.define	k0		,$26		# /* kernel registers */
.define	k1		,$27
.define	gp		,$28		# /* global pointer */
.define	sp		,$29		# /* stack pointer */
.define	s8		,$30		# /* saved register */
.define	fp		,$30		# /* frame pointer (old usage) */
.define	ra		,$31		# /* return address */

# /* System Control Coprocessor (CP0) registers */
.define C0_SR		,$12		# /* Processor Status */
.define C0_CAUSE	,$13		# /* Exception Cause */
.define C0_EPC		,$14		# /* Exception PC */
.define C0_BADADDR	,$8		# /* Bad Address */
.define C0_BADVADDR	,$8		# /* Bad Virtual Address */
.define C0_PRID		,$15		# /* Processor Rev Indentifier */

.define C0_CTEXT	,$4		# /* Context */
.define C0_TLBHI	,$10		# /* TLB EntryHi */
.define C0_TLBLO	,$2		# /* TLB EntryLo */
.define C0_INX		,$0		# /* TLB Index */
.define C0_RAND		,$1		# /* TLB Random */

# /* Status Register */
.define SR_CUMASK	,0xf0000000	# /* Coprocessor usable bits */
.define SR_CU3		,0x80000000	# /* Coprocessor 3 usable */
.define SR_CU2		,0x40000000	# /* coprocessor 2 usable */
.define SR_CU1		,0x20000000	# /* Coprocessor 1 usable */
.define SR_CU0		,0x10000000	# /* Coprocessor 0 usable */
.define SR_BEV		,0x00400000	# /* Bootstrap Exception Vector */
.define SR_TS		,0x00200000	# /* TLB shutdown */
.define SR_SR		,0x00100000	# /* Reset was due to Soft Reset */
.define SR_NMI		,0x00080000	# /* Reset was due to NMI */
.define SR_PZ		,0x00040000	# /* Parity Zero */
.define SR_SWC		,0x00020000	# /* Swap Caches */
.define SR_ISC		,0x00010000	# /* Isolate Cache */

.define SR_IMASK	,0x0000ff00	# /* Interrupt Mask */
.define SR_IMASK8	,0x00000000	# /* Interrupt Mask level=8 */
.define SR_IMASK7	,0x00008000	# /* Interrupt Mask level=7 */
.define SR_IMASK6	,0x0000c000	# /* Interrupt Mask level=6 */
.define SR_IMASK5	,0x0000e000	# /* Interrupt Mask level=5 */
.define SR_IMASK4	,0x0000f000	# /* Interrupt Mask level=4 */
.define SR_IMASK3	,0x0000f800	# /* Interrupt Mask level=3 */
.define SR_IMASK2	,0x0000fc00	# /* Interrupt Mask level=2 */
.define SR_IMASK1	,0x0000fe00	# /* Interrupt Mask level=1 */
.define SR_IMASK0	,0x0000ff00	# /* Interrupt Mask level=0 */

.define SR_IBIT8	,0x00008000	# /*  (Intr5) */
.define SR_IBIT7	,0x00004000	# /*  (Intr4) */
.define SR_IBIT6	,0x00002000	# /*  (Intr3) */
.define SR_IBIT5	,0x00001000	# /*  (Intr2) */
.define SR_IBIT4	,0x00000800	# /*  (Intr1) */
.define SR_IBIT3	,0x00000400	# /*  (Intr0) */
.define SR_IBIT2	,0x00000200	# /*  (Software Interrupt 1) */
.define SR_IBIT1	,0x00000100	# /*  (Software Interrupt 0) */

.define SR_KUO		,0x00000020	# /* Kernel/User mode, old */
.define SR_IEO		,0x00000010	# /* Interrupt Enable, old */
.define SR_KUP		,0x00000008	# /* Kernel/User mode, previous */
.define SR_IEP		,0x00000004	# /* Interrupt Enable, previous */
.define SR_KUC		,0x00000002	# /* Kernel/User mode, current */
.define SR_IEC		,0x00000001	# /* Interrupt Enable, current */
.define SR_EXL      ,0x00000002 # /* Exception Level */
.define SR_ERL      ,0x00000004 # /* Error Level */

# /* Cause Register */
.define CAUSE_BD		,0x80000000	# /* Branch Delay */
.define CAUSE_CEMASK	,0x30000000	# /* Coprocessor Error */
.define CAUSE_CESHIFT	,28			# /* Right justify CE  */
.define CAUSE_IPMASK	,0x0000ff00	# /* Interrupt Pending */
.define CAUSE_IPSHIFT	,8			# /* Right justify IP  */
.define CAUSE_IP8		,0x00008000	# /*  (Intr5) */
.define CAUSE_IP7		,0x00004000	# /*  (Intr4) */
.define CAUSE_IP6		,0x00002000	# /*  (Intr3) */
.define CAUSE_IP5		,0x00001000	# /*  (Intr2) */
.define CAUSE_IP4		,0x00000800	# /*  (Intr1) */
.define CAUSE_IP3		,0x00000400	# /*  (Intr0) */
.define CAUSE_SW2		,0x00000200	# /*  (Software Int 1) */
.define CAUSE_SW1		,0x00000100	# /*  (Software Int 0) */
.define CAUSE_EXCMASK	,0x0000007c	# /* Exception Code */
.define CAUSE_EXCSHIFT	,2			# /* Right justify EXC */

# /* Exception Code */
.define EXC_INT		,(0 << 2)	# /* External interrupt */
.define EXC_MOD		,(1 << 2)	# /* TLB modification */
.define EXC_TLBL	,(2 << 2)    	# /* TLB miss (Load or Ifetch) */
.define EXC_TLBS	,(3 << 2)	# /* TLB miss (Save) */
.define EXC_ADEL	,(4 << 2)    	# /* Addr error (Load or Ifetch) */
.define EXC_ADES	,(5 << 2)	# /* Address error (Save) */
.define EXC_IBE		,(6 << 2)	# /* Bus error (Ifetch) */
.define EXC_DBE		,(7 << 2)	# /* Bus error (data load/store) */
.define EXC_SYS		,(8 << 2)	# /* System call */
.define EXC_BP		,(9 << 2)	# /* Break point */
.define EXC_RI		,(10 << 2)	# /* Reserved instruction */
.define EXC_CPU		,(11 << 2)	# /* Coprocessor unusable */
.define EXC_OVF		,(12 << 2)	# /* Arithmetic overflow */

# /* FPU stuff */
.define C1_CSR		,$31
.define CSR_EMASK	,(0x3f<<12)
.define CSR_TMASK	,(0x1f<<7)
.define CSR_SMASK	,(0x1f<<2)
.define C1_FRID		,$0

