#/*****************************************************************************
#*    
#*   MODULE NAME:
#*       MT_OsReg.s
#*   DESCRIPTION: 
#*       Helper functions to avoid Green Hills compiler libraries.
#*       Save/restore register rutines, replacing Green Hills rutines.
#*       Includes _main function that is called first and copy initilized 
#*       varibles from romdata,romsdata segments to data,sdata segments.
#*   AUTHOR:  
#*       Ziv Avital
#*   DATE: 
#*       24/04/2000
#*   COPYRIGHT: 
#*       (C) Metalink Ltd.
#*       All rights are strictly reserved. Reproduction or divulgence in any 
#*       form whatsoever is not permitted without written authority from the 
#*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
#*       Israel - 11/94.
#*   REVISION HISTORY: 
#*       MetalinkRevision: 
#*****************************************************************************/

    .text
    .include "mt_osmip.hs"

    .globl __saveg30
    .globl __saveg23
    .globl __saveg22
    .globl __saveg21
    .globl __saveg20
    .globl __saveg19
    .globl __saveg18
    .globl __saveg17
    .globl __saveg16
    .globl __saveg31
    .globl __restg31
    .globl __restg16
    .globl __restg17
    .globl __restg18
    .globl __restg19
    .globl __restg20
    .globl __restg21
    .globl __restg22
    .globl __restg23
    .globl __restg30
    .globl __saveg30s
    .globl __saveg23s
    .globl __saveg22s
    .globl __saveg21s
    .globl __saveg20s
    .globl __saveg19s
    .globl __saveg18s
    .globl __saveg17s
    .globl __saveg16s
    .globl __saveg31s


    .set noreorder

__saveg30:            addiu      sp, sp, -0x4
                      sw         $30, 0(sp)
__saveg23:            addiu      sp, sp, -0x4
                      sw         $23, 0(sp)
__saveg22:            addiu      sp, sp, -0x4
                      sw         $22, 0(sp)
__saveg21:            addiu      sp, sp, -0x4
                      sw         $21, 0(sp)
__saveg20:            addiu      sp, sp, -0x4
                      sw         $20, 0(sp)
__saveg19:            addiu      sp, sp, -0x4
                      sw         $19, 0(sp)
__saveg18:            addiu      sp, sp, -0x4
                      sw         $18, 0(sp)
__saveg17:            addiu      sp, sp, -0x4
                      sw         $17, 0(sp)
__saveg16:            addiu      sp, sp, -0x4
                      sw         $16, 0(sp)
                      addu       $16, $31, zero
__saveg31:            addiu      sp, sp, -0x4
                      sw         $2, 0(sp)
                      jr         $31
                      ori        sp, $12, 0


__restg31:            beq        zero, zero, __restg30_0x2c 
                      ori        $4, zero, 0x4
__restg16:            beq        zero, zero, __restg30_0x28 
                      ori        $4, zero, 0x8
__restg17:            beq        zero, zero, __restg30_0x24 
                      ori        $4, zero, 0xc
__restg18:            beq        zero, zero, __restg30_0x20 
                      ori        $4, zero, 0x10
__restg19:            beq        zero, zero, __restg30_0x1c 
                      ori        $4, zero, 0x14
__restg20:            beq        zero, zero, __restg30_0x18 
                      ori        $4, zero, 0x18
__restg21:            beq        zero, zero, __restg30_0x14 
                      ori        $4, zero, 0x1c
__restg22:            beq        zero, zero, __restg30_0x10 
                      ori        $4, zero, 0x20
__restg23:            beq        zero, zero, __restg30_0xc 
                      ori        $4, zero, 0x24
__restg30:            beq        zero, zero, __restg30_0x8 
                      ori        $4, zero, 0x28
__restg30_0x8:
                      lw         $30, 0x24(sp)
__restg30_0xc:
                      lw         $23, 0x20(sp)
__restg30_0x10:
                      lw         $22, 0x1c(sp)
__restg30_0x14:
                      lw         $21, 0x18(sp)
__restg30_0x18:
                      lw         $20, 0x14(sp)
__restg30_0x1c:
                      lw         $19, 0x10(sp)
__restg30_0x20:
                      lw         $18, 0xc(sp)
__restg30_0x24:
                      lw         $17, 0x8(sp)
__restg30_0x28:
                      lw         $16, 0x4(sp)
__restg30_0x2c:
                      lw         $31, 0(sp)
                      add        sp, sp, $4
                      jr         $31
                      nop

__saveg30s:           addiu      sp, sp, -0x4
                      sw         $30, 0(sp)
__saveg23s:           addiu      sp, sp, -0x4
                      sw         $23, 0(sp)
__saveg22s:           addiu      sp, sp, -0x4
                      sw         $22, 0(sp)
__saveg21s:           addiu      sp, sp, -0x4
                      sw         $21, 0(sp)
__saveg20s:           addiu      sp, sp, -0x4
                      sw         $20, 0(sp)
__saveg19s:           addiu      sp, sp, -0x4
                      sw         $19, 0(sp)
__saveg18s:           addiu      sp, sp, -0x4
                      sw         $18, 0(sp)
__saveg17s:           addiu      sp, sp, -0x4
                      sw         $17, 0(sp)
__saveg16s:           addiu      sp, sp, -0x4
                      sw         $16, 0(sp)
                      addu       $16, $31, zero
__saveg31s:           addiu      sp, sp, -0x4
                      jr         $31
                      sw         $2, 0(sp)
                      nop



#-----------------------------------------------------------------
# _main function
#
# Called first and copy initilized 
# varibles from romdata,romsdata segments to data,sdata segments.
# Only for SIMULATOR !! (defined in mt_osmip.hs)
# For the Chip - The copy is from the HOST DPRAM to the DATA seg. 
#   ( because the MIPS can not read from the IRAM !!)
#
#-----------------------------------------------------------------
.section ".base_inst", "ax"
.extern main              

.if SIMULATOR 

.globl _main

_main:



 #/* Copy romdata segment to data segment */
    lui      $1, (%hi(__ghsbegin_romdata))  
    addiu    $1, $1, %lo(__ghsbegin_romdata)
    lui      $2, (%hi(__ghsend_romdata))  
    addiu    $2, $2, %lo(__ghsend_romdata)
    lui      $3, (%hi(__ghsbegin_data))  
    addiu    $3, $3, %lo(__ghsbegin_data)
    beq      $1,$2, sdata_copy            # No data in romdata segment
    nop

data_loop:
    lw       $5,$1
    addi     $1,4
    sw       $5,$3
    addi     $3,4
    bne      $1,$2,data_loop
    nop

 #/* Copy romsdata segment to sdata segment */
sdata_copy:
    lui      $1, (%hi(__ghsbegin_romsdata))  
    addiu    $1, $1, %lo(__ghsbegin_romsdata)
    lui      $2, (%hi(__ghsend_romsdata))  
    addiu    $2, $2, %lo(__ghsend_romsdata)
    lui      $3, (%hi(__ghsbegin_sdata))  
    addiu    $3, $3, %lo(__ghsbegin_sdata)
    beq      $1,$2, return            # No data in sromdata segment
	nop

sdata_loop:
    lw       $5,$1
    addi     $1,4
    sw       $5,$3
    addi     $3,4
    bne      $1,$2,sdata_loop
    nop


return:
    j        main
    nop

.endif ## SIMULATOR


.set reorder
