/* CMSynergyVer %full_filespec: mt_sysrst.c;16.1.1.1.6.1.1.1.1.1.5:csrc:4 % */
/*****************************************************************************
*    
*   MODULE NAME:
*       mt_sysrst.c
*   DESCRIPTION: 
*       System BIST and static init from 'main'
*   FUNCTION LIST: 
*       SYS_ResetHandler1
*       SYS_ResetHandler2
*   AUTHOR:  
*       Omri Friedman
*   DATE: 
*       20/08/2000
*   COPYRIGHT: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*   REVISION HISTORY: 
*       MetalinkRevision: 
*       17/2/02 - Added host less support by Omri
*****************************************************************************/


/*****************************************************************************
*        Library Function Include Files
*****************************************************************************/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Interrupts.h"
#include "InterruptManager_Api.h"

#include "ieee80211.h"
#include "enet_pas.h"
#if defined (CPU_MIPS)
#include "MT_osutl.h"
#endif
#if defined (CPU_ARC)
#include "arc_reg.h"
#include "arc_intrinsics.h"
#include "stackCheck_api.h"
#endif

#include "mt_sysrst.h"
#include "Pac_Api.h"
#include "RegAccess_Api.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_Emerald_Env_regs.h"
#endif
#include "EmeraldEnvRegs.h"
#include "database.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_MAC_HT_extensions_regs.h"
#endif
#include "MacHtExtensionsRegs.h"

/* to recognize chipID */
#include "stringLibApi.h"												  
#include "loggerAPI.h"

/*****************************************************************************
*        Local Definitions
*****************************************************************************/
#define LOG_LOCAL_GID   GLOBAL_GID_SYS
#define LOG_LOCAL_FID 2


#define START_TIME              0
#define END_TIME                1


#define MT_MAC_HW_ENABLE_MASK			0xFFFFFFFF //Enable ALL
/*****************************************************************************
*        Local Type Definitions
*****************************************************************************/


/*****************************************************************************
*        Local functions prototypes,
*****************************************************************************/
/*****************************************************************************
*       Local Data
*****************************************************************************/
PRAGMA_START_DATA
/* uninitialized */


#if defined (CPU_MIPS)
extern char __ghsbegin_sbss[];	
extern char __ghsend_sbss[];	
extern char __ghsbegin_bss[];	
extern char __ghsend_bss[];		
extern char __ghsbegin_stack[];
extern char __ghsend_stack[];
extern char __ghsbegin_Exc_stack[];
extern char __ghsend_Exc_stack[];
#endif
#if defined (CPU_ARC)
// _fSECTION_NAME and _eSECTION_NAME are the start/end of a given section (It's defined by ARC linker).
extern char _fstack[];
extern char _estack[];
#endif


PRAGMA_END_DATA

#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif

/*****************************************************************************
*   Module Pragma's
*****************************************************************************/

/*****************************************************************************
* Function Name:    SYS_ResetHandler1
* Description: 
*   1. Test and zero host and modem DPR
*   2. Test and zero DRAM bss and sbss segments.
*   3. Init ROM DRAM 
*   4. Trasfer modem BIST status 
*   5. Initialize stack with 'blank' values.(for testing stack usage later)
*****************************************************************************/
void System_MemoryInit(void)
{
#if defined (CPU_MIPS)
	//Zero sbss section
	memset(&__ghsbegin_sbss, 0x00, (uint32)__ghsend_sbss - (uint32)__ghsbegin_sbss);
	//Zero bss section
	memset(&__ghsbegin_bss, 0x00, (uint32)__ghsend_bss - (uint32)__ghsbegin_bss);

    /* initialize stack to a pre-defined value, to enable checking of stack usage later. */
    /* leave the locations used for current context. */
	memset(__ghsbegin_stack, 0xA5, __GetStackPointer() - (uint32)__ghsbegin_stack);
	memset(__ghsbegin_Exc_stack, 0xA5, (uint32)__ghsend_Exc_stack - (uint32)__ghsbegin_Exc_stack);
#endif
#if defined (CPU_ARC)
	// In ARC, the memories are already initialized by the arc init assembler code.
	// Here we just need to initialize the stack to 0xA5A5A5A5 so that later we can know stack usage.
	uint32 pStackPointer;

	pStackPointer = _core_read(REG_SP); // TBD - can we replace _core_read with MACRO? (READ_ARC_CORE_REG / READ_ARC_AUX_REG)
	memset(_fstack, 0xA5, (char*)pStackPointer - _fstack);

	// Enable the stack cheking feature in HW
	StackCheckInit();
#endif

}
#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif


/*****************************************************************************  
* Function Name:  MT_Delay  
* Description:   Create delay using MIPs timer #4. 
*
* Input Parameters: 
*    	Time  - time in us
* Output Parameters: 
*        None
* Eyal change on 17.10.06
*****************************************************************************/
void MT_Delay(uint32 u32Delay_us)
{
	uint32 Start_Time_low       ;
	uint32 End_Time             ;

	Start_Time_low  = GET_TSF_TIMER_LOW() ;

	do
	{
	  End_Time = GET_TSF_TIMER_LOW() - Start_Time_low;

    }while((End_Time)<=u32Delay_us);
}

#if defined (ENABLE_PIE_TEST)    
/***********************************************************************
* MT_Delay_PIE
* 
* Description:
* ------------
* This function adds a delay in the same manner as MT_Delay.
* Since the HW Timer is read in a loop, the bus is grinded.
* To refrain from grinding the bus, some actions are added in the loop.
* 
* Input:
* ------
* u32Delay_us - delay in [uSec]
* 
* Output:
* -------
* garbage - so that the compiler does not obseletes the anti-grind code
* 
* Returns:
* --------
* None
* 
************************************************************************/
uint32 MT_Delay_PIE(uint32 u32Delay_us)
{
	uint32 Start_Time_low       ;
	uint32 End_Time             ;
	uint32 garbage = 0, count1 = 0, count2 = 0, count3 = 0;
	
	
	Start_Time_low  = GET_TSF_TIMER_LOW() ;

	do
	{
	  End_Time = GET_TSF_TIMER_LOW() - Start_Time_low;
	  /* Do 3 actions so we do not grind the bus */
	  count1 +=2;
	  count2 +=3;
	  count3 +=4;
	  garbage = count1+count2+count3;

    }while((End_Time)<=u32Delay_us);
	return(garbage);
}
#endif

#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif


/*****************************************************************************  
* Function Name:  MT_ReleaseGatedUnits
* Description:   Releases the following units:
					* Timers
					* UART
					* MAC HW units(Upper CPU only)
* Input Parameters: 
*    	none
* Output Parameters: 
*        None
*****************************************************************************/
void MT_ReleaseCPUGatedUnits(void)
{
	RegEmeraldEnvSysIfGclk_u		SysIfGclkReg;
	RegEmeraldEnvSysIfSwReset_u		SysIfSwResetReg;

	SysIfGclkReg.val = 0;
	SysIfGclkReg.bitFields.uartRxGclk = TRUE;		// UART Rx gated clock
	SysIfGclkReg.bitFields.uartRxFifoGclk = TRUE;	// UART Rx FIFO gated clock
	SysIfGclkReg.bitFields.uartTxGclk = TRUE;		// UART Tx gated clock
	SysIfGclkReg.bitFields.uartTxFifoGclk = TRUE;	// UART Tx FIFO gated clock
	SysIfGclkReg.bitFields.uartCdivGclk = TRUE;		// UART Clock divider gated clock
//	SysIfGclkReg.bitFields.cacheCtrsGclk			// NOT USED in RTL in WAVE600
	SysIfGclkReg.bitFields.timersGclk = TRUE;		// Timers gated clock
	SysIfGclkReg.bitFields.testBusFifoGclk = TRUE;	// Test bus FIFO gated clock
	RegAccess_Write(REG_EMERALD_ENV_SYS_IF_GCLK, SysIfGclkReg.val);


	SysIfSwResetReg.val = 0;
	SysIfSwResetReg.bitFields.uartRxSwReset = TRUE; 		// UART Rx SW reset
	SysIfSwResetReg.bitFields.uartRxFifoSwReset = TRUE; 	// UART Rx FIFO  SW reset
	SysIfSwResetReg.bitFields.uartTxSwReset = TRUE;			// UART Tx SW reset
	SysIfSwResetReg.bitFields.uartTxFifoSwReset = TRUE; 	// UART Tx FIFO SW reset
	SysIfSwResetReg.bitFields.uartCdivSwReset = TRUE;		// UART Clock divider SW reset
	SysIfSwResetReg.bitFields.cacheCtrsSwReset = TRUE;		// Cache perfomance counters SW reset
	SysIfSwResetReg.bitFields.timersGclkSwReset = TRUE; 	// Timers SW reset
	SysIfSwResetReg.bitFields.testBusFifoSwReset = TRUE;	// Test bus FIFO SW reset
	RegAccess_Write(REG_EMERALD_ENV_SYS_IF_SW_RESET, SysIfSwResetReg.val);

}
#if !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif


#if defined (ENET_INC_LMAC) & !defined(ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization" 
#endif
/*****************************************************************************  
* Function Name:  MT_ReleaseGatedUnits
* Description:   Releases the following units:
					* MAC HW units
* Input Parameters: 
*    	none
* Output Parameters: 
*        None
*****************************************************************************/
#ifndef ENET_INC_ARCH_WAVE600
#if defined (ENET_INC_LMAC)

void MT_ReleaseMACHWGatedUnits(void)
{
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_HT_GCLK_ENABLE,MT_MAC_HW_ENABLE_MASK);
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_ASSERT,MT_MAC_HW_ENABLE_MASK);
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_RELEASE,MT_MAC_HW_ENABLE_MASK);
}
#endif
#if defined (ENET_INC_LMAC) & !defined(ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif
#endif
/*****************************************************************************  
* Function Name:  Time_Stamp  
* Description:   count the runing time of the program 
*
* Input Parameters: 
*    	status - start time or end time
* Output Parameters: 
*        time in microsec
* Eyal 
*****************************************************************************/
//KW_FIX_FW_M
uint32 Time_Stamp(uint32 status,uint32 Start_Time_low)
{
	uint32 Time = GET_TSF_TIMER_LOW();

	if (status == END_TIME)
	{
		Time = Time-Start_Time_low;
    }

    return(Time);
}

