/***********************************************************************************
 File:			PacketDescriptors_Api.h
 Module:			MemoryManagement
 Purpose: 		Utility functions for managing a pool of Packet Descriptors
 Description:		Utility functions for managing a pool of Packet Descriptors
************************************************************************************/
#ifndef PACKET_DESCRIPTORS_POOL_API_H_
#define PACKET_DESCRIPTORS_POOL_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "PacketDescriptor.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void Pool_InitializePdPool(PacketDescriptorPool_t* pPdPool, TxPd_t* pPdPoolArray, uint32 numOfPdsInShramBuffer, PdType_e pdType);
void Pool_ReleasePdList(PacketDescriptorPool_t *  pPdPool, TxPd_t* pHeadPdList, TxPd_t* pTailPdList, uint16 numPdsInList);
void Pool_PushPd(PacketDescriptorPool_t* pPdPool, TxPd_t* pPd);
TxPd_t* Pool_PullPd(PacketDescriptorPool_t* pPdPool);


#endif //PACKET_DESCRIPTORS_POOL_API_H_
