/* CMSynergyVer %full_filespec: MT_NSSMemoryPool.h;5:incl:1 % */
//***************************************************************
// File: MT_NSSMemoryPool.h
// Class/Module:
// Purpose: 
// Description: 
// 
// Modification history:
//           27-Jul-2006   [author]  Created
//  
// Class Invariant: 
// Copy Semantics:
// ***************************************************************
#ifndef MT_NSSMEMORYPOOL_H
#define MT_NSSMEMORYPOOL_H


#define MT_POOL_HEADER_SIZE                     (sizeof(uint32))

#define MT_POOL_OBJ_SIZE_ALLIGN(ObjSize)		( (( (ObjSize) + 3) / 4) * 4)
#define MT_POOL_BUF_SIZE(ObjSize)               (MT_POOL_HEADER_SIZE * 2 + (MT_POOL_OBJ_SIZE_ALLIGN(ObjSize))) 
#define MT_POOL_SIZE(ObjSize, ObjNum)           ( MT_POOL_BUF_SIZE(ObjSize) * (ObjNum) )

typedef uint32 MemPoolHdr_T;     //The buffer header (from alignment reasons it's not smaller the 32 bits)

typedef struct 
{
    uint32        PoolSize;                    //The number of buffers that belongs to this pool
    void          *PoolStart;                  //Pool start address
    uint32        BufferSize;                  //The size of the buffers on this pool
    MemPoolHdr_T  **BufferList;                //An array that contains the pointer of free buffers
    uint32        NBuffersInPool;              //The buffer array index
}MemPool_T;


// #defined also in mhi_umi.h for Mac Client use
#define FREE_NSSBUF  0x55555555   //This value is used to mark a free buffer
#define USED_NSSBUF  0xABABABAB   //This value is used to mark an allocated buffer

void CreatePool(MemPool_T *inMemPool, void *inMemAllocated,uint32 inSizeOfPool, uint32 inBufferSize, uint32 inNBuffes);
void  *AllocBuf(MemPool_T *inMemPool);
void FreeBuf(MemPool_T *inMemPool, void  *inBuf);   //Return a memory buffer back to pool
void* GetBufferAddressById(MemPool_T *inMemPool, uint32 inNumber);//Get an address of the "theNUmber" buffer in this pool


#endif //MT_NSSMEMORYPOOL_H
