/* CMSynergyVer %full_filespec: init_ifmsg.h;4:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET MAC: Utility
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/init_ifmsg.h $
 **
 ** VERSION:        $Revision: #1 $
 **
 ** DATED:          $Date: 2003/10/27 $
 **
 ** AUTHOR:         IFO
 **
 ** DESCRIPTION:    Common message initialisation functions
 **
 ** LAST MODIFIED BY:   $Author: njk $
 **                     $Modtime:   $
 **
 ****************************************************************************
 *
 *  (c) Copyright 2001, TTPCom
 *
 ****************************************************************************/

#ifndef INIT_IFMSG_INCLUDED
#define INIT_IFMSG_INCLUDED

#include "OSAL_Api.h"

typedef struct QPI
{
	void* psFirstElement;    
    void* psLastElement;
	void* psHead;    
    void* psTail;
	uint8 sizeOfElement;	
}QPI;


/*************************************************************************/
/***                     Public Functions                              ***/
/*************************************************************************/

extern void  vInit_IFmsg (
	uint16 u16Npackets,
	uint16 u16PayloadSize,
	FwUtils_queue_t  *psFreeQueue ,
	K_MSG * psPrivatePool );

extern void vIF_SendMsg(FwUtils_queue_t  *psFreeQueue,
						K_MSG_TYPE bMsgType,
						K_TASKID bTaskId,
						void * pu8Payload,
						uint16	 u16PayloadSize, 
						uint8 vapId
                        );
extern void vIF_SendMsgWithoutAllocation(K_MSG  *psMsg,
						K_MSG_TYPE bMsgType,
						K_TASKID bTaskId,
						void * pu8Payload,
						uint16	 u16PayloadSize, 
						uint8 vapId
                        );

extern bool boIF_TrySendingMsg(FwUtils_queue_t  *psFreeQueue,
						  	   K_MSG_TYPE bMsgType,
							   K_TASKID bTaskId,
							   void * pu8Payload,
							   uint16	 u16PayloadSize, 
							   uint8 vapId
	);


extern void vIF_InitPendingIndicationQueue(QPI* sPendingQueue, 
										 void* pvCyclicBuffer,
										 uint8 u8Nelements,
										 uint8 u8sizeOfElement);

extern bool boIF_PutPendingIndication(QPI* sPendingQueue, void* pvPendingMsg);
extern bool boIF_GetPendingIndication(QPI* sPendingQueue, void* pvPendingMsg);



#endif /* INIT_IFMSG_INCLUDED */



