/* CMSynergyVer %full_filespec: init_ifmsg.c;2.1.3:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET MAC: Utility
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/init_ifmsg.c $
 **
 ** VERSION:        $Revision: #1 $
 **
 ** DATED:          $Date: 2003/10/27 $
 **
 ** AUTHOR:         IFO
 **
 ** DESCRIPTION:    Common message initialisation function
 **
 ** LAST MODIFIED BY:   $Author: njk $
 **                     $Modtime:   $
 **
 ****************************************************************************
 *
 *  (c) Copyright 2001, TTPCom
 *
 ****************************************************************************/

/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "System_GlobalDefinitions.h"
#include "Utils_Api.h"
#include "ieee80211.h"
#include "frame.h"
#include "init_ifmsg.h"
#include "lmi.h"
#include "stringLibApi.h"
#include "queue_utility.h"
#include "ErrorHandler_Api.h"

/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"

#define LOG_LOCAL_GID   GLOBAL_GID_MEMORY_MGMT
#define LOG_LOCAL_FID 0

#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif

/****************************************************************************
**
** NAME:            vInit_IFmsg
**
** PARAMETERS                   r/w
**              u16Npackets     r   number of packets to format
**              u16PayloadSize  r   size zero supported
**              psFreeQueue     w   where to store IF data
**              psPrivatePool   r   input for data pool
**
** RETURN VALUES:   none
**
** DESCRIPTION:
**  This initialises messages (usually in SH ram) that pass accross the UMI or LMI.
****************************************************************************/
  void  vInit_IFmsg(
    uint16 u16Npackets,
    uint16 u16PayloadSize,
    FwUtils_queue_t  *psFreeQueue ,
    K_MSG * psPrivatePool )
{
    uint8 * pu8Temp = (uint8 * ) psPrivatePool;
    uint16 u16AllocSize;


    ASSERT(u16Npackets);
    /* zero payload length supported */
    ASSERT(psPrivatePool);

    u16AllocSize = ALIGN4(sizeof(K_MSG_HEADER) + u16PayloadSize);

    /* round size up to 4 byte boundary */

    /* init queue */
    OSAL_INIT_QUEUE( psFreeQueue );

	psFreeQueue->maxPayload = u16AllocSize - sizeof(K_MSG_HEADER);

    while ( u16Npackets--)
    {
        K_MSG * psMsg = (K_MSG * )pu8Temp;
        /* prevent deallocate (vUMqueuePut does this for us) */
        OSAL_INIT_PERSISTENT_MSG(psMsg, (K_LEN)(u16AllocSize - sizeof(K_MSG_HEADER)));
        OSAL_QUEUE_MSG(psFreeQueue, psMsg );
        pu8Temp += u16AllocSize;
    }

}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

/****************************************************************************
 **
 ** NAME:           vLMI_SendMsg
 **
 ** PARAMETERS:		psFreeQueue     Free queue to allocate the MSG from
 **					bMsgType        Message type to be sent
 **					bTaskId			Task ID of the destination task.	
 **                 pu8Payload      Message parameters (payload)
 **                 u16PayloadSize  Length of user message space in bytes
 **
 **
 ** RETURN VALUES:  void
 **
 ** DESCRIPTION:    Allocates a K_MSG from the LMI management message pool
 **                 then copies the correct payload into it, and sends it.
 **					ASSERT if allocation from queue fails. If assert is not
 **					necessary use boIF_TrySendingMsg instead.
 **
 ****************************************************************************/
void vIF_SendMsg(FwUtils_queue_t  *psFreeQueue,
                        K_MSG_TYPE bMsgType,
                        K_TASKID bTaskId,
                        void * pu8Payload,
                        uint16   u16PayloadSize, 
                        uint8 vapId
                        )
{
    K_MSG *psMsg = OSAL_DEQUEUE_MSG(psFreeQueue);
	ASSERT(psMsg) // IF assert is not necessary, use boIF_TrySendingMsg instead of vIF_SendMsg.

	psMsg->header.vapId = vapId;

	if (psFreeQueue->maxPayload < u16PayloadSize)
	{
		ASSERT(0);
	}
	
	if (pu8Payload)
	{
		// Copy stack based parameters to allocated area
		memcpy(pK_MSG_DATA(psMsg), pu8Payload, u16PayloadSize);
	}

	// select the right queue
	// - destination must be awake if infra networks
	//- destination station may be asleep if adhoc network

	psMsg->header.tKMsgType = bMsgType;
	
	OSAL_SET_MESSAGE_ORIGINATOR(psMsg); 
	
	asAPP_TaskTable[bTaskId].rFunction(psMsg);

}


