/***********************************************************************************
 File:		performanceCounters.h
 Module:		
 Purpose: 
 Description:
************************************************************************************/
#ifndef PERFORMANCE_H_
#define PERFORMANCE_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------



// In our current ARC implementation we have 4 performance counters (VLSI team can change it)
#define PERFORMANCE_COUNTER_0	0
#define PERFORMANCE_COUNTER_1	1
#define PERFORMANCE_COUNTER_2	2
#define PERFORMANCE_COUNTER_3	3

// countable conditions - we have 120 conditions. the full list can be found below and taken from MDB when connected via debugger (counters: conditions)
#define COUNTABLE_CONDITION_TOTAL_CYCLE_COUNT	86
#define COUNTABLE_CONDITION_SLEEP_CYCLE_COUNT	87

/*
The full list of countablae conditions in our current ARC (gen6/gen6b):
  0    never
  1   always                            Cycles: always true, whether or not running
  2     iall                            Instrs: any instruction committed
  3   isleep                            Instrs: Sleep
  4     ijmp                            Instrs: Jump/Branch
  5    ijmpc                            Instrs: Jump conditional taken
  6    ijmpu                            Instrs: Jump unconditional taken
  7    ijmpd                            Instrs: Jump with delay slot
  8  ijmptak                            Instrs: Jump taken
  9    icall                            Instrs: linked subroutine call
 10      ilr                            Instrs: Auxiliary Register Read (LR)
 11      isr                            Instrs: Auxiliary Register Write (SR)
 12      ilp                            Instrs: Loop
 13   ilpend                            Instrs: Loop End
 14    ilpin                            Instrs: inside a loop
 15   i2byte                            Instrs: 16-bit
 16   i4byte                            Instrs: 32-bit
 17  i2lbyte                            Instrs: 16-bit with LIMM
 18  i4lbyte                            Instrs: 32-bit with LIMM
 19   imemrd                            Instrs: Memory Read
 20   imemwr                            Instrs: Memory Write
 21  imemrdc                            Instrs: Memory Read, cached
 22  imemwrc                            Instrs: Memory Write, cached
 23    itrap                            Instrs: TRAP
 24     iswi                            Instrs: SWI
 25   illock                            Instrs: Load Locked
 26   iscond                            Instrs: Store Conditional
 27  ialljmp
 28     ivec
 29 ivgather
 30  ivscatt
 31   bstall                            Bubbles: All stalls
 32   bflush                            Bubbles: All flushes
 33   bdebug                            Bubbles: Bubbles: Debug related stall
 34   bissue                            Bubbles: Instruction Issue stall
 35    bfbmp                            Bubbles: Branch Mispredict stall
 36   beslot                            Bubbles: eSlot Instruction Fetch stall
 37   bdslot                            Bubbles: Delay Slot fetch stall
 38 bnofetch                            Bubbles: No Instruction Memory Fetch stall
 39 bflgstal                            Bubbles: Flag Dependency stall
 40 berrbrch                            Bubbles: Error Branch stall
 41 buopstal                            Bubbles: Micro-op dependency stall
 42  brgbank                            Bubbles: Bank Swap stall
 43  bagustl                            Bubbles: Address Gen stall
 44 baccstal                            Bubbles: Accumulator stall
 45  bzolcnt                            Bubbles: ZOL dependency stall
 46  bdata64                            Bubbles: 64-bit data stall
 47 bdcstall                            Bubbles: DMP stall
 48 bauxflsh                            Bubbles: Auxiliary Flush
 49  bfirqex                            Bubbles: Interrupt or Exception taken
 50   etaken                            Event: Exception taken
 51   qtaken                            Event: Interrupt taken
 52      icm                            Event: Instruction cache miss
 53     icll                            Event: Instruction cache line load
 54    icoff                            Event: Instruction cache disabled
 55     ivic                            Event: Instruction cache invalidate
 56     ivil                            Event: Instruction cache invalidate line
 57    icwpm                            Event: Instruction cache Way Prediction Miss
 58      dcm                            Event: Data cache miss
 59     dclm                            Event: Data cache load miss
 60     dcsm                            Event: Data cache store miss
 61     dcpm                            Event: Data cache predictor miss
 62     dcbc                            Event: Data cache/dccm bank conflict
 63     fldc                            Event: Data cache flush
 64     fldl                            Event: Data cache flush line
 65     ivdc                            Event: Data cache invalidate
 66     ivdl                            Event: Data cache invalidate line
 67     bpmp                            Event: mispredict -- all cases of misprediction
 68   bplate
 69    bpcmp                            Event: ifu_cond_mispredict -- mispredicted direction
 70  bpbtamp                            Event: ifu_bta_mispredict -- mispredicted branch target
 71  bpsubrt                            Event: ifu_sub_return -- mispredicted subroutine return
 72  bperrbr                            Event: ifu_error_branch
 73    bpbcm                            Event: ifu_bc_miss -- missing prediction
 74    mecc1                            Event: ifu_bit_error
 75    eitlb                            Event: Instruction TLB miss taken
 76    edtlb                            Event: Data TLB miss taken
 77   evinst
 78   ivgath
 79   ivscat
 80   bvgath
 81   bvscat
 82  ccdc2cm                            Event: Coherency cache-to-cache transfer
 83 ccserial                            Event: Coherency serialize
 84 ccupgrad                            Event: Coherency cache upgrade
 85  ccresps                            Event: Coherency non-null response
 86     crun                            Cycles: CPU is running
 87   csleep                            Cycles: CPU is running in Sleep
 88    cruni
 89   uflag0                            Cycles: User flag 0 enabled
 90   uflag1                            Cycles: User flag 1 enabled
 91   uflag2                            Cycles: User flag 2 enabled
 92   uflag3                            Cycles: User flag 3 enabled
 93   uflag4                            Cycles: User flag 4 enabled
 94   uflag5                            Cycles: User flag 5 enabled
 95   uflag6                            Cycles: User flag 6 enabled
 96   uflag7                            Cycles: User flag 7 enabled
 97   uflag8                            Cycles: User flag 8 enabled
 98   uflag9                            Cycles: User flag 9 enabled
 99  uflag10                            Cycles: User flag 10 enabled
100  uflag11                            Cycles: User flag 11 enabled
101  uflag12                            Cycles: User flag 12 enabled
102  uflag13                            Cycles: User flag 13 enabled
103  uflag14                            Cycles: User flag 14 enabled
104  uflag15                            Cycles: User flag 15 enabled
105  uflag16                            Cycles: User flag 16 enabled
106  uflag17                            Cycles: User flag 17 enabled
107  uflag18                            Cycles: User flag 18 enabled
108  uflag19                            Cycles: User flag 19 enabled
109  uflag20                            Cycles: User flag 20 enabled
110  uflag21                            Cycles: User flag 21 enabled
111  uflag22                            Cycles: User flag 22 enabled
112  uflag23                            Cycles: User flag 23 enabled
113  uflag24                            Cycles: User flag 24 enabled
114  uflag25                            Cycles: User flag 25 enabled
115  uflag26                            Cycles: User flag 26 enabled
116  uflag27                            Cycles: User flag 27 enabled
117  uflag28                            Cycles: User flag 28 enabled
118  uflag29                            Cycles: User flag 29 enabled
119  uflag30                            Cycles: User flag 30 enabled
120  uflag31                            Cycles: User flag 31 enabled
*/





//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


/*PCT_CONTROL 0x0255 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 enable		: 2; 
		uint32 uf_i0 		: 1;
		uint32 uf_i1 		: 1; 
		uint32 uf_op 		: 2;
		uint32 ku_global 	: 3;
		uint32 e_global 	: 3;
		uint32 i_global 	: 3;
		uint32 reserved1 	: 1;
		uint32 clear_counts : 1;
		uint32 snapshot 	: 1;
		uint32 reserved2 	: 14;
	} bitFields;
} AuxRegPctControl_u;




//---------------------------------------------------------------------------------
//						Static Function Declaration				
//---------------------------------------------------------------------------------

#endif //PERFORMANCE_H_


