/* CMSynergyVer %full_filespec: enet_brc.h;3.1.1:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET SW - Base Reference Configuration
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/drivers/enet_brc.h $
 **
 ** DESCRIPTION:    C Structures For Access To Base Reference Config
 **
 ** AUTHOR:         Laurence Evans
 **
 ** THIS VERSION:   $Revision: #2 $
 **   CHANGED ON:   $Date: 2004/03/10 $
 **           BY:   $Author: prh $
 **
 ** $Log: enet_brc.h $
 ** Revision 1.17  2002/07/09 13:24:59Z  abm
 ** Added baud rates for other clock speeds
 ** Revision 1.16  2002/03/20 14:29:35  abm
 ** Increase ENET UART Rx buffer size back to 16 as bug now fixed
 ** Revision 1.15  2002/03/18 10:29:13  abm
 ** Reduce BRC UART FIFO depth constant to 14, due to pr11090/028.
 ** Revision 1.14  2002/03/14 17:35:49  abm
 ** Add extra baud rates for the BRC UART.
 ** Revision 1.13  2002/03/11 17:34:07  smk
 ** Fixed the definition of the watchdog timer registers
 ** Revision 1.12  2001/12/14 10:21:59Z  jgs
 ** Removed PHY registers - this will by PHY specific and has been
 ** moved to a PHY driver file
 ** Revision 1.11  2001/12/04 10:28:51Z  ifo
 ** Updated headers.
 ** Removed tabs.
 ** No functional changes.
 ** Revision 1.10  2001/11/16 10:27:50Z  lde
 ** Added define for self reset duration.
 ** Revision 1.9  2001/11/13 15:11:43Z  jag1
 ** Added ENET_BRC_PHY structure definition.
 ** Revision 1.8  2001/11/08 12:19:52Z  ifo
 ** Cleaned up fro boot loader use.
 ** Revision 1.7  2001/10/05 10:14:09Z  lde
 ** Changes for C100
 ** Revision 1.6  2001/09/19 14:02:05Z  ifo
 ** Interrupt 15 is PAC TSF interrupt.
 ** Revision 1.5  2001/09/19 13:20:33Z  jag1
 ** Added PAS TSF software interrupt.
 ** Revision 1.4  2001/08/16 13:49:44Z  ifo
 ** Mods to get ENET UART driver in place.
 ** Revision 1.3  2001/08/16 10:58:11Z  ifo
 ** Updated for test LM compilation on ARM
 ** Revision 1.2  2001/08/16 10:38:09Z  ifo
 ** Added interrupts into test config.
 ** Revision 1.1  2001/08/16 09:43:03Z  ifo
 ** ENET drivers added..
 ** Revision 1.1  2001/05/04 14:38:23Z  lde
 ** Initial revision
 **
 ****************************************************************************
 **
 ** Copyright (c) 2001 TTPCom Limited
 **
 ****************************************************************************
 ****************************************************************************/

#ifndef ENET_BRC_INCLUDED_H
#define ENET_BRC_INCLUDED_H

/***************************************************************************/
/***                            Includes                                 ***/
/***************************************************************************/

#include "System_GlobalDefinitions.h"

/***************************************************************************/
/***                     BRC/INT Interrupt Controller                    ***/
/***************************************************************************/

typedef struct ENET_BRC_INT
{
    /* Global enable */
    uint32 u32GlobalEnable;
    /* Register clears an asserted interrupt source register */
    uint32 u32Clear;
    /* Register selects interrupt sources to trigger irq0 */
    uint32 u32Enable0;
    /* Register selects interrupt sources to trigger irq1 */
    uint32 u32Enable1;
    /* Register selects interrupt sources to trigger irq2 */
    uint32 u32Enable2;
    /* Defines interrupt polarity */
    uint32 u32Polarity;
    /* Defines interrupt type */
    uint32 u32Type;
    /* Register reports which enabled interrupt source
       has triggered an interrupt on irq0 */
    uint32 u32Status0;  /* Alias FIQ */
    /* Register reports which enabled interrupt source
       has triggered an interrupt on irq1 */
    uint32 u32Status1;  /* Alias IRQ */
    /* Register reports which enabled interrupt source
       has triggered an interrupt on irq2 */
    uint32 u32Status2;
    /* Register reports which interrupt source has
       triggered an interrupt on any irq0,1 or 2. */
    uint32 u32Status;
} ENET_BRC_INT;

/* Global enable bit */
#define ENET_INT_GLOBAL_ENABLE  0x00000001

/* Int mask for all interrupts */
#define ENET_INT_INT_MASK       0xFFFFFFFF

/* Interrupt polarity */
#define ENET_INT_POLARITY_NEG   0
#define ENET_INT_POLARITY_POS   1

/* Interrupt type */
#define ENET_INT_EDGE           0
#define ENET_INT_LEVEL          1

/* Interupt bits */
#define ENET_INT_UART_TX_EMPTY          0x00000001 /*((uint32)1<<0)*/
#define ENET_INT_UART_RX_ERROR          0x00000002 /*((uint32)1<<1)*/
#define ENET_INT_UART_RX_TRIG           0x00000004 /*((uint32)1<<2)*/
#define ENET_INT_UART_RX_OVERFLOW       0x00000008 /*((uint32)1<<3)*/
#define ENET_INT_RESERVED1              0x00000010 /*((uint32)1<<4)*/
#define ENET_INT_HRC_DMA_COMPLETE       0x00000020 /*((uint32)1<<5)*/
#define ENET_INT_HRC_MASTER_ABORT       0x00000040 /*((uint32)1<<6)*/
#define ENET_INT_HRC_TARGET_ABORT       0x00000080 /*((uint32)1<<7)*/
#define ENET_INT_HRC_INT_TARGET_ABORT   0x00000100 /*((uint32)1<<8)*/
#define ENET_INT_HRC_PARITY_ERROR       0x00000200 /*((uint32)1<<9)*/
#define ENET_INT_HRC_SYSTEM_ERROR       0x00000400 /*((uint32)1<<10)*/
#define ENET_INT_HRC_BIS_START          0x00000800 /*((uint32)1<<11)*/
#define ENET_INT_HRC_DOORBELL0          0x00001000 /*((uint32)1<<12)*/
#define ENET_INT_HRC_DOORBELL1          0x00002000 /*((uint32)1<<13)*/
#define ENET_INT_HRC_DOORBELL2          0x00004000 /*((uint32)1<<14)*/
#define ENET_INT_HRC_DOORBELL3          0x00008000 /*((uint32)1<<15)*/
#define ENET_INT_PAC_TSF_TIMER          0x00010000 /*((uint32)1<<16)*/
#define ENET_INT_PAC_TICK_TIMER         0x00020000 /*((uint32)1<<17)*/
#define ENET_INT_PAC                    0x00040000 /*((uint32)1<<18)*/
#define ENET_INT_PHI                    0x00080000 /*((uint32)1<<19)*/
#define ENET_INT_LCPU                   0x00100000 /*((uint32)1<<20)*/
#define ENET_INT_UCPU                   0x00200000 /*((uint32)1<<21)*/
#define ENET_INT_EMW_CRC_FAIL           0x00400000 /*((uint32)1<<22)*/
#define ENET_INT_EMW_COMPLETE           0x00800000 /*((uint32)1<<23)*/
#define ENET_INT_MISC0                  0x01000000 /*((uint32)1<<24)*/
#define ENET_INT_MISC1                  0x02000000 /*((uint32)1<<25)*/
#define ENET_INT_MISC2                  0x04000000 /*((uint32)1<<26)*/
#define ENET_INT_MISC3                  0x08000000 /*((uint32)1<<27)*/
#define ENET_INT_MISC4                  0x10000000 /*((uint32)1<<28)*/
#define ENET_INT_MISC5                  0x20000000 /*((uint32)1<<29)*/
#define ENET_INT_MISC6                  0x40000000 /*((uint32)1<<30)*/
#define ENET_INT_PAC_RX_FIFO_OVERFLOW   0x80000000 /*((uint32)1<<31)*/

/***************************************************************************/
/***                            BRC / UART                               ***/
/***************************************************************************/

typedef struct ENET_BRC_UART
{
    /* Selects how many bytes need to be waiting in rx fifo before
       ua_rx_trig interrupt line is asserted */
    uint32  u32CntrlTrigLevel;
    /* Baud rate selection - values to be used  depend on clock frequency */
    uint32  u32ClkDivider;
    /* Number of bytes waiting in the rx fifo - 4 bits wide */
    uint32  u32StatusRxBytes;
    /* UART Tx data - 8 bits wide, 16 bytes deep  */
    uint32  u32TxData;
    /* UART Rx data - 8 bits wide, 16 bytes deep */
    uint32  u32RxData;
} ENET_BRC_UART;

/* Rx interrupt trigger level */
#define ENET_UART_TRIG_1BYTE    0x0
#define ENET_UART_TRIG_4BYTES   0x1
#define ENET_UART_TRIG_8BYTES   0x2
#define ENET_UART_TRIG_12BYTES  0x3

/* Number of bytes waiting in the FIFO */
#define ENET_UART_WAITING_MASK  0x0000000F

/* Size of Tx FIFO */
/* This is supposed to be 16.  However  if running with hardware IP prior */
/* to release 2.0, set it to 14 owing to a bug in the UART. (pr11090/028) */
#define ENET_UART_TX_FIFO_SIZE  16

/***************************************************************************/
/***                            BRC / GPIO                               ***/
/***************************************************************************/

typedef struct ENET_BRC_GPIO
{
    /* Data output enable */
    uint32 u32DataOE;
    /* Data Input - 16 bits wide */
    uint32 u32DataIn;
    /* Data Output - 16 bits wide */
    uint32 u32DataOut;
} ENET_BRC_GPIO;

/***************************************************************************/
/***                         BRC / WDG - Watchdog                        ***/
/***************************************************************************/

typedef struct ENET_BRC_WDG
{
    /* 00: Control watchdog function - 1 bit enable, 28 bits timeout */
    uint32 u32Control;
    /* 04: CPU writes 1 to reset the watchdog timer */
    uint32 u32Stroke;
} ENET_BRC_WDG;

#define ENET_WDG_ENABLE     0x80000000

#define ENET_WDG_MAX        0x0FFFFFFF

#define ENET_WDG_STROKE     0x00000001


/***************************************************************************/
/***                         BRC / MIR - Misc registers                  ***/
/***************************************************************************/

/* Misc registers are unique to Upper or Lower CPU */
typedef struct ENET_BRC_MIR
{
    /* 00: CPU Sleep Time (write only) */
    uint32      u32CPUsleepTime_Count;
    /* 04: CPU self/other reset (write only) */
    uint32      u32Reset_MemMap;
    /* 08: Other CPU interrupt generation (write only) */
    uint32      u32OtherCPUintReq;
    /* 0C: Slow Clock control (UCPU only) */
    uint32      u32SlowClockControl;
    /* 00: CPU sleep counter */
    uint32      u32SleepCount;
    /* 04: unused */
    uint32      u32Unused1;
    /* 08: unused */
    uint32      u32Unused2;
    /* 0C: Slow clock status (UCPU only) */
    uint32      u32SlowClockStatus;
} ENET_BRC_MIR;

/* Misc reg 00 (write) */
#define ENET_MIR_SLEEP              0x80000000
#define ENET_MIR_SLEEP_MASK         0x7FFFFFFF

/* Misc reg 00 (read) */
#define ENET_MIR_SLEEP_COUNT_MASK   0x003FFFFF

/* Misc reg 04 (write) */
#define ENET_MIR_MAX_RESET_DURATION 0x00000600
#define ENET_MIR_FORCE_SELF_RESET   0x00000100
#define ENET_MIR_FORCE_OTHER_RESET  0x00000010 /* UCPU only */
#define ENET_MIR_MEM_MAP            0x00000001

/* Misc reg 08 */
/* 8 bits of output to trigger other CPUs interrupt lines */
/* REVISIT - now in PAS so these interprocessor interupts will be removed! */
#define ENET_MIR_IGEN_0             0x00000001
#define ENET_MIR_IGEN_1             0x00000002
#define ENET_MIR_IGEN_2             0x00000004
#define ENET_MIR_IGEN_3             0x00000008
#define ENET_MIR_IGEN_4             0x00000010
#define ENET_MIR_IGEN_5             0x00000020
#define ENET_MIR_IGEN_6             0x00000040
#define ENET_MIR_IGEN_7             0x00000080
/* REVISIT - shoudl have more bits! */

/* Misc reg 0C (write) */
#define ENET_MIR_SLOW_CLK_REQ       0x00000100 /* UCPU only */
#define ENET_MIR_FAST_WARMUP_MASK   0x000000FF /* UCPU only */

/* Misc reg 0C (read) */
#define ENET_MIR_FAST_CLK_POWER     0x02000000 /* UCPU only */
#define ENET_MIR_SLOW_CLK_ACTIVE    0x01000000 /* UCPU only */
#define ENET_MIR_SLOW_CYCLE_MASK    0x00FFFFFF /* UCPU only */


/***************************************************************************/
/***                         BRC / PHY - Misc registers                  ***/
/***************************************************************************/

/* Phy and Radio registers are defined elsewhere (in the PHY and Radio drivers) */



/***************************************************************************/
/***                          Public Data                                ***/
/***************************************************************************/

PRAGMA_START_DATA

extern volatile ENET_BRC_INT        sBRC_INT;
extern volatile ENET_BRC_UART       sBRC_UART;

PRAGMA_END_DATA



/***************************************************************************/
/***                     Public Function Prototypes                      ***/
/***************************************************************************/

#endif /* ENET_BRC_INCLUDED */
